/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.compute.models;

/**
* Describes Compute Resource Usage.
*/
public class Usage {
    private int currentValue;
    
    /**
    * Required. Gets or sets the current value of the usage.
    * @return The CurrentValue value.
    */
    public int getCurrentValue() {
        return this.currentValue;
    }
    
    /**
    * Required. Gets or sets the current value of the usage.
    * @param currentValueValue The CurrentValue value.
    */
    public void setCurrentValue(final int currentValueValue) {
        this.currentValue = currentValueValue;
    }
    
    private long limit;
    
    /**
    * Required. Gets or sets the limit of usage.
    * @return The Limit value.
    */
    public long getLimit() {
        return this.limit;
    }
    
    /**
    * Required. Gets or sets the limit of usage.
    * @param limitValue The Limit value.
    */
    public void setLimit(final long limitValue) {
        this.limit = limitValue;
    }
    
    private UsageName name;
    
    /**
    * Required. Gets or sets the name of the type of usage.
    * @return The Name value.
    */
    public UsageName getName() {
        return this.name;
    }
    
    /**
    * Required. Gets or sets the name of the type of usage.
    * @param nameValue The Name value.
    */
    public void setName(final UsageName nameValue) {
        this.name = nameValue;
    }
    
    private UsageUnit unit;
    
    /**
    * Required. Gets or sets an enum describing the unit of measurement.
    * @return The Unit value.
    */
    public UsageUnit getUnit() {
        return this.unit;
    }
    
    /**
    * Required. Gets or sets an enum describing the unit of measurement.
    * @param unitValue The Unit value.
    */
    public void setUnit(final UsageUnit unitValue) {
        this.unit = unitValue;
    }
}
