/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.compute.models;

import com.microsoft.windowsazure.core.LazyArrayList;

import java.util.ArrayList;

/**
* Describes a set of certificates which are all in the same Key Vault.
*/
public class VaultSecretGroup {
    private SourceVaultReference sourceVault;
    
    /**
    * Optional. Gets or sets the Relative URL of the Key Vault containing all
    * of the certificates in VaultCertificates.
    * @return The SourceVault value.
    */
    public SourceVaultReference getSourceVault() {
        return this.sourceVault;
    }
    
    /**
    * Optional. Gets or sets the Relative URL of the Key Vault containing all
    * of the certificates in VaultCertificates.
    * @param sourceVaultValue The SourceVault value.
    */
    public void setSourceVault(final SourceVaultReference sourceVaultValue) {
        this.sourceVault = sourceVaultValue;
    }
    
    private ArrayList<VaultCertificate> vaultCertificates;
    
    /**
    * Optional. Gets or sets the list of key vault references in SourceVault
    * which contain certificates
    * @return The VaultCertificates value.
    */
    public ArrayList<VaultCertificate> getVaultCertificates() {
        return this.vaultCertificates;
    }
    
    /**
    * Optional. Gets or sets the list of key vault references in SourceVault
    * which contain certificates
    * @param vaultCertificatesValue The VaultCertificates value.
    */
    public void setVaultCertificates(final ArrayList<VaultCertificate> vaultCertificatesValue) {
        this.vaultCertificates = vaultCertificatesValue;
    }
    
    /**
    * Initializes a new instance of the VaultSecretGroup class.
    *
    */
    public VaultSecretGroup() {
        this.setVaultCertificates(new LazyArrayList<VaultCertificate>());
    }
}
