/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.compute.models;

import com.microsoft.windowsazure.core.ResourceBaseExtended;

import java.util.ArrayList;

/**
* Describes a Virtual Machine.
*/
public class VirtualMachine extends ResourceBaseExtended {
    private AvailabilitySetReference availabilitySetReference;
    
    /**
    * Optional. Gets or sets the reference Id of the availailbity set to which
    * this virtual machine belongs.
    * @return The AvailabilitySetReference value.
    */
    public AvailabilitySetReference getAvailabilitySetReference() {
        return this.availabilitySetReference;
    }
    
    /**
    * Optional. Gets or sets the reference Id of the availailbity set to which
    * this virtual machine belongs.
    * @param availabilitySetReferenceValue The AvailabilitySetReference value.
    */
    public void setAvailabilitySetReference(final AvailabilitySetReference availabilitySetReferenceValue) {
        this.availabilitySetReference = availabilitySetReferenceValue;
    }
    
    private DiagnosticsProfile diagnosticsProfile;
    
    /**
    * Optional. Gets or sets the diagnostics profile.
    * @return The DiagnosticsProfile value.
    */
    public DiagnosticsProfile getDiagnosticsProfile() {
        return this.diagnosticsProfile;
    }
    
    /**
    * Optional. Gets or sets the diagnostics profile.
    * @param diagnosticsProfileValue The DiagnosticsProfile value.
    */
    public void setDiagnosticsProfile(final DiagnosticsProfile diagnosticsProfileValue) {
        this.diagnosticsProfile = diagnosticsProfileValue;
    }
    
    private ArrayList<VirtualMachineExtension> extensions;
    
    /**
    * Optional. Gets the virtual machine child extension resources.
    * @return The Extensions value.
    */
    public ArrayList<VirtualMachineExtension> getExtensions() {
        return this.extensions;
    }
    
    /**
    * Optional. Gets the virtual machine child extension resources.
    * @param extensionsValue The Extensions value.
    */
    public void setExtensions(final ArrayList<VirtualMachineExtension> extensionsValue) {
        this.extensions = extensionsValue;
    }
    
    private HardwareProfile hardwareProfile;
    
    /**
    * Optional. Gets or sets the hardware profile.
    * @return The HardwareProfile value.
    */
    public HardwareProfile getHardwareProfile() {
        return this.hardwareProfile;
    }
    
    /**
    * Optional. Gets or sets the hardware profile.
    * @param hardwareProfileValue The HardwareProfile value.
    */
    public void setHardwareProfile(final HardwareProfile hardwareProfileValue) {
        this.hardwareProfile = hardwareProfileValue;
    }
    
    private VirtualMachineInstanceView instanceView;
    
    /**
    * Optional. Gets the virtual machine instance view.
    * @return The InstanceView value.
    */
    public VirtualMachineInstanceView getInstanceView() {
        return this.instanceView;
    }
    
    /**
    * Optional. Gets the virtual machine instance view.
    * @param instanceViewValue The InstanceView value.
    */
    public void setInstanceView(final VirtualMachineInstanceView instanceViewValue) {
        this.instanceView = instanceViewValue;
    }
    
    private NetworkProfile networkProfile;
    
    /**
    * Optional. Gets or sets the network profile.
    * @return The NetworkProfile value.
    */
    public NetworkProfile getNetworkProfile() {
        return this.networkProfile;
    }
    
    /**
    * Optional. Gets or sets the network profile.
    * @param networkProfileValue The NetworkProfile value.
    */
    public void setNetworkProfile(final NetworkProfile networkProfileValue) {
        this.networkProfile = networkProfileValue;
    }
    
    private OSProfile oSProfile;
    
    /**
    * Optional. Gets or sets the OS profile.
    * @return The OSProfile value.
    */
    public OSProfile getOSProfile() {
        return this.oSProfile;
    }
    
    /**
    * Optional. Gets or sets the OS profile.
    * @param oSProfileValue The OSProfile value.
    */
    public void setOSProfile(final OSProfile oSProfileValue) {
        this.oSProfile = oSProfileValue;
    }
    
    private Plan plan;
    
    /**
    * Optional. Gets or sets the purchase plan when deploying virtual machine
    * from VM Marketplace images.
    * @return The Plan value.
    */
    public Plan getPlan() {
        return this.plan;
    }
    
    /**
    * Optional. Gets or sets the purchase plan when deploying virtual machine
    * from VM Marketplace images.
    * @param planValue The Plan value.
    */
    public void setPlan(final Plan planValue) {
        this.plan = planValue;
    }
    
    private String provisioningState;
    
    /**
    * Optional. Gets or sets the provisioning state, which only appears in the
    * response.
    * @return The ProvisioningState value.
    */
    public String getProvisioningState() {
        return this.provisioningState;
    }
    
    /**
    * Optional. Gets or sets the provisioning state, which only appears in the
    * response.
    * @param provisioningStateValue The ProvisioningState value.
    */
    public void setProvisioningState(final String provisioningStateValue) {
        this.provisioningState = provisioningStateValue;
    }
    
    private StorageProfile storageProfile;
    
    /**
    * Optional. Gets or sets the storage profile.
    * @return The StorageProfile value.
    */
    public StorageProfile getStorageProfile() {
        return this.storageProfile;
    }
    
    /**
    * Optional. Gets or sets the storage profile.
    * @param storageProfileValue The StorageProfile value.
    */
    public void setStorageProfile(final StorageProfile storageProfileValue) {
        this.storageProfile = storageProfileValue;
    }
    
    /**
    * Initializes a new instance of the VirtualMachine class.
    *
    */
    public VirtualMachine() {
        super();
    }
    
    /**
    * Initializes a new instance of the VirtualMachine class with required
    * arguments.
    *
    * @param location Gets or sets the location of the resource.
    */
    public VirtualMachine(String location) {
        this();
        if (location == null) {
            throw new NullPointerException("location");
        }
        this.setLocation(location);
    }
}
