/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.compute.models;

import com.microsoft.windowsazure.core.LazyArrayList;

import java.util.ArrayList;

/**
* The instance view of the VM Agent running on the virtual machine.
*/
public class VirtualMachineAgentInstanceView extends ResourceInstanceView {
    private ArrayList<VirtualMachineExtensionHandlerInstanceView> extensionHandlers;
    
    /**
    * Optional. Gets or sets the virtual machine extension handler instance
    * view.
    * @return The ExtensionHandlers value.
    */
    public ArrayList<VirtualMachineExtensionHandlerInstanceView> getExtensionHandlers() {
        return this.extensionHandlers;
    }
    
    /**
    * Optional. Gets or sets the virtual machine extension handler instance
    * view.
    * @param extensionHandlersValue The ExtensionHandlers value.
    */
    public void setExtensionHandlers(final ArrayList<VirtualMachineExtensionHandlerInstanceView> extensionHandlersValue) {
        this.extensionHandlers = extensionHandlersValue;
    }
    
    private String vMAgentVersion;
    
    /**
    * Optional. Gets or sets the VM Agent full version.
    * @return The VMAgentVersion value.
    */
    public String getVMAgentVersion() {
        return this.vMAgentVersion;
    }
    
    /**
    * Optional. Gets or sets the VM Agent full version.
    * @param vMAgentVersionValue The VMAgentVersion value.
    */
    public void setVMAgentVersion(final String vMAgentVersionValue) {
        this.vMAgentVersion = vMAgentVersionValue;
    }
    
    /**
    * Initializes a new instance of the VirtualMachineAgentInstanceView class.
    *
    */
    public VirtualMachineAgentInstanceView() {
        super();
        this.setExtensionHandlers(new LazyArrayList<VirtualMachineExtensionHandlerInstanceView>());
    }
}
