/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.compute.models;

/**
* Describes a Virtual Machine Extension Image.
*/
public class VirtualMachineExtensionImage extends VirtualMachineImageResource {
    private String computeRole;
    
    /**
    * Required. Gets or sets the type of role (IaaS or PaaS) this extension
    * supports.
    * @return The ComputeRole value.
    */
    public String getComputeRole() {
        return this.computeRole;
    }
    
    /**
    * Required. Gets or sets the type of role (IaaS or PaaS) this extension
    * supports.
    * @param computeRoleValue The ComputeRole value.
    */
    public void setComputeRole(final String computeRoleValue) {
        this.computeRole = computeRoleValue;
    }
    
    private String handlerSchema;
    
    /**
    * Required. Gets or sets the schema defined by publisher, where extension
    * consumers should provide settings in a matching schema.
    * @return The HandlerSchema value.
    */
    public String getHandlerSchema() {
        return this.handlerSchema;
    }
    
    /**
    * Required. Gets or sets the schema defined by publisher, where extension
    * consumers should provide settings in a matching schema.
    * @param handlerSchemaValue The HandlerSchema value.
    */
    public void setHandlerSchema(final String handlerSchemaValue) {
        this.handlerSchema = handlerSchemaValue;
    }
    
    private String operatingSystem;
    
    /**
    * Required. Gets or sets the operating system this extension supports.
    * @return The OperatingSystem value.
    */
    public String getOperatingSystem() {
        return this.operatingSystem;
    }
    
    /**
    * Required. Gets or sets the operating system this extension supports.
    * @param operatingSystemValue The OperatingSystem value.
    */
    public void setOperatingSystem(final String operatingSystemValue) {
        this.operatingSystem = operatingSystemValue;
    }
    
    private boolean supportsMultipleExtensions;
    
    /**
    * Optional. Gets or sets whether the handler can support multiple
    * extensions.
    * @return The SupportsMultipleExtensions value.
    */
    public boolean isSupportsMultipleExtensions() {
        return this.supportsMultipleExtensions;
    }
    
    /**
    * Optional. Gets or sets whether the handler can support multiple
    * extensions.
    * @param supportsMultipleExtensionsValue The SupportsMultipleExtensions
    * value.
    */
    public void setSupportsMultipleExtensions(final boolean supportsMultipleExtensionsValue) {
        this.supportsMultipleExtensions = supportsMultipleExtensionsValue;
    }
    
    private boolean vMScaleSetEnabled;
    
    /**
    * Optional. Gets or sets whether the extension can be used on xRP
    * VMScaleSets.By default existing extensions are usable on scalesets, but
    * there might be cases where a publisher wants to explicitly indicate the
    * extension is only enabled for CRP VMs but not VMSS.
    * @return The VMScaleSetEnabled value.
    */
    public boolean isVMScaleSetEnabled() {
        return this.vMScaleSetEnabled;
    }
    
    /**
    * Optional. Gets or sets whether the extension can be used on xRP
    * VMScaleSets.By default existing extensions are usable on scalesets, but
    * there might be cases where a publisher wants to explicitly indicate the
    * extension is only enabled for CRP VMs but not VMSS.
    * @param vMScaleSetEnabledValue The VMScaleSetEnabled value.
    */
    public void setVMScaleSetEnabled(final boolean vMScaleSetEnabledValue) {
        this.vMScaleSetEnabled = vMScaleSetEnabledValue;
    }
}
