/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.compute.models;

import com.microsoft.windowsazure.core.LazyArrayList;

import java.util.ArrayList;

/**
* Describes a Virtual Machine Image.
*/
public class VirtualMachineImage extends VirtualMachineImageResource {
    private ArrayList<DataDiskImage> dataDiskImages;
    
    /**
    * Optional.
    * @return The DataDiskImages value.
    */
    public ArrayList<DataDiskImage> getDataDiskImages() {
        return this.dataDiskImages;
    }
    
    /**
    * Optional.
    * @param dataDiskImagesValue The DataDiskImages value.
    */
    public void setDataDiskImages(final ArrayList<DataDiskImage> dataDiskImagesValue) {
        this.dataDiskImages = dataDiskImagesValue;
    }
    
    private OSDiskImage oSDiskImage;
    
    /**
    * Optional.
    * @return The OSDiskImage value.
    */
    public OSDiskImage getOSDiskImage() {
        return this.oSDiskImage;
    }
    
    /**
    * Optional.
    * @param oSDiskImageValue The OSDiskImage value.
    */
    public void setOSDiskImage(final OSDiskImage oSDiskImageValue) {
        this.oSDiskImage = oSDiskImageValue;
    }
    
    private PurchasePlan purchasePlan;
    
    /**
    * Optional.
    * @return The PurchasePlan value.
    */
    public PurchasePlan getPurchasePlan() {
        return this.purchasePlan;
    }
    
    /**
    * Optional.
    * @param purchasePlanValue The PurchasePlan value.
    */
    public void setPurchasePlan(final PurchasePlan purchasePlanValue) {
        this.purchasePlan = purchasePlanValue;
    }
    
    /**
    * Initializes a new instance of the VirtualMachineImage class.
    *
    */
    public VirtualMachineImage() {
        super();
        this.setDataDiskImages(new LazyArrayList<DataDiskImage>());
    }
    
    /**
    * Initializes a new instance of the VirtualMachineImage class with required
    * arguments.
    *
    * @param id Gets or sets the ID of the artifact.
    * @param name Gets or sets the name of the resource.
    * @param location Gets or sets the location of the resource.
    */
    public VirtualMachineImage(String id, String name, String location) {
        this();
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (location == null) {
            throw new NullPointerException("location");
        }
        this.setId(id);
        this.setName(name);
        this.setLocation(location);
    }
}
