/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.compute.models;

import com.microsoft.windowsazure.core.LazyArrayList;

import java.util.ArrayList;

/**
* The instance view of a virtual machine.
*/
public class VirtualMachineInstanceView extends ResourceInstanceView {
    private BootDiagnosticsInstanceView bootDiagnostics;
    
    /**
    * Optional. Gets or sets the boot diagnostics.
    * @return The BootDiagnostics value.
    */
    public BootDiagnosticsInstanceView getBootDiagnostics() {
        return this.bootDiagnostics;
    }
    
    /**
    * Optional. Gets or sets the boot diagnostics.
    * @param bootDiagnosticsValue The BootDiagnostics value.
    */
    public void setBootDiagnostics(final BootDiagnosticsInstanceView bootDiagnosticsValue) {
        this.bootDiagnostics = bootDiagnosticsValue;
    }
    
    private ArrayList<DiskInstanceView> disks;
    
    /**
    * Optional. Gets or sets the the disks information.
    * @return The Disks value.
    */
    public ArrayList<DiskInstanceView> getDisks() {
        return this.disks;
    }
    
    /**
    * Optional. Gets or sets the the disks information.
    * @param disksValue The Disks value.
    */
    public void setDisks(final ArrayList<DiskInstanceView> disksValue) {
        this.disks = disksValue;
    }
    
    private ArrayList<VirtualMachineExtensionInstanceView> extensions;
    
    /**
    * Optional. Gets or sets the extensions information.
    * @return The Extensions value.
    */
    public ArrayList<VirtualMachineExtensionInstanceView> getExtensions() {
        return this.extensions;
    }
    
    /**
    * Optional. Gets or sets the extensions information.
    * @param extensionsValue The Extensions value.
    */
    public void setExtensions(final ArrayList<VirtualMachineExtensionInstanceView> extensionsValue) {
        this.extensions = extensionsValue;
    }
    
    private Integer platformFaultDomain;
    
    /**
    * Optional. Gets or sets the Fault Domain count.
    * @return The PlatformFaultDomain value.
    */
    public Integer getPlatformFaultDomain() {
        return this.platformFaultDomain;
    }
    
    /**
    * Optional. Gets or sets the Fault Domain count.
    * @param platformFaultDomainValue The PlatformFaultDomain value.
    */
    public void setPlatformFaultDomain(final Integer platformFaultDomainValue) {
        this.platformFaultDomain = platformFaultDomainValue;
    }
    
    private Integer platformUpdateDomain;
    
    /**
    * Optional. Gets or sets the Update Domain count.
    * @return The PlatformUpdateDomain value.
    */
    public Integer getPlatformUpdateDomain() {
        return this.platformUpdateDomain;
    }
    
    /**
    * Optional. Gets or sets the Update Domain count.
    * @param platformUpdateDomainValue The PlatformUpdateDomain value.
    */
    public void setPlatformUpdateDomain(final Integer platformUpdateDomainValue) {
        this.platformUpdateDomain = platformUpdateDomainValue;
    }
    
    private String remoteDesktopThumbprint;
    
    /**
    * Optional. Gets or sets the Remote desktop certificate thumbprint.
    * @return The RemoteDesktopThumbprint value.
    */
    public String getRemoteDesktopThumbprint() {
        return this.remoteDesktopThumbprint;
    }
    
    /**
    * Optional. Gets or sets the Remote desktop certificate thumbprint.
    * @param remoteDesktopThumbprintValue The RemoteDesktopThumbprint value.
    */
    public void setRemoteDesktopThumbprint(final String remoteDesktopThumbprintValue) {
        this.remoteDesktopThumbprint = remoteDesktopThumbprintValue;
    }
    
    private VirtualMachineAgentInstanceView vMAgent;
    
    /**
    * Optional. Gets or sets the VM Agent running on the virtual machine.
    * @return The VMAgent value.
    */
    public VirtualMachineAgentInstanceView getVMAgent() {
        return this.vMAgent;
    }
    
    /**
    * Optional. Gets or sets the VM Agent running on the virtual machine.
    * @param vMAgentValue The VMAgent value.
    */
    public void setVMAgent(final VirtualMachineAgentInstanceView vMAgentValue) {
        this.vMAgent = vMAgentValue;
    }
    
    /**
    * Initializes a new instance of the VirtualMachineInstanceView class.
    *
    */
    public VirtualMachineInstanceView() {
        super();
        this.setDisks(new LazyArrayList<DiskInstanceView>());
        this.setExtensions(new LazyArrayList<VirtualMachineExtensionInstanceView>());
    }
}
