/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.azure.management.compute.models;

/**
* Describes the properties of a VM size.
*/
public class VirtualMachineSize {
    private Integer maxDataDiskCount;
    
    /**
    * Optional. Gets or sets the Maximum number of data disks allowed by a VM
    * size.
    * @return The MaxDataDiskCount value.
    */
    public Integer getMaxDataDiskCount() {
        return this.maxDataDiskCount;
    }
    
    /**
    * Optional. Gets or sets the Maximum number of data disks allowed by a VM
    * size.
    * @param maxDataDiskCountValue The MaxDataDiskCount value.
    */
    public void setMaxDataDiskCount(final Integer maxDataDiskCountValue) {
        this.maxDataDiskCount = maxDataDiskCountValue;
    }
    
    private int memoryInMB;
    
    /**
    * Optional. Gets or sets the Memory size supported by a VM size.
    * @return The MemoryInMB value.
    */
    public int getMemoryInMB() {
        return this.memoryInMB;
    }
    
    /**
    * Optional. Gets or sets the Memory size supported by a VM size.
    * @param memoryInMBValue The MemoryInMB value.
    */
    public void setMemoryInMB(final int memoryInMBValue) {
        this.memoryInMB = memoryInMBValue;
    }
    
    private String name;
    
    /**
    * Optional. Gets or sets the VM size name.
    * @return The Name value.
    */
    public String getName() {
        return this.name;
    }
    
    /**
    * Optional. Gets or sets the VM size name.
    * @param nameValue The Name value.
    */
    public void setName(final String nameValue) {
        this.name = nameValue;
    }
    
    private int numberOfCores;
    
    /**
    * Optional. Gets or sets the Number of cores supported by a VM size.
    * @return The NumberOfCores value.
    */
    public int getNumberOfCores() {
        return this.numberOfCores;
    }
    
    /**
    * Optional. Gets or sets the Number of cores supported by a VM size.
    * @param numberOfCoresValue The NumberOfCores value.
    */
    public void setNumberOfCores(final int numberOfCoresValue) {
        this.numberOfCores = numberOfCoresValue;
    }
    
    private int oSDiskSizeInMB;
    
    /**
    * Optional. Gets or sets the OS disk size allowed by a VM size.
    * @return The OSDiskSizeInMB value.
    */
    public int getOSDiskSizeInMB() {
        return this.oSDiskSizeInMB;
    }
    
    /**
    * Optional. Gets or sets the OS disk size allowed by a VM size.
    * @param oSDiskSizeInMBValue The OSDiskSizeInMB value.
    */
    public void setOSDiskSizeInMB(final int oSDiskSizeInMBValue) {
        this.oSDiskSizeInMB = oSDiskSizeInMBValue;
    }
    
    private int resourceDiskSizeInMB;
    
    /**
    * Optional. Gets or sets the Resource disk size allowed by a VM size.
    * @return The ResourceDiskSizeInMB value.
    */
    public int getResourceDiskSizeInMB() {
        return this.resourceDiskSizeInMB;
    }
    
    /**
    * Optional. Gets or sets the Resource disk size allowed by a VM size.
    * @param resourceDiskSizeInMBValue The ResourceDiskSizeInMB value.
    */
    public void setResourceDiskSizeInMB(final int resourceDiskSizeInMBValue) {
        this.resourceDiskSizeInMB = resourceDiskSizeInMBValue;
    }
}
