/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.compute;

import com.microsoft.azure.management.compute.ComputeManagementClient;
import com.microsoft.azure.management.compute.ComputeManagementClientImpl;
import com.microsoft.azure.management.compute.VirtualMachineOperations;
import com.microsoft.azure.management.compute.models.AdditionalUnattendContent;
import com.microsoft.azure.management.compute.models.AvailabilitySetReference;
import com.microsoft.azure.management.compute.models.BootDiagnostics;
import com.microsoft.azure.management.compute.models.BootDiagnosticsInstanceView;
import com.microsoft.azure.management.compute.models.ComputeLongRunningOperationResponse;
import com.microsoft.azure.management.compute.models.ComputeOperationResponse;
import com.microsoft.azure.management.compute.models.ComputeOperationStatus;
import com.microsoft.azure.management.compute.models.DataDisk;
import com.microsoft.azure.management.compute.models.DeleteOperationResponse;
import com.microsoft.azure.management.compute.models.DiagnosticsProfile;
import com.microsoft.azure.management.compute.models.DiskInstanceView;
import com.microsoft.azure.management.compute.models.HardwareProfile;
import com.microsoft.azure.management.compute.models.ImageReference;
import com.microsoft.azure.management.compute.models.InstanceViewStatus;
import com.microsoft.azure.management.compute.models.LinuxConfiguration;
import com.microsoft.azure.management.compute.models.ListParameters;
import com.microsoft.azure.management.compute.models.NetworkInterfaceReference;
import com.microsoft.azure.management.compute.models.NetworkProfile;
import com.microsoft.azure.management.compute.models.OSDisk;
import com.microsoft.azure.management.compute.models.OSProfile;
import com.microsoft.azure.management.compute.models.Plan;
import com.microsoft.azure.management.compute.models.SourceVaultReference;
import com.microsoft.azure.management.compute.models.SshConfiguration;
import com.microsoft.azure.management.compute.models.SshPublicKey;
import com.microsoft.azure.management.compute.models.StorageProfile;
import com.microsoft.azure.management.compute.models.VaultCertificate;
import com.microsoft.azure.management.compute.models.VaultSecretGroup;
import com.microsoft.azure.management.compute.models.VirtualHardDisk;
import com.microsoft.azure.management.compute.models.VirtualMachine;
import com.microsoft.azure.management.compute.models.VirtualMachineAgentInstanceView;
import com.microsoft.azure.management.compute.models.VirtualMachineCaptureParameters;
import com.microsoft.azure.management.compute.models.VirtualMachineCreateOrUpdateResponse;
import com.microsoft.azure.management.compute.models.VirtualMachineExtension;
import com.microsoft.azure.management.compute.models.VirtualMachineExtensionHandlerInstanceView;
import com.microsoft.azure.management.compute.models.VirtualMachineExtensionInstanceView;
import com.microsoft.azure.management.compute.models.VirtualMachineGetResponse;
import com.microsoft.azure.management.compute.models.VirtualMachineInstanceView;
import com.microsoft.azure.management.compute.models.VirtualMachineListResponse;
import com.microsoft.azure.management.compute.models.VirtualMachineSize;
import com.microsoft.azure.management.compute.models.VirtualMachineSizeListResponse;
import com.microsoft.azure.management.compute.models.WinRMConfiguration;
import com.microsoft.azure.management.compute.models.WinRMListener;
import com.microsoft.azure.management.compute.models.WindowsConfiguration;
import com.microsoft.windowsazure.core.LazyCollection;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseFilter;
import com.microsoft.windowsazure.core.utils.CollectionStringBuilder;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.NullNode;
import org.codehaus.jackson.node.ObjectNode;

public class VirtualMachineOperationsImpl
implements ServiceOperations<ComputeManagementClientImpl>,
VirtualMachineOperations {
    private ComputeManagementClientImpl client;

    VirtualMachineOperationsImpl(ComputeManagementClientImpl client) {
        this.client = client;
    }

    public ComputeManagementClientImpl getClient() {
        return this.client;
    }

    @Override
    public Future<ComputeOperationResponse> beginCapturingAsync(final String resourceGroupName, final String vmName, final VirtualMachineCaptureParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<ComputeOperationResponse>(){

            @Override
            public ComputeOperationResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.beginCapturing(resourceGroupName, vmName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComputeOperationResponse beginCapturing(String resourceGroupName, String vmName, VirtualMachineCaptureParameters parameters) throws IOException, ServiceException {
        ObjectNode virtualMachineCaptureParametersValue;
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (vmName == null) {
            throw new NullPointerException("vmName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getDestinationContainerName() == null) {
            throw new NullPointerException("parameters.DestinationContainerName");
        }
        if (parameters.getVirtualHardDiskNamePrefix() == null) {
            throw new NullPointerException("parameters.VirtualHardDiskNamePrefix");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("vmName", vmName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginCapturingAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/";
        url = url + "virtualMachines";
        url = url + "/";
        url = url + URLEncoder.encode(vmName, "UTF-8");
        url = url + "/capture";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/json");
        String requestContent = null;
        ObjectNode requestDoc = null;
        ObjectMapper objectMapper = new ObjectMapper();
        requestDoc = virtualMachineCaptureParametersValue = objectMapper.createObjectNode();
        virtualMachineCaptureParametersValue.put("vhdPrefix", parameters.getVirtualHardDiskNamePrefix());
        virtualMachineCaptureParametersValue.put("destinationContainerName", parameters.getDestinationContainerName());
        virtualMachineCaptureParametersValue.put("overwriteVhds", parameters.isOverwrite());
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue((Writer)stringWriter, (Object)requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            ComputeOperationResponse result = null;
            result = new ComputeOperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            ComputeOperationResponse computeOperationResponse = result;
            return computeOperationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<VirtualMachineCreateOrUpdateResponse> beginCreatingOrUpdatingAsync(final String resourceGroupName, final VirtualMachine parameters) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineCreateOrUpdateResponse>(){

            @Override
            public VirtualMachineCreateOrUpdateResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.beginCreatingOrUpdating(resourceGroupName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public VirtualMachineCreateOrUpdateResponse beginCreatingOrUpdating(String resourceGroupName, VirtualMachine parameters) throws IOException, ServiceException, URISyntaxException {
        void var19_103;
        CloseableHttpResponse closeableHttpResponse;
        ObjectNode virtualMachineJsonValue;
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getExtensions() != null) {
            for (VirtualMachineExtension extensionsParameterItem : parameters.getExtensions()) {
                if (extensionsParameterItem.getLocation() != null) continue;
                throw new NullPointerException("parameters.Extensions.Location");
            }
        }
        if (parameters.getLocation() == null) {
            throw new NullPointerException("parameters.Location");
        }
        if (parameters.getStorageProfile() != null) {
            if (parameters.getStorageProfile().getDataDisks() != null) {
                for (DataDisk dataDisksParameterItem : parameters.getStorageProfile().getDataDisks()) {
                    if (dataDisksParameterItem.getCreateOption() == null) {
                        throw new NullPointerException("parameters.StorageProfile.DataDisks.CreateOption");
                    }
                    if (dataDisksParameterItem.getName() == null) {
                        throw new NullPointerException("parameters.StorageProfile.DataDisks.Name");
                    }
                    if (dataDisksParameterItem.getVirtualHardDisk() != null) continue;
                    throw new NullPointerException("parameters.StorageProfile.DataDisks.VirtualHardDisk");
                }
            }
            if (parameters.getStorageProfile().getOSDisk() != null) {
                if (parameters.getStorageProfile().getOSDisk().getCreateOption() == null) {
                    throw new NullPointerException("parameters.StorageProfile.OSDisk.CreateOption");
                }
                if (parameters.getStorageProfile().getOSDisk().getName() == null) {
                    throw new NullPointerException("parameters.StorageProfile.OSDisk.Name");
                }
                if (parameters.getStorageProfile().getOSDisk().getVirtualHardDisk() == null) {
                    throw new NullPointerException("parameters.StorageProfile.OSDisk.VirtualHardDisk");
                }
            }
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("parameters", (Object)parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginCreatingOrUpdatingAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/";
        url = url + "virtualMachines";
        url = url + "/";
        if (parameters.getName() != null) {
            url = url + URLEncoder.encode(parameters.getName(), "UTF-8");
        }
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPut httpRequest = new HttpPut(url);
        httpRequest.setHeader("Content-Type", "application/json");
        String requestContent = null;
        ObjectNode requestDoc = null;
        ObjectMapper objectMapper = new ObjectMapper();
        requestDoc = virtualMachineJsonValue = objectMapper.createObjectNode();
        if (parameters.getPlan() != null) {
            ObjectNode planValue = objectMapper.createObjectNode();
            virtualMachineJsonValue.put("plan", (JsonNode)planValue);
            if (parameters.getPlan().getName() != null) {
                planValue.put("name", parameters.getPlan().getName());
            }
            if (parameters.getPlan().getPublisher() != null) {
                planValue.put("publisher", parameters.getPlan().getPublisher());
            }
            if (parameters.getPlan().getProduct() != null) {
                planValue.put("product", parameters.getPlan().getProduct());
            }
            if (parameters.getPlan().getPromotionCode() != null) {
                planValue.put("promotionCode", parameters.getPlan().getPromotionCode());
            }
        }
        ObjectNode propertiesValue = objectMapper.createObjectNode();
        virtualMachineJsonValue.put("properties", (JsonNode)propertiesValue);
        if (parameters.getHardwareProfile() != null) {
            ObjectNode hardwareProfileValue = objectMapper.createObjectNode();
            propertiesValue.put("hardwareProfile", (JsonNode)hardwareProfileValue);
            if (parameters.getHardwareProfile().getVirtualMachineSize() != null) {
                hardwareProfileValue.put("vmSize", parameters.getHardwareProfile().getVirtualMachineSize());
            }
        }
        if (parameters.getStorageProfile() != null) {
            ObjectNode storageProfileValue = objectMapper.createObjectNode();
            propertiesValue.put("storageProfile", (JsonNode)storageProfileValue);
            if (parameters.getStorageProfile().getImageReference() != null) {
                ObjectNode imageReferenceValue = objectMapper.createObjectNode();
                storageProfileValue.put("imageReference", (JsonNode)imageReferenceValue);
                if (parameters.getStorageProfile().getImageReference().getPublisher() != null) {
                    imageReferenceValue.put("publisher", parameters.getStorageProfile().getImageReference().getPublisher());
                }
                if (parameters.getStorageProfile().getImageReference().getOffer() != null) {
                    imageReferenceValue.put("offer", parameters.getStorageProfile().getImageReference().getOffer());
                }
                if (parameters.getStorageProfile().getImageReference().getSku() != null) {
                    imageReferenceValue.put("sku", parameters.getStorageProfile().getImageReference().getSku());
                }
                if (parameters.getStorageProfile().getImageReference().getVersion() != null) {
                    imageReferenceValue.put("version", parameters.getStorageProfile().getImageReference().getVersion());
                }
            }
            if (parameters.getStorageProfile().getOSDisk() != null) {
                ObjectNode osDiskValue = objectMapper.createObjectNode();
                storageProfileValue.put("osDisk", (JsonNode)osDiskValue);
                if (parameters.getStorageProfile().getOSDisk().getOperatingSystemType() != null) {
                    osDiskValue.put("osType", parameters.getStorageProfile().getOSDisk().getOperatingSystemType());
                }
                osDiskValue.put("name", parameters.getStorageProfile().getOSDisk().getName());
                ObjectNode objectNode = objectMapper.createObjectNode();
                osDiskValue.put("vhd", (JsonNode)objectNode);
                if (parameters.getStorageProfile().getOSDisk().getVirtualHardDisk().getUri() != null) {
                    objectNode.put("uri", parameters.getStorageProfile().getOSDisk().getVirtualHardDisk().getUri());
                }
                if (parameters.getStorageProfile().getOSDisk().getSourceImage() != null) {
                    ObjectNode objectNode2 = objectMapper.createObjectNode();
                    osDiskValue.put("image", (JsonNode)objectNode2);
                    if (parameters.getStorageProfile().getOSDisk().getSourceImage().getUri() != null) {
                        objectNode2.put("uri", parameters.getStorageProfile().getOSDisk().getSourceImage().getUri());
                    }
                }
                if (parameters.getStorageProfile().getOSDisk().getCaching() != null) {
                    osDiskValue.put("caching", parameters.getStorageProfile().getOSDisk().getCaching());
                }
                osDiskValue.put("createOption", parameters.getStorageProfile().getOSDisk().getCreateOption());
                if (parameters.getStorageProfile().getOSDisk().getDiskSizeGB() != null) {
                    osDiskValue.put("diskSizeGB", parameters.getStorageProfile().getOSDisk().getDiskSizeGB());
                }
            }
            if (parameters.getStorageProfile().getDataDisks() != null && (!(parameters.getStorageProfile().getDataDisks() instanceof LazyCollection) || ((LazyCollection)parameters.getStorageProfile().getDataDisks()).isInitialized())) {
                ArrayNode dataDisksArray = objectMapper.createArrayNode();
                for (DataDisk dataDisk : parameters.getStorageProfile().getDataDisks()) {
                    ObjectNode objectNode = objectMapper.createObjectNode();
                    dataDisksArray.add((JsonNode)objectNode);
                    objectNode.put("lun", dataDisk.getLun());
                    objectNode.put("name", dataDisk.getName());
                    ObjectNode vhdValue2 = objectMapper.createObjectNode();
                    objectNode.put("vhd", (JsonNode)vhdValue2);
                    if (dataDisk.getVirtualHardDisk().getUri() != null) {
                        vhdValue2.put("uri", dataDisk.getVirtualHardDisk().getUri());
                    }
                    if (dataDisk.getSourceImage() != null) {
                        ObjectNode imageValue2 = objectMapper.createObjectNode();
                        objectNode.put("image", (JsonNode)imageValue2);
                        if (dataDisk.getSourceImage().getUri() != null) {
                            imageValue2.put("uri", dataDisk.getSourceImage().getUri());
                        }
                    }
                    if (dataDisk.getCaching() != null) {
                        objectNode.put("caching", dataDisk.getCaching());
                    }
                    objectNode.put("createOption", dataDisk.getCreateOption());
                    if (dataDisk.getDiskSizeGB() == null) continue;
                    objectNode.put("diskSizeGB", dataDisk.getDiskSizeGB());
                }
                storageProfileValue.put("dataDisks", (JsonNode)dataDisksArray);
            }
        }
        if (parameters.getOSProfile() != null) {
            ObjectNode osProfileValue = objectMapper.createObjectNode();
            propertiesValue.put("osProfile", (JsonNode)osProfileValue);
            if (parameters.getOSProfile().getComputerName() != null) {
                osProfileValue.put("computerName", parameters.getOSProfile().getComputerName());
            }
            if (parameters.getOSProfile().getAdminUsername() != null) {
                osProfileValue.put("adminUsername", parameters.getOSProfile().getAdminUsername());
            }
            if (parameters.getOSProfile().getAdminPassword() != null) {
                osProfileValue.put("adminPassword", parameters.getOSProfile().getAdminPassword());
            }
            if (parameters.getOSProfile().getCustomData() != null) {
                osProfileValue.put("customData", parameters.getOSProfile().getCustomData());
            }
            if (parameters.getOSProfile().getWindowsConfiguration() != null) {
                ObjectNode windowsConfigurationValue = objectMapper.createObjectNode();
                osProfileValue.put("windowsConfiguration", (JsonNode)windowsConfigurationValue);
                if (parameters.getOSProfile().getWindowsConfiguration().isProvisionVMAgent() != null) {
                    windowsConfigurationValue.put("provisionVMAgent", parameters.getOSProfile().getWindowsConfiguration().isProvisionVMAgent());
                }
                if (parameters.getOSProfile().getWindowsConfiguration().isEnableAutomaticUpdates() != null) {
                    windowsConfigurationValue.put("enableAutomaticUpdates", parameters.getOSProfile().getWindowsConfiguration().isEnableAutomaticUpdates());
                }
                if (parameters.getOSProfile().getWindowsConfiguration().getTimeZone() != null) {
                    windowsConfigurationValue.put("timeZone", parameters.getOSProfile().getWindowsConfiguration().getTimeZone());
                }
                if (parameters.getOSProfile().getWindowsConfiguration().getAdditionalUnattendContents() != null && (!(parameters.getOSProfile().getWindowsConfiguration().getAdditionalUnattendContents() instanceof LazyCollection) || ((LazyCollection)parameters.getOSProfile().getWindowsConfiguration().getAdditionalUnattendContents()).isInitialized())) {
                    ArrayNode arrayNode = objectMapper.createArrayNode();
                    for (AdditionalUnattendContent additionalUnattendContent : parameters.getOSProfile().getWindowsConfiguration().getAdditionalUnattendContents()) {
                        ObjectNode additionalUnattendContentValue = objectMapper.createObjectNode();
                        arrayNode.add((JsonNode)additionalUnattendContentValue);
                        if (additionalUnattendContent.getPassName() != null) {
                            additionalUnattendContentValue.put("passName", additionalUnattendContent.getPassName());
                        }
                        if (additionalUnattendContent.getComponentName() != null) {
                            additionalUnattendContentValue.put("componentName", additionalUnattendContent.getComponentName());
                        }
                        if (additionalUnattendContent.getSettingName() != null) {
                            additionalUnattendContentValue.put("settingName", additionalUnattendContent.getSettingName());
                        }
                        if (additionalUnattendContent.getContent() == null) continue;
                        additionalUnattendContentValue.put("content", additionalUnattendContent.getContent());
                    }
                    windowsConfigurationValue.put("additionalUnattendContent", (JsonNode)arrayNode);
                }
                if (parameters.getOSProfile().getWindowsConfiguration().getWinRMConfiguration() != null) {
                    ObjectNode objectNode = objectMapper.createObjectNode();
                    windowsConfigurationValue.put("winRM", (JsonNode)objectNode);
                    if (parameters.getOSProfile().getWindowsConfiguration().getWinRMConfiguration().getListeners() != null && (!(parameters.getOSProfile().getWindowsConfiguration().getWinRMConfiguration().getListeners() instanceof LazyCollection) || ((LazyCollection)parameters.getOSProfile().getWindowsConfiguration().getWinRMConfiguration().getListeners()).isInitialized())) {
                        ArrayNode arrayNode = objectMapper.createArrayNode();
                        for (WinRMListener listenersItem : parameters.getOSProfile().getWindowsConfiguration().getWinRMConfiguration().getListeners()) {
                            ObjectNode winRMListenerValue = objectMapper.createObjectNode();
                            arrayNode.add((JsonNode)winRMListenerValue);
                            if (listenersItem.getProtocol() != null) {
                                winRMListenerValue.put("protocol", listenersItem.getProtocol());
                            }
                            if (listenersItem.getCertificateUrl() == null) continue;
                            winRMListenerValue.put("certificateUrl", listenersItem.getCertificateUrl().toString());
                        }
                        objectNode.put("listeners", (JsonNode)arrayNode);
                    }
                }
            }
            if (parameters.getOSProfile().getLinuxConfiguration() != null) {
                ObjectNode linuxConfigurationValue = objectMapper.createObjectNode();
                osProfileValue.put("linuxConfiguration", (JsonNode)linuxConfigurationValue);
                if (parameters.getOSProfile().getLinuxConfiguration().isDisablePasswordAuthentication() != null) {
                    linuxConfigurationValue.put("disablePasswordAuthentication", parameters.getOSProfile().getLinuxConfiguration().isDisablePasswordAuthentication());
                }
                if (parameters.getOSProfile().getLinuxConfiguration().getSshConfiguration() != null) {
                    ObjectNode objectNode = objectMapper.createObjectNode();
                    linuxConfigurationValue.put("ssh", (JsonNode)objectNode);
                    if (parameters.getOSProfile().getLinuxConfiguration().getSshConfiguration().getPublicKeys() != null && (!(parameters.getOSProfile().getLinuxConfiguration().getSshConfiguration().getPublicKeys() instanceof LazyCollection) || ((LazyCollection)parameters.getOSProfile().getLinuxConfiguration().getSshConfiguration().getPublicKeys()).isInitialized())) {
                        ArrayNode arrayNode = objectMapper.createArrayNode();
                        for (SshPublicKey publicKeysItem : parameters.getOSProfile().getLinuxConfiguration().getSshConfiguration().getPublicKeys()) {
                            ObjectNode sshPublicKeyValue = objectMapper.createObjectNode();
                            arrayNode.add((JsonNode)sshPublicKeyValue);
                            if (publicKeysItem.getPath() != null) {
                                sshPublicKeyValue.put("path", publicKeysItem.getPath());
                            }
                            if (publicKeysItem.getKeyData() == null) continue;
                            sshPublicKeyValue.put("keyData", publicKeysItem.getKeyData());
                        }
                        objectNode.put("publicKeys", (JsonNode)arrayNode);
                    }
                }
            }
            if (parameters.getOSProfile().getSecrets() != null) {
                ArrayNode secretsArray = objectMapper.createArrayNode();
                for (VaultSecretGroup vaultSecretGroup : parameters.getOSProfile().getSecrets()) {
                    ObjectNode objectNode = objectMapper.createObjectNode();
                    secretsArray.add((JsonNode)objectNode);
                    if (vaultSecretGroup.getSourceVault() != null) {
                        ObjectNode sourceVaultValue = objectMapper.createObjectNode();
                        objectNode.put("sourceVault", (JsonNode)sourceVaultValue);
                        if (vaultSecretGroup.getSourceVault().getReferenceUri() != null) {
                            sourceVaultValue.put("id", vaultSecretGroup.getSourceVault().getReferenceUri());
                        }
                    }
                    if (vaultSecretGroup.getVaultCertificates() == null || vaultSecretGroup.getVaultCertificates() instanceof LazyCollection && !((LazyCollection)vaultSecretGroup.getVaultCertificates()).isInitialized()) continue;
                    ArrayNode vaultCertificatesArray = objectMapper.createArrayNode();
                    for (VaultCertificate vaultCertificate : vaultSecretGroup.getVaultCertificates()) {
                        ObjectNode vaultCertificateValue = objectMapper.createObjectNode();
                        vaultCertificatesArray.add((JsonNode)vaultCertificateValue);
                        if (vaultCertificate.getCertificateUrl() != null) {
                            vaultCertificateValue.put("certificateUrl", vaultCertificate.getCertificateUrl());
                        }
                        if (vaultCertificate.getCertificateStore() == null) continue;
                        vaultCertificateValue.put("certificateStore", vaultCertificate.getCertificateStore());
                    }
                    objectNode.put("vaultCertificates", (JsonNode)vaultCertificatesArray);
                }
                osProfileValue.put("secrets", (JsonNode)secretsArray);
            }
        }
        if (parameters.getNetworkProfile() != null) {
            ObjectNode networkProfileValue = objectMapper.createObjectNode();
            propertiesValue.put("networkProfile", (JsonNode)networkProfileValue);
            if (parameters.getNetworkProfile().getNetworkInterfaces() != null && (!(parameters.getNetworkProfile().getNetworkInterfaces() instanceof LazyCollection) || ((LazyCollection)parameters.getNetworkProfile().getNetworkInterfaces()).isInitialized())) {
                ArrayNode networkInterfacesArray = objectMapper.createArrayNode();
                for (NetworkInterfaceReference networkInterfaceReference : parameters.getNetworkProfile().getNetworkInterfaces()) {
                    ObjectNode objectNode = objectMapper.createObjectNode();
                    networkInterfacesArray.add((JsonNode)objectNode);
                    ObjectNode propertiesValue2 = objectMapper.createObjectNode();
                    objectNode.put("properties", (JsonNode)propertiesValue2);
                    if (networkInterfaceReference.isPrimary() != null) {
                        propertiesValue2.put("primary", networkInterfaceReference.isPrimary());
                    }
                    if (networkInterfaceReference.getReferenceUri() == null) continue;
                    objectNode.put("id", networkInterfaceReference.getReferenceUri());
                }
                networkProfileValue.put("networkInterfaces", (JsonNode)networkInterfacesArray);
            }
        }
        if (parameters.getDiagnosticsProfile() != null) {
            ObjectNode diagnosticsProfileValue = objectMapper.createObjectNode();
            propertiesValue.put("diagnosticsProfile", (JsonNode)diagnosticsProfileValue);
            if (parameters.getDiagnosticsProfile().getBootDiagnostics() != null) {
                ObjectNode bootDiagnosticsValue = objectMapper.createObjectNode();
                diagnosticsProfileValue.put("bootDiagnostics", (JsonNode)bootDiagnosticsValue);
                if (parameters.getDiagnosticsProfile().getBootDiagnostics().isEnabled() != null) {
                    bootDiagnosticsValue.put("enabled", parameters.getDiagnosticsProfile().getBootDiagnostics().isEnabled());
                }
                if (parameters.getDiagnosticsProfile().getBootDiagnostics().getStorageUri() != null) {
                    bootDiagnosticsValue.put("storageUri", parameters.getDiagnosticsProfile().getBootDiagnostics().getStorageUri().toString());
                }
            }
        }
        if (parameters.getAvailabilitySetReference() != null) {
            ObjectNode availabilitySetValue = objectMapper.createObjectNode();
            propertiesValue.put("availabilitySet", (JsonNode)availabilitySetValue);
            if (parameters.getAvailabilitySetReference().getReferenceUri() != null) {
                availabilitySetValue.put("id", parameters.getAvailabilitySetReference().getReferenceUri());
            }
        }
        if (parameters.getProvisioningState() != null) {
            propertiesValue.put("provisioningState", parameters.getProvisioningState());
        }
        if (parameters.getInstanceView() != null) {
            ObjectNode instanceViewValue = objectMapper.createObjectNode();
            propertiesValue.put("instanceView", (JsonNode)instanceViewValue);
            if (parameters.getInstanceView().getPlatformUpdateDomain() != null) {
                instanceViewValue.put("platformUpdateDomain", parameters.getInstanceView().getPlatformUpdateDomain());
            }
            if (parameters.getInstanceView().getPlatformFaultDomain() != null) {
                instanceViewValue.put("platformFaultDomain", parameters.getInstanceView().getPlatformFaultDomain());
            }
            if (parameters.getInstanceView().getRemoteDesktopThumbprint() != null) {
                instanceViewValue.put("rdpThumbPrint", parameters.getInstanceView().getRemoteDesktopThumbprint());
            }
            if (parameters.getInstanceView().getVMAgent() != null) {
                ObjectNode vmAgentValue = objectMapper.createObjectNode();
                instanceViewValue.put("vmAgent", (JsonNode)vmAgentValue);
                if (parameters.getInstanceView().getVMAgent().getVMAgentVersion() != null) {
                    vmAgentValue.put("vmAgentVersion", parameters.getInstanceView().getVMAgent().getVMAgentVersion());
                }
                if (parameters.getInstanceView().getVMAgent().getExtensionHandlers() != null && (!(parameters.getInstanceView().getVMAgent().getExtensionHandlers() instanceof LazyCollection) || ((LazyCollection)parameters.getInstanceView().getVMAgent().getExtensionHandlers()).isInitialized())) {
                    ArrayNode arrayNode = objectMapper.createArrayNode();
                    for (VirtualMachineExtensionHandlerInstanceView virtualMachineExtensionHandlerInstanceView : parameters.getInstanceView().getVMAgent().getExtensionHandlers()) {
                        ObjectNode virtualMachineExtensionHandlerInstanceViewValue = objectMapper.createObjectNode();
                        arrayNode.add((JsonNode)virtualMachineExtensionHandlerInstanceViewValue);
                        if (virtualMachineExtensionHandlerInstanceView.getType() != null) {
                            virtualMachineExtensionHandlerInstanceViewValue.put("type", virtualMachineExtensionHandlerInstanceView.getType());
                        }
                        if (virtualMachineExtensionHandlerInstanceView.getTypeHandlerVersion() != null) {
                            virtualMachineExtensionHandlerInstanceViewValue.put("typeHandlerVersion", virtualMachineExtensionHandlerInstanceView.getTypeHandlerVersion());
                        }
                        if (virtualMachineExtensionHandlerInstanceView.getStatus() == null) continue;
                        ObjectNode statusValue = objectMapper.createObjectNode();
                        virtualMachineExtensionHandlerInstanceViewValue.put("status", (JsonNode)statusValue);
                        if (virtualMachineExtensionHandlerInstanceView.getStatus().getCode() != null) {
                            statusValue.put("code", virtualMachineExtensionHandlerInstanceView.getStatus().getCode());
                        }
                        if (virtualMachineExtensionHandlerInstanceView.getStatus().getLevel() != null) {
                            statusValue.put("level", virtualMachineExtensionHandlerInstanceView.getStatus().getLevel());
                        }
                        if (virtualMachineExtensionHandlerInstanceView.getStatus().getDisplayStatus() != null) {
                            statusValue.put("displayStatus", virtualMachineExtensionHandlerInstanceView.getStatus().getDisplayStatus());
                        }
                        if (virtualMachineExtensionHandlerInstanceView.getStatus().getMessage() != null) {
                            statusValue.put("message", virtualMachineExtensionHandlerInstanceView.getStatus().getMessage());
                        }
                        if (virtualMachineExtensionHandlerInstanceView.getStatus().getTime() == null) continue;
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                        statusValue.put("time", simpleDateFormat.format(virtualMachineExtensionHandlerInstanceView.getStatus().getTime().getTime()));
                    }
                    vmAgentValue.put("extensionHandlers", (JsonNode)arrayNode);
                }
                if (parameters.getInstanceView().getVMAgent().getStatuses() != null) {
                    ArrayNode arrayNode = objectMapper.createArrayNode();
                    for (InstanceViewStatus instanceViewStatus : parameters.getInstanceView().getVMAgent().getStatuses()) {
                        ObjectNode instanceViewStatusValue = objectMapper.createObjectNode();
                        arrayNode.add((JsonNode)instanceViewStatusValue);
                        if (instanceViewStatus.getCode() != null) {
                            instanceViewStatusValue.put("code", instanceViewStatus.getCode());
                        }
                        if (instanceViewStatus.getLevel() != null) {
                            instanceViewStatusValue.put("level", instanceViewStatus.getLevel());
                        }
                        if (instanceViewStatus.getDisplayStatus() != null) {
                            instanceViewStatusValue.put("displayStatus", instanceViewStatus.getDisplayStatus());
                        }
                        if (instanceViewStatus.getMessage() != null) {
                            instanceViewStatusValue.put("message", instanceViewStatus.getMessage());
                        }
                        if (instanceViewStatus.getTime() == null) continue;
                        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                        simpleDateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
                        instanceViewStatusValue.put("time", simpleDateFormat2.format(instanceViewStatus.getTime().getTime()));
                    }
                    vmAgentValue.put("statuses", (JsonNode)arrayNode);
                }
            }
            if (parameters.getInstanceView().getDisks() != null && (!(parameters.getInstanceView().getDisks() instanceof LazyCollection) || ((LazyCollection)parameters.getInstanceView().getDisks()).isInitialized())) {
                ArrayNode disksArray = objectMapper.createArrayNode();
                for (DiskInstanceView diskInstanceView : parameters.getInstanceView().getDisks()) {
                    ObjectNode objectNode = objectMapper.createObjectNode();
                    disksArray.add((JsonNode)objectNode);
                    if (diskInstanceView.getName() != null) {
                        objectNode.put("name", diskInstanceView.getName());
                    }
                    if (diskInstanceView.getStatuses() == null) continue;
                    ArrayNode statusesArray2 = objectMapper.createArrayNode();
                    for (InstanceViewStatus instanceViewStatus : diskInstanceView.getStatuses()) {
                        ObjectNode instanceViewStatusValue2 = objectMapper.createObjectNode();
                        statusesArray2.add((JsonNode)instanceViewStatusValue2);
                        if (instanceViewStatus.getCode() != null) {
                            instanceViewStatusValue2.put("code", instanceViewStatus.getCode());
                        }
                        if (instanceViewStatus.getLevel() != null) {
                            instanceViewStatusValue2.put("level", instanceViewStatus.getLevel());
                        }
                        if (instanceViewStatus.getDisplayStatus() != null) {
                            instanceViewStatusValue2.put("displayStatus", instanceViewStatus.getDisplayStatus());
                        }
                        if (instanceViewStatus.getMessage() != null) {
                            instanceViewStatusValue2.put("message", instanceViewStatus.getMessage());
                        }
                        if (instanceViewStatus.getTime() == null) continue;
                        SimpleDateFormat simpleDateFormat3 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                        simpleDateFormat3.setTimeZone(TimeZone.getTimeZone("UTC"));
                        instanceViewStatusValue2.put("time", simpleDateFormat3.format(instanceViewStatus.getTime().getTime()));
                    }
                    objectNode.put("statuses", (JsonNode)statusesArray2);
                }
                instanceViewValue.put("disks", (JsonNode)disksArray);
            }
            if (parameters.getInstanceView().getExtensions() != null && (!(parameters.getInstanceView().getExtensions() instanceof LazyCollection) || ((LazyCollection)parameters.getInstanceView().getExtensions()).isInitialized())) {
                ArrayNode extensionsArray = objectMapper.createArrayNode();
                for (VirtualMachineExtensionInstanceView virtualMachineExtensionInstanceView : parameters.getInstanceView().getExtensions()) {
                    ObjectNode objectNode = objectMapper.createObjectNode();
                    extensionsArray.add((JsonNode)objectNode);
                    if (virtualMachineExtensionInstanceView.getName() != null) {
                        objectNode.put("name", virtualMachineExtensionInstanceView.getName());
                    }
                    if (virtualMachineExtensionInstanceView.getExtensionType() != null) {
                        objectNode.put("type", virtualMachineExtensionInstanceView.getExtensionType());
                    }
                    if (virtualMachineExtensionInstanceView.getTypeHandlerVersion() != null) {
                        objectNode.put("typeHandlerVersion", virtualMachineExtensionInstanceView.getTypeHandlerVersion());
                    }
                    if (virtualMachineExtensionInstanceView.getSubStatuses() != null && (!(virtualMachineExtensionInstanceView.getSubStatuses() instanceof LazyCollection) || ((LazyCollection)virtualMachineExtensionInstanceView.getSubStatuses()).isInitialized())) {
                        ArrayNode substatusesArray = objectMapper.createArrayNode();
                        for (InstanceViewStatus instanceViewStatus : virtualMachineExtensionInstanceView.getSubStatuses()) {
                            ObjectNode instanceViewStatusValue3 = objectMapper.createObjectNode();
                            substatusesArray.add((JsonNode)instanceViewStatusValue3);
                            if (instanceViewStatus.getCode() != null) {
                                instanceViewStatusValue3.put("code", instanceViewStatus.getCode());
                            }
                            if (instanceViewStatus.getLevel() != null) {
                                instanceViewStatusValue3.put("level", instanceViewStatus.getLevel());
                            }
                            if (instanceViewStatus.getDisplayStatus() != null) {
                                instanceViewStatusValue3.put("displayStatus", instanceViewStatus.getDisplayStatus());
                            }
                            if (instanceViewStatus.getMessage() != null) {
                                instanceViewStatusValue3.put("message", instanceViewStatus.getMessage());
                            }
                            if (instanceViewStatus.getTime() == null) continue;
                            SimpleDateFormat simpleDateFormat4 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                            simpleDateFormat4.setTimeZone(TimeZone.getTimeZone("UTC"));
                            instanceViewStatusValue3.put("time", simpleDateFormat4.format(instanceViewStatus.getTime().getTime()));
                        }
                        objectNode.put("substatuses", (JsonNode)substatusesArray);
                    }
                    if (virtualMachineExtensionInstanceView.getStatuses() == null) continue;
                    ArrayNode statusesArray3 = objectMapper.createArrayNode();
                    for (InstanceViewStatus instanceViewStatus : virtualMachineExtensionInstanceView.getStatuses()) {
                        ObjectNode instanceViewStatusValue4 = objectMapper.createObjectNode();
                        statusesArray3.add((JsonNode)instanceViewStatusValue4);
                        if (instanceViewStatus.getCode() != null) {
                            instanceViewStatusValue4.put("code", instanceViewStatus.getCode());
                        }
                        if (instanceViewStatus.getLevel() != null) {
                            instanceViewStatusValue4.put("level", instanceViewStatus.getLevel());
                        }
                        if (instanceViewStatus.getDisplayStatus() != null) {
                            instanceViewStatusValue4.put("displayStatus", instanceViewStatus.getDisplayStatus());
                        }
                        if (instanceViewStatus.getMessage() != null) {
                            instanceViewStatusValue4.put("message", instanceViewStatus.getMessage());
                        }
                        if (instanceViewStatus.getTime() == null) continue;
                        SimpleDateFormat simpleDateFormat5 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                        simpleDateFormat5.setTimeZone(TimeZone.getTimeZone("UTC"));
                        instanceViewStatusValue4.put("time", simpleDateFormat5.format(instanceViewStatus.getTime().getTime()));
                    }
                    objectNode.put("statuses", (JsonNode)statusesArray3);
                }
                instanceViewValue.put("extensions", (JsonNode)extensionsArray);
            }
            if (parameters.getInstanceView().getBootDiagnostics() != null) {
                ObjectNode bootDiagnosticsValue2 = objectMapper.createObjectNode();
                instanceViewValue.put("bootDiagnostics", (JsonNode)bootDiagnosticsValue2);
                if (parameters.getInstanceView().getBootDiagnostics().getConsoleScreenshotBlobUri() != null) {
                    bootDiagnosticsValue2.put("consoleScreenshotBlobUri", parameters.getInstanceView().getBootDiagnostics().getConsoleScreenshotBlobUri().toString());
                }
                if (parameters.getInstanceView().getBootDiagnostics().getSerialConsoleLogBlobUri() != null) {
                    bootDiagnosticsValue2.put("serialConsoleLogBlobUri", parameters.getInstanceView().getBootDiagnostics().getSerialConsoleLogBlobUri().toString());
                }
            }
            if (parameters.getInstanceView().getStatuses() != null) {
                Iterator<Object> statusesArray4 = objectMapper.createArrayNode();
                for (InstanceViewStatus instanceViewStatus : parameters.getInstanceView().getStatuses()) {
                    ObjectNode objectNode = objectMapper.createObjectNode();
                    statusesArray4.add((JsonNode)objectNode);
                    if (instanceViewStatus.getCode() != null) {
                        objectNode.put("code", instanceViewStatus.getCode());
                    }
                    if (instanceViewStatus.getLevel() != null) {
                        objectNode.put("level", instanceViewStatus.getLevel());
                    }
                    if (instanceViewStatus.getDisplayStatus() != null) {
                        objectNode.put("displayStatus", instanceViewStatus.getDisplayStatus());
                    }
                    if (instanceViewStatus.getMessage() != null) {
                        objectNode.put("message", instanceViewStatus.getMessage());
                    }
                    if (instanceViewStatus.getTime() == null) continue;
                    SimpleDateFormat simpleDateFormat6 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                    simpleDateFormat6.setTimeZone(TimeZone.getTimeZone("UTC"));
                    objectNode.put("time", simpleDateFormat6.format(instanceViewStatus.getTime().getTime()));
                }
                instanceViewValue.put("statuses", statusesArray4);
            }
        }
        if (parameters.getExtensions() != null) {
            ArrayNode resourcesArray = objectMapper.createArrayNode();
            for (VirtualMachineExtension virtualMachineExtension : parameters.getExtensions()) {
                ObjectNode objectNode = objectMapper.createObjectNode();
                resourcesArray.add((JsonNode)objectNode);
                ObjectNode objectNode3 = objectMapper.createObjectNode();
                objectNode.put("properties", (JsonNode)objectNode3);
                if (virtualMachineExtension.getPublisher() != null) {
                    objectNode3.put("publisher", virtualMachineExtension.getPublisher());
                }
                if (virtualMachineExtension.getExtensionType() != null) {
                    objectNode3.put("type", virtualMachineExtension.getExtensionType());
                }
                if (virtualMachineExtension.getTypeHandlerVersion() != null) {
                    objectNode3.put("typeHandlerVersion", virtualMachineExtension.getTypeHandlerVersion());
                }
                objectNode3.put("autoUpgradeMinorVersion", virtualMachineExtension.isAutoUpgradeMinorVersion());
                if (virtualMachineExtension.getSettings() != null) {
                    objectNode3.put("settings", objectMapper.readTree(virtualMachineExtension.getSettings()));
                }
                if (virtualMachineExtension.getProtectedSettings() != null) {
                    objectNode3.put("protectedSettings", objectMapper.readTree(virtualMachineExtension.getProtectedSettings()));
                }
                if (virtualMachineExtension.getProvisioningState() != null) {
                    objectNode3.put("provisioningState", virtualMachineExtension.getProvisioningState());
                }
                if (virtualMachineExtension.getInstanceView() != null) {
                    ObjectNode instanceViewValue2 = objectMapper.createObjectNode();
                    objectNode3.put("instanceView", (JsonNode)instanceViewValue2);
                    if (virtualMachineExtension.getInstanceView().getName() != null) {
                        instanceViewValue2.put("name", virtualMachineExtension.getInstanceView().getName());
                    }
                    if (virtualMachineExtension.getInstanceView().getExtensionType() != null) {
                        instanceViewValue2.put("type", virtualMachineExtension.getInstanceView().getExtensionType());
                    }
                    if (virtualMachineExtension.getInstanceView().getTypeHandlerVersion() != null) {
                        instanceViewValue2.put("typeHandlerVersion", virtualMachineExtension.getInstanceView().getTypeHandlerVersion());
                    }
                    if (virtualMachineExtension.getInstanceView().getSubStatuses() != null && (!(virtualMachineExtension.getInstanceView().getSubStatuses() instanceof LazyCollection) || ((LazyCollection)virtualMachineExtension.getInstanceView().getSubStatuses()).isInitialized())) {
                        ArrayNode substatusesArray2 = objectMapper.createArrayNode();
                        for (InstanceViewStatus substatusesItem2 : virtualMachineExtension.getInstanceView().getSubStatuses()) {
                            ObjectNode instanceViewStatusValue6 = objectMapper.createObjectNode();
                            substatusesArray2.add((JsonNode)instanceViewStatusValue6);
                            if (substatusesItem2.getCode() != null) {
                                instanceViewStatusValue6.put("code", substatusesItem2.getCode());
                            }
                            if (substatusesItem2.getLevel() != null) {
                                instanceViewStatusValue6.put("level", substatusesItem2.getLevel());
                            }
                            if (substatusesItem2.getDisplayStatus() != null) {
                                instanceViewStatusValue6.put("displayStatus", substatusesItem2.getDisplayStatus());
                            }
                            if (substatusesItem2.getMessage() != null) {
                                instanceViewStatusValue6.put("message", substatusesItem2.getMessage());
                            }
                            if (substatusesItem2.getTime() == null) continue;
                            SimpleDateFormat simpleDateFormat7 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                            simpleDateFormat7.setTimeZone(TimeZone.getTimeZone("UTC"));
                            instanceViewStatusValue6.put("time", simpleDateFormat7.format(substatusesItem2.getTime().getTime()));
                        }
                        instanceViewValue2.put("substatuses", (JsonNode)substatusesArray2);
                    }
                    if (virtualMachineExtension.getInstanceView().getStatuses() != null) {
                        ArrayNode statusesArray5 = objectMapper.createArrayNode();
                        for (InstanceViewStatus statusesItem5 : virtualMachineExtension.getInstanceView().getStatuses()) {
                            ObjectNode instanceViewStatusValue7 = objectMapper.createObjectNode();
                            statusesArray5.add((JsonNode)instanceViewStatusValue7);
                            if (statusesItem5.getCode() != null) {
                                instanceViewStatusValue7.put("code", statusesItem5.getCode());
                            }
                            if (statusesItem5.getLevel() != null) {
                                instanceViewStatusValue7.put("level", statusesItem5.getLevel());
                            }
                            if (statusesItem5.getDisplayStatus() != null) {
                                instanceViewStatusValue7.put("displayStatus", statusesItem5.getDisplayStatus());
                            }
                            if (statusesItem5.getMessage() != null) {
                                instanceViewStatusValue7.put("message", statusesItem5.getMessage());
                            }
                            if (statusesItem5.getTime() == null) continue;
                            SimpleDateFormat simpleDateFormat8 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
                            simpleDateFormat8.setTimeZone(TimeZone.getTimeZone("UTC"));
                            instanceViewStatusValue7.put("time", simpleDateFormat8.format(statusesItem5.getTime().getTime()));
                        }
                        instanceViewValue2.put("statuses", (JsonNode)statusesArray5);
                    }
                }
                if (virtualMachineExtension.getId() != null) {
                    objectNode.put("id", virtualMachineExtension.getId());
                }
                if (virtualMachineExtension.getName() != null) {
                    objectNode.put("name", virtualMachineExtension.getName());
                }
                if (virtualMachineExtension.getType() != null) {
                    objectNode.put("type", virtualMachineExtension.getType());
                }
                objectNode.put("location", virtualMachineExtension.getLocation());
                if (virtualMachineExtension.getTags() == null) continue;
                ObjectNode tagsDictionary = objectMapper.createObjectNode();
                for (Map.Entry entry : virtualMachineExtension.getTags().entrySet()) {
                    String tagsKey = (String)entry.getKey();
                    String tagsValue = (String)entry.getValue();
                    tagsDictionary.put(tagsKey, tagsValue);
                }
                objectNode.put("tags", (JsonNode)tagsDictionary);
            }
            virtualMachineJsonValue.put("resources", (JsonNode)resourcesArray);
        }
        if (parameters.getId() != null) {
            virtualMachineJsonValue.put("id", parameters.getId());
        }
        if (parameters.getName() != null) {
            virtualMachineJsonValue.put("name", parameters.getName());
        }
        if (parameters.getType() != null) {
            virtualMachineJsonValue.put("type", parameters.getType());
        }
        virtualMachineJsonValue.put("location", parameters.getLocation());
        if (parameters.getTags() != null) {
            ObjectNode tagsDictionary2 = objectMapper.createObjectNode();
            for (Map.Entry entry : parameters.getTags().entrySet()) {
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
                tagsDictionary2.put(string, string2);
            }
            virtualMachineJsonValue.put("tags", (JsonNode)tagsDictionary2);
        }
        StringWriter stringWriter = new StringWriter();
        objectMapper.writeValue((Writer)stringWriter, (Object)requestDoc);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity((HttpEntity)entity);
        httpRequest.setHeader("Content-Type", "application/json");
        Object var16_44 = null;
        try {
            void var18_102;
            int n;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            closeableHttpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)closeableHttpResponse);
            }
            if ((n = closeableHttpResponse.getStatusLine().getStatusCode()) != 200 && n != 201) {
                ServiceException serviceException = ServiceException.createFromJson((HttpRequest)httpRequest, (String)requestContent, (HttpResponse)closeableHttpResponse, (HttpEntity)closeableHttpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)serviceException);
                }
                throw serviceException;
            }
            Object var18_100 = null;
            if (n == 200 || n == 201) {
                InputStream responseContent = closeableHttpResponse.getEntity().getContent();
                VirtualMachineCreateOrUpdateResponse virtualMachineCreateOrUpdateResponse = new VirtualMachineCreateOrUpdateResponse();
                JsonNode responseDoc = null;
                String string = IOUtils.toString((InputStream)responseContent);
                if (!(string == null) && string.length() > 0) {
                    responseDoc = objectMapper.readTree(string);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode tagsSequenceElement2;
                    JsonNode locationValue2;
                    JsonNode typeValue6;
                    JsonNode nameValue8;
                    JsonNode idValue5;
                    JsonNode resourcesArray2;
                    JsonNode propertiesValue4;
                    VirtualMachine virtualMachineInstance = new VirtualMachine();
                    virtualMachineCreateOrUpdateResponse.setVirtualMachine(virtualMachineInstance);
                    JsonNode planValue2 = responseDoc.get("plan");
                    if (planValue2 != null && !(planValue2 instanceof NullNode)) {
                        JsonNode promotionCodeValue;
                        JsonNode productValue;
                        JsonNode publisherValue;
                        Plan planInstance = new Plan();
                        virtualMachineInstance.setPlan(planInstance);
                        JsonNode nameValue = planValue2.get("name");
                        if (nameValue != null && !(nameValue instanceof NullNode)) {
                            String nameInstance = nameValue.getTextValue();
                            planInstance.setName(nameInstance);
                        }
                        if ((publisherValue = planValue2.get("publisher")) != null && !(publisherValue instanceof NullNode)) {
                            String publisherInstance = publisherValue.getTextValue();
                            planInstance.setPublisher(publisherInstance);
                        }
                        if ((productValue = planValue2.get("product")) != null && !(productValue instanceof NullNode)) {
                            String productInstance = productValue.getTextValue();
                            planInstance.setProduct(productInstance);
                        }
                        if ((promotionCodeValue = planValue2.get("promotionCode")) != null && !(promotionCodeValue instanceof NullNode)) {
                            String promotionCodeInstance = promotionCodeValue.getTextValue();
                            planInstance.setPromotionCode(promotionCodeInstance);
                        }
                    }
                    if ((propertiesValue4 = responseDoc.get("properties")) != null && !(propertiesValue4 instanceof NullNode)) {
                        JsonNode instanceViewValue3;
                        JsonNode provisioningStateValue;
                        JsonNode availabilitySetValue2;
                        JsonNode diagnosticsProfileValue2;
                        JsonNode networkProfileValue2;
                        JsonNode osProfileValue2;
                        Object storageProfileValue2;
                        JsonNode hardwareProfileValue2 = propertiesValue4.get("hardwareProfile");
                        if (hardwareProfileValue2 != null && !(hardwareProfileValue2 instanceof NullNode)) {
                            HardwareProfile hardwareProfileInstance = new HardwareProfile();
                            virtualMachineInstance.setHardwareProfile(hardwareProfileInstance);
                            JsonNode vmSizeValue = hardwareProfileValue2.get("vmSize");
                            if (vmSizeValue != null && !(vmSizeValue instanceof NullNode)) {
                                String vmSizeInstance = vmSizeValue.getTextValue();
                                hardwareProfileInstance.setVirtualMachineSize(vmSizeInstance);
                            }
                        }
                        if ((storageProfileValue2 = propertiesValue4.get("storageProfile")) != null && !(storageProfileValue2 instanceof NullNode)) {
                            JsonNode dataDisksArray2;
                            JsonNode osDiskValue2;
                            StorageProfile storageProfileInstance = new StorageProfile();
                            virtualMachineInstance.setStorageProfile(storageProfileInstance);
                            JsonNode imageReferenceValue2 = storageProfileValue2.get("imageReference");
                            if (imageReferenceValue2 != null && !(imageReferenceValue2 instanceof NullNode)) {
                                JsonNode versionValue;
                                JsonNode skuValue;
                                JsonNode offerValue;
                                ImageReference imageReferenceInstance = new ImageReference();
                                storageProfileInstance.setImageReference(imageReferenceInstance);
                                JsonNode publisherValue2 = imageReferenceValue2.get("publisher");
                                if (publisherValue2 != null && !(publisherValue2 instanceof NullNode)) {
                                    String publisherInstance2 = publisherValue2.getTextValue();
                                    imageReferenceInstance.setPublisher(publisherInstance2);
                                }
                                if ((offerValue = imageReferenceValue2.get("offer")) != null && !(offerValue instanceof NullNode)) {
                                    String offerInstance = offerValue.getTextValue();
                                    imageReferenceInstance.setOffer(offerInstance);
                                }
                                if ((skuValue = imageReferenceValue2.get("sku")) != null && !(skuValue instanceof NullNode)) {
                                    String skuInstance = skuValue.getTextValue();
                                    imageReferenceInstance.setSku(skuInstance);
                                }
                                if ((versionValue = imageReferenceValue2.get("version")) != null && !(versionValue instanceof NullNode)) {
                                    String versionInstance = versionValue.getTextValue();
                                    imageReferenceInstance.setVersion(versionInstance);
                                }
                            }
                            if ((osDiskValue2 = storageProfileValue2.get("osDisk")) != null && !(osDiskValue2 instanceof NullNode)) {
                                JsonNode diskSizeGBValue;
                                JsonNode createOptionValue;
                                JsonNode cachingValue;
                                JsonNode imageValue3;
                                JsonNode vhdValue3;
                                JsonNode nameValue2;
                                OSDisk osDiskInstance = new OSDisk();
                                storageProfileInstance.setOSDisk(osDiskInstance);
                                Iterator osTypeValue = osDiskValue2.get("osType");
                                if (osTypeValue != null && !(osTypeValue instanceof NullNode)) {
                                    String osTypeInstance = osTypeValue.getTextValue();
                                    osDiskInstance.setOperatingSystemType(osTypeInstance);
                                }
                                if ((nameValue2 = osDiskValue2.get("name")) != null && !(nameValue2 instanceof NullNode)) {
                                    String nameInstance2 = nameValue2.getTextValue();
                                    osDiskInstance.setName(nameInstance2);
                                }
                                if ((vhdValue3 = osDiskValue2.get("vhd")) != null && !(vhdValue3 instanceof NullNode)) {
                                    VirtualHardDisk vhdInstance = new VirtualHardDisk();
                                    osDiskInstance.setVirtualHardDisk(vhdInstance);
                                    JsonNode uriValue = vhdValue3.get("uri");
                                    if (uriValue != null && !(uriValue instanceof NullNode)) {
                                        String uriInstance = uriValue.getTextValue();
                                        vhdInstance.setUri(uriInstance);
                                    }
                                }
                                if ((imageValue3 = osDiskValue2.get("image")) != null && !(imageValue3 instanceof NullNode)) {
                                    VirtualHardDisk imageInstance = new VirtualHardDisk();
                                    osDiskInstance.setSourceImage(imageInstance);
                                    JsonNode uriValue2 = imageValue3.get("uri");
                                    if (uriValue2 != null && !(uriValue2 instanceof NullNode)) {
                                        String uriInstance2 = uriValue2.getTextValue();
                                        imageInstance.setUri(uriInstance2);
                                    }
                                }
                                if ((cachingValue = osDiskValue2.get("caching")) != null && !(cachingValue instanceof NullNode)) {
                                    String cachingInstance = cachingValue.getTextValue();
                                    osDiskInstance.setCaching(cachingInstance);
                                }
                                if ((createOptionValue = osDiskValue2.get("createOption")) != null && !(createOptionValue instanceof NullNode)) {
                                    String createOptionInstance = createOptionValue.getTextValue();
                                    osDiskInstance.setCreateOption(createOptionInstance);
                                }
                                if ((diskSizeGBValue = osDiskValue2.get("diskSizeGB")) != null && !(diskSizeGBValue instanceof NullNode)) {
                                    int diskSizeGBInstance = diskSizeGBValue.getIntValue();
                                    osDiskInstance.setDiskSizeGB(diskSizeGBInstance);
                                }
                            }
                            if ((dataDisksArray2 = storageProfileValue2.get("dataDisks")) != null && !(dataDisksArray2 instanceof NullNode)) {
                                for (JsonNode dataDisksValue : (ArrayNode)dataDisksArray2) {
                                    JsonNode diskSizeGBValue2;
                                    Object createOptionValue2;
                                    JsonNode cachingValue2;
                                    JsonNode imageValue4;
                                    JsonNode vhdValue4;
                                    JsonNode nameValue3;
                                    DataDisk dataDiskInstance = new DataDisk();
                                    storageProfileInstance.getDataDisks().add(dataDiskInstance);
                                    JsonNode lunValue = dataDisksValue.get("lun");
                                    if (lunValue != null && !(lunValue instanceof NullNode)) {
                                        int lunInstance = lunValue.getIntValue();
                                        dataDiskInstance.setLun(lunInstance);
                                    }
                                    if ((nameValue3 = dataDisksValue.get("name")) != null && !(nameValue3 instanceof NullNode)) {
                                        String nameInstance3 = nameValue3.getTextValue();
                                        dataDiskInstance.setName(nameInstance3);
                                    }
                                    if ((vhdValue4 = dataDisksValue.get("vhd")) != null && !(vhdValue4 instanceof NullNode)) {
                                        VirtualHardDisk vhdInstance2 = new VirtualHardDisk();
                                        dataDiskInstance.setVirtualHardDisk(vhdInstance2);
                                        JsonNode uriValue3 = vhdValue4.get("uri");
                                        if (uriValue3 != null && !(uriValue3 instanceof NullNode)) {
                                            String uriInstance3 = uriValue3.getTextValue();
                                            vhdInstance2.setUri(uriInstance3);
                                        }
                                    }
                                    if ((imageValue4 = dataDisksValue.get("image")) != null && !(imageValue4 instanceof NullNode)) {
                                        VirtualHardDisk imageInstance2 = new VirtualHardDisk();
                                        dataDiskInstance.setSourceImage(imageInstance2);
                                        JsonNode uriValue4 = imageValue4.get("uri");
                                        if (uriValue4 != null && !(uriValue4 instanceof NullNode)) {
                                            String uriInstance4 = uriValue4.getTextValue();
                                            imageInstance2.setUri(uriInstance4);
                                        }
                                    }
                                    if ((cachingValue2 = dataDisksValue.get("caching")) != null && !(cachingValue2 instanceof NullNode)) {
                                        String cachingInstance2 = cachingValue2.getTextValue();
                                        dataDiskInstance.setCaching(cachingInstance2);
                                    }
                                    if ((createOptionValue2 = dataDisksValue.get("createOption")) != null && !(createOptionValue2 instanceof NullNode)) {
                                        String createOptionInstance2 = createOptionValue2.getTextValue();
                                        dataDiskInstance.setCreateOption(createOptionInstance2);
                                    }
                                    if ((diskSizeGBValue2 = dataDisksValue.get("diskSizeGB")) == null || diskSizeGBValue2 instanceof NullNode) continue;
                                    int diskSizeGBInstance2 = diskSizeGBValue2.getIntValue();
                                    dataDiskInstance.setDiskSizeGB(diskSizeGBInstance2);
                                }
                            }
                        }
                        if ((osProfileValue2 = propertiesValue4.get("osProfile")) != null && !(osProfileValue2 instanceof NullNode)) {
                            JsonNode secretsArray2;
                            JsonNode linuxConfigurationValue2;
                            JsonNode windowsConfigurationValue2;
                            JsonNode customDataValue;
                            Object adminPasswordValue;
                            JsonNode adminUsernameValue;
                            OSProfile osProfileInstance = new OSProfile();
                            virtualMachineInstance.setOSProfile(osProfileInstance);
                            JsonNode computerNameValue = osProfileValue2.get("computerName");
                            if (computerNameValue != null && !(computerNameValue instanceof NullNode)) {
                                String computerNameInstance = computerNameValue.getTextValue();
                                osProfileInstance.setComputerName(computerNameInstance);
                            }
                            if ((adminUsernameValue = osProfileValue2.get("adminUsername")) != null && !(adminUsernameValue instanceof NullNode)) {
                                String adminUsernameInstance = adminUsernameValue.getTextValue();
                                osProfileInstance.setAdminUsername(adminUsernameInstance);
                            }
                            if ((adminPasswordValue = osProfileValue2.get("adminPassword")) != null && !(adminPasswordValue instanceof NullNode)) {
                                String adminPasswordInstance = adminPasswordValue.getTextValue();
                                osProfileInstance.setAdminPassword(adminPasswordInstance);
                            }
                            if ((customDataValue = osProfileValue2.get("customData")) != null && !(customDataValue instanceof NullNode)) {
                                String customDataInstance = customDataValue.getTextValue();
                                osProfileInstance.setCustomData(customDataInstance);
                            }
                            if ((windowsConfigurationValue2 = osProfileValue2.get("windowsConfiguration")) != null && !(windowsConfigurationValue2 instanceof NullNode)) {
                                JsonNode winRMValue2;
                                JsonNode additionalUnattendContentArray2;
                                JsonNode timeZoneValue;
                                JsonNode enableAutomaticUpdatesValue;
                                WindowsConfiguration windowsConfigurationInstance = new WindowsConfiguration();
                                osProfileInstance.setWindowsConfiguration(windowsConfigurationInstance);
                                JsonNode provisionVMAgentValue = windowsConfigurationValue2.get("provisionVMAgent");
                                if (provisionVMAgentValue != null && !(provisionVMAgentValue instanceof NullNode)) {
                                    boolean provisionVMAgentInstance = provisionVMAgentValue.getBooleanValue();
                                    windowsConfigurationInstance.setProvisionVMAgent(provisionVMAgentInstance);
                                }
                                if ((enableAutomaticUpdatesValue = windowsConfigurationValue2.get("enableAutomaticUpdates")) != null && !(enableAutomaticUpdatesValue instanceof NullNode)) {
                                    boolean enableAutomaticUpdatesInstance = enableAutomaticUpdatesValue.getBooleanValue();
                                    windowsConfigurationInstance.setEnableAutomaticUpdates(enableAutomaticUpdatesInstance);
                                }
                                if ((timeZoneValue = windowsConfigurationValue2.get("timeZone")) != null && !(timeZoneValue instanceof NullNode)) {
                                    String timeZoneInstance = timeZoneValue.getTextValue();
                                    windowsConfigurationInstance.setTimeZone(timeZoneInstance);
                                }
                                if ((additionalUnattendContentArray2 = windowsConfigurationValue2.get("additionalUnattendContent")) != null && !(additionalUnattendContentArray2 instanceof NullNode)) {
                                    for (JsonNode additionalUnattendContentValue2 : (ArrayNode)additionalUnattendContentArray2) {
                                        JsonNode contentValue;
                                        JsonNode settingNameValue;
                                        JsonNode componentNameValue;
                                        AdditionalUnattendContent additionalUnattendContentInstance = new AdditionalUnattendContent();
                                        windowsConfigurationInstance.getAdditionalUnattendContents().add(additionalUnattendContentInstance);
                                        JsonNode passNameValue = additionalUnattendContentValue2.get("passName");
                                        if (passNameValue != null && !(passNameValue instanceof NullNode)) {
                                            String passNameInstance = passNameValue.getTextValue();
                                            additionalUnattendContentInstance.setPassName(passNameInstance);
                                        }
                                        if ((componentNameValue = additionalUnattendContentValue2.get("componentName")) != null && !(componentNameValue instanceof NullNode)) {
                                            String componentNameInstance = componentNameValue.getTextValue();
                                            additionalUnattendContentInstance.setComponentName(componentNameInstance);
                                        }
                                        if ((settingNameValue = additionalUnattendContentValue2.get("settingName")) != null && !(settingNameValue instanceof NullNode)) {
                                            String settingNameInstance = settingNameValue.getTextValue();
                                            additionalUnattendContentInstance.setSettingName(settingNameInstance);
                                        }
                                        if ((contentValue = additionalUnattendContentValue2.get("content")) == null || contentValue instanceof NullNode) continue;
                                        String contentInstance = contentValue.getTextValue();
                                        additionalUnattendContentInstance.setContent(contentInstance);
                                    }
                                }
                                if ((winRMValue2 = windowsConfigurationValue2.get("winRM")) != null && !(winRMValue2 instanceof NullNode)) {
                                    WinRMConfiguration winRMInstance = new WinRMConfiguration();
                                    windowsConfigurationInstance.setWinRMConfiguration(winRMInstance);
                                    JsonNode listenersArray2 = winRMValue2.get("listeners");
                                    if (listenersArray2 != null && !(listenersArray2 instanceof NullNode)) {
                                        for (JsonNode listenersValue : (ArrayNode)listenersArray2) {
                                            JsonNode certificateUrlValue;
                                            WinRMListener winRMListenerInstance = new WinRMListener();
                                            winRMInstance.getListeners().add(winRMListenerInstance);
                                            JsonNode protocolValue = listenersValue.get("protocol");
                                            if (protocolValue != null && !(protocolValue instanceof NullNode)) {
                                                String protocolInstance = protocolValue.getTextValue();
                                                winRMListenerInstance.setProtocol(protocolInstance);
                                            }
                                            if ((certificateUrlValue = listenersValue.get("certificateUrl")) == null || certificateUrlValue instanceof NullNode) continue;
                                            URI certificateUrlInstance = new URI(certificateUrlValue.getTextValue());
                                            winRMListenerInstance.setCertificateUrl(certificateUrlInstance);
                                        }
                                    }
                                }
                            }
                            if ((linuxConfigurationValue2 = osProfileValue2.get("linuxConfiguration")) != null && !(linuxConfigurationValue2 instanceof NullNode)) {
                                JsonNode sshValue2;
                                LinuxConfiguration linuxConfigurationInstance = new LinuxConfiguration();
                                osProfileInstance.setLinuxConfiguration(linuxConfigurationInstance);
                                Iterator disablePasswordAuthenticationValue = linuxConfigurationValue2.get("disablePasswordAuthentication");
                                if (disablePasswordAuthenticationValue != null && !(disablePasswordAuthenticationValue instanceof NullNode)) {
                                    boolean disablePasswordAuthenticationInstance = disablePasswordAuthenticationValue.getBooleanValue();
                                    linuxConfigurationInstance.setDisablePasswordAuthentication(disablePasswordAuthenticationInstance);
                                }
                                if ((sshValue2 = linuxConfigurationValue2.get("ssh")) != null && !(sshValue2 instanceof NullNode)) {
                                    SshConfiguration sshInstance = new SshConfiguration();
                                    linuxConfigurationInstance.setSshConfiguration(sshInstance);
                                    JsonNode publicKeysArray2 = sshValue2.get("publicKeys");
                                    if (publicKeysArray2 != null && !(publicKeysArray2 instanceof NullNode)) {
                                        for (JsonNode publicKeysValue : (ArrayNode)publicKeysArray2) {
                                            JsonNode keyDataValue;
                                            SshPublicKey sshPublicKeyInstance = new SshPublicKey();
                                            sshInstance.getPublicKeys().add(sshPublicKeyInstance);
                                            JsonNode pathValue = publicKeysValue.get("path");
                                            if (pathValue != null && !(pathValue instanceof NullNode)) {
                                                String pathInstance = pathValue.getTextValue();
                                                sshPublicKeyInstance.setPath(pathInstance);
                                            }
                                            if ((keyDataValue = publicKeysValue.get("keyData")) == null || keyDataValue instanceof NullNode) continue;
                                            String keyDataInstance = keyDataValue.getTextValue();
                                            sshPublicKeyInstance.setKeyData(keyDataInstance);
                                        }
                                    }
                                }
                            }
                            if ((secretsArray2 = osProfileValue2.get("secrets")) != null && !(secretsArray2 instanceof NullNode)) {
                                for (JsonNode secretsValue : (ArrayNode)secretsArray2) {
                                    JsonNode vaultCertificatesArray2;
                                    VaultSecretGroup vaultSecretGroupInstance = new VaultSecretGroup();
                                    osProfileInstance.getSecrets().add(vaultSecretGroupInstance);
                                    JsonNode sourceVaultValue2 = secretsValue.get("sourceVault");
                                    if (sourceVaultValue2 != null && !(sourceVaultValue2 instanceof NullNode)) {
                                        SourceVaultReference sourceVaultInstance = new SourceVaultReference();
                                        vaultSecretGroupInstance.setSourceVault(sourceVaultInstance);
                                        Iterator idValue = sourceVaultValue2.get("id");
                                        if (idValue != null && !(idValue instanceof NullNode)) {
                                            String idInstance = idValue.getTextValue();
                                            sourceVaultInstance.setReferenceUri(idInstance);
                                        }
                                    }
                                    if ((vaultCertificatesArray2 = secretsValue.get("vaultCertificates")) == null || vaultCertificatesArray2 instanceof NullNode) continue;
                                    for (JsonNode vaultCertificatesValue : (ArrayNode)vaultCertificatesArray2) {
                                        JsonNode certificateStoreValue;
                                        VaultCertificate vaultCertificateInstance = new VaultCertificate();
                                        vaultSecretGroupInstance.getVaultCertificates().add(vaultCertificateInstance);
                                        JsonNode certificateUrlValue2 = vaultCertificatesValue.get("certificateUrl");
                                        if (certificateUrlValue2 != null && !(certificateUrlValue2 instanceof NullNode)) {
                                            String certificateUrlInstance2 = certificateUrlValue2.getTextValue();
                                            vaultCertificateInstance.setCertificateUrl(certificateUrlInstance2);
                                        }
                                        if ((certificateStoreValue = vaultCertificatesValue.get("certificateStore")) == null || certificateStoreValue instanceof NullNode) continue;
                                        String certificateStoreInstance = certificateStoreValue.getTextValue();
                                        vaultCertificateInstance.setCertificateStore(certificateStoreInstance);
                                    }
                                }
                            }
                        }
                        if ((networkProfileValue2 = propertiesValue4.get("networkProfile")) != null && !(networkProfileValue2 instanceof NullNode)) {
                            NetworkProfile networkProfileInstance = new NetworkProfile();
                            virtualMachineInstance.setNetworkProfile(networkProfileInstance);
                            JsonNode networkInterfacesArray2 = networkProfileValue2.get("networkInterfaces");
                            if (networkInterfacesArray2 != null && !(networkInterfacesArray2 instanceof NullNode)) {
                                for (JsonNode networkInterfacesValue : (ArrayNode)networkInterfacesArray2) {
                                    JsonNode idValue2;
                                    JsonNode primaryValue;
                                    NetworkInterfaceReference networkInterfaceReferenceJsonInstance = new NetworkInterfaceReference();
                                    networkProfileInstance.getNetworkInterfaces().add(networkInterfaceReferenceJsonInstance);
                                    JsonNode propertiesValue5 = networkInterfacesValue.get("properties");
                                    if (propertiesValue5 != null && !(propertiesValue5 instanceof NullNode) && (primaryValue = propertiesValue5.get("primary")) != null && !(primaryValue instanceof NullNode)) {
                                        boolean primaryInstance = primaryValue.getBooleanValue();
                                        networkInterfaceReferenceJsonInstance.setPrimary(primaryInstance);
                                    }
                                    if ((idValue2 = networkInterfacesValue.get("id")) == null || idValue2 instanceof NullNode) continue;
                                    String idInstance2 = idValue2.getTextValue();
                                    networkInterfaceReferenceJsonInstance.setReferenceUri(idInstance2);
                                }
                            }
                        }
                        if ((diagnosticsProfileValue2 = propertiesValue4.get("diagnosticsProfile")) != null && !(diagnosticsProfileValue2 instanceof NullNode)) {
                            DiagnosticsProfile diagnosticsProfileInstance = new DiagnosticsProfile();
                            virtualMachineInstance.setDiagnosticsProfile(diagnosticsProfileInstance);
                            JsonNode bootDiagnosticsValue3 = diagnosticsProfileValue2.get("bootDiagnostics");
                            if (bootDiagnosticsValue3 != null && !(bootDiagnosticsValue3 instanceof NullNode)) {
                                JsonNode storageUriValue;
                                BootDiagnostics bootDiagnosticsInstance = new BootDiagnostics();
                                diagnosticsProfileInstance.setBootDiagnostics(bootDiagnosticsInstance);
                                JsonNode enabledValue = bootDiagnosticsValue3.get("enabled");
                                if (enabledValue != null && !(enabledValue instanceof NullNode)) {
                                    boolean enabledInstance = enabledValue.getBooleanValue();
                                    bootDiagnosticsInstance.setEnabled(enabledInstance);
                                }
                                if ((storageUriValue = bootDiagnosticsValue3.get("storageUri")) != null && !(storageUriValue instanceof NullNode)) {
                                    URI storageUriInstance = new URI(storageUriValue.getTextValue());
                                    bootDiagnosticsInstance.setStorageUri(storageUriInstance);
                                }
                            }
                        }
                        if ((availabilitySetValue2 = propertiesValue4.get("availabilitySet")) != null && !(availabilitySetValue2 instanceof NullNode)) {
                            AvailabilitySetReference availabilitySetInstance = new AvailabilitySetReference();
                            virtualMachineInstance.setAvailabilitySetReference(availabilitySetInstance);
                            JsonNode idValue3 = availabilitySetValue2.get("id");
                            if (idValue3 != null && !(idValue3 instanceof NullNode)) {
                                String idInstance3 = idValue3.getTextValue();
                                availabilitySetInstance.setReferenceUri(idInstance3);
                            }
                        }
                        if ((provisioningStateValue = propertiesValue4.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                            String provisioningStateInstance = provisioningStateValue.getTextValue();
                            virtualMachineInstance.setProvisioningState(provisioningStateInstance);
                        }
                        if ((instanceViewValue3 = propertiesValue4.get("instanceView")) != null && !(instanceViewValue3 instanceof NullNode)) {
                            JsonNode statusesArray9;
                            JsonNode bootDiagnosticsValue4;
                            JsonNode extensionsArray2;
                            JsonNode disksArray2;
                            JsonNode vmAgentValue2;
                            JsonNode rdpThumbPrintValue;
                            JsonNode platformFaultDomainValue;
                            VirtualMachineInstanceView instanceViewInstance = new VirtualMachineInstanceView();
                            virtualMachineInstance.setInstanceView(instanceViewInstance);
                            JsonNode platformUpdateDomainValue = instanceViewValue3.get("platformUpdateDomain");
                            if (platformUpdateDomainValue != null && !(platformUpdateDomainValue instanceof NullNode)) {
                                int platformUpdateDomainInstance = platformUpdateDomainValue.getIntValue();
                                instanceViewInstance.setPlatformUpdateDomain(platformUpdateDomainInstance);
                            }
                            if ((platformFaultDomainValue = instanceViewValue3.get("platformFaultDomain")) != null && !(platformFaultDomainValue instanceof NullNode)) {
                                int platformFaultDomainInstance = platformFaultDomainValue.getIntValue();
                                instanceViewInstance.setPlatformFaultDomain(platformFaultDomainInstance);
                            }
                            if ((rdpThumbPrintValue = instanceViewValue3.get("rdpThumbPrint")) != null && !(rdpThumbPrintValue instanceof NullNode)) {
                                String rdpThumbPrintInstance = rdpThumbPrintValue.getTextValue();
                                instanceViewInstance.setRemoteDesktopThumbprint(rdpThumbPrintInstance);
                            }
                            if ((vmAgentValue2 = instanceViewValue3.get("vmAgent")) != null && !(vmAgentValue2 instanceof NullNode)) {
                                JsonNode statusesArray6;
                                JsonNode extensionHandlersArray2;
                                VirtualMachineAgentInstanceView vmAgentInstance = new VirtualMachineAgentInstanceView();
                                instanceViewInstance.setVMAgent(vmAgentInstance);
                                Iterator vmAgentVersionValue = vmAgentValue2.get("vmAgentVersion");
                                if (vmAgentVersionValue != null && !(vmAgentVersionValue instanceof NullNode)) {
                                    String vmAgentVersionInstance = vmAgentVersionValue.getTextValue();
                                    vmAgentInstance.setVMAgentVersion(vmAgentVersionInstance);
                                }
                                if ((extensionHandlersArray2 = vmAgentValue2.get("extensionHandlers")) != null && !(extensionHandlersArray2 instanceof NullNode)) {
                                    for (Iterator extensionHandlersValue : (ArrayNode)extensionHandlersArray2) {
                                        JsonNode timeValue;
                                        JsonNode messageValue;
                                        JsonNode displayStatusValue;
                                        JsonNode levelValue;
                                        JsonNode statusValue2;
                                        JsonNode typeHandlerVersionValue;
                                        VirtualMachineExtensionHandlerInstanceView virtualMachineExtensionHandlerInstanceViewInstance = new VirtualMachineExtensionHandlerInstanceView();
                                        vmAgentInstance.getExtensionHandlers().add(virtualMachineExtensionHandlerInstanceViewInstance);
                                        JsonNode typeValue = extensionHandlersValue.get("type");
                                        if (typeValue != null && !(typeValue instanceof NullNode)) {
                                            String typeInstance = typeValue.getTextValue();
                                            virtualMachineExtensionHandlerInstanceViewInstance.setType(typeInstance);
                                        }
                                        if ((typeHandlerVersionValue = extensionHandlersValue.get("typeHandlerVersion")) != null && !(typeHandlerVersionValue instanceof NullNode)) {
                                            String typeHandlerVersionInstance = typeHandlerVersionValue.getTextValue();
                                            virtualMachineExtensionHandlerInstanceViewInstance.setTypeHandlerVersion(typeHandlerVersionInstance);
                                        }
                                        if ((statusValue2 = extensionHandlersValue.get("status")) == null || statusValue2 instanceof NullNode) continue;
                                        InstanceViewStatus statusInstance = new InstanceViewStatus();
                                        virtualMachineExtensionHandlerInstanceViewInstance.setStatus(statusInstance);
                                        JsonNode codeValue = statusValue2.get("code");
                                        if (codeValue != null && !(codeValue instanceof NullNode)) {
                                            String codeInstance = codeValue.getTextValue();
                                            statusInstance.setCode(codeInstance);
                                        }
                                        if ((levelValue = statusValue2.get("level")) != null && !(levelValue instanceof NullNode)) {
                                            String levelInstance = levelValue.getTextValue();
                                            statusInstance.setLevel(levelInstance);
                                        }
                                        if ((displayStatusValue = statusValue2.get("displayStatus")) != null && !(displayStatusValue instanceof NullNode)) {
                                            String displayStatusInstance = displayStatusValue.getTextValue();
                                            statusInstance.setDisplayStatus(displayStatusInstance);
                                        }
                                        if ((messageValue = statusValue2.get("message")) != null && !(messageValue instanceof NullNode)) {
                                            String messageInstance = messageValue.getTextValue();
                                            statusInstance.setMessage(messageInstance);
                                        }
                                        if ((timeValue = statusValue2.get("time")) == null || timeValue instanceof NullNode) continue;
                                        Calendar timeInstance = DatatypeConverter.parseDateTime((String)timeValue.getTextValue());
                                        statusInstance.setTime(timeInstance);
                                    }
                                }
                                if ((statusesArray6 = vmAgentValue2.get("statuses")) != null && !(statusesArray6 instanceof NullNode)) {
                                    for (JsonNode statusesValue : (ArrayNode)statusesArray6) {
                                        JsonNode timeValue2;
                                        JsonNode messageValue2;
                                        JsonNode displayStatusValue2;
                                        JsonNode levelValue2;
                                        InstanceViewStatus instanceViewStatusInstance = new InstanceViewStatus();
                                        vmAgentInstance.getStatuses().add(instanceViewStatusInstance);
                                        JsonNode codeValue2 = statusesValue.get("code");
                                        if (codeValue2 != null && !(codeValue2 instanceof NullNode)) {
                                            String codeInstance2 = codeValue2.getTextValue();
                                            instanceViewStatusInstance.setCode(codeInstance2);
                                        }
                                        if ((levelValue2 = statusesValue.get("level")) != null && !(levelValue2 instanceof NullNode)) {
                                            String levelInstance2 = levelValue2.getTextValue();
                                            instanceViewStatusInstance.setLevel(levelInstance2);
                                        }
                                        if ((displayStatusValue2 = statusesValue.get("displayStatus")) != null && !(displayStatusValue2 instanceof NullNode)) {
                                            String displayStatusInstance2 = displayStatusValue2.getTextValue();
                                            instanceViewStatusInstance.setDisplayStatus(displayStatusInstance2);
                                        }
                                        if ((messageValue2 = statusesValue.get("message")) != null && !(messageValue2 instanceof NullNode)) {
                                            String messageInstance2 = messageValue2.getTextValue();
                                            instanceViewStatusInstance.setMessage(messageInstance2);
                                        }
                                        if ((timeValue2 = statusesValue.get("time")) == null || timeValue2 instanceof NullNode) continue;
                                        Calendar timeInstance2 = DatatypeConverter.parseDateTime((String)timeValue2.getTextValue());
                                        instanceViewStatusInstance.setTime(timeInstance2);
                                    }
                                }
                            }
                            if ((disksArray2 = instanceViewValue3.get("disks")) != null && !(disksArray2 instanceof NullNode)) {
                                for (Iterator disksValue : (ArrayNode)disksArray2) {
                                    JsonNode statusesArray7;
                                    DiskInstanceView diskInstanceViewInstance = new DiskInstanceView();
                                    instanceViewInstance.getDisks().add(diskInstanceViewInstance);
                                    JsonNode nameValue4 = disksValue.get("name");
                                    if (nameValue4 != null && !(nameValue4 instanceof NullNode)) {
                                        String nameInstance4 = nameValue4.getTextValue();
                                        diskInstanceViewInstance.setName(nameInstance4);
                                    }
                                    if ((statusesArray7 = disksValue.get("statuses")) == null || statusesArray7 instanceof NullNode) continue;
                                    for (JsonNode statusesValue2 : (ArrayNode)statusesArray7) {
                                        JsonNode timeValue3;
                                        JsonNode messageValue3;
                                        JsonNode displayStatusValue3;
                                        JsonNode levelValue3;
                                        InstanceViewStatus instanceViewStatusInstance2 = new InstanceViewStatus();
                                        diskInstanceViewInstance.getStatuses().add(instanceViewStatusInstance2);
                                        Iterator codeValue3 = statusesValue2.get("code");
                                        if (codeValue3 != null && !(codeValue3 instanceof NullNode)) {
                                            String codeInstance3 = codeValue3.getTextValue();
                                            instanceViewStatusInstance2.setCode(codeInstance3);
                                        }
                                        if ((levelValue3 = statusesValue2.get("level")) != null && !(levelValue3 instanceof NullNode)) {
                                            String levelInstance3 = levelValue3.getTextValue();
                                            instanceViewStatusInstance2.setLevel(levelInstance3);
                                        }
                                        if ((displayStatusValue3 = statusesValue2.get("displayStatus")) != null && !(displayStatusValue3 instanceof NullNode)) {
                                            String displayStatusInstance3 = displayStatusValue3.getTextValue();
                                            instanceViewStatusInstance2.setDisplayStatus(displayStatusInstance3);
                                        }
                                        if ((messageValue3 = statusesValue2.get("message")) != null && !(messageValue3 instanceof NullNode)) {
                                            String messageInstance3 = messageValue3.getTextValue();
                                            instanceViewStatusInstance2.setMessage(messageInstance3);
                                        }
                                        if ((timeValue3 = statusesValue2.get("time")) == null || timeValue3 instanceof NullNode) continue;
                                        Calendar timeInstance3 = DatatypeConverter.parseDateTime((String)timeValue3.getTextValue());
                                        instanceViewStatusInstance2.setTime(timeInstance3);
                                    }
                                }
                            }
                            if ((extensionsArray2 = instanceViewValue3.get("extensions")) != null && !(extensionsArray2 instanceof NullNode)) {
                                for (JsonNode extensionsValue : (ArrayNode)extensionsArray2) {
                                    JsonNode statusesArray8;
                                    Iterator substatusesValue22;
                                    JsonNode substatusesArray3;
                                    JsonNode typeHandlerVersionValue2;
                                    JsonNode typeValue2;
                                    VirtualMachineExtensionInstanceView virtualMachineExtensionInstanceViewInstance = new VirtualMachineExtensionInstanceView();
                                    instanceViewInstance.getExtensions().add(virtualMachineExtensionInstanceViewInstance);
                                    JsonNode nameValue5 = extensionsValue.get("name");
                                    if (nameValue5 != null && !(nameValue5 instanceof NullNode)) {
                                        String nameInstance5 = nameValue5.getTextValue();
                                        virtualMachineExtensionInstanceViewInstance.setName(nameInstance5);
                                    }
                                    if ((typeValue2 = extensionsValue.get("type")) != null && !(typeValue2 instanceof NullNode)) {
                                        String typeInstance2 = typeValue2.getTextValue();
                                        virtualMachineExtensionInstanceViewInstance.setExtensionType(typeInstance2);
                                    }
                                    if ((typeHandlerVersionValue2 = extensionsValue.get("typeHandlerVersion")) != null && !(typeHandlerVersionValue2 instanceof NullNode)) {
                                        String typeHandlerVersionInstance2 = typeHandlerVersionValue2.getTextValue();
                                        virtualMachineExtensionInstanceViewInstance.setTypeHandlerVersion(typeHandlerVersionInstance2);
                                    }
                                    if ((substatusesArray3 = extensionsValue.get("substatuses")) != null && !(substatusesArray3 instanceof NullNode)) {
                                        for (Iterator substatusesValue22 : (ArrayNode)substatusesArray3) {
                                            JsonNode timeValue4;
                                            JsonNode messageValue4;
                                            JsonNode displayStatusValue4;
                                            JsonNode levelValue4;
                                            InstanceViewStatus instanceViewStatusInstance3 = new InstanceViewStatus();
                                            virtualMachineExtensionInstanceViewInstance.getSubStatuses().add(instanceViewStatusInstance3);
                                            JsonNode codeValue4 = substatusesValue22.get("code");
                                            if (codeValue4 != null && !(codeValue4 instanceof NullNode)) {
                                                String codeInstance4 = codeValue4.getTextValue();
                                                instanceViewStatusInstance3.setCode(codeInstance4);
                                            }
                                            if ((levelValue4 = substatusesValue22.get("level")) != null && !(levelValue4 instanceof NullNode)) {
                                                String levelInstance4 = levelValue4.getTextValue();
                                                instanceViewStatusInstance3.setLevel(levelInstance4);
                                            }
                                            if ((displayStatusValue4 = substatusesValue22.get("displayStatus")) != null && !(displayStatusValue4 instanceof NullNode)) {
                                                String displayStatusInstance4 = displayStatusValue4.getTextValue();
                                                instanceViewStatusInstance3.setDisplayStatus(displayStatusInstance4);
                                            }
                                            if ((messageValue4 = substatusesValue22.get("message")) != null && !(messageValue4 instanceof NullNode)) {
                                                String messageInstance4 = messageValue4.getTextValue();
                                                instanceViewStatusInstance3.setMessage(messageInstance4);
                                            }
                                            if ((timeValue4 = substatusesValue22.get("time")) == null || timeValue4 instanceof NullNode) continue;
                                            Calendar timeInstance4 = DatatypeConverter.parseDateTime((String)timeValue4.getTextValue());
                                            instanceViewStatusInstance3.setTime(timeInstance4);
                                        }
                                    }
                                    if ((statusesArray8 = extensionsValue.get("statuses")) == null || statusesArray8 instanceof NullNode) continue;
                                    substatusesValue22 = ((ArrayNode)statusesArray8).iterator();
                                    while (substatusesValue22.hasNext()) {
                                        JsonNode timeValue5;
                                        JsonNode messageValue5;
                                        JsonNode displayStatusValue5;
                                        JsonNode levelValue5;
                                        JsonNode statusesValue3 = (JsonNode)substatusesValue22.next();
                                        InstanceViewStatus instanceViewStatusInstance4 = new InstanceViewStatus();
                                        virtualMachineExtensionInstanceViewInstance.getStatuses().add(instanceViewStatusInstance4);
                                        JsonNode codeValue5 = statusesValue3.get("code");
                                        if (codeValue5 != null && !(codeValue5 instanceof NullNode)) {
                                            String codeInstance5 = codeValue5.getTextValue();
                                            instanceViewStatusInstance4.setCode(codeInstance5);
                                        }
                                        if ((levelValue5 = statusesValue3.get("level")) != null && !(levelValue5 instanceof NullNode)) {
                                            String levelInstance5 = levelValue5.getTextValue();
                                            instanceViewStatusInstance4.setLevel(levelInstance5);
                                        }
                                        if ((displayStatusValue5 = statusesValue3.get("displayStatus")) != null && !(displayStatusValue5 instanceof NullNode)) {
                                            String displayStatusInstance5 = displayStatusValue5.getTextValue();
                                            instanceViewStatusInstance4.setDisplayStatus(displayStatusInstance5);
                                        }
                                        if ((messageValue5 = statusesValue3.get("message")) != null && !(messageValue5 instanceof NullNode)) {
                                            String messageInstance5 = messageValue5.getTextValue();
                                            instanceViewStatusInstance4.setMessage(messageInstance5);
                                        }
                                        if ((timeValue5 = statusesValue3.get("time")) == null || timeValue5 instanceof NullNode) continue;
                                        Calendar timeInstance5 = DatatypeConverter.parseDateTime((String)timeValue5.getTextValue());
                                        instanceViewStatusInstance4.setTime(timeInstance5);
                                    }
                                }
                            }
                            if ((bootDiagnosticsValue4 = instanceViewValue3.get("bootDiagnostics")) != null && !(bootDiagnosticsValue4 instanceof NullNode)) {
                                JsonNode serialConsoleLogBlobUriValue;
                                BootDiagnosticsInstanceView bootDiagnosticsInstance2 = new BootDiagnosticsInstanceView();
                                instanceViewInstance.setBootDiagnostics(bootDiagnosticsInstance2);
                                Iterator consoleScreenshotBlobUriValue = bootDiagnosticsValue4.get("consoleScreenshotBlobUri");
                                if (consoleScreenshotBlobUriValue != null && !(consoleScreenshotBlobUriValue instanceof NullNode)) {
                                    URI consoleScreenshotBlobUriInstance = new URI(consoleScreenshotBlobUriValue.getTextValue());
                                    bootDiagnosticsInstance2.setConsoleScreenshotBlobUri(consoleScreenshotBlobUriInstance);
                                }
                                if ((serialConsoleLogBlobUriValue = bootDiagnosticsValue4.get("serialConsoleLogBlobUri")) != null && !(serialConsoleLogBlobUriValue instanceof NullNode)) {
                                    URI serialConsoleLogBlobUriInstance = new URI(serialConsoleLogBlobUriValue.getTextValue());
                                    bootDiagnosticsInstance2.setSerialConsoleLogBlobUri(serialConsoleLogBlobUriInstance);
                                }
                            }
                            if ((statusesArray9 = instanceViewValue3.get("statuses")) != null && !(statusesArray9 instanceof NullNode)) {
                                for (Object statusesValue4 : (ArrayNode)statusesArray9) {
                                    JsonNode timeValue6;
                                    JsonNode messageValue6;
                                    JsonNode displayStatusValue6;
                                    JsonNode levelValue6;
                                    InstanceViewStatus instanceViewStatusInstance5 = new InstanceViewStatus();
                                    instanceViewInstance.getStatuses().add(instanceViewStatusInstance5);
                                    JsonNode codeValue6 = statusesValue4.get("code");
                                    if (codeValue6 != null && !(codeValue6 instanceof NullNode)) {
                                        String codeInstance6 = codeValue6.getTextValue();
                                        instanceViewStatusInstance5.setCode(codeInstance6);
                                    }
                                    if ((levelValue6 = statusesValue4.get("level")) != null && !(levelValue6 instanceof NullNode)) {
                                        String levelInstance6 = levelValue6.getTextValue();
                                        instanceViewStatusInstance5.setLevel(levelInstance6);
                                    }
                                    if ((displayStatusValue6 = statusesValue4.get("displayStatus")) != null && !(displayStatusValue6 instanceof NullNode)) {
                                        String displayStatusInstance6 = displayStatusValue6.getTextValue();
                                        instanceViewStatusInstance5.setDisplayStatus(displayStatusInstance6);
                                    }
                                    if ((messageValue6 = statusesValue4.get("message")) != null && !(messageValue6 instanceof NullNode)) {
                                        String messageInstance6 = messageValue6.getTextValue();
                                        instanceViewStatusInstance5.setMessage(messageInstance6);
                                    }
                                    if ((timeValue6 = statusesValue4.get("time")) == null || timeValue6 instanceof NullNode) continue;
                                    Calendar timeInstance6 = DatatypeConverter.parseDateTime((String)timeValue6.getTextValue());
                                    instanceViewStatusInstance5.setTime(timeInstance6);
                                }
                            }
                        }
                    }
                    if ((resourcesArray2 = responseDoc.get("resources")) != null && !(resourcesArray2 instanceof NullNode)) {
                        virtualMachineInstance.setExtensions(new ArrayList<VirtualMachineExtension>());
                        for (JsonNode resourcesValue : (ArrayNode)resourcesArray2) {
                            JsonNode tagsSequenceElement;
                            JsonNode locationValue;
                            JsonNode typeValue5;
                            JsonNode nameValue7;
                            JsonNode idValue4;
                            VirtualMachineExtension virtualMachineExtensionJsonInstance = new VirtualMachineExtension();
                            virtualMachineInstance.getExtensions().add(virtualMachineExtensionJsonInstance);
                            JsonNode propertiesValue6 = resourcesValue.get("properties");
                            if (propertiesValue6 != null && !(propertiesValue6 instanceof NullNode)) {
                                JsonNode instanceViewValue4;
                                JsonNode provisioningStateValue2;
                                JsonNode protectedSettingsValue;
                                JsonNode settingsValue;
                                JsonNode autoUpgradeMinorVersionValue;
                                JsonNode typeHandlerVersionValue3;
                                JsonNode typeValue3;
                                JsonNode publisherValue3 = propertiesValue6.get("publisher");
                                if (publisherValue3 != null && !(publisherValue3 instanceof NullNode)) {
                                    String publisherInstance3 = publisherValue3.getTextValue();
                                    virtualMachineExtensionJsonInstance.setPublisher(publisherInstance3);
                                }
                                if ((typeValue3 = propertiesValue6.get("type")) != null && !(typeValue3 instanceof NullNode)) {
                                    String typeInstance3 = typeValue3.getTextValue();
                                    virtualMachineExtensionJsonInstance.setExtensionType(typeInstance3);
                                }
                                if ((typeHandlerVersionValue3 = propertiesValue6.get("typeHandlerVersion")) != null && !(typeHandlerVersionValue3 instanceof NullNode)) {
                                    String typeHandlerVersionInstance3 = typeHandlerVersionValue3.getTextValue();
                                    virtualMachineExtensionJsonInstance.setTypeHandlerVersion(typeHandlerVersionInstance3);
                                }
                                if ((autoUpgradeMinorVersionValue = propertiesValue6.get("autoUpgradeMinorVersion")) != null && !(autoUpgradeMinorVersionValue instanceof NullNode)) {
                                    boolean autoUpgradeMinorVersionInstance = autoUpgradeMinorVersionValue.getBooleanValue();
                                    virtualMachineExtensionJsonInstance.setAutoUpgradeMinorVersion(autoUpgradeMinorVersionInstance);
                                }
                                if ((settingsValue = propertiesValue6.get("settings")) != null && !(settingsValue instanceof NullNode)) {
                                    String settingsInstance = settingsValue.getTextValue();
                                    virtualMachineExtensionJsonInstance.setSettings(settingsInstance);
                                }
                                if ((protectedSettingsValue = propertiesValue6.get("protectedSettings")) != null && !(protectedSettingsValue instanceof NullNode)) {
                                    String protectedSettingsInstance = protectedSettingsValue.getTextValue();
                                    virtualMachineExtensionJsonInstance.setProtectedSettings(protectedSettingsInstance);
                                }
                                if ((provisioningStateValue2 = propertiesValue6.get("provisioningState")) != null && !(provisioningStateValue2 instanceof NullNode)) {
                                    String provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                    virtualMachineExtensionJsonInstance.setProvisioningState(provisioningStateInstance2);
                                }
                                if ((instanceViewValue4 = propertiesValue6.get("instanceView")) != null && !(instanceViewValue4 instanceof NullNode)) {
                                    JsonNode statusesArray10;
                                    JsonNode substatusesArray4;
                                    JsonNode typeHandlerVersionValue4;
                                    JsonNode typeValue4;
                                    VirtualMachineExtensionInstanceView instanceViewInstance2 = new VirtualMachineExtensionInstanceView();
                                    virtualMachineExtensionJsonInstance.setInstanceView(instanceViewInstance2);
                                    JsonNode nameValue6 = instanceViewValue4.get("name");
                                    if (nameValue6 != null && !(nameValue6 instanceof NullNode)) {
                                        String nameInstance6 = nameValue6.getTextValue();
                                        instanceViewInstance2.setName(nameInstance6);
                                    }
                                    if ((typeValue4 = instanceViewValue4.get("type")) != null && !(typeValue4 instanceof NullNode)) {
                                        String typeInstance4 = typeValue4.getTextValue();
                                        instanceViewInstance2.setExtensionType(typeInstance4);
                                    }
                                    if ((typeHandlerVersionValue4 = instanceViewValue4.get("typeHandlerVersion")) != null && !(typeHandlerVersionValue4 instanceof NullNode)) {
                                        String typeHandlerVersionInstance4 = typeHandlerVersionValue4.getTextValue();
                                        instanceViewInstance2.setTypeHandlerVersion(typeHandlerVersionInstance4);
                                    }
                                    if ((substatusesArray4 = instanceViewValue4.get("substatuses")) != null && !(substatusesArray4 instanceof NullNode)) {
                                        for (JsonNode substatusesValue2 : (ArrayNode)substatusesArray4) {
                                            JsonNode timeValue7;
                                            JsonNode messageValue7;
                                            JsonNode displayStatusValue7;
                                            JsonNode levelValue7;
                                            InstanceViewStatus instanceViewStatusInstance6 = new InstanceViewStatus();
                                            instanceViewInstance2.getSubStatuses().add(instanceViewStatusInstance6);
                                            JsonNode codeValue7 = substatusesValue2.get("code");
                                            if (codeValue7 != null && !(codeValue7 instanceof NullNode)) {
                                                String codeInstance7 = codeValue7.getTextValue();
                                                instanceViewStatusInstance6.setCode(codeInstance7);
                                            }
                                            if ((levelValue7 = substatusesValue2.get("level")) != null && !(levelValue7 instanceof NullNode)) {
                                                String levelInstance7 = levelValue7.getTextValue();
                                                instanceViewStatusInstance6.setLevel(levelInstance7);
                                            }
                                            if ((displayStatusValue7 = substatusesValue2.get("displayStatus")) != null && !(displayStatusValue7 instanceof NullNode)) {
                                                String displayStatusInstance7 = displayStatusValue7.getTextValue();
                                                instanceViewStatusInstance6.setDisplayStatus(displayStatusInstance7);
                                            }
                                            if ((messageValue7 = substatusesValue2.get("message")) != null && !(messageValue7 instanceof NullNode)) {
                                                String messageInstance7 = messageValue7.getTextValue();
                                                instanceViewStatusInstance6.setMessage(messageInstance7);
                                            }
                                            if ((timeValue7 = substatusesValue2.get("time")) == null || timeValue7 instanceof NullNode) continue;
                                            Calendar timeInstance7 = DatatypeConverter.parseDateTime((String)timeValue7.getTextValue());
                                            instanceViewStatusInstance6.setTime(timeInstance7);
                                        }
                                    }
                                    if ((statusesArray10 = instanceViewValue4.get("statuses")) != null && !(statusesArray10 instanceof NullNode)) {
                                        for (JsonNode statusesValue5 : (ArrayNode)statusesArray10) {
                                            JsonNode timeValue8;
                                            JsonNode messageValue8;
                                            JsonNode displayStatusValue8;
                                            JsonNode levelValue8;
                                            InstanceViewStatus instanceViewStatusInstance7 = new InstanceViewStatus();
                                            instanceViewInstance2.getStatuses().add(instanceViewStatusInstance7);
                                            JsonNode codeValue8 = statusesValue5.get("code");
                                            if (codeValue8 != null && !(codeValue8 instanceof NullNode)) {
                                                String codeInstance8 = codeValue8.getTextValue();
                                                instanceViewStatusInstance7.setCode(codeInstance8);
                                            }
                                            if ((levelValue8 = statusesValue5.get("level")) != null && !(levelValue8 instanceof NullNode)) {
                                                String levelInstance8 = levelValue8.getTextValue();
                                                instanceViewStatusInstance7.setLevel(levelInstance8);
                                            }
                                            if ((displayStatusValue8 = statusesValue5.get("displayStatus")) != null && !(displayStatusValue8 instanceof NullNode)) {
                                                String displayStatusInstance8 = displayStatusValue8.getTextValue();
                                                instanceViewStatusInstance7.setDisplayStatus(displayStatusInstance8);
                                            }
                                            if ((messageValue8 = statusesValue5.get("message")) != null && !(messageValue8 instanceof NullNode)) {
                                                String messageInstance8 = messageValue8.getTextValue();
                                                instanceViewStatusInstance7.setMessage(messageInstance8);
                                            }
                                            if ((timeValue8 = statusesValue5.get("time")) == null || timeValue8 instanceof NullNode) continue;
                                            Calendar timeInstance8 = DatatypeConverter.parseDateTime((String)timeValue8.getTextValue());
                                            instanceViewStatusInstance7.setTime(timeInstance8);
                                        }
                                    }
                                }
                            }
                            if ((idValue4 = resourcesValue.get("id")) != null && !(idValue4 instanceof NullNode)) {
                                String idInstance4 = idValue4.getTextValue();
                                virtualMachineExtensionJsonInstance.setId(idInstance4);
                            }
                            if ((nameValue7 = resourcesValue.get("name")) != null && !(nameValue7 instanceof NullNode)) {
                                String nameInstance7 = nameValue7.getTextValue();
                                virtualMachineExtensionJsonInstance.setName(nameInstance7);
                            }
                            if ((typeValue5 = resourcesValue.get("type")) != null && !(typeValue5 instanceof NullNode)) {
                                String typeInstance5 = typeValue5.getTextValue();
                                virtualMachineExtensionJsonInstance.setType(typeInstance5);
                            }
                            if ((locationValue = resourcesValue.get("location")) != null && !(locationValue instanceof NullNode)) {
                                String locationInstance = locationValue.getTextValue();
                                virtualMachineExtensionJsonInstance.setLocation(locationInstance);
                            }
                            if ((tagsSequenceElement = resourcesValue.get("tags")) == null || tagsSequenceElement instanceof NullNode) continue;
                            Iterator itr = tagsSequenceElement.getFields();
                            while (itr.hasNext()) {
                                Map.Entry property = (Map.Entry)itr.next();
                                String tagsKey3 = (String)property.getKey();
                                String tagsValue3 = ((JsonNode)property.getValue()).getTextValue();
                                virtualMachineExtensionJsonInstance.getTags().put(tagsKey3, tagsValue3);
                            }
                        }
                    }
                    if ((idValue5 = responseDoc.get("id")) != null && !(idValue5 instanceof NullNode)) {
                        String idInstance5 = idValue5.getTextValue();
                        virtualMachineInstance.setId(idInstance5);
                    }
                    if ((nameValue8 = responseDoc.get("name")) != null && !(nameValue8 instanceof NullNode)) {
                        String nameInstance8 = nameValue8.getTextValue();
                        virtualMachineInstance.setName(nameInstance8);
                    }
                    if ((typeValue6 = responseDoc.get("type")) != null && !(typeValue6 instanceof NullNode)) {
                        String typeInstance6 = typeValue6.getTextValue();
                        virtualMachineInstance.setType(typeInstance6);
                    }
                    if ((locationValue2 = responseDoc.get("location")) != null && !(locationValue2 instanceof NullNode)) {
                        String locationInstance2 = locationValue2.getTextValue();
                        virtualMachineInstance.setLocation(locationInstance2);
                    }
                    if ((tagsSequenceElement2 = responseDoc.get("tags")) != null && !(tagsSequenceElement2 instanceof NullNode)) {
                        Iterator itr2 = tagsSequenceElement2.getFields();
                        while (itr2.hasNext()) {
                            Map.Entry property2 = (Map.Entry)itr2.next();
                            String tagsKey4 = (String)property2.getKey();
                            String tagsValue4 = ((JsonNode)property2.getValue()).getTextValue();
                            virtualMachineInstance.getTags().put(tagsKey4, tagsValue4);
                        }
                    }
                }
            }
            var18_102.setStatusCode(n);
            if (closeableHttpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                var18_102.setAzureAsyncOperation(closeableHttpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (closeableHttpResponse.getHeaders("x-ms-request-id").length > 0) {
                var18_102.setRequestId(closeableHttpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)var18_102);
            }
            var19_103 = var18_102;
        }
        catch (Throwable throwable) {
            if (var16_44 != null && var16_44.getEntity() != null) {
                var16_44.getEntity().getContent().close();
            }
            throw throwable;
        }
        if (closeableHttpResponse != null && closeableHttpResponse.getEntity() != null) {
            closeableHttpResponse.getEntity().getContent().close();
        }
        return var19_103;
    }

    @Override
    public Future<ComputeOperationResponse> beginDeallocatingAsync(final String resourceGroupName, final String vmName) {
        return this.getClient().getExecutorService().submit(new Callable<ComputeOperationResponse>(){

            @Override
            public ComputeOperationResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.beginDeallocating(resourceGroupName, vmName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComputeOperationResponse beginDeallocating(String resourceGroupName, String vmName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (vmName == null) {
            throw new NullPointerException("vmName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("vmName", vmName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginDeallocatingAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/";
        url = url + "virtualMachines";
        url = url + "/";
        url = url + URLEncoder.encode(vmName, "UTF-8");
        url = url + "/deallocate";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            ComputeOperationResponse result = null;
            result = new ComputeOperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            ComputeOperationResponse computeOperationResponse = result;
            return computeOperationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<DeleteOperationResponse> beginDeletingAsync(final String resourceGroupName, final String vmName) {
        return this.getClient().getExecutorService().submit(new Callable<DeleteOperationResponse>(){

            @Override
            public DeleteOperationResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.beginDeleting(resourceGroupName, vmName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteOperationResponse beginDeleting(String resourceGroupName, String vmName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (vmName == null) {
            throw new NullPointerException("vmName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("vmName", vmName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginDeletingAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/";
        url = url + "virtualMachines";
        url = url + "/";
        url = url + URLEncoder.encode(vmName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200 && statusCode != 202 && statusCode != 204) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            DeleteOperationResponse result = null;
            result = new DeleteOperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (statusCode == 409) {
                result.setStatus(OperationStatus.Failed);
            }
            if (statusCode == 200) {
                result.setStatus(OperationStatus.Succeeded);
            }
            if (statusCode == 204) {
                result.setStatus(OperationStatus.Succeeded);
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            DeleteOperationResponse deleteOperationResponse = result;
            return deleteOperationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<ComputeOperationResponse> beginPoweringOffAsync(final String resourceGroupName, final String vmName) {
        return this.getClient().getExecutorService().submit(new Callable<ComputeOperationResponse>(){

            @Override
            public ComputeOperationResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.beginPoweringOff(resourceGroupName, vmName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComputeOperationResponse beginPoweringOff(String resourceGroupName, String vmName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (vmName == null) {
            throw new NullPointerException("vmName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("vmName", vmName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginPoweringOffAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/";
        url = url + "virtualMachines";
        url = url + "/";
        url = url + URLEncoder.encode(vmName, "UTF-8");
        url = url + "/powerOff";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            ComputeOperationResponse result = null;
            result = new ComputeOperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            ComputeOperationResponse computeOperationResponse = result;
            return computeOperationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<ComputeOperationResponse> beginRestartingAsync(final String resourceGroupName, final String vmName) {
        return this.getClient().getExecutorService().submit(new Callable<ComputeOperationResponse>(){

            @Override
            public ComputeOperationResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.beginRestarting(resourceGroupName, vmName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComputeOperationResponse beginRestarting(String resourceGroupName, String vmName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (vmName == null) {
            throw new NullPointerException("vmName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("vmName", vmName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginRestartingAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/";
        url = url + "virtualMachines";
        url = url + "/";
        url = url + URLEncoder.encode(vmName, "UTF-8");
        url = url + "/restart";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            ComputeOperationResponse result = null;
            result = new ComputeOperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            ComputeOperationResponse computeOperationResponse = result;
            return computeOperationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<ComputeOperationResponse> beginStartingAsync(final String resourceGroupName, final String vmName) {
        return this.getClient().getExecutorService().submit(new Callable<ComputeOperationResponse>(){

            @Override
            public ComputeOperationResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.beginStarting(resourceGroupName, vmName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComputeOperationResponse beginStarting(String resourceGroupName, String vmName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (vmName == null) {
            throw new NullPointerException("vmName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("vmName", vmName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"beginStartingAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/";
        url = url + "virtualMachines";
        url = url + "/";
        url = url + URLEncoder.encode(vmName, "UTF-8");
        url = url + "/start";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 202) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            ComputeOperationResponse result = null;
            result = new ComputeOperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("Azure-AsyncOperation").length > 0) {
                result.setAzureAsyncOperation(httpResponse.getFirstHeader("Azure-AsyncOperation").getValue());
            }
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            ComputeOperationResponse computeOperationResponse = result;
            return computeOperationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<ComputeLongRunningOperationResponse> captureAsync(final String resourceGroupName, final String vmName, final VirtualMachineCaptureParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<ComputeLongRunningOperationResponse>(){

            @Override
            public ComputeLongRunningOperationResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.capture(resourceGroupName, vmName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComputeLongRunningOperationResponse capture(String resourceGroupName, String vmName, VirtualMachineCaptureParameters parameters) throws InterruptedException, ExecutionException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("vmName", vmName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"captureAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            ComputeOperationResponse response = client2.getVirtualMachinesOperations().beginCapturingAsync(resourceGroupName, vmName, parameters).get();
            ComputeLongRunningOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)ComputeOperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            ComputeLongRunningOperationResponse computeLongRunningOperationResponse = result;
            return computeLongRunningOperationResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<ComputeLongRunningOperationResponse> createOrUpdateAsync(final String resourceGroupName, final VirtualMachine parameters) {
        return this.getClient().getExecutorService().submit(new Callable<ComputeLongRunningOperationResponse>(){

            @Override
            public ComputeLongRunningOperationResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.createOrUpdate(resourceGroupName, parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComputeLongRunningOperationResponse createOrUpdate(String resourceGroupName, VirtualMachine parameters) throws IOException, ServiceException, InterruptedException, ExecutionException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("parameters", (Object)parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"createOrUpdateAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            VirtualMachineCreateOrUpdateResponse response = client2.getVirtualMachinesOperations().beginCreatingOrUpdatingAsync(resourceGroupName, parameters).get();
            ComputeLongRunningOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)ComputeOperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            ComputeLongRunningOperationResponse computeLongRunningOperationResponse = result;
            return computeLongRunningOperationResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<ComputeLongRunningOperationResponse> deallocateAsync(final String resourceGroupName, final String vmName) {
        return this.getClient().getExecutorService().submit(new Callable<ComputeLongRunningOperationResponse>(){

            @Override
            public ComputeLongRunningOperationResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.deallocate(resourceGroupName, vmName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComputeLongRunningOperationResponse deallocate(String resourceGroupName, String vmName) throws InterruptedException, ExecutionException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("vmName", vmName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deallocateAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            ComputeOperationResponse response = client2.getVirtualMachinesOperations().beginDeallocatingAsync(resourceGroupName, vmName).get();
            ComputeLongRunningOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)ComputeOperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            ComputeLongRunningOperationResponse computeLongRunningOperationResponse = result;
            return computeLongRunningOperationResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<DeleteOperationResponse> deleteAsync(final String resourceGroupName, final String vmName) {
        return this.getClient().getExecutorService().submit(new Callable<DeleteOperationResponse>(){

            @Override
            public DeleteOperationResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.delete(resourceGroupName, vmName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteOperationResponse delete(String resourceGroupName, String vmName) throws IOException, ServiceException, InterruptedException, ExecutionException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("vmName", vmName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"deleteAsync", tracingParameters);
        }
        try {
            DeleteOperationResponse response;
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            if ((response = client2.getVirtualMachinesOperations().beginDeletingAsync(resourceGroupName, vmName).get()).getStatus() == OperationStatus.Succeeded) {
                DeleteOperationResponse deleteOperationResponse = response;
                return deleteOperationResponse;
            }
            DeleteOperationResponse result = client2.getDeleteOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)OperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getDeleteOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            DeleteOperationResponse deleteOperationResponse = result;
            return deleteOperationResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<OperationResponse> generalizeAsync(final String resourceGroupName, final String vmName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>(){

            @Override
            public OperationResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.generalize(resourceGroupName, vmName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse generalize(String resourceGroupName, String vmName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (vmName == null) {
            throw new NullPointerException("vmName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("vmName", vmName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"generalizeAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/";
        url = url + "virtualMachines";
        url = url + "/";
        url = url + URLEncoder.encode(vmName, "UTF-8");
        url = url + "/generalize";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpPost httpRequest = new HttpPost(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromXml((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            OperationResponse operationResponse = result;
            return operationResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<VirtualMachineGetResponse> getAsync(final String resourceGroupName, final String vmName) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineGetResponse>(){

            @Override
            public VirtualMachineGetResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.get(resourceGroupName, vmName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualMachineGetResponse get(String resourceGroupName, String vmName) throws IOException, ServiceException, URISyntaxException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (vmName == null) {
            throw new NullPointerException("vmName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("vmName", vmName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/";
        url = url + "virtualMachines";
        url = url + "/";
        url = url + URLEncoder.encode(vmName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualMachineGetResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualMachineGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString((InputStream)responseContent);
                if (!(responseDocContent == null) && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode tagsSequenceElement2;
                    JsonNode locationValue2;
                    JsonNode typeValue6;
                    JsonNode nameValue8;
                    JsonNode idValue5;
                    JsonNode resourcesArray;
                    JsonNode propertiesValue;
                    VirtualMachine virtualMachineInstance = new VirtualMachine();
                    result.setVirtualMachine(virtualMachineInstance);
                    JsonNode planValue = responseDoc.get("plan");
                    if (planValue != null && !(planValue instanceof NullNode)) {
                        JsonNode promotionCodeValue;
                        JsonNode productValue;
                        JsonNode publisherValue;
                        Plan planInstance = new Plan();
                        virtualMachineInstance.setPlan(planInstance);
                        JsonNode nameValue = planValue.get("name");
                        if (nameValue != null && !(nameValue instanceof NullNode)) {
                            String nameInstance = nameValue.getTextValue();
                            planInstance.setName(nameInstance);
                        }
                        if ((publisherValue = planValue.get("publisher")) != null && !(publisherValue instanceof NullNode)) {
                            String publisherInstance = publisherValue.getTextValue();
                            planInstance.setPublisher(publisherInstance);
                        }
                        if ((productValue = planValue.get("product")) != null && !(productValue instanceof NullNode)) {
                            String productInstance = productValue.getTextValue();
                            planInstance.setProduct(productInstance);
                        }
                        if ((promotionCodeValue = planValue.get("promotionCode")) != null && !(promotionCodeValue instanceof NullNode)) {
                            String promotionCodeInstance = promotionCodeValue.getTextValue();
                            planInstance.setPromotionCode(promotionCodeInstance);
                        }
                    }
                    if ((propertiesValue = responseDoc.get("properties")) != null && !(propertiesValue instanceof NullNode)) {
                        JsonNode instanceViewValue;
                        JsonNode provisioningStateValue;
                        JsonNode availabilitySetValue;
                        JsonNode diagnosticsProfileValue;
                        JsonNode networkProfileValue;
                        JsonNode osProfileValue;
                        Object storageProfileValue;
                        JsonNode hardwareProfileValue = propertiesValue.get("hardwareProfile");
                        if (hardwareProfileValue != null && !(hardwareProfileValue instanceof NullNode)) {
                            HardwareProfile hardwareProfileInstance = new HardwareProfile();
                            virtualMachineInstance.setHardwareProfile(hardwareProfileInstance);
                            JsonNode vmSizeValue = hardwareProfileValue.get("vmSize");
                            if (vmSizeValue != null && !(vmSizeValue instanceof NullNode)) {
                                String vmSizeInstance = vmSizeValue.getTextValue();
                                hardwareProfileInstance.setVirtualMachineSize(vmSizeInstance);
                            }
                        }
                        if ((storageProfileValue = propertiesValue.get("storageProfile")) != null && !(storageProfileValue instanceof NullNode)) {
                            JsonNode dataDisksArray;
                            JsonNode osDiskValue;
                            StorageProfile storageProfileInstance = new StorageProfile();
                            virtualMachineInstance.setStorageProfile(storageProfileInstance);
                            JsonNode imageReferenceValue = storageProfileValue.get("imageReference");
                            if (imageReferenceValue != null && !(imageReferenceValue instanceof NullNode)) {
                                JsonNode versionValue;
                                JsonNode skuValue;
                                JsonNode offerValue;
                                ImageReference imageReferenceInstance = new ImageReference();
                                storageProfileInstance.setImageReference(imageReferenceInstance);
                                JsonNode publisherValue2 = imageReferenceValue.get("publisher");
                                if (publisherValue2 != null && !(publisherValue2 instanceof NullNode)) {
                                    String publisherInstance2 = publisherValue2.getTextValue();
                                    imageReferenceInstance.setPublisher(publisherInstance2);
                                }
                                if ((offerValue = imageReferenceValue.get("offer")) != null && !(offerValue instanceof NullNode)) {
                                    String offerInstance = offerValue.getTextValue();
                                    imageReferenceInstance.setOffer(offerInstance);
                                }
                                if ((skuValue = imageReferenceValue.get("sku")) != null && !(skuValue instanceof NullNode)) {
                                    String skuInstance = skuValue.getTextValue();
                                    imageReferenceInstance.setSku(skuInstance);
                                }
                                if ((versionValue = imageReferenceValue.get("version")) != null && !(versionValue instanceof NullNode)) {
                                    String versionInstance = versionValue.getTextValue();
                                    imageReferenceInstance.setVersion(versionInstance);
                                }
                            }
                            if ((osDiskValue = storageProfileValue.get("osDisk")) != null && !(osDiskValue instanceof NullNode)) {
                                JsonNode diskSizeGBValue;
                                JsonNode createOptionValue;
                                JsonNode cachingValue;
                                JsonNode imageValue;
                                JsonNode vhdValue;
                                JsonNode nameValue2;
                                OSDisk osDiskInstance = new OSDisk();
                                storageProfileInstance.setOSDisk(osDiskInstance);
                                Iterator osTypeValue = osDiskValue.get("osType");
                                if (osTypeValue != null && !(osTypeValue instanceof NullNode)) {
                                    String osTypeInstance = osTypeValue.getTextValue();
                                    osDiskInstance.setOperatingSystemType(osTypeInstance);
                                }
                                if ((nameValue2 = osDiskValue.get("name")) != null && !(nameValue2 instanceof NullNode)) {
                                    String nameInstance2 = nameValue2.getTextValue();
                                    osDiskInstance.setName(nameInstance2);
                                }
                                if ((vhdValue = osDiskValue.get("vhd")) != null && !(vhdValue instanceof NullNode)) {
                                    VirtualHardDisk vhdInstance = new VirtualHardDisk();
                                    osDiskInstance.setVirtualHardDisk(vhdInstance);
                                    JsonNode uriValue = vhdValue.get("uri");
                                    if (uriValue != null && !(uriValue instanceof NullNode)) {
                                        String uriInstance = uriValue.getTextValue();
                                        vhdInstance.setUri(uriInstance);
                                    }
                                }
                                if ((imageValue = osDiskValue.get("image")) != null && !(imageValue instanceof NullNode)) {
                                    VirtualHardDisk imageInstance = new VirtualHardDisk();
                                    osDiskInstance.setSourceImage(imageInstance);
                                    JsonNode uriValue2 = imageValue.get("uri");
                                    if (uriValue2 != null && !(uriValue2 instanceof NullNode)) {
                                        String uriInstance2 = uriValue2.getTextValue();
                                        imageInstance.setUri(uriInstance2);
                                    }
                                }
                                if ((cachingValue = osDiskValue.get("caching")) != null && !(cachingValue instanceof NullNode)) {
                                    String cachingInstance = cachingValue.getTextValue();
                                    osDiskInstance.setCaching(cachingInstance);
                                }
                                if ((createOptionValue = osDiskValue.get("createOption")) != null && !(createOptionValue instanceof NullNode)) {
                                    String createOptionInstance = createOptionValue.getTextValue();
                                    osDiskInstance.setCreateOption(createOptionInstance);
                                }
                                if ((diskSizeGBValue = osDiskValue.get("diskSizeGB")) != null && !(diskSizeGBValue instanceof NullNode)) {
                                    int diskSizeGBInstance = diskSizeGBValue.getIntValue();
                                    osDiskInstance.setDiskSizeGB(diskSizeGBInstance);
                                }
                            }
                            if ((dataDisksArray = storageProfileValue.get("dataDisks")) != null && !(dataDisksArray instanceof NullNode)) {
                                for (JsonNode dataDisksValue : (ArrayNode)dataDisksArray) {
                                    JsonNode diskSizeGBValue2;
                                    Object createOptionValue2;
                                    JsonNode cachingValue2;
                                    JsonNode imageValue2;
                                    JsonNode vhdValue2;
                                    JsonNode nameValue3;
                                    DataDisk dataDiskInstance = new DataDisk();
                                    storageProfileInstance.getDataDisks().add(dataDiskInstance);
                                    JsonNode lunValue = dataDisksValue.get("lun");
                                    if (lunValue != null && !(lunValue instanceof NullNode)) {
                                        int lunInstance = lunValue.getIntValue();
                                        dataDiskInstance.setLun(lunInstance);
                                    }
                                    if ((nameValue3 = dataDisksValue.get("name")) != null && !(nameValue3 instanceof NullNode)) {
                                        String nameInstance3 = nameValue3.getTextValue();
                                        dataDiskInstance.setName(nameInstance3);
                                    }
                                    if ((vhdValue2 = dataDisksValue.get("vhd")) != null && !(vhdValue2 instanceof NullNode)) {
                                        VirtualHardDisk vhdInstance2 = new VirtualHardDisk();
                                        dataDiskInstance.setVirtualHardDisk(vhdInstance2);
                                        JsonNode uriValue3 = vhdValue2.get("uri");
                                        if (uriValue3 != null && !(uriValue3 instanceof NullNode)) {
                                            String uriInstance3 = uriValue3.getTextValue();
                                            vhdInstance2.setUri(uriInstance3);
                                        }
                                    }
                                    if ((imageValue2 = dataDisksValue.get("image")) != null && !(imageValue2 instanceof NullNode)) {
                                        VirtualHardDisk imageInstance2 = new VirtualHardDisk();
                                        dataDiskInstance.setSourceImage(imageInstance2);
                                        JsonNode uriValue4 = imageValue2.get("uri");
                                        if (uriValue4 != null && !(uriValue4 instanceof NullNode)) {
                                            String uriInstance4 = uriValue4.getTextValue();
                                            imageInstance2.setUri(uriInstance4);
                                        }
                                    }
                                    if ((cachingValue2 = dataDisksValue.get("caching")) != null && !(cachingValue2 instanceof NullNode)) {
                                        String cachingInstance2 = cachingValue2.getTextValue();
                                        dataDiskInstance.setCaching(cachingInstance2);
                                    }
                                    if ((createOptionValue2 = dataDisksValue.get("createOption")) != null && !(createOptionValue2 instanceof NullNode)) {
                                        String createOptionInstance2 = createOptionValue2.getTextValue();
                                        dataDiskInstance.setCreateOption(createOptionInstance2);
                                    }
                                    if ((diskSizeGBValue2 = dataDisksValue.get("diskSizeGB")) == null || diskSizeGBValue2 instanceof NullNode) continue;
                                    int diskSizeGBInstance2 = diskSizeGBValue2.getIntValue();
                                    dataDiskInstance.setDiskSizeGB(diskSizeGBInstance2);
                                }
                            }
                        }
                        if ((osProfileValue = propertiesValue.get("osProfile")) != null && !(osProfileValue instanceof NullNode)) {
                            JsonNode secretsArray;
                            JsonNode linuxConfigurationValue;
                            JsonNode windowsConfigurationValue;
                            JsonNode customDataValue;
                            Object adminPasswordValue;
                            JsonNode adminUsernameValue;
                            OSProfile osProfileInstance = new OSProfile();
                            virtualMachineInstance.setOSProfile(osProfileInstance);
                            JsonNode computerNameValue = osProfileValue.get("computerName");
                            if (computerNameValue != null && !(computerNameValue instanceof NullNode)) {
                                String computerNameInstance = computerNameValue.getTextValue();
                                osProfileInstance.setComputerName(computerNameInstance);
                            }
                            if ((adminUsernameValue = osProfileValue.get("adminUsername")) != null && !(adminUsernameValue instanceof NullNode)) {
                                String adminUsernameInstance = adminUsernameValue.getTextValue();
                                osProfileInstance.setAdminUsername(adminUsernameInstance);
                            }
                            if ((adminPasswordValue = osProfileValue.get("adminPassword")) != null && !(adminPasswordValue instanceof NullNode)) {
                                String adminPasswordInstance = adminPasswordValue.getTextValue();
                                osProfileInstance.setAdminPassword(adminPasswordInstance);
                            }
                            if ((customDataValue = osProfileValue.get("customData")) != null && !(customDataValue instanceof NullNode)) {
                                String customDataInstance = customDataValue.getTextValue();
                                osProfileInstance.setCustomData(customDataInstance);
                            }
                            if ((windowsConfigurationValue = osProfileValue.get("windowsConfiguration")) != null && !(windowsConfigurationValue instanceof NullNode)) {
                                JsonNode winRMValue;
                                JsonNode additionalUnattendContentArray;
                                JsonNode timeZoneValue;
                                JsonNode enableAutomaticUpdatesValue;
                                WindowsConfiguration windowsConfigurationInstance = new WindowsConfiguration();
                                osProfileInstance.setWindowsConfiguration(windowsConfigurationInstance);
                                JsonNode provisionVMAgentValue = windowsConfigurationValue.get("provisionVMAgent");
                                if (provisionVMAgentValue != null && !(provisionVMAgentValue instanceof NullNode)) {
                                    boolean provisionVMAgentInstance = provisionVMAgentValue.getBooleanValue();
                                    windowsConfigurationInstance.setProvisionVMAgent(provisionVMAgentInstance);
                                }
                                if ((enableAutomaticUpdatesValue = windowsConfigurationValue.get("enableAutomaticUpdates")) != null && !(enableAutomaticUpdatesValue instanceof NullNode)) {
                                    boolean enableAutomaticUpdatesInstance = enableAutomaticUpdatesValue.getBooleanValue();
                                    windowsConfigurationInstance.setEnableAutomaticUpdates(enableAutomaticUpdatesInstance);
                                }
                                if ((timeZoneValue = windowsConfigurationValue.get("timeZone")) != null && !(timeZoneValue instanceof NullNode)) {
                                    String timeZoneInstance = timeZoneValue.getTextValue();
                                    windowsConfigurationInstance.setTimeZone(timeZoneInstance);
                                }
                                if ((additionalUnattendContentArray = windowsConfigurationValue.get("additionalUnattendContent")) != null && !(additionalUnattendContentArray instanceof NullNode)) {
                                    for (JsonNode additionalUnattendContentValue : (ArrayNode)additionalUnattendContentArray) {
                                        JsonNode contentValue;
                                        JsonNode settingNameValue;
                                        JsonNode componentNameValue;
                                        AdditionalUnattendContent additionalUnattendContentInstance = new AdditionalUnattendContent();
                                        windowsConfigurationInstance.getAdditionalUnattendContents().add(additionalUnattendContentInstance);
                                        JsonNode passNameValue = additionalUnattendContentValue.get("passName");
                                        if (passNameValue != null && !(passNameValue instanceof NullNode)) {
                                            String passNameInstance = passNameValue.getTextValue();
                                            additionalUnattendContentInstance.setPassName(passNameInstance);
                                        }
                                        if ((componentNameValue = additionalUnattendContentValue.get("componentName")) != null && !(componentNameValue instanceof NullNode)) {
                                            String componentNameInstance = componentNameValue.getTextValue();
                                            additionalUnattendContentInstance.setComponentName(componentNameInstance);
                                        }
                                        if ((settingNameValue = additionalUnattendContentValue.get("settingName")) != null && !(settingNameValue instanceof NullNode)) {
                                            String settingNameInstance = settingNameValue.getTextValue();
                                            additionalUnattendContentInstance.setSettingName(settingNameInstance);
                                        }
                                        if ((contentValue = additionalUnattendContentValue.get("content")) == null || contentValue instanceof NullNode) continue;
                                        String contentInstance = contentValue.getTextValue();
                                        additionalUnattendContentInstance.setContent(contentInstance);
                                    }
                                }
                                if ((winRMValue = windowsConfigurationValue.get("winRM")) != null && !(winRMValue instanceof NullNode)) {
                                    WinRMConfiguration winRMInstance = new WinRMConfiguration();
                                    windowsConfigurationInstance.setWinRMConfiguration(winRMInstance);
                                    JsonNode listenersArray = winRMValue.get("listeners");
                                    if (listenersArray != null && !(listenersArray instanceof NullNode)) {
                                        for (JsonNode listenersValue : (ArrayNode)listenersArray) {
                                            JsonNode certificateUrlValue;
                                            WinRMListener winRMListenerInstance = new WinRMListener();
                                            winRMInstance.getListeners().add(winRMListenerInstance);
                                            JsonNode protocolValue = listenersValue.get("protocol");
                                            if (protocolValue != null && !(protocolValue instanceof NullNode)) {
                                                String protocolInstance = protocolValue.getTextValue();
                                                winRMListenerInstance.setProtocol(protocolInstance);
                                            }
                                            if ((certificateUrlValue = listenersValue.get("certificateUrl")) == null || certificateUrlValue instanceof NullNode) continue;
                                            URI certificateUrlInstance = new URI(certificateUrlValue.getTextValue());
                                            winRMListenerInstance.setCertificateUrl(certificateUrlInstance);
                                        }
                                    }
                                }
                            }
                            if ((linuxConfigurationValue = osProfileValue.get("linuxConfiguration")) != null && !(linuxConfigurationValue instanceof NullNode)) {
                                JsonNode sshValue;
                                LinuxConfiguration linuxConfigurationInstance = new LinuxConfiguration();
                                osProfileInstance.setLinuxConfiguration(linuxConfigurationInstance);
                                Iterator disablePasswordAuthenticationValue = linuxConfigurationValue.get("disablePasswordAuthentication");
                                if (disablePasswordAuthenticationValue != null && !(disablePasswordAuthenticationValue instanceof NullNode)) {
                                    boolean disablePasswordAuthenticationInstance = disablePasswordAuthenticationValue.getBooleanValue();
                                    linuxConfigurationInstance.setDisablePasswordAuthentication(disablePasswordAuthenticationInstance);
                                }
                                if ((sshValue = linuxConfigurationValue.get("ssh")) != null && !(sshValue instanceof NullNode)) {
                                    SshConfiguration sshInstance = new SshConfiguration();
                                    linuxConfigurationInstance.setSshConfiguration(sshInstance);
                                    JsonNode publicKeysArray = sshValue.get("publicKeys");
                                    if (publicKeysArray != null && !(publicKeysArray instanceof NullNode)) {
                                        for (JsonNode publicKeysValue : (ArrayNode)publicKeysArray) {
                                            JsonNode keyDataValue;
                                            SshPublicKey sshPublicKeyInstance = new SshPublicKey();
                                            sshInstance.getPublicKeys().add(sshPublicKeyInstance);
                                            JsonNode pathValue = publicKeysValue.get("path");
                                            if (pathValue != null && !(pathValue instanceof NullNode)) {
                                                String pathInstance = pathValue.getTextValue();
                                                sshPublicKeyInstance.setPath(pathInstance);
                                            }
                                            if ((keyDataValue = publicKeysValue.get("keyData")) == null || keyDataValue instanceof NullNode) continue;
                                            String keyDataInstance = keyDataValue.getTextValue();
                                            sshPublicKeyInstance.setKeyData(keyDataInstance);
                                        }
                                    }
                                }
                            }
                            if ((secretsArray = osProfileValue.get("secrets")) != null && !(secretsArray instanceof NullNode)) {
                                for (JsonNode secretsValue : (ArrayNode)secretsArray) {
                                    JsonNode vaultCertificatesArray;
                                    VaultSecretGroup vaultSecretGroupInstance = new VaultSecretGroup();
                                    osProfileInstance.getSecrets().add(vaultSecretGroupInstance);
                                    JsonNode sourceVaultValue = secretsValue.get("sourceVault");
                                    if (sourceVaultValue != null && !(sourceVaultValue instanceof NullNode)) {
                                        SourceVaultReference sourceVaultInstance = new SourceVaultReference();
                                        vaultSecretGroupInstance.setSourceVault(sourceVaultInstance);
                                        Iterator idValue = sourceVaultValue.get("id");
                                        if (idValue != null && !(idValue instanceof NullNode)) {
                                            String idInstance = idValue.getTextValue();
                                            sourceVaultInstance.setReferenceUri(idInstance);
                                        }
                                    }
                                    if ((vaultCertificatesArray = secretsValue.get("vaultCertificates")) == null || vaultCertificatesArray instanceof NullNode) continue;
                                    for (JsonNode vaultCertificatesValue : (ArrayNode)vaultCertificatesArray) {
                                        JsonNode certificateStoreValue;
                                        VaultCertificate vaultCertificateInstance = new VaultCertificate();
                                        vaultSecretGroupInstance.getVaultCertificates().add(vaultCertificateInstance);
                                        JsonNode certificateUrlValue2 = vaultCertificatesValue.get("certificateUrl");
                                        if (certificateUrlValue2 != null && !(certificateUrlValue2 instanceof NullNode)) {
                                            String certificateUrlInstance2 = certificateUrlValue2.getTextValue();
                                            vaultCertificateInstance.setCertificateUrl(certificateUrlInstance2);
                                        }
                                        if ((certificateStoreValue = vaultCertificatesValue.get("certificateStore")) == null || certificateStoreValue instanceof NullNode) continue;
                                        String certificateStoreInstance = certificateStoreValue.getTextValue();
                                        vaultCertificateInstance.setCertificateStore(certificateStoreInstance);
                                    }
                                }
                            }
                        }
                        if ((networkProfileValue = propertiesValue.get("networkProfile")) != null && !(networkProfileValue instanceof NullNode)) {
                            NetworkProfile networkProfileInstance = new NetworkProfile();
                            virtualMachineInstance.setNetworkProfile(networkProfileInstance);
                            JsonNode networkInterfacesArray = networkProfileValue.get("networkInterfaces");
                            if (networkInterfacesArray != null && !(networkInterfacesArray instanceof NullNode)) {
                                for (JsonNode networkInterfacesValue : (ArrayNode)networkInterfacesArray) {
                                    JsonNode idValue2;
                                    JsonNode primaryValue;
                                    NetworkInterfaceReference networkInterfaceReferenceJsonInstance = new NetworkInterfaceReference();
                                    networkProfileInstance.getNetworkInterfaces().add(networkInterfaceReferenceJsonInstance);
                                    JsonNode propertiesValue2 = networkInterfacesValue.get("properties");
                                    if (propertiesValue2 != null && !(propertiesValue2 instanceof NullNode) && (primaryValue = propertiesValue2.get("primary")) != null && !(primaryValue instanceof NullNode)) {
                                        boolean primaryInstance = primaryValue.getBooleanValue();
                                        networkInterfaceReferenceJsonInstance.setPrimary(primaryInstance);
                                    }
                                    if ((idValue2 = networkInterfacesValue.get("id")) == null || idValue2 instanceof NullNode) continue;
                                    String idInstance2 = idValue2.getTextValue();
                                    networkInterfaceReferenceJsonInstance.setReferenceUri(idInstance2);
                                }
                            }
                        }
                        if ((diagnosticsProfileValue = propertiesValue.get("diagnosticsProfile")) != null && !(diagnosticsProfileValue instanceof NullNode)) {
                            DiagnosticsProfile diagnosticsProfileInstance = new DiagnosticsProfile();
                            virtualMachineInstance.setDiagnosticsProfile(diagnosticsProfileInstance);
                            JsonNode bootDiagnosticsValue = diagnosticsProfileValue.get("bootDiagnostics");
                            if (bootDiagnosticsValue != null && !(bootDiagnosticsValue instanceof NullNode)) {
                                JsonNode storageUriValue;
                                BootDiagnostics bootDiagnosticsInstance = new BootDiagnostics();
                                diagnosticsProfileInstance.setBootDiagnostics(bootDiagnosticsInstance);
                                JsonNode enabledValue = bootDiagnosticsValue.get("enabled");
                                if (enabledValue != null && !(enabledValue instanceof NullNode)) {
                                    boolean enabledInstance = enabledValue.getBooleanValue();
                                    bootDiagnosticsInstance.setEnabled(enabledInstance);
                                }
                                if ((storageUriValue = bootDiagnosticsValue.get("storageUri")) != null && !(storageUriValue instanceof NullNode)) {
                                    URI storageUriInstance = new URI(storageUriValue.getTextValue());
                                    bootDiagnosticsInstance.setStorageUri(storageUriInstance);
                                }
                            }
                        }
                        if ((availabilitySetValue = propertiesValue.get("availabilitySet")) != null && !(availabilitySetValue instanceof NullNode)) {
                            AvailabilitySetReference availabilitySetInstance = new AvailabilitySetReference();
                            virtualMachineInstance.setAvailabilitySetReference(availabilitySetInstance);
                            JsonNode idValue3 = availabilitySetValue.get("id");
                            if (idValue3 != null && !(idValue3 instanceof NullNode)) {
                                String idInstance3 = idValue3.getTextValue();
                                availabilitySetInstance.setReferenceUri(idInstance3);
                            }
                        }
                        if ((provisioningStateValue = propertiesValue.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                            String provisioningStateInstance = provisioningStateValue.getTextValue();
                            virtualMachineInstance.setProvisioningState(provisioningStateInstance);
                        }
                        if ((instanceViewValue = propertiesValue.get("instanceView")) != null && !(instanceViewValue instanceof NullNode)) {
                            JsonNode statusesArray4;
                            JsonNode bootDiagnosticsValue2;
                            JsonNode extensionsArray;
                            JsonNode disksArray;
                            JsonNode vmAgentValue;
                            JsonNode rdpThumbPrintValue;
                            JsonNode platformFaultDomainValue;
                            VirtualMachineInstanceView instanceViewInstance = new VirtualMachineInstanceView();
                            virtualMachineInstance.setInstanceView(instanceViewInstance);
                            JsonNode platformUpdateDomainValue = instanceViewValue.get("platformUpdateDomain");
                            if (platformUpdateDomainValue != null && !(platformUpdateDomainValue instanceof NullNode)) {
                                int platformUpdateDomainInstance = platformUpdateDomainValue.getIntValue();
                                instanceViewInstance.setPlatformUpdateDomain(platformUpdateDomainInstance);
                            }
                            if ((platformFaultDomainValue = instanceViewValue.get("platformFaultDomain")) != null && !(platformFaultDomainValue instanceof NullNode)) {
                                int platformFaultDomainInstance = platformFaultDomainValue.getIntValue();
                                instanceViewInstance.setPlatformFaultDomain(platformFaultDomainInstance);
                            }
                            if ((rdpThumbPrintValue = instanceViewValue.get("rdpThumbPrint")) != null && !(rdpThumbPrintValue instanceof NullNode)) {
                                String rdpThumbPrintInstance = rdpThumbPrintValue.getTextValue();
                                instanceViewInstance.setRemoteDesktopThumbprint(rdpThumbPrintInstance);
                            }
                            if ((vmAgentValue = instanceViewValue.get("vmAgent")) != null && !(vmAgentValue instanceof NullNode)) {
                                JsonNode statusesArray;
                                JsonNode extensionHandlersArray;
                                VirtualMachineAgentInstanceView vmAgentInstance = new VirtualMachineAgentInstanceView();
                                instanceViewInstance.setVMAgent(vmAgentInstance);
                                Iterator vmAgentVersionValue = vmAgentValue.get("vmAgentVersion");
                                if (vmAgentVersionValue != null && !(vmAgentVersionValue instanceof NullNode)) {
                                    String vmAgentVersionInstance = vmAgentVersionValue.getTextValue();
                                    vmAgentInstance.setVMAgentVersion(vmAgentVersionInstance);
                                }
                                if ((extensionHandlersArray = vmAgentValue.get("extensionHandlers")) != null && !(extensionHandlersArray instanceof NullNode)) {
                                    for (Iterator extensionHandlersValue : (ArrayNode)extensionHandlersArray) {
                                        JsonNode timeValue;
                                        JsonNode messageValue;
                                        JsonNode displayStatusValue;
                                        JsonNode levelValue;
                                        JsonNode statusValue;
                                        JsonNode typeHandlerVersionValue;
                                        VirtualMachineExtensionHandlerInstanceView virtualMachineExtensionHandlerInstanceViewInstance = new VirtualMachineExtensionHandlerInstanceView();
                                        vmAgentInstance.getExtensionHandlers().add(virtualMachineExtensionHandlerInstanceViewInstance);
                                        JsonNode typeValue = extensionHandlersValue.get("type");
                                        if (typeValue != null && !(typeValue instanceof NullNode)) {
                                            String typeInstance = typeValue.getTextValue();
                                            virtualMachineExtensionHandlerInstanceViewInstance.setType(typeInstance);
                                        }
                                        if ((typeHandlerVersionValue = extensionHandlersValue.get("typeHandlerVersion")) != null && !(typeHandlerVersionValue instanceof NullNode)) {
                                            String typeHandlerVersionInstance = typeHandlerVersionValue.getTextValue();
                                            virtualMachineExtensionHandlerInstanceViewInstance.setTypeHandlerVersion(typeHandlerVersionInstance);
                                        }
                                        if ((statusValue = extensionHandlersValue.get("status")) == null || statusValue instanceof NullNode) continue;
                                        InstanceViewStatus statusInstance = new InstanceViewStatus();
                                        virtualMachineExtensionHandlerInstanceViewInstance.setStatus(statusInstance);
                                        JsonNode codeValue = statusValue.get("code");
                                        if (codeValue != null && !(codeValue instanceof NullNode)) {
                                            String codeInstance = codeValue.getTextValue();
                                            statusInstance.setCode(codeInstance);
                                        }
                                        if ((levelValue = statusValue.get("level")) != null && !(levelValue instanceof NullNode)) {
                                            String levelInstance = levelValue.getTextValue();
                                            statusInstance.setLevel(levelInstance);
                                        }
                                        if ((displayStatusValue = statusValue.get("displayStatus")) != null && !(displayStatusValue instanceof NullNode)) {
                                            String displayStatusInstance = displayStatusValue.getTextValue();
                                            statusInstance.setDisplayStatus(displayStatusInstance);
                                        }
                                        if ((messageValue = statusValue.get("message")) != null && !(messageValue instanceof NullNode)) {
                                            String messageInstance = messageValue.getTextValue();
                                            statusInstance.setMessage(messageInstance);
                                        }
                                        if ((timeValue = statusValue.get("time")) == null || timeValue instanceof NullNode) continue;
                                        Calendar timeInstance = DatatypeConverter.parseDateTime((String)timeValue.getTextValue());
                                        statusInstance.setTime(timeInstance);
                                    }
                                }
                                if ((statusesArray = vmAgentValue.get("statuses")) != null && !(statusesArray instanceof NullNode)) {
                                    for (JsonNode statusesValue : (ArrayNode)statusesArray) {
                                        JsonNode timeValue2;
                                        JsonNode messageValue2;
                                        JsonNode displayStatusValue2;
                                        JsonNode levelValue2;
                                        InstanceViewStatus instanceViewStatusInstance = new InstanceViewStatus();
                                        vmAgentInstance.getStatuses().add(instanceViewStatusInstance);
                                        JsonNode codeValue2 = statusesValue.get("code");
                                        if (codeValue2 != null && !(codeValue2 instanceof NullNode)) {
                                            String codeInstance2 = codeValue2.getTextValue();
                                            instanceViewStatusInstance.setCode(codeInstance2);
                                        }
                                        if ((levelValue2 = statusesValue.get("level")) != null && !(levelValue2 instanceof NullNode)) {
                                            String levelInstance2 = levelValue2.getTextValue();
                                            instanceViewStatusInstance.setLevel(levelInstance2);
                                        }
                                        if ((displayStatusValue2 = statusesValue.get("displayStatus")) != null && !(displayStatusValue2 instanceof NullNode)) {
                                            String displayStatusInstance2 = displayStatusValue2.getTextValue();
                                            instanceViewStatusInstance.setDisplayStatus(displayStatusInstance2);
                                        }
                                        if ((messageValue2 = statusesValue.get("message")) != null && !(messageValue2 instanceof NullNode)) {
                                            String messageInstance2 = messageValue2.getTextValue();
                                            instanceViewStatusInstance.setMessage(messageInstance2);
                                        }
                                        if ((timeValue2 = statusesValue.get("time")) == null || timeValue2 instanceof NullNode) continue;
                                        Calendar timeInstance2 = DatatypeConverter.parseDateTime((String)timeValue2.getTextValue());
                                        instanceViewStatusInstance.setTime(timeInstance2);
                                    }
                                }
                            }
                            if ((disksArray = instanceViewValue.get("disks")) != null && !(disksArray instanceof NullNode)) {
                                for (Iterator disksValue : (ArrayNode)disksArray) {
                                    JsonNode statusesArray2;
                                    DiskInstanceView diskInstanceViewInstance = new DiskInstanceView();
                                    instanceViewInstance.getDisks().add(diskInstanceViewInstance);
                                    JsonNode nameValue4 = disksValue.get("name");
                                    if (nameValue4 != null && !(nameValue4 instanceof NullNode)) {
                                        String nameInstance4 = nameValue4.getTextValue();
                                        diskInstanceViewInstance.setName(nameInstance4);
                                    }
                                    if ((statusesArray2 = disksValue.get("statuses")) == null || statusesArray2 instanceof NullNode) continue;
                                    for (JsonNode statusesValue2 : (ArrayNode)statusesArray2) {
                                        JsonNode timeValue3;
                                        JsonNode messageValue3;
                                        JsonNode displayStatusValue3;
                                        JsonNode levelValue3;
                                        InstanceViewStatus instanceViewStatusInstance2 = new InstanceViewStatus();
                                        diskInstanceViewInstance.getStatuses().add(instanceViewStatusInstance2);
                                        Iterator codeValue3 = statusesValue2.get("code");
                                        if (codeValue3 != null && !(codeValue3 instanceof NullNode)) {
                                            String codeInstance3 = codeValue3.getTextValue();
                                            instanceViewStatusInstance2.setCode(codeInstance3);
                                        }
                                        if ((levelValue3 = statusesValue2.get("level")) != null && !(levelValue3 instanceof NullNode)) {
                                            String levelInstance3 = levelValue3.getTextValue();
                                            instanceViewStatusInstance2.setLevel(levelInstance3);
                                        }
                                        if ((displayStatusValue3 = statusesValue2.get("displayStatus")) != null && !(displayStatusValue3 instanceof NullNode)) {
                                            String displayStatusInstance3 = displayStatusValue3.getTextValue();
                                            instanceViewStatusInstance2.setDisplayStatus(displayStatusInstance3);
                                        }
                                        if ((messageValue3 = statusesValue2.get("message")) != null && !(messageValue3 instanceof NullNode)) {
                                            String messageInstance3 = messageValue3.getTextValue();
                                            instanceViewStatusInstance2.setMessage(messageInstance3);
                                        }
                                        if ((timeValue3 = statusesValue2.get("time")) == null || timeValue3 instanceof NullNode) continue;
                                        Calendar timeInstance3 = DatatypeConverter.parseDateTime((String)timeValue3.getTextValue());
                                        instanceViewStatusInstance2.setTime(timeInstance3);
                                    }
                                }
                            }
                            if ((extensionsArray = instanceViewValue.get("extensions")) != null && !(extensionsArray instanceof NullNode)) {
                                for (JsonNode extensionsValue : (ArrayNode)extensionsArray) {
                                    JsonNode statusesArray3;
                                    Iterator substatusesValue2;
                                    JsonNode substatusesArray;
                                    JsonNode typeHandlerVersionValue2;
                                    JsonNode typeValue2;
                                    VirtualMachineExtensionInstanceView virtualMachineExtensionInstanceViewInstance = new VirtualMachineExtensionInstanceView();
                                    instanceViewInstance.getExtensions().add(virtualMachineExtensionInstanceViewInstance);
                                    JsonNode nameValue5 = extensionsValue.get("name");
                                    if (nameValue5 != null && !(nameValue5 instanceof NullNode)) {
                                        String nameInstance5 = nameValue5.getTextValue();
                                        virtualMachineExtensionInstanceViewInstance.setName(nameInstance5);
                                    }
                                    if ((typeValue2 = extensionsValue.get("type")) != null && !(typeValue2 instanceof NullNode)) {
                                        String typeInstance2 = typeValue2.getTextValue();
                                        virtualMachineExtensionInstanceViewInstance.setExtensionType(typeInstance2);
                                    }
                                    if ((typeHandlerVersionValue2 = extensionsValue.get("typeHandlerVersion")) != null && !(typeHandlerVersionValue2 instanceof NullNode)) {
                                        String typeHandlerVersionInstance2 = typeHandlerVersionValue2.getTextValue();
                                        virtualMachineExtensionInstanceViewInstance.setTypeHandlerVersion(typeHandlerVersionInstance2);
                                    }
                                    if ((substatusesArray = extensionsValue.get("substatuses")) != null && !(substatusesArray instanceof NullNode)) {
                                        for (Iterator substatusesValue2 : (ArrayNode)substatusesArray) {
                                            JsonNode timeValue4;
                                            JsonNode messageValue4;
                                            JsonNode displayStatusValue4;
                                            JsonNode levelValue4;
                                            InstanceViewStatus instanceViewStatusInstance3 = new InstanceViewStatus();
                                            virtualMachineExtensionInstanceViewInstance.getSubStatuses().add(instanceViewStatusInstance3);
                                            JsonNode codeValue4 = substatusesValue2.get("code");
                                            if (codeValue4 != null && !(codeValue4 instanceof NullNode)) {
                                                String codeInstance4 = codeValue4.getTextValue();
                                                instanceViewStatusInstance3.setCode(codeInstance4);
                                            }
                                            if ((levelValue4 = substatusesValue2.get("level")) != null && !(levelValue4 instanceof NullNode)) {
                                                String levelInstance4 = levelValue4.getTextValue();
                                                instanceViewStatusInstance3.setLevel(levelInstance4);
                                            }
                                            if ((displayStatusValue4 = substatusesValue2.get("displayStatus")) != null && !(displayStatusValue4 instanceof NullNode)) {
                                                String displayStatusInstance4 = displayStatusValue4.getTextValue();
                                                instanceViewStatusInstance3.setDisplayStatus(displayStatusInstance4);
                                            }
                                            if ((messageValue4 = substatusesValue2.get("message")) != null && !(messageValue4 instanceof NullNode)) {
                                                String messageInstance4 = messageValue4.getTextValue();
                                                instanceViewStatusInstance3.setMessage(messageInstance4);
                                            }
                                            if ((timeValue4 = substatusesValue2.get("time")) == null || timeValue4 instanceof NullNode) continue;
                                            Calendar timeInstance4 = DatatypeConverter.parseDateTime((String)timeValue4.getTextValue());
                                            instanceViewStatusInstance3.setTime(timeInstance4);
                                        }
                                    }
                                    if ((statusesArray3 = extensionsValue.get("statuses")) == null || statusesArray3 instanceof NullNode) continue;
                                    substatusesValue2 = ((ArrayNode)statusesArray3).iterator();
                                    while (substatusesValue2.hasNext()) {
                                        JsonNode timeValue5;
                                        JsonNode messageValue5;
                                        JsonNode displayStatusValue5;
                                        JsonNode levelValue5;
                                        JsonNode statusesValue3 = (JsonNode)substatusesValue2.next();
                                        InstanceViewStatus instanceViewStatusInstance4 = new InstanceViewStatus();
                                        virtualMachineExtensionInstanceViewInstance.getStatuses().add(instanceViewStatusInstance4);
                                        JsonNode codeValue5 = statusesValue3.get("code");
                                        if (codeValue5 != null && !(codeValue5 instanceof NullNode)) {
                                            String codeInstance5 = codeValue5.getTextValue();
                                            instanceViewStatusInstance4.setCode(codeInstance5);
                                        }
                                        if ((levelValue5 = statusesValue3.get("level")) != null && !(levelValue5 instanceof NullNode)) {
                                            String levelInstance5 = levelValue5.getTextValue();
                                            instanceViewStatusInstance4.setLevel(levelInstance5);
                                        }
                                        if ((displayStatusValue5 = statusesValue3.get("displayStatus")) != null && !(displayStatusValue5 instanceof NullNode)) {
                                            String displayStatusInstance5 = displayStatusValue5.getTextValue();
                                            instanceViewStatusInstance4.setDisplayStatus(displayStatusInstance5);
                                        }
                                        if ((messageValue5 = statusesValue3.get("message")) != null && !(messageValue5 instanceof NullNode)) {
                                            String messageInstance5 = messageValue5.getTextValue();
                                            instanceViewStatusInstance4.setMessage(messageInstance5);
                                        }
                                        if ((timeValue5 = statusesValue3.get("time")) == null || timeValue5 instanceof NullNode) continue;
                                        Calendar timeInstance5 = DatatypeConverter.parseDateTime((String)timeValue5.getTextValue());
                                        instanceViewStatusInstance4.setTime(timeInstance5);
                                    }
                                }
                            }
                            if ((bootDiagnosticsValue2 = instanceViewValue.get("bootDiagnostics")) != null && !(bootDiagnosticsValue2 instanceof NullNode)) {
                                JsonNode serialConsoleLogBlobUriValue;
                                BootDiagnosticsInstanceView bootDiagnosticsInstance2 = new BootDiagnosticsInstanceView();
                                instanceViewInstance.setBootDiagnostics(bootDiagnosticsInstance2);
                                Iterator consoleScreenshotBlobUriValue = bootDiagnosticsValue2.get("consoleScreenshotBlobUri");
                                if (consoleScreenshotBlobUriValue != null && !(consoleScreenshotBlobUriValue instanceof NullNode)) {
                                    URI consoleScreenshotBlobUriInstance = new URI(consoleScreenshotBlobUriValue.getTextValue());
                                    bootDiagnosticsInstance2.setConsoleScreenshotBlobUri(consoleScreenshotBlobUriInstance);
                                }
                                if ((serialConsoleLogBlobUriValue = bootDiagnosticsValue2.get("serialConsoleLogBlobUri")) != null && !(serialConsoleLogBlobUriValue instanceof NullNode)) {
                                    URI serialConsoleLogBlobUriInstance = new URI(serialConsoleLogBlobUriValue.getTextValue());
                                    bootDiagnosticsInstance2.setSerialConsoleLogBlobUri(serialConsoleLogBlobUriInstance);
                                }
                            }
                            if ((statusesArray4 = instanceViewValue.get("statuses")) != null && !(statusesArray4 instanceof NullNode)) {
                                for (Object statusesValue4 : (ArrayNode)statusesArray4) {
                                    JsonNode timeValue6;
                                    JsonNode messageValue6;
                                    JsonNode displayStatusValue6;
                                    JsonNode levelValue6;
                                    InstanceViewStatus instanceViewStatusInstance5 = new InstanceViewStatus();
                                    instanceViewInstance.getStatuses().add(instanceViewStatusInstance5);
                                    JsonNode codeValue6 = statusesValue4.get("code");
                                    if (codeValue6 != null && !(codeValue6 instanceof NullNode)) {
                                        String codeInstance6 = codeValue6.getTextValue();
                                        instanceViewStatusInstance5.setCode(codeInstance6);
                                    }
                                    if ((levelValue6 = statusesValue4.get("level")) != null && !(levelValue6 instanceof NullNode)) {
                                        String levelInstance6 = levelValue6.getTextValue();
                                        instanceViewStatusInstance5.setLevel(levelInstance6);
                                    }
                                    if ((displayStatusValue6 = statusesValue4.get("displayStatus")) != null && !(displayStatusValue6 instanceof NullNode)) {
                                        String displayStatusInstance6 = displayStatusValue6.getTextValue();
                                        instanceViewStatusInstance5.setDisplayStatus(displayStatusInstance6);
                                    }
                                    if ((messageValue6 = statusesValue4.get("message")) != null && !(messageValue6 instanceof NullNode)) {
                                        String messageInstance6 = messageValue6.getTextValue();
                                        instanceViewStatusInstance5.setMessage(messageInstance6);
                                    }
                                    if ((timeValue6 = statusesValue4.get("time")) == null || timeValue6 instanceof NullNode) continue;
                                    Calendar timeInstance6 = DatatypeConverter.parseDateTime((String)timeValue6.getTextValue());
                                    instanceViewStatusInstance5.setTime(timeInstance6);
                                }
                            }
                        }
                    }
                    if ((resourcesArray = responseDoc.get("resources")) != null && !(resourcesArray instanceof NullNode)) {
                        virtualMachineInstance.setExtensions(new ArrayList<VirtualMachineExtension>());
                        for (JsonNode resourcesValue : (ArrayNode)resourcesArray) {
                            JsonNode tagsSequenceElement;
                            JsonNode locationValue;
                            JsonNode typeValue5;
                            JsonNode nameValue7;
                            JsonNode idValue4;
                            VirtualMachineExtension virtualMachineExtensionJsonInstance = new VirtualMachineExtension();
                            virtualMachineInstance.getExtensions().add(virtualMachineExtensionJsonInstance);
                            JsonNode propertiesValue3 = resourcesValue.get("properties");
                            if (propertiesValue3 != null && !(propertiesValue3 instanceof NullNode)) {
                                JsonNode instanceViewValue2;
                                JsonNode provisioningStateValue2;
                                JsonNode protectedSettingsValue;
                                JsonNode settingsValue;
                                JsonNode autoUpgradeMinorVersionValue;
                                JsonNode typeHandlerVersionValue3;
                                JsonNode typeValue3;
                                JsonNode publisherValue3 = propertiesValue3.get("publisher");
                                if (publisherValue3 != null && !(publisherValue3 instanceof NullNode)) {
                                    String publisherInstance3 = publisherValue3.getTextValue();
                                    virtualMachineExtensionJsonInstance.setPublisher(publisherInstance3);
                                }
                                if ((typeValue3 = propertiesValue3.get("type")) != null && !(typeValue3 instanceof NullNode)) {
                                    String typeInstance3 = typeValue3.getTextValue();
                                    virtualMachineExtensionJsonInstance.setExtensionType(typeInstance3);
                                }
                                if ((typeHandlerVersionValue3 = propertiesValue3.get("typeHandlerVersion")) != null && !(typeHandlerVersionValue3 instanceof NullNode)) {
                                    String typeHandlerVersionInstance3 = typeHandlerVersionValue3.getTextValue();
                                    virtualMachineExtensionJsonInstance.setTypeHandlerVersion(typeHandlerVersionInstance3);
                                }
                                if ((autoUpgradeMinorVersionValue = propertiesValue3.get("autoUpgradeMinorVersion")) != null && !(autoUpgradeMinorVersionValue instanceof NullNode)) {
                                    boolean autoUpgradeMinorVersionInstance = autoUpgradeMinorVersionValue.getBooleanValue();
                                    virtualMachineExtensionJsonInstance.setAutoUpgradeMinorVersion(autoUpgradeMinorVersionInstance);
                                }
                                if ((settingsValue = propertiesValue3.get("settings")) != null && !(settingsValue instanceof NullNode)) {
                                    String settingsInstance = settingsValue.getTextValue();
                                    virtualMachineExtensionJsonInstance.setSettings(settingsInstance);
                                }
                                if ((protectedSettingsValue = propertiesValue3.get("protectedSettings")) != null && !(protectedSettingsValue instanceof NullNode)) {
                                    String protectedSettingsInstance = protectedSettingsValue.getTextValue();
                                    virtualMachineExtensionJsonInstance.setProtectedSettings(protectedSettingsInstance);
                                }
                                if ((provisioningStateValue2 = propertiesValue3.get("provisioningState")) != null && !(provisioningStateValue2 instanceof NullNode)) {
                                    String provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                    virtualMachineExtensionJsonInstance.setProvisioningState(provisioningStateInstance2);
                                }
                                if ((instanceViewValue2 = propertiesValue3.get("instanceView")) != null && !(instanceViewValue2 instanceof NullNode)) {
                                    JsonNode statusesArray5;
                                    JsonNode substatusesArray2;
                                    JsonNode typeHandlerVersionValue4;
                                    JsonNode typeValue4;
                                    VirtualMachineExtensionInstanceView instanceViewInstance2 = new VirtualMachineExtensionInstanceView();
                                    virtualMachineExtensionJsonInstance.setInstanceView(instanceViewInstance2);
                                    JsonNode nameValue6 = instanceViewValue2.get("name");
                                    if (nameValue6 != null && !(nameValue6 instanceof NullNode)) {
                                        String nameInstance6 = nameValue6.getTextValue();
                                        instanceViewInstance2.setName(nameInstance6);
                                    }
                                    if ((typeValue4 = instanceViewValue2.get("type")) != null && !(typeValue4 instanceof NullNode)) {
                                        String typeInstance4 = typeValue4.getTextValue();
                                        instanceViewInstance2.setExtensionType(typeInstance4);
                                    }
                                    if ((typeHandlerVersionValue4 = instanceViewValue2.get("typeHandlerVersion")) != null && !(typeHandlerVersionValue4 instanceof NullNode)) {
                                        String typeHandlerVersionInstance4 = typeHandlerVersionValue4.getTextValue();
                                        instanceViewInstance2.setTypeHandlerVersion(typeHandlerVersionInstance4);
                                    }
                                    if ((substatusesArray2 = instanceViewValue2.get("substatuses")) != null && !(substatusesArray2 instanceof NullNode)) {
                                        for (JsonNode substatusesValue2 : (ArrayNode)substatusesArray2) {
                                            JsonNode timeValue7;
                                            JsonNode messageValue7;
                                            JsonNode displayStatusValue7;
                                            JsonNode levelValue7;
                                            InstanceViewStatus instanceViewStatusInstance6 = new InstanceViewStatus();
                                            instanceViewInstance2.getSubStatuses().add(instanceViewStatusInstance6);
                                            JsonNode codeValue7 = substatusesValue2.get("code");
                                            if (codeValue7 != null && !(codeValue7 instanceof NullNode)) {
                                                String codeInstance7 = codeValue7.getTextValue();
                                                instanceViewStatusInstance6.setCode(codeInstance7);
                                            }
                                            if ((levelValue7 = substatusesValue2.get("level")) != null && !(levelValue7 instanceof NullNode)) {
                                                String levelInstance7 = levelValue7.getTextValue();
                                                instanceViewStatusInstance6.setLevel(levelInstance7);
                                            }
                                            if ((displayStatusValue7 = substatusesValue2.get("displayStatus")) != null && !(displayStatusValue7 instanceof NullNode)) {
                                                String displayStatusInstance7 = displayStatusValue7.getTextValue();
                                                instanceViewStatusInstance6.setDisplayStatus(displayStatusInstance7);
                                            }
                                            if ((messageValue7 = substatusesValue2.get("message")) != null && !(messageValue7 instanceof NullNode)) {
                                                String messageInstance7 = messageValue7.getTextValue();
                                                instanceViewStatusInstance6.setMessage(messageInstance7);
                                            }
                                            if ((timeValue7 = substatusesValue2.get("time")) == null || timeValue7 instanceof NullNode) continue;
                                            Calendar timeInstance7 = DatatypeConverter.parseDateTime((String)timeValue7.getTextValue());
                                            instanceViewStatusInstance6.setTime(timeInstance7);
                                        }
                                    }
                                    if ((statusesArray5 = instanceViewValue2.get("statuses")) != null && !(statusesArray5 instanceof NullNode)) {
                                        for (JsonNode statusesValue5 : (ArrayNode)statusesArray5) {
                                            JsonNode timeValue8;
                                            JsonNode messageValue8;
                                            JsonNode displayStatusValue8;
                                            JsonNode levelValue8;
                                            InstanceViewStatus instanceViewStatusInstance7 = new InstanceViewStatus();
                                            instanceViewInstance2.getStatuses().add(instanceViewStatusInstance7);
                                            JsonNode codeValue8 = statusesValue5.get("code");
                                            if (codeValue8 != null && !(codeValue8 instanceof NullNode)) {
                                                String codeInstance8 = codeValue8.getTextValue();
                                                instanceViewStatusInstance7.setCode(codeInstance8);
                                            }
                                            if ((levelValue8 = statusesValue5.get("level")) != null && !(levelValue8 instanceof NullNode)) {
                                                String levelInstance8 = levelValue8.getTextValue();
                                                instanceViewStatusInstance7.setLevel(levelInstance8);
                                            }
                                            if ((displayStatusValue8 = statusesValue5.get("displayStatus")) != null && !(displayStatusValue8 instanceof NullNode)) {
                                                String displayStatusInstance8 = displayStatusValue8.getTextValue();
                                                instanceViewStatusInstance7.setDisplayStatus(displayStatusInstance8);
                                            }
                                            if ((messageValue8 = statusesValue5.get("message")) != null && !(messageValue8 instanceof NullNode)) {
                                                String messageInstance8 = messageValue8.getTextValue();
                                                instanceViewStatusInstance7.setMessage(messageInstance8);
                                            }
                                            if ((timeValue8 = statusesValue5.get("time")) == null || timeValue8 instanceof NullNode) continue;
                                            Calendar timeInstance8 = DatatypeConverter.parseDateTime((String)timeValue8.getTextValue());
                                            instanceViewStatusInstance7.setTime(timeInstance8);
                                        }
                                    }
                                }
                            }
                            if ((idValue4 = resourcesValue.get("id")) != null && !(idValue4 instanceof NullNode)) {
                                String idInstance4 = idValue4.getTextValue();
                                virtualMachineExtensionJsonInstance.setId(idInstance4);
                            }
                            if ((nameValue7 = resourcesValue.get("name")) != null && !(nameValue7 instanceof NullNode)) {
                                String nameInstance7 = nameValue7.getTextValue();
                                virtualMachineExtensionJsonInstance.setName(nameInstance7);
                            }
                            if ((typeValue5 = resourcesValue.get("type")) != null && !(typeValue5 instanceof NullNode)) {
                                String typeInstance5 = typeValue5.getTextValue();
                                virtualMachineExtensionJsonInstance.setType(typeInstance5);
                            }
                            if ((locationValue = resourcesValue.get("location")) != null && !(locationValue instanceof NullNode)) {
                                String locationInstance = locationValue.getTextValue();
                                virtualMachineExtensionJsonInstance.setLocation(locationInstance);
                            }
                            if ((tagsSequenceElement = resourcesValue.get("tags")) == null || tagsSequenceElement instanceof NullNode) continue;
                            Iterator itr = tagsSequenceElement.getFields();
                            while (itr.hasNext()) {
                                Map.Entry property = (Map.Entry)itr.next();
                                String tagsKey = (String)property.getKey();
                                String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                                virtualMachineExtensionJsonInstance.getTags().put(tagsKey, tagsValue);
                            }
                        }
                    }
                    if ((idValue5 = responseDoc.get("id")) != null && !(idValue5 instanceof NullNode)) {
                        String idInstance5 = idValue5.getTextValue();
                        virtualMachineInstance.setId(idInstance5);
                    }
                    if ((nameValue8 = responseDoc.get("name")) != null && !(nameValue8 instanceof NullNode)) {
                        String nameInstance8 = nameValue8.getTextValue();
                        virtualMachineInstance.setName(nameInstance8);
                    }
                    if ((typeValue6 = responseDoc.get("type")) != null && !(typeValue6 instanceof NullNode)) {
                        String typeInstance6 = typeValue6.getTextValue();
                        virtualMachineInstance.setType(typeInstance6);
                    }
                    if ((locationValue2 = responseDoc.get("location")) != null && !(locationValue2 instanceof NullNode)) {
                        String locationInstance2 = locationValue2.getTextValue();
                        virtualMachineInstance.setLocation(locationInstance2);
                    }
                    if ((tagsSequenceElement2 = responseDoc.get("tags")) != null && !(tagsSequenceElement2 instanceof NullNode)) {
                        Iterator itr2 = tagsSequenceElement2.getFields();
                        while (itr2.hasNext()) {
                            Map.Entry property2 = (Map.Entry)itr2.next();
                            String tagsKey2 = (String)property2.getKey();
                            String tagsValue2 = ((JsonNode)property2.getValue()).getTextValue();
                            virtualMachineInstance.getTags().put(tagsKey2, tagsValue2);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            VirtualMachineGetResponse virtualMachineGetResponse = result;
            return virtualMachineGetResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<VirtualMachineGetResponse> getWithInstanceViewAsync(final String resourceGroupName, final String vmName) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineGetResponse>(){

            @Override
            public VirtualMachineGetResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.getWithInstanceView(resourceGroupName, vmName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualMachineGetResponse getWithInstanceView(String resourceGroupName, String vmName) throws IOException, ServiceException, URISyntaxException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (vmName == null) {
            throw new NullPointerException("vmName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("vmName", vmName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"getWithInstanceViewAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/";
        url = url + "virtualMachines";
        url = url + "/";
        url = url + URLEncoder.encode(vmName, "UTF-8");
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("$expand=instanceView");
        queryParameters.add("api-version=2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualMachineGetResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualMachineGetResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString((InputStream)responseContent);
                if (!(responseDocContent == null) && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode tagsSequenceElement2;
                    JsonNode locationValue2;
                    JsonNode typeValue6;
                    JsonNode nameValue8;
                    JsonNode idValue5;
                    JsonNode resourcesArray;
                    JsonNode propertiesValue;
                    VirtualMachine virtualMachineInstance = new VirtualMachine();
                    result.setVirtualMachine(virtualMachineInstance);
                    JsonNode planValue = responseDoc.get("plan");
                    if (planValue != null && !(planValue instanceof NullNode)) {
                        JsonNode promotionCodeValue;
                        JsonNode productValue;
                        JsonNode publisherValue;
                        Plan planInstance = new Plan();
                        virtualMachineInstance.setPlan(planInstance);
                        JsonNode nameValue = planValue.get("name");
                        if (nameValue != null && !(nameValue instanceof NullNode)) {
                            String nameInstance = nameValue.getTextValue();
                            planInstance.setName(nameInstance);
                        }
                        if ((publisherValue = planValue.get("publisher")) != null && !(publisherValue instanceof NullNode)) {
                            String publisherInstance = publisherValue.getTextValue();
                            planInstance.setPublisher(publisherInstance);
                        }
                        if ((productValue = planValue.get("product")) != null && !(productValue instanceof NullNode)) {
                            String productInstance = productValue.getTextValue();
                            planInstance.setProduct(productInstance);
                        }
                        if ((promotionCodeValue = planValue.get("promotionCode")) != null && !(promotionCodeValue instanceof NullNode)) {
                            String promotionCodeInstance = promotionCodeValue.getTextValue();
                            planInstance.setPromotionCode(promotionCodeInstance);
                        }
                    }
                    if ((propertiesValue = responseDoc.get("properties")) != null && !(propertiesValue instanceof NullNode)) {
                        JsonNode instanceViewValue;
                        JsonNode provisioningStateValue;
                        JsonNode availabilitySetValue;
                        JsonNode diagnosticsProfileValue;
                        JsonNode networkProfileValue;
                        JsonNode osProfileValue;
                        Object storageProfileValue;
                        JsonNode hardwareProfileValue = propertiesValue.get("hardwareProfile");
                        if (hardwareProfileValue != null && !(hardwareProfileValue instanceof NullNode)) {
                            HardwareProfile hardwareProfileInstance = new HardwareProfile();
                            virtualMachineInstance.setHardwareProfile(hardwareProfileInstance);
                            JsonNode vmSizeValue = hardwareProfileValue.get("vmSize");
                            if (vmSizeValue != null && !(vmSizeValue instanceof NullNode)) {
                                String vmSizeInstance = vmSizeValue.getTextValue();
                                hardwareProfileInstance.setVirtualMachineSize(vmSizeInstance);
                            }
                        }
                        if ((storageProfileValue = propertiesValue.get("storageProfile")) != null && !(storageProfileValue instanceof NullNode)) {
                            JsonNode dataDisksArray;
                            JsonNode osDiskValue;
                            StorageProfile storageProfileInstance = new StorageProfile();
                            virtualMachineInstance.setStorageProfile(storageProfileInstance);
                            JsonNode imageReferenceValue = storageProfileValue.get("imageReference");
                            if (imageReferenceValue != null && !(imageReferenceValue instanceof NullNode)) {
                                JsonNode versionValue;
                                JsonNode skuValue;
                                JsonNode offerValue;
                                ImageReference imageReferenceInstance = new ImageReference();
                                storageProfileInstance.setImageReference(imageReferenceInstance);
                                JsonNode publisherValue2 = imageReferenceValue.get("publisher");
                                if (publisherValue2 != null && !(publisherValue2 instanceof NullNode)) {
                                    String publisherInstance2 = publisherValue2.getTextValue();
                                    imageReferenceInstance.setPublisher(publisherInstance2);
                                }
                                if ((offerValue = imageReferenceValue.get("offer")) != null && !(offerValue instanceof NullNode)) {
                                    String offerInstance = offerValue.getTextValue();
                                    imageReferenceInstance.setOffer(offerInstance);
                                }
                                if ((skuValue = imageReferenceValue.get("sku")) != null && !(skuValue instanceof NullNode)) {
                                    String skuInstance = skuValue.getTextValue();
                                    imageReferenceInstance.setSku(skuInstance);
                                }
                                if ((versionValue = imageReferenceValue.get("version")) != null && !(versionValue instanceof NullNode)) {
                                    String versionInstance = versionValue.getTextValue();
                                    imageReferenceInstance.setVersion(versionInstance);
                                }
                            }
                            if ((osDiskValue = storageProfileValue.get("osDisk")) != null && !(osDiskValue instanceof NullNode)) {
                                JsonNode diskSizeGBValue;
                                JsonNode createOptionValue;
                                JsonNode cachingValue;
                                JsonNode imageValue;
                                JsonNode vhdValue;
                                JsonNode nameValue2;
                                OSDisk osDiskInstance = new OSDisk();
                                storageProfileInstance.setOSDisk(osDiskInstance);
                                Iterator osTypeValue = osDiskValue.get("osType");
                                if (osTypeValue != null && !(osTypeValue instanceof NullNode)) {
                                    String osTypeInstance = osTypeValue.getTextValue();
                                    osDiskInstance.setOperatingSystemType(osTypeInstance);
                                }
                                if ((nameValue2 = osDiskValue.get("name")) != null && !(nameValue2 instanceof NullNode)) {
                                    String nameInstance2 = nameValue2.getTextValue();
                                    osDiskInstance.setName(nameInstance2);
                                }
                                if ((vhdValue = osDiskValue.get("vhd")) != null && !(vhdValue instanceof NullNode)) {
                                    VirtualHardDisk vhdInstance = new VirtualHardDisk();
                                    osDiskInstance.setVirtualHardDisk(vhdInstance);
                                    JsonNode uriValue = vhdValue.get("uri");
                                    if (uriValue != null && !(uriValue instanceof NullNode)) {
                                        String uriInstance = uriValue.getTextValue();
                                        vhdInstance.setUri(uriInstance);
                                    }
                                }
                                if ((imageValue = osDiskValue.get("image")) != null && !(imageValue instanceof NullNode)) {
                                    VirtualHardDisk imageInstance = new VirtualHardDisk();
                                    osDiskInstance.setSourceImage(imageInstance);
                                    JsonNode uriValue2 = imageValue.get("uri");
                                    if (uriValue2 != null && !(uriValue2 instanceof NullNode)) {
                                        String uriInstance2 = uriValue2.getTextValue();
                                        imageInstance.setUri(uriInstance2);
                                    }
                                }
                                if ((cachingValue = osDiskValue.get("caching")) != null && !(cachingValue instanceof NullNode)) {
                                    String cachingInstance = cachingValue.getTextValue();
                                    osDiskInstance.setCaching(cachingInstance);
                                }
                                if ((createOptionValue = osDiskValue.get("createOption")) != null && !(createOptionValue instanceof NullNode)) {
                                    String createOptionInstance = createOptionValue.getTextValue();
                                    osDiskInstance.setCreateOption(createOptionInstance);
                                }
                                if ((diskSizeGBValue = osDiskValue.get("diskSizeGB")) != null && !(diskSizeGBValue instanceof NullNode)) {
                                    int diskSizeGBInstance = diskSizeGBValue.getIntValue();
                                    osDiskInstance.setDiskSizeGB(diskSizeGBInstance);
                                }
                            }
                            if ((dataDisksArray = storageProfileValue.get("dataDisks")) != null && !(dataDisksArray instanceof NullNode)) {
                                for (JsonNode dataDisksValue : (ArrayNode)dataDisksArray) {
                                    JsonNode diskSizeGBValue2;
                                    Object createOptionValue2;
                                    JsonNode cachingValue2;
                                    JsonNode imageValue2;
                                    JsonNode vhdValue2;
                                    JsonNode nameValue3;
                                    DataDisk dataDiskInstance = new DataDisk();
                                    storageProfileInstance.getDataDisks().add(dataDiskInstance);
                                    JsonNode lunValue = dataDisksValue.get("lun");
                                    if (lunValue != null && !(lunValue instanceof NullNode)) {
                                        int lunInstance = lunValue.getIntValue();
                                        dataDiskInstance.setLun(lunInstance);
                                    }
                                    if ((nameValue3 = dataDisksValue.get("name")) != null && !(nameValue3 instanceof NullNode)) {
                                        String nameInstance3 = nameValue3.getTextValue();
                                        dataDiskInstance.setName(nameInstance3);
                                    }
                                    if ((vhdValue2 = dataDisksValue.get("vhd")) != null && !(vhdValue2 instanceof NullNode)) {
                                        VirtualHardDisk vhdInstance2 = new VirtualHardDisk();
                                        dataDiskInstance.setVirtualHardDisk(vhdInstance2);
                                        JsonNode uriValue3 = vhdValue2.get("uri");
                                        if (uriValue3 != null && !(uriValue3 instanceof NullNode)) {
                                            String uriInstance3 = uriValue3.getTextValue();
                                            vhdInstance2.setUri(uriInstance3);
                                        }
                                    }
                                    if ((imageValue2 = dataDisksValue.get("image")) != null && !(imageValue2 instanceof NullNode)) {
                                        VirtualHardDisk imageInstance2 = new VirtualHardDisk();
                                        dataDiskInstance.setSourceImage(imageInstance2);
                                        JsonNode uriValue4 = imageValue2.get("uri");
                                        if (uriValue4 != null && !(uriValue4 instanceof NullNode)) {
                                            String uriInstance4 = uriValue4.getTextValue();
                                            imageInstance2.setUri(uriInstance4);
                                        }
                                    }
                                    if ((cachingValue2 = dataDisksValue.get("caching")) != null && !(cachingValue2 instanceof NullNode)) {
                                        String cachingInstance2 = cachingValue2.getTextValue();
                                        dataDiskInstance.setCaching(cachingInstance2);
                                    }
                                    if ((createOptionValue2 = dataDisksValue.get("createOption")) != null && !(createOptionValue2 instanceof NullNode)) {
                                        String createOptionInstance2 = createOptionValue2.getTextValue();
                                        dataDiskInstance.setCreateOption(createOptionInstance2);
                                    }
                                    if ((diskSizeGBValue2 = dataDisksValue.get("diskSizeGB")) == null || diskSizeGBValue2 instanceof NullNode) continue;
                                    int diskSizeGBInstance2 = diskSizeGBValue2.getIntValue();
                                    dataDiskInstance.setDiskSizeGB(diskSizeGBInstance2);
                                }
                            }
                        }
                        if ((osProfileValue = propertiesValue.get("osProfile")) != null && !(osProfileValue instanceof NullNode)) {
                            JsonNode secretsArray;
                            JsonNode linuxConfigurationValue;
                            JsonNode windowsConfigurationValue;
                            JsonNode customDataValue;
                            Object adminPasswordValue;
                            JsonNode adminUsernameValue;
                            OSProfile osProfileInstance = new OSProfile();
                            virtualMachineInstance.setOSProfile(osProfileInstance);
                            JsonNode computerNameValue = osProfileValue.get("computerName");
                            if (computerNameValue != null && !(computerNameValue instanceof NullNode)) {
                                String computerNameInstance = computerNameValue.getTextValue();
                                osProfileInstance.setComputerName(computerNameInstance);
                            }
                            if ((adminUsernameValue = osProfileValue.get("adminUsername")) != null && !(adminUsernameValue instanceof NullNode)) {
                                String adminUsernameInstance = adminUsernameValue.getTextValue();
                                osProfileInstance.setAdminUsername(adminUsernameInstance);
                            }
                            if ((adminPasswordValue = osProfileValue.get("adminPassword")) != null && !(adminPasswordValue instanceof NullNode)) {
                                String adminPasswordInstance = adminPasswordValue.getTextValue();
                                osProfileInstance.setAdminPassword(adminPasswordInstance);
                            }
                            if ((customDataValue = osProfileValue.get("customData")) != null && !(customDataValue instanceof NullNode)) {
                                String customDataInstance = customDataValue.getTextValue();
                                osProfileInstance.setCustomData(customDataInstance);
                            }
                            if ((windowsConfigurationValue = osProfileValue.get("windowsConfiguration")) != null && !(windowsConfigurationValue instanceof NullNode)) {
                                JsonNode winRMValue;
                                JsonNode additionalUnattendContentArray;
                                JsonNode timeZoneValue;
                                JsonNode enableAutomaticUpdatesValue;
                                WindowsConfiguration windowsConfigurationInstance = new WindowsConfiguration();
                                osProfileInstance.setWindowsConfiguration(windowsConfigurationInstance);
                                JsonNode provisionVMAgentValue = windowsConfigurationValue.get("provisionVMAgent");
                                if (provisionVMAgentValue != null && !(provisionVMAgentValue instanceof NullNode)) {
                                    boolean provisionVMAgentInstance = provisionVMAgentValue.getBooleanValue();
                                    windowsConfigurationInstance.setProvisionVMAgent(provisionVMAgentInstance);
                                }
                                if ((enableAutomaticUpdatesValue = windowsConfigurationValue.get("enableAutomaticUpdates")) != null && !(enableAutomaticUpdatesValue instanceof NullNode)) {
                                    boolean enableAutomaticUpdatesInstance = enableAutomaticUpdatesValue.getBooleanValue();
                                    windowsConfigurationInstance.setEnableAutomaticUpdates(enableAutomaticUpdatesInstance);
                                }
                                if ((timeZoneValue = windowsConfigurationValue.get("timeZone")) != null && !(timeZoneValue instanceof NullNode)) {
                                    String timeZoneInstance = timeZoneValue.getTextValue();
                                    windowsConfigurationInstance.setTimeZone(timeZoneInstance);
                                }
                                if ((additionalUnattendContentArray = windowsConfigurationValue.get("additionalUnattendContent")) != null && !(additionalUnattendContentArray instanceof NullNode)) {
                                    for (JsonNode additionalUnattendContentValue : (ArrayNode)additionalUnattendContentArray) {
                                        JsonNode contentValue;
                                        JsonNode settingNameValue;
                                        JsonNode componentNameValue;
                                        AdditionalUnattendContent additionalUnattendContentInstance = new AdditionalUnattendContent();
                                        windowsConfigurationInstance.getAdditionalUnattendContents().add(additionalUnattendContentInstance);
                                        JsonNode passNameValue = additionalUnattendContentValue.get("passName");
                                        if (passNameValue != null && !(passNameValue instanceof NullNode)) {
                                            String passNameInstance = passNameValue.getTextValue();
                                            additionalUnattendContentInstance.setPassName(passNameInstance);
                                        }
                                        if ((componentNameValue = additionalUnattendContentValue.get("componentName")) != null && !(componentNameValue instanceof NullNode)) {
                                            String componentNameInstance = componentNameValue.getTextValue();
                                            additionalUnattendContentInstance.setComponentName(componentNameInstance);
                                        }
                                        if ((settingNameValue = additionalUnattendContentValue.get("settingName")) != null && !(settingNameValue instanceof NullNode)) {
                                            String settingNameInstance = settingNameValue.getTextValue();
                                            additionalUnattendContentInstance.setSettingName(settingNameInstance);
                                        }
                                        if ((contentValue = additionalUnattendContentValue.get("content")) == null || contentValue instanceof NullNode) continue;
                                        String contentInstance = contentValue.getTextValue();
                                        additionalUnattendContentInstance.setContent(contentInstance);
                                    }
                                }
                                if ((winRMValue = windowsConfigurationValue.get("winRM")) != null && !(winRMValue instanceof NullNode)) {
                                    WinRMConfiguration winRMInstance = new WinRMConfiguration();
                                    windowsConfigurationInstance.setWinRMConfiguration(winRMInstance);
                                    JsonNode listenersArray = winRMValue.get("listeners");
                                    if (listenersArray != null && !(listenersArray instanceof NullNode)) {
                                        for (JsonNode listenersValue : (ArrayNode)listenersArray) {
                                            JsonNode certificateUrlValue;
                                            WinRMListener winRMListenerInstance = new WinRMListener();
                                            winRMInstance.getListeners().add(winRMListenerInstance);
                                            JsonNode protocolValue = listenersValue.get("protocol");
                                            if (protocolValue != null && !(protocolValue instanceof NullNode)) {
                                                String protocolInstance = protocolValue.getTextValue();
                                                winRMListenerInstance.setProtocol(protocolInstance);
                                            }
                                            if ((certificateUrlValue = listenersValue.get("certificateUrl")) == null || certificateUrlValue instanceof NullNode) continue;
                                            URI certificateUrlInstance = new URI(certificateUrlValue.getTextValue());
                                            winRMListenerInstance.setCertificateUrl(certificateUrlInstance);
                                        }
                                    }
                                }
                            }
                            if ((linuxConfigurationValue = osProfileValue.get("linuxConfiguration")) != null && !(linuxConfigurationValue instanceof NullNode)) {
                                JsonNode sshValue;
                                LinuxConfiguration linuxConfigurationInstance = new LinuxConfiguration();
                                osProfileInstance.setLinuxConfiguration(linuxConfigurationInstance);
                                Iterator disablePasswordAuthenticationValue = linuxConfigurationValue.get("disablePasswordAuthentication");
                                if (disablePasswordAuthenticationValue != null && !(disablePasswordAuthenticationValue instanceof NullNode)) {
                                    boolean disablePasswordAuthenticationInstance = disablePasswordAuthenticationValue.getBooleanValue();
                                    linuxConfigurationInstance.setDisablePasswordAuthentication(disablePasswordAuthenticationInstance);
                                }
                                if ((sshValue = linuxConfigurationValue.get("ssh")) != null && !(sshValue instanceof NullNode)) {
                                    SshConfiguration sshInstance = new SshConfiguration();
                                    linuxConfigurationInstance.setSshConfiguration(sshInstance);
                                    JsonNode publicKeysArray = sshValue.get("publicKeys");
                                    if (publicKeysArray != null && !(publicKeysArray instanceof NullNode)) {
                                        for (JsonNode publicKeysValue : (ArrayNode)publicKeysArray) {
                                            JsonNode keyDataValue;
                                            SshPublicKey sshPublicKeyInstance = new SshPublicKey();
                                            sshInstance.getPublicKeys().add(sshPublicKeyInstance);
                                            JsonNode pathValue = publicKeysValue.get("path");
                                            if (pathValue != null && !(pathValue instanceof NullNode)) {
                                                String pathInstance = pathValue.getTextValue();
                                                sshPublicKeyInstance.setPath(pathInstance);
                                            }
                                            if ((keyDataValue = publicKeysValue.get("keyData")) == null || keyDataValue instanceof NullNode) continue;
                                            String keyDataInstance = keyDataValue.getTextValue();
                                            sshPublicKeyInstance.setKeyData(keyDataInstance);
                                        }
                                    }
                                }
                            }
                            if ((secretsArray = osProfileValue.get("secrets")) != null && !(secretsArray instanceof NullNode)) {
                                for (JsonNode secretsValue : (ArrayNode)secretsArray) {
                                    JsonNode vaultCertificatesArray;
                                    VaultSecretGroup vaultSecretGroupInstance = new VaultSecretGroup();
                                    osProfileInstance.getSecrets().add(vaultSecretGroupInstance);
                                    JsonNode sourceVaultValue = secretsValue.get("sourceVault");
                                    if (sourceVaultValue != null && !(sourceVaultValue instanceof NullNode)) {
                                        SourceVaultReference sourceVaultInstance = new SourceVaultReference();
                                        vaultSecretGroupInstance.setSourceVault(sourceVaultInstance);
                                        Iterator idValue = sourceVaultValue.get("id");
                                        if (idValue != null && !(idValue instanceof NullNode)) {
                                            String idInstance = idValue.getTextValue();
                                            sourceVaultInstance.setReferenceUri(idInstance);
                                        }
                                    }
                                    if ((vaultCertificatesArray = secretsValue.get("vaultCertificates")) == null || vaultCertificatesArray instanceof NullNode) continue;
                                    for (JsonNode vaultCertificatesValue : (ArrayNode)vaultCertificatesArray) {
                                        JsonNode certificateStoreValue;
                                        VaultCertificate vaultCertificateInstance = new VaultCertificate();
                                        vaultSecretGroupInstance.getVaultCertificates().add(vaultCertificateInstance);
                                        JsonNode certificateUrlValue2 = vaultCertificatesValue.get("certificateUrl");
                                        if (certificateUrlValue2 != null && !(certificateUrlValue2 instanceof NullNode)) {
                                            String certificateUrlInstance2 = certificateUrlValue2.getTextValue();
                                            vaultCertificateInstance.setCertificateUrl(certificateUrlInstance2);
                                        }
                                        if ((certificateStoreValue = vaultCertificatesValue.get("certificateStore")) == null || certificateStoreValue instanceof NullNode) continue;
                                        String certificateStoreInstance = certificateStoreValue.getTextValue();
                                        vaultCertificateInstance.setCertificateStore(certificateStoreInstance);
                                    }
                                }
                            }
                        }
                        if ((networkProfileValue = propertiesValue.get("networkProfile")) != null && !(networkProfileValue instanceof NullNode)) {
                            NetworkProfile networkProfileInstance = new NetworkProfile();
                            virtualMachineInstance.setNetworkProfile(networkProfileInstance);
                            JsonNode networkInterfacesArray = networkProfileValue.get("networkInterfaces");
                            if (networkInterfacesArray != null && !(networkInterfacesArray instanceof NullNode)) {
                                for (JsonNode networkInterfacesValue : (ArrayNode)networkInterfacesArray) {
                                    JsonNode idValue2;
                                    JsonNode primaryValue;
                                    NetworkInterfaceReference networkInterfaceReferenceJsonInstance = new NetworkInterfaceReference();
                                    networkProfileInstance.getNetworkInterfaces().add(networkInterfaceReferenceJsonInstance);
                                    JsonNode propertiesValue2 = networkInterfacesValue.get("properties");
                                    if (propertiesValue2 != null && !(propertiesValue2 instanceof NullNode) && (primaryValue = propertiesValue2.get("primary")) != null && !(primaryValue instanceof NullNode)) {
                                        boolean primaryInstance = primaryValue.getBooleanValue();
                                        networkInterfaceReferenceJsonInstance.setPrimary(primaryInstance);
                                    }
                                    if ((idValue2 = networkInterfacesValue.get("id")) == null || idValue2 instanceof NullNode) continue;
                                    String idInstance2 = idValue2.getTextValue();
                                    networkInterfaceReferenceJsonInstance.setReferenceUri(idInstance2);
                                }
                            }
                        }
                        if ((diagnosticsProfileValue = propertiesValue.get("diagnosticsProfile")) != null && !(diagnosticsProfileValue instanceof NullNode)) {
                            DiagnosticsProfile diagnosticsProfileInstance = new DiagnosticsProfile();
                            virtualMachineInstance.setDiagnosticsProfile(diagnosticsProfileInstance);
                            JsonNode bootDiagnosticsValue = diagnosticsProfileValue.get("bootDiagnostics");
                            if (bootDiagnosticsValue != null && !(bootDiagnosticsValue instanceof NullNode)) {
                                JsonNode storageUriValue;
                                BootDiagnostics bootDiagnosticsInstance = new BootDiagnostics();
                                diagnosticsProfileInstance.setBootDiagnostics(bootDiagnosticsInstance);
                                JsonNode enabledValue = bootDiagnosticsValue.get("enabled");
                                if (enabledValue != null && !(enabledValue instanceof NullNode)) {
                                    boolean enabledInstance = enabledValue.getBooleanValue();
                                    bootDiagnosticsInstance.setEnabled(enabledInstance);
                                }
                                if ((storageUriValue = bootDiagnosticsValue.get("storageUri")) != null && !(storageUriValue instanceof NullNode)) {
                                    URI storageUriInstance = new URI(storageUriValue.getTextValue());
                                    bootDiagnosticsInstance.setStorageUri(storageUriInstance);
                                }
                            }
                        }
                        if ((availabilitySetValue = propertiesValue.get("availabilitySet")) != null && !(availabilitySetValue instanceof NullNode)) {
                            AvailabilitySetReference availabilitySetInstance = new AvailabilitySetReference();
                            virtualMachineInstance.setAvailabilitySetReference(availabilitySetInstance);
                            JsonNode idValue3 = availabilitySetValue.get("id");
                            if (idValue3 != null && !(idValue3 instanceof NullNode)) {
                                String idInstance3 = idValue3.getTextValue();
                                availabilitySetInstance.setReferenceUri(idInstance3);
                            }
                        }
                        if ((provisioningStateValue = propertiesValue.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                            String provisioningStateInstance = provisioningStateValue.getTextValue();
                            virtualMachineInstance.setProvisioningState(provisioningStateInstance);
                        }
                        if ((instanceViewValue = propertiesValue.get("instanceView")) != null && !(instanceViewValue instanceof NullNode)) {
                            JsonNode statusesArray4;
                            JsonNode bootDiagnosticsValue2;
                            JsonNode extensionsArray;
                            JsonNode disksArray;
                            JsonNode vmAgentValue;
                            JsonNode rdpThumbPrintValue;
                            JsonNode platformFaultDomainValue;
                            VirtualMachineInstanceView instanceViewInstance = new VirtualMachineInstanceView();
                            virtualMachineInstance.setInstanceView(instanceViewInstance);
                            JsonNode platformUpdateDomainValue = instanceViewValue.get("platformUpdateDomain");
                            if (platformUpdateDomainValue != null && !(platformUpdateDomainValue instanceof NullNode)) {
                                int platformUpdateDomainInstance = platformUpdateDomainValue.getIntValue();
                                instanceViewInstance.setPlatformUpdateDomain(platformUpdateDomainInstance);
                            }
                            if ((platformFaultDomainValue = instanceViewValue.get("platformFaultDomain")) != null && !(platformFaultDomainValue instanceof NullNode)) {
                                int platformFaultDomainInstance = platformFaultDomainValue.getIntValue();
                                instanceViewInstance.setPlatformFaultDomain(platformFaultDomainInstance);
                            }
                            if ((rdpThumbPrintValue = instanceViewValue.get("rdpThumbPrint")) != null && !(rdpThumbPrintValue instanceof NullNode)) {
                                String rdpThumbPrintInstance = rdpThumbPrintValue.getTextValue();
                                instanceViewInstance.setRemoteDesktopThumbprint(rdpThumbPrintInstance);
                            }
                            if ((vmAgentValue = instanceViewValue.get("vmAgent")) != null && !(vmAgentValue instanceof NullNode)) {
                                JsonNode statusesArray;
                                JsonNode extensionHandlersArray;
                                VirtualMachineAgentInstanceView vmAgentInstance = new VirtualMachineAgentInstanceView();
                                instanceViewInstance.setVMAgent(vmAgentInstance);
                                Iterator vmAgentVersionValue = vmAgentValue.get("vmAgentVersion");
                                if (vmAgentVersionValue != null && !(vmAgentVersionValue instanceof NullNode)) {
                                    String vmAgentVersionInstance = vmAgentVersionValue.getTextValue();
                                    vmAgentInstance.setVMAgentVersion(vmAgentVersionInstance);
                                }
                                if ((extensionHandlersArray = vmAgentValue.get("extensionHandlers")) != null && !(extensionHandlersArray instanceof NullNode)) {
                                    for (Iterator extensionHandlersValue : (ArrayNode)extensionHandlersArray) {
                                        JsonNode timeValue;
                                        JsonNode messageValue;
                                        JsonNode displayStatusValue;
                                        JsonNode levelValue;
                                        JsonNode statusValue;
                                        JsonNode typeHandlerVersionValue;
                                        VirtualMachineExtensionHandlerInstanceView virtualMachineExtensionHandlerInstanceViewInstance = new VirtualMachineExtensionHandlerInstanceView();
                                        vmAgentInstance.getExtensionHandlers().add(virtualMachineExtensionHandlerInstanceViewInstance);
                                        JsonNode typeValue = extensionHandlersValue.get("type");
                                        if (typeValue != null && !(typeValue instanceof NullNode)) {
                                            String typeInstance = typeValue.getTextValue();
                                            virtualMachineExtensionHandlerInstanceViewInstance.setType(typeInstance);
                                        }
                                        if ((typeHandlerVersionValue = extensionHandlersValue.get("typeHandlerVersion")) != null && !(typeHandlerVersionValue instanceof NullNode)) {
                                            String typeHandlerVersionInstance = typeHandlerVersionValue.getTextValue();
                                            virtualMachineExtensionHandlerInstanceViewInstance.setTypeHandlerVersion(typeHandlerVersionInstance);
                                        }
                                        if ((statusValue = extensionHandlersValue.get("status")) == null || statusValue instanceof NullNode) continue;
                                        InstanceViewStatus statusInstance = new InstanceViewStatus();
                                        virtualMachineExtensionHandlerInstanceViewInstance.setStatus(statusInstance);
                                        JsonNode codeValue = statusValue.get("code");
                                        if (codeValue != null && !(codeValue instanceof NullNode)) {
                                            String codeInstance = codeValue.getTextValue();
                                            statusInstance.setCode(codeInstance);
                                        }
                                        if ((levelValue = statusValue.get("level")) != null && !(levelValue instanceof NullNode)) {
                                            String levelInstance = levelValue.getTextValue();
                                            statusInstance.setLevel(levelInstance);
                                        }
                                        if ((displayStatusValue = statusValue.get("displayStatus")) != null && !(displayStatusValue instanceof NullNode)) {
                                            String displayStatusInstance = displayStatusValue.getTextValue();
                                            statusInstance.setDisplayStatus(displayStatusInstance);
                                        }
                                        if ((messageValue = statusValue.get("message")) != null && !(messageValue instanceof NullNode)) {
                                            String messageInstance = messageValue.getTextValue();
                                            statusInstance.setMessage(messageInstance);
                                        }
                                        if ((timeValue = statusValue.get("time")) == null || timeValue instanceof NullNode) continue;
                                        Calendar timeInstance = DatatypeConverter.parseDateTime((String)timeValue.getTextValue());
                                        statusInstance.setTime(timeInstance);
                                    }
                                }
                                if ((statusesArray = vmAgentValue.get("statuses")) != null && !(statusesArray instanceof NullNode)) {
                                    for (JsonNode statusesValue : (ArrayNode)statusesArray) {
                                        JsonNode timeValue2;
                                        JsonNode messageValue2;
                                        JsonNode displayStatusValue2;
                                        JsonNode levelValue2;
                                        InstanceViewStatus instanceViewStatusInstance = new InstanceViewStatus();
                                        vmAgentInstance.getStatuses().add(instanceViewStatusInstance);
                                        JsonNode codeValue2 = statusesValue.get("code");
                                        if (codeValue2 != null && !(codeValue2 instanceof NullNode)) {
                                            String codeInstance2 = codeValue2.getTextValue();
                                            instanceViewStatusInstance.setCode(codeInstance2);
                                        }
                                        if ((levelValue2 = statusesValue.get("level")) != null && !(levelValue2 instanceof NullNode)) {
                                            String levelInstance2 = levelValue2.getTextValue();
                                            instanceViewStatusInstance.setLevel(levelInstance2);
                                        }
                                        if ((displayStatusValue2 = statusesValue.get("displayStatus")) != null && !(displayStatusValue2 instanceof NullNode)) {
                                            String displayStatusInstance2 = displayStatusValue2.getTextValue();
                                            instanceViewStatusInstance.setDisplayStatus(displayStatusInstance2);
                                        }
                                        if ((messageValue2 = statusesValue.get("message")) != null && !(messageValue2 instanceof NullNode)) {
                                            String messageInstance2 = messageValue2.getTextValue();
                                            instanceViewStatusInstance.setMessage(messageInstance2);
                                        }
                                        if ((timeValue2 = statusesValue.get("time")) == null || timeValue2 instanceof NullNode) continue;
                                        Calendar timeInstance2 = DatatypeConverter.parseDateTime((String)timeValue2.getTextValue());
                                        instanceViewStatusInstance.setTime(timeInstance2);
                                    }
                                }
                            }
                            if ((disksArray = instanceViewValue.get("disks")) != null && !(disksArray instanceof NullNode)) {
                                for (Iterator disksValue : (ArrayNode)disksArray) {
                                    JsonNode statusesArray2;
                                    DiskInstanceView diskInstanceViewInstance = new DiskInstanceView();
                                    instanceViewInstance.getDisks().add(diskInstanceViewInstance);
                                    JsonNode nameValue4 = disksValue.get("name");
                                    if (nameValue4 != null && !(nameValue4 instanceof NullNode)) {
                                        String nameInstance4 = nameValue4.getTextValue();
                                        diskInstanceViewInstance.setName(nameInstance4);
                                    }
                                    if ((statusesArray2 = disksValue.get("statuses")) == null || statusesArray2 instanceof NullNode) continue;
                                    for (JsonNode statusesValue2 : (ArrayNode)statusesArray2) {
                                        JsonNode timeValue3;
                                        JsonNode messageValue3;
                                        JsonNode displayStatusValue3;
                                        JsonNode levelValue3;
                                        InstanceViewStatus instanceViewStatusInstance2 = new InstanceViewStatus();
                                        diskInstanceViewInstance.getStatuses().add(instanceViewStatusInstance2);
                                        Iterator codeValue3 = statusesValue2.get("code");
                                        if (codeValue3 != null && !(codeValue3 instanceof NullNode)) {
                                            String codeInstance3 = codeValue3.getTextValue();
                                            instanceViewStatusInstance2.setCode(codeInstance3);
                                        }
                                        if ((levelValue3 = statusesValue2.get("level")) != null && !(levelValue3 instanceof NullNode)) {
                                            String levelInstance3 = levelValue3.getTextValue();
                                            instanceViewStatusInstance2.setLevel(levelInstance3);
                                        }
                                        if ((displayStatusValue3 = statusesValue2.get("displayStatus")) != null && !(displayStatusValue3 instanceof NullNode)) {
                                            String displayStatusInstance3 = displayStatusValue3.getTextValue();
                                            instanceViewStatusInstance2.setDisplayStatus(displayStatusInstance3);
                                        }
                                        if ((messageValue3 = statusesValue2.get("message")) != null && !(messageValue3 instanceof NullNode)) {
                                            String messageInstance3 = messageValue3.getTextValue();
                                            instanceViewStatusInstance2.setMessage(messageInstance3);
                                        }
                                        if ((timeValue3 = statusesValue2.get("time")) == null || timeValue3 instanceof NullNode) continue;
                                        Calendar timeInstance3 = DatatypeConverter.parseDateTime((String)timeValue3.getTextValue());
                                        instanceViewStatusInstance2.setTime(timeInstance3);
                                    }
                                }
                            }
                            if ((extensionsArray = instanceViewValue.get("extensions")) != null && !(extensionsArray instanceof NullNode)) {
                                for (JsonNode extensionsValue : (ArrayNode)extensionsArray) {
                                    JsonNode statusesArray3;
                                    Iterator substatusesValue2;
                                    JsonNode substatusesArray;
                                    JsonNode typeHandlerVersionValue2;
                                    JsonNode typeValue2;
                                    VirtualMachineExtensionInstanceView virtualMachineExtensionInstanceViewInstance = new VirtualMachineExtensionInstanceView();
                                    instanceViewInstance.getExtensions().add(virtualMachineExtensionInstanceViewInstance);
                                    JsonNode nameValue5 = extensionsValue.get("name");
                                    if (nameValue5 != null && !(nameValue5 instanceof NullNode)) {
                                        String nameInstance5 = nameValue5.getTextValue();
                                        virtualMachineExtensionInstanceViewInstance.setName(nameInstance5);
                                    }
                                    if ((typeValue2 = extensionsValue.get("type")) != null && !(typeValue2 instanceof NullNode)) {
                                        String typeInstance2 = typeValue2.getTextValue();
                                        virtualMachineExtensionInstanceViewInstance.setExtensionType(typeInstance2);
                                    }
                                    if ((typeHandlerVersionValue2 = extensionsValue.get("typeHandlerVersion")) != null && !(typeHandlerVersionValue2 instanceof NullNode)) {
                                        String typeHandlerVersionInstance2 = typeHandlerVersionValue2.getTextValue();
                                        virtualMachineExtensionInstanceViewInstance.setTypeHandlerVersion(typeHandlerVersionInstance2);
                                    }
                                    if ((substatusesArray = extensionsValue.get("substatuses")) != null && !(substatusesArray instanceof NullNode)) {
                                        for (Iterator substatusesValue2 : (ArrayNode)substatusesArray) {
                                            JsonNode timeValue4;
                                            JsonNode messageValue4;
                                            JsonNode displayStatusValue4;
                                            JsonNode levelValue4;
                                            InstanceViewStatus instanceViewStatusInstance3 = new InstanceViewStatus();
                                            virtualMachineExtensionInstanceViewInstance.getSubStatuses().add(instanceViewStatusInstance3);
                                            JsonNode codeValue4 = substatusesValue2.get("code");
                                            if (codeValue4 != null && !(codeValue4 instanceof NullNode)) {
                                                String codeInstance4 = codeValue4.getTextValue();
                                                instanceViewStatusInstance3.setCode(codeInstance4);
                                            }
                                            if ((levelValue4 = substatusesValue2.get("level")) != null && !(levelValue4 instanceof NullNode)) {
                                                String levelInstance4 = levelValue4.getTextValue();
                                                instanceViewStatusInstance3.setLevel(levelInstance4);
                                            }
                                            if ((displayStatusValue4 = substatusesValue2.get("displayStatus")) != null && !(displayStatusValue4 instanceof NullNode)) {
                                                String displayStatusInstance4 = displayStatusValue4.getTextValue();
                                                instanceViewStatusInstance3.setDisplayStatus(displayStatusInstance4);
                                            }
                                            if ((messageValue4 = substatusesValue2.get("message")) != null && !(messageValue4 instanceof NullNode)) {
                                                String messageInstance4 = messageValue4.getTextValue();
                                                instanceViewStatusInstance3.setMessage(messageInstance4);
                                            }
                                            if ((timeValue4 = substatusesValue2.get("time")) == null || timeValue4 instanceof NullNode) continue;
                                            Calendar timeInstance4 = DatatypeConverter.parseDateTime((String)timeValue4.getTextValue());
                                            instanceViewStatusInstance3.setTime(timeInstance4);
                                        }
                                    }
                                    if ((statusesArray3 = extensionsValue.get("statuses")) == null || statusesArray3 instanceof NullNode) continue;
                                    substatusesValue2 = ((ArrayNode)statusesArray3).iterator();
                                    while (substatusesValue2.hasNext()) {
                                        JsonNode timeValue5;
                                        JsonNode messageValue5;
                                        JsonNode displayStatusValue5;
                                        JsonNode levelValue5;
                                        JsonNode statusesValue3 = (JsonNode)substatusesValue2.next();
                                        InstanceViewStatus instanceViewStatusInstance4 = new InstanceViewStatus();
                                        virtualMachineExtensionInstanceViewInstance.getStatuses().add(instanceViewStatusInstance4);
                                        JsonNode codeValue5 = statusesValue3.get("code");
                                        if (codeValue5 != null && !(codeValue5 instanceof NullNode)) {
                                            String codeInstance5 = codeValue5.getTextValue();
                                            instanceViewStatusInstance4.setCode(codeInstance5);
                                        }
                                        if ((levelValue5 = statusesValue3.get("level")) != null && !(levelValue5 instanceof NullNode)) {
                                            String levelInstance5 = levelValue5.getTextValue();
                                            instanceViewStatusInstance4.setLevel(levelInstance5);
                                        }
                                        if ((displayStatusValue5 = statusesValue3.get("displayStatus")) != null && !(displayStatusValue5 instanceof NullNode)) {
                                            String displayStatusInstance5 = displayStatusValue5.getTextValue();
                                            instanceViewStatusInstance4.setDisplayStatus(displayStatusInstance5);
                                        }
                                        if ((messageValue5 = statusesValue3.get("message")) != null && !(messageValue5 instanceof NullNode)) {
                                            String messageInstance5 = messageValue5.getTextValue();
                                            instanceViewStatusInstance4.setMessage(messageInstance5);
                                        }
                                        if ((timeValue5 = statusesValue3.get("time")) == null || timeValue5 instanceof NullNode) continue;
                                        Calendar timeInstance5 = DatatypeConverter.parseDateTime((String)timeValue5.getTextValue());
                                        instanceViewStatusInstance4.setTime(timeInstance5);
                                    }
                                }
                            }
                            if ((bootDiagnosticsValue2 = instanceViewValue.get("bootDiagnostics")) != null && !(bootDiagnosticsValue2 instanceof NullNode)) {
                                JsonNode serialConsoleLogBlobUriValue;
                                BootDiagnosticsInstanceView bootDiagnosticsInstance2 = new BootDiagnosticsInstanceView();
                                instanceViewInstance.setBootDiagnostics(bootDiagnosticsInstance2);
                                Iterator consoleScreenshotBlobUriValue = bootDiagnosticsValue2.get("consoleScreenshotBlobUri");
                                if (consoleScreenshotBlobUriValue != null && !(consoleScreenshotBlobUriValue instanceof NullNode)) {
                                    URI consoleScreenshotBlobUriInstance = new URI(consoleScreenshotBlobUriValue.getTextValue());
                                    bootDiagnosticsInstance2.setConsoleScreenshotBlobUri(consoleScreenshotBlobUriInstance);
                                }
                                if ((serialConsoleLogBlobUriValue = bootDiagnosticsValue2.get("serialConsoleLogBlobUri")) != null && !(serialConsoleLogBlobUriValue instanceof NullNode)) {
                                    URI serialConsoleLogBlobUriInstance = new URI(serialConsoleLogBlobUriValue.getTextValue());
                                    bootDiagnosticsInstance2.setSerialConsoleLogBlobUri(serialConsoleLogBlobUriInstance);
                                }
                            }
                            if ((statusesArray4 = instanceViewValue.get("statuses")) != null && !(statusesArray4 instanceof NullNode)) {
                                for (Object statusesValue4 : (ArrayNode)statusesArray4) {
                                    JsonNode timeValue6;
                                    JsonNode messageValue6;
                                    JsonNode displayStatusValue6;
                                    JsonNode levelValue6;
                                    InstanceViewStatus instanceViewStatusInstance5 = new InstanceViewStatus();
                                    instanceViewInstance.getStatuses().add(instanceViewStatusInstance5);
                                    JsonNode codeValue6 = statusesValue4.get("code");
                                    if (codeValue6 != null && !(codeValue6 instanceof NullNode)) {
                                        String codeInstance6 = codeValue6.getTextValue();
                                        instanceViewStatusInstance5.setCode(codeInstance6);
                                    }
                                    if ((levelValue6 = statusesValue4.get("level")) != null && !(levelValue6 instanceof NullNode)) {
                                        String levelInstance6 = levelValue6.getTextValue();
                                        instanceViewStatusInstance5.setLevel(levelInstance6);
                                    }
                                    if ((displayStatusValue6 = statusesValue4.get("displayStatus")) != null && !(displayStatusValue6 instanceof NullNode)) {
                                        String displayStatusInstance6 = displayStatusValue6.getTextValue();
                                        instanceViewStatusInstance5.setDisplayStatus(displayStatusInstance6);
                                    }
                                    if ((messageValue6 = statusesValue4.get("message")) != null && !(messageValue6 instanceof NullNode)) {
                                        String messageInstance6 = messageValue6.getTextValue();
                                        instanceViewStatusInstance5.setMessage(messageInstance6);
                                    }
                                    if ((timeValue6 = statusesValue4.get("time")) == null || timeValue6 instanceof NullNode) continue;
                                    Calendar timeInstance6 = DatatypeConverter.parseDateTime((String)timeValue6.getTextValue());
                                    instanceViewStatusInstance5.setTime(timeInstance6);
                                }
                            }
                        }
                    }
                    if ((resourcesArray = responseDoc.get("resources")) != null && !(resourcesArray instanceof NullNode)) {
                        virtualMachineInstance.setExtensions(new ArrayList<VirtualMachineExtension>());
                        for (JsonNode resourcesValue : (ArrayNode)resourcesArray) {
                            JsonNode tagsSequenceElement;
                            JsonNode locationValue;
                            JsonNode typeValue5;
                            JsonNode nameValue7;
                            JsonNode idValue4;
                            VirtualMachineExtension virtualMachineExtensionJsonInstance = new VirtualMachineExtension();
                            virtualMachineInstance.getExtensions().add(virtualMachineExtensionJsonInstance);
                            JsonNode propertiesValue3 = resourcesValue.get("properties");
                            if (propertiesValue3 != null && !(propertiesValue3 instanceof NullNode)) {
                                JsonNode instanceViewValue2;
                                JsonNode provisioningStateValue2;
                                JsonNode protectedSettingsValue;
                                JsonNode settingsValue;
                                JsonNode autoUpgradeMinorVersionValue;
                                JsonNode typeHandlerVersionValue3;
                                JsonNode typeValue3;
                                JsonNode publisherValue3 = propertiesValue3.get("publisher");
                                if (publisherValue3 != null && !(publisherValue3 instanceof NullNode)) {
                                    String publisherInstance3 = publisherValue3.getTextValue();
                                    virtualMachineExtensionJsonInstance.setPublisher(publisherInstance3);
                                }
                                if ((typeValue3 = propertiesValue3.get("type")) != null && !(typeValue3 instanceof NullNode)) {
                                    String typeInstance3 = typeValue3.getTextValue();
                                    virtualMachineExtensionJsonInstance.setExtensionType(typeInstance3);
                                }
                                if ((typeHandlerVersionValue3 = propertiesValue3.get("typeHandlerVersion")) != null && !(typeHandlerVersionValue3 instanceof NullNode)) {
                                    String typeHandlerVersionInstance3 = typeHandlerVersionValue3.getTextValue();
                                    virtualMachineExtensionJsonInstance.setTypeHandlerVersion(typeHandlerVersionInstance3);
                                }
                                if ((autoUpgradeMinorVersionValue = propertiesValue3.get("autoUpgradeMinorVersion")) != null && !(autoUpgradeMinorVersionValue instanceof NullNode)) {
                                    boolean autoUpgradeMinorVersionInstance = autoUpgradeMinorVersionValue.getBooleanValue();
                                    virtualMachineExtensionJsonInstance.setAutoUpgradeMinorVersion(autoUpgradeMinorVersionInstance);
                                }
                                if ((settingsValue = propertiesValue3.get("settings")) != null && !(settingsValue instanceof NullNode)) {
                                    String settingsInstance = settingsValue.getTextValue();
                                    virtualMachineExtensionJsonInstance.setSettings(settingsInstance);
                                }
                                if ((protectedSettingsValue = propertiesValue3.get("protectedSettings")) != null && !(protectedSettingsValue instanceof NullNode)) {
                                    String protectedSettingsInstance = protectedSettingsValue.getTextValue();
                                    virtualMachineExtensionJsonInstance.setProtectedSettings(protectedSettingsInstance);
                                }
                                if ((provisioningStateValue2 = propertiesValue3.get("provisioningState")) != null && !(provisioningStateValue2 instanceof NullNode)) {
                                    String provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                    virtualMachineExtensionJsonInstance.setProvisioningState(provisioningStateInstance2);
                                }
                                if ((instanceViewValue2 = propertiesValue3.get("instanceView")) != null && !(instanceViewValue2 instanceof NullNode)) {
                                    JsonNode statusesArray5;
                                    JsonNode substatusesArray2;
                                    JsonNode typeHandlerVersionValue4;
                                    JsonNode typeValue4;
                                    VirtualMachineExtensionInstanceView instanceViewInstance2 = new VirtualMachineExtensionInstanceView();
                                    virtualMachineExtensionJsonInstance.setInstanceView(instanceViewInstance2);
                                    JsonNode nameValue6 = instanceViewValue2.get("name");
                                    if (nameValue6 != null && !(nameValue6 instanceof NullNode)) {
                                        String nameInstance6 = nameValue6.getTextValue();
                                        instanceViewInstance2.setName(nameInstance6);
                                    }
                                    if ((typeValue4 = instanceViewValue2.get("type")) != null && !(typeValue4 instanceof NullNode)) {
                                        String typeInstance4 = typeValue4.getTextValue();
                                        instanceViewInstance2.setExtensionType(typeInstance4);
                                    }
                                    if ((typeHandlerVersionValue4 = instanceViewValue2.get("typeHandlerVersion")) != null && !(typeHandlerVersionValue4 instanceof NullNode)) {
                                        String typeHandlerVersionInstance4 = typeHandlerVersionValue4.getTextValue();
                                        instanceViewInstance2.setTypeHandlerVersion(typeHandlerVersionInstance4);
                                    }
                                    if ((substatusesArray2 = instanceViewValue2.get("substatuses")) != null && !(substatusesArray2 instanceof NullNode)) {
                                        for (JsonNode substatusesValue2 : (ArrayNode)substatusesArray2) {
                                            JsonNode timeValue7;
                                            JsonNode messageValue7;
                                            JsonNode displayStatusValue7;
                                            JsonNode levelValue7;
                                            InstanceViewStatus instanceViewStatusInstance6 = new InstanceViewStatus();
                                            instanceViewInstance2.getSubStatuses().add(instanceViewStatusInstance6);
                                            JsonNode codeValue7 = substatusesValue2.get("code");
                                            if (codeValue7 != null && !(codeValue7 instanceof NullNode)) {
                                                String codeInstance7 = codeValue7.getTextValue();
                                                instanceViewStatusInstance6.setCode(codeInstance7);
                                            }
                                            if ((levelValue7 = substatusesValue2.get("level")) != null && !(levelValue7 instanceof NullNode)) {
                                                String levelInstance7 = levelValue7.getTextValue();
                                                instanceViewStatusInstance6.setLevel(levelInstance7);
                                            }
                                            if ((displayStatusValue7 = substatusesValue2.get("displayStatus")) != null && !(displayStatusValue7 instanceof NullNode)) {
                                                String displayStatusInstance7 = displayStatusValue7.getTextValue();
                                                instanceViewStatusInstance6.setDisplayStatus(displayStatusInstance7);
                                            }
                                            if ((messageValue7 = substatusesValue2.get("message")) != null && !(messageValue7 instanceof NullNode)) {
                                                String messageInstance7 = messageValue7.getTextValue();
                                                instanceViewStatusInstance6.setMessage(messageInstance7);
                                            }
                                            if ((timeValue7 = substatusesValue2.get("time")) == null || timeValue7 instanceof NullNode) continue;
                                            Calendar timeInstance7 = DatatypeConverter.parseDateTime((String)timeValue7.getTextValue());
                                            instanceViewStatusInstance6.setTime(timeInstance7);
                                        }
                                    }
                                    if ((statusesArray5 = instanceViewValue2.get("statuses")) != null && !(statusesArray5 instanceof NullNode)) {
                                        for (JsonNode statusesValue5 : (ArrayNode)statusesArray5) {
                                            JsonNode timeValue8;
                                            JsonNode messageValue8;
                                            JsonNode displayStatusValue8;
                                            JsonNode levelValue8;
                                            InstanceViewStatus instanceViewStatusInstance7 = new InstanceViewStatus();
                                            instanceViewInstance2.getStatuses().add(instanceViewStatusInstance7);
                                            JsonNode codeValue8 = statusesValue5.get("code");
                                            if (codeValue8 != null && !(codeValue8 instanceof NullNode)) {
                                                String codeInstance8 = codeValue8.getTextValue();
                                                instanceViewStatusInstance7.setCode(codeInstance8);
                                            }
                                            if ((levelValue8 = statusesValue5.get("level")) != null && !(levelValue8 instanceof NullNode)) {
                                                String levelInstance8 = levelValue8.getTextValue();
                                                instanceViewStatusInstance7.setLevel(levelInstance8);
                                            }
                                            if ((displayStatusValue8 = statusesValue5.get("displayStatus")) != null && !(displayStatusValue8 instanceof NullNode)) {
                                                String displayStatusInstance8 = displayStatusValue8.getTextValue();
                                                instanceViewStatusInstance7.setDisplayStatus(displayStatusInstance8);
                                            }
                                            if ((messageValue8 = statusesValue5.get("message")) != null && !(messageValue8 instanceof NullNode)) {
                                                String messageInstance8 = messageValue8.getTextValue();
                                                instanceViewStatusInstance7.setMessage(messageInstance8);
                                            }
                                            if ((timeValue8 = statusesValue5.get("time")) == null || timeValue8 instanceof NullNode) continue;
                                            Calendar timeInstance8 = DatatypeConverter.parseDateTime((String)timeValue8.getTextValue());
                                            instanceViewStatusInstance7.setTime(timeInstance8);
                                        }
                                    }
                                }
                            }
                            if ((idValue4 = resourcesValue.get("id")) != null && !(idValue4 instanceof NullNode)) {
                                String idInstance4 = idValue4.getTextValue();
                                virtualMachineExtensionJsonInstance.setId(idInstance4);
                            }
                            if ((nameValue7 = resourcesValue.get("name")) != null && !(nameValue7 instanceof NullNode)) {
                                String nameInstance7 = nameValue7.getTextValue();
                                virtualMachineExtensionJsonInstance.setName(nameInstance7);
                            }
                            if ((typeValue5 = resourcesValue.get("type")) != null && !(typeValue5 instanceof NullNode)) {
                                String typeInstance5 = typeValue5.getTextValue();
                                virtualMachineExtensionJsonInstance.setType(typeInstance5);
                            }
                            if ((locationValue = resourcesValue.get("location")) != null && !(locationValue instanceof NullNode)) {
                                String locationInstance = locationValue.getTextValue();
                                virtualMachineExtensionJsonInstance.setLocation(locationInstance);
                            }
                            if ((tagsSequenceElement = resourcesValue.get("tags")) == null || tagsSequenceElement instanceof NullNode) continue;
                            Iterator itr = tagsSequenceElement.getFields();
                            while (itr.hasNext()) {
                                Map.Entry property = (Map.Entry)itr.next();
                                String tagsKey = (String)property.getKey();
                                String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                                virtualMachineExtensionJsonInstance.getTags().put(tagsKey, tagsValue);
                            }
                        }
                    }
                    if ((idValue5 = responseDoc.get("id")) != null && !(idValue5 instanceof NullNode)) {
                        String idInstance5 = idValue5.getTextValue();
                        virtualMachineInstance.setId(idInstance5);
                    }
                    if ((nameValue8 = responseDoc.get("name")) != null && !(nameValue8 instanceof NullNode)) {
                        String nameInstance8 = nameValue8.getTextValue();
                        virtualMachineInstance.setName(nameInstance8);
                    }
                    if ((typeValue6 = responseDoc.get("type")) != null && !(typeValue6 instanceof NullNode)) {
                        String typeInstance6 = typeValue6.getTextValue();
                        virtualMachineInstance.setType(typeInstance6);
                    }
                    if ((locationValue2 = responseDoc.get("location")) != null && !(locationValue2 instanceof NullNode)) {
                        String locationInstance2 = locationValue2.getTextValue();
                        virtualMachineInstance.setLocation(locationInstance2);
                    }
                    if ((tagsSequenceElement2 = responseDoc.get("tags")) != null && !(tagsSequenceElement2 instanceof NullNode)) {
                        Iterator itr2 = tagsSequenceElement2.getFields();
                        while (itr2.hasNext()) {
                            Map.Entry property2 = (Map.Entry)itr2.next();
                            String tagsKey2 = (String)property2.getKey();
                            String tagsValue2 = ((JsonNode)property2.getValue()).getTextValue();
                            virtualMachineInstance.getTags().put(tagsKey2, tagsValue2);
                        }
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            VirtualMachineGetResponse virtualMachineGetResponse = result;
            return virtualMachineGetResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<VirtualMachineListResponse> listAsync(final String resourceGroupName) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineListResponse>(){

            @Override
            public VirtualMachineListResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.list(resourceGroupName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualMachineListResponse list(String resourceGroupName) throws IOException, ServiceException, URISyntaxException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/";
        url = url + "virtualMachines";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualMachineListResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualMachineListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString((InputStream)responseContent);
                if (!(responseDocContent == null) && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode nextLinkValue;
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && !(valueArray instanceof NullNode)) {
                        for (JsonNode valueValue : (ArrayNode)valueArray) {
                            JsonNode tagsSequenceElement2;
                            JsonNode locationValue2;
                            JsonNode typeValue6;
                            JsonNode nameValue8;
                            JsonNode idValue5;
                            JsonNode resourcesArray;
                            Object storageProfileValue;
                            JsonNode propertiesValue;
                            VirtualMachine virtualMachineJsonInstance = new VirtualMachine();
                            result.getVirtualMachines().add(virtualMachineJsonInstance);
                            JsonNode planValue = valueValue.get("plan");
                            if (planValue != null && !(planValue instanceof NullNode)) {
                                JsonNode promotionCodeValue;
                                JsonNode productValue;
                                JsonNode publisherValue;
                                Plan planInstance = new Plan();
                                virtualMachineJsonInstance.setPlan(planInstance);
                                JsonNode nameValue = planValue.get("name");
                                if (nameValue != null && !(nameValue instanceof NullNode)) {
                                    String nameInstance = nameValue.getTextValue();
                                    planInstance.setName(nameInstance);
                                }
                                if ((publisherValue = planValue.get("publisher")) != null && !(publisherValue instanceof NullNode)) {
                                    String publisherInstance = publisherValue.getTextValue();
                                    planInstance.setPublisher(publisherInstance);
                                }
                                if ((productValue = planValue.get("product")) != null && !(productValue instanceof NullNode)) {
                                    String productInstance = productValue.getTextValue();
                                    planInstance.setProduct(productInstance);
                                }
                                if ((promotionCodeValue = planValue.get("promotionCode")) != null && !(promotionCodeValue instanceof NullNode)) {
                                    String promotionCodeInstance = promotionCodeValue.getTextValue();
                                    planInstance.setPromotionCode(promotionCodeInstance);
                                }
                            }
                            if ((propertiesValue = valueValue.get("properties")) != null && !(propertiesValue instanceof NullNode)) {
                                JsonNode instanceViewValue;
                                JsonNode provisioningStateValue;
                                JsonNode availabilitySetValue;
                                JsonNode diagnosticsProfileValue;
                                JsonNode networkProfileValue;
                                Object adminPasswordValue;
                                JsonNode osProfileValue;
                                Object createOptionValue2;
                                JsonNode hardwareProfileValue = propertiesValue.get("hardwareProfile");
                                if (hardwareProfileValue != null && !(hardwareProfileValue instanceof NullNode)) {
                                    HardwareProfile hardwareProfileInstance = new HardwareProfile();
                                    virtualMachineJsonInstance.setHardwareProfile(hardwareProfileInstance);
                                    JsonNode vmSizeValue = hardwareProfileValue.get("vmSize");
                                    if (vmSizeValue != null && !(vmSizeValue instanceof NullNode)) {
                                        String vmSizeInstance = vmSizeValue.getTextValue();
                                        hardwareProfileInstance.setVirtualMachineSize(vmSizeInstance);
                                    }
                                }
                                if ((storageProfileValue = propertiesValue.get("storageProfile")) != null && !(storageProfileValue instanceof NullNode)) {
                                    JsonNode dataDisksArray;
                                    JsonNode osDiskValue;
                                    StorageProfile storageProfileInstance = new StorageProfile();
                                    virtualMachineJsonInstance.setStorageProfile(storageProfileInstance);
                                    JsonNode imageReferenceValue = storageProfileValue.get("imageReference");
                                    if (imageReferenceValue != null && !(imageReferenceValue instanceof NullNode)) {
                                        JsonNode versionValue;
                                        JsonNode skuValue;
                                        JsonNode offerValue;
                                        ImageReference imageReferenceInstance = new ImageReference();
                                        storageProfileInstance.setImageReference(imageReferenceInstance);
                                        JsonNode publisherValue2 = imageReferenceValue.get("publisher");
                                        if (publisherValue2 != null && !(publisherValue2 instanceof NullNode)) {
                                            String publisherInstance2 = publisherValue2.getTextValue();
                                            imageReferenceInstance.setPublisher(publisherInstance2);
                                        }
                                        if ((offerValue = imageReferenceValue.get("offer")) != null && !(offerValue instanceof NullNode)) {
                                            String offerInstance = offerValue.getTextValue();
                                            imageReferenceInstance.setOffer(offerInstance);
                                        }
                                        if ((skuValue = imageReferenceValue.get("sku")) != null && !(skuValue instanceof NullNode)) {
                                            String skuInstance = skuValue.getTextValue();
                                            imageReferenceInstance.setSku(skuInstance);
                                        }
                                        if ((versionValue = imageReferenceValue.get("version")) != null && !(versionValue instanceof NullNode)) {
                                            String versionInstance = versionValue.getTextValue();
                                            imageReferenceInstance.setVersion(versionInstance);
                                        }
                                    }
                                    if ((osDiskValue = storageProfileValue.get("osDisk")) != null && !(osDiskValue instanceof NullNode)) {
                                        JsonNode diskSizeGBValue;
                                        JsonNode createOptionValue;
                                        JsonNode cachingValue;
                                        JsonNode imageValue;
                                        JsonNode vhdValue;
                                        JsonNode nameValue2;
                                        OSDisk osDiskInstance = new OSDisk();
                                        storageProfileInstance.setOSDisk(osDiskInstance);
                                        Iterator osTypeValue = osDiskValue.get("osType");
                                        if (osTypeValue != null && !(osTypeValue instanceof NullNode)) {
                                            String osTypeInstance = osTypeValue.getTextValue();
                                            osDiskInstance.setOperatingSystemType(osTypeInstance);
                                        }
                                        if ((nameValue2 = osDiskValue.get("name")) != null && !(nameValue2 instanceof NullNode)) {
                                            String nameInstance2 = nameValue2.getTextValue();
                                            osDiskInstance.setName(nameInstance2);
                                        }
                                        if ((vhdValue = osDiskValue.get("vhd")) != null && !(vhdValue instanceof NullNode)) {
                                            VirtualHardDisk vhdInstance = new VirtualHardDisk();
                                            osDiskInstance.setVirtualHardDisk(vhdInstance);
                                            JsonNode uriValue = vhdValue.get("uri");
                                            if (uriValue != null && !(uriValue instanceof NullNode)) {
                                                String uriInstance = uriValue.getTextValue();
                                                vhdInstance.setUri(uriInstance);
                                            }
                                        }
                                        if ((imageValue = osDiskValue.get("image")) != null && !(imageValue instanceof NullNode)) {
                                            VirtualHardDisk imageInstance = new VirtualHardDisk();
                                            osDiskInstance.setSourceImage(imageInstance);
                                            JsonNode uriValue2 = imageValue.get("uri");
                                            if (uriValue2 != null && !(uriValue2 instanceof NullNode)) {
                                                String uriInstance2 = uriValue2.getTextValue();
                                                imageInstance.setUri(uriInstance2);
                                            }
                                        }
                                        if ((cachingValue = osDiskValue.get("caching")) != null && !(cachingValue instanceof NullNode)) {
                                            String cachingInstance = cachingValue.getTextValue();
                                            osDiskInstance.setCaching(cachingInstance);
                                        }
                                        if ((createOptionValue = osDiskValue.get("createOption")) != null && !(createOptionValue instanceof NullNode)) {
                                            String createOptionInstance = createOptionValue.getTextValue();
                                            osDiskInstance.setCreateOption(createOptionInstance);
                                        }
                                        if ((diskSizeGBValue = osDiskValue.get("diskSizeGB")) != null && !(diskSizeGBValue instanceof NullNode)) {
                                            int diskSizeGBInstance = diskSizeGBValue.getIntValue();
                                            osDiskInstance.setDiskSizeGB(diskSizeGBInstance);
                                        }
                                    }
                                    if ((dataDisksArray = storageProfileValue.get("dataDisks")) != null && !(dataDisksArray instanceof NullNode)) {
                                        for (JsonNode dataDisksValue : (ArrayNode)dataDisksArray) {
                                            JsonNode diskSizeGBValue2;
                                            JsonNode cachingValue2;
                                            JsonNode imageValue2;
                                            JsonNode vhdValue2;
                                            JsonNode nameValue3;
                                            DataDisk dataDiskInstance = new DataDisk();
                                            storageProfileInstance.getDataDisks().add(dataDiskInstance);
                                            JsonNode lunValue = dataDisksValue.get("lun");
                                            if (lunValue != null && !(lunValue instanceof NullNode)) {
                                                int lunInstance = lunValue.getIntValue();
                                                dataDiskInstance.setLun(lunInstance);
                                            }
                                            if ((nameValue3 = dataDisksValue.get("name")) != null && !(nameValue3 instanceof NullNode)) {
                                                String nameInstance3 = nameValue3.getTextValue();
                                                dataDiskInstance.setName(nameInstance3);
                                            }
                                            if ((vhdValue2 = dataDisksValue.get("vhd")) != null && !(vhdValue2 instanceof NullNode)) {
                                                VirtualHardDisk vhdInstance2 = new VirtualHardDisk();
                                                dataDiskInstance.setVirtualHardDisk(vhdInstance2);
                                                JsonNode uriValue3 = vhdValue2.get("uri");
                                                if (uriValue3 != null && !(uriValue3 instanceof NullNode)) {
                                                    String uriInstance3 = uriValue3.getTextValue();
                                                    vhdInstance2.setUri(uriInstance3);
                                                }
                                            }
                                            if ((imageValue2 = dataDisksValue.get("image")) != null && !(imageValue2 instanceof NullNode)) {
                                                VirtualHardDisk imageInstance2 = new VirtualHardDisk();
                                                dataDiskInstance.setSourceImage(imageInstance2);
                                                JsonNode uriValue4 = imageValue2.get("uri");
                                                if (uriValue4 != null && !(uriValue4 instanceof NullNode)) {
                                                    String uriInstance4 = uriValue4.getTextValue();
                                                    imageInstance2.setUri(uriInstance4);
                                                }
                                            }
                                            if ((cachingValue2 = dataDisksValue.get("caching")) != null && !(cachingValue2 instanceof NullNode)) {
                                                String cachingInstance2 = cachingValue2.getTextValue();
                                                dataDiskInstance.setCaching(cachingInstance2);
                                            }
                                            if ((createOptionValue2 = dataDisksValue.get("createOption")) != null && !(createOptionValue2 instanceof NullNode)) {
                                                String createOptionInstance2 = createOptionValue2.getTextValue();
                                                dataDiskInstance.setCreateOption(createOptionInstance2);
                                            }
                                            if ((diskSizeGBValue2 = dataDisksValue.get("diskSizeGB")) == null || diskSizeGBValue2 instanceof NullNode) continue;
                                            int diskSizeGBInstance2 = diskSizeGBValue2.getIntValue();
                                            dataDiskInstance.setDiskSizeGB(diskSizeGBInstance2);
                                        }
                                    }
                                }
                                if ((osProfileValue = propertiesValue.get("osProfile")) != null && !(osProfileValue instanceof NullNode)) {
                                    JsonNode secretsArray;
                                    JsonNode linuxConfigurationValue;
                                    JsonNode windowsConfigurationValue;
                                    JsonNode customDataValue;
                                    JsonNode adminUsernameValue;
                                    OSProfile osProfileInstance = new OSProfile();
                                    virtualMachineJsonInstance.setOSProfile(osProfileInstance);
                                    JsonNode computerNameValue = osProfileValue.get("computerName");
                                    if (computerNameValue != null && !(computerNameValue instanceof NullNode)) {
                                        String computerNameInstance = computerNameValue.getTextValue();
                                        osProfileInstance.setComputerName(computerNameInstance);
                                    }
                                    if ((adminUsernameValue = osProfileValue.get("adminUsername")) != null && !(adminUsernameValue instanceof NullNode)) {
                                        String adminUsernameInstance = adminUsernameValue.getTextValue();
                                        osProfileInstance.setAdminUsername(adminUsernameInstance);
                                    }
                                    if ((adminPasswordValue = osProfileValue.get("adminPassword")) != null && !(adminPasswordValue instanceof NullNode)) {
                                        String adminPasswordInstance = adminPasswordValue.getTextValue();
                                        osProfileInstance.setAdminPassword(adminPasswordInstance);
                                    }
                                    if ((customDataValue = osProfileValue.get("customData")) != null && !(customDataValue instanceof NullNode)) {
                                        String customDataInstance = customDataValue.getTextValue();
                                        osProfileInstance.setCustomData(customDataInstance);
                                    }
                                    if ((windowsConfigurationValue = osProfileValue.get("windowsConfiguration")) != null && !(windowsConfigurationValue instanceof NullNode)) {
                                        JsonNode winRMValue;
                                        JsonNode additionalUnattendContentArray;
                                        JsonNode timeZoneValue;
                                        JsonNode enableAutomaticUpdatesValue;
                                        WindowsConfiguration windowsConfigurationInstance = new WindowsConfiguration();
                                        osProfileInstance.setWindowsConfiguration(windowsConfigurationInstance);
                                        JsonNode provisionVMAgentValue = windowsConfigurationValue.get("provisionVMAgent");
                                        if (provisionVMAgentValue != null && !(provisionVMAgentValue instanceof NullNode)) {
                                            boolean provisionVMAgentInstance = provisionVMAgentValue.getBooleanValue();
                                            windowsConfigurationInstance.setProvisionVMAgent(provisionVMAgentInstance);
                                        }
                                        if ((enableAutomaticUpdatesValue = windowsConfigurationValue.get("enableAutomaticUpdates")) != null && !(enableAutomaticUpdatesValue instanceof NullNode)) {
                                            boolean enableAutomaticUpdatesInstance = enableAutomaticUpdatesValue.getBooleanValue();
                                            windowsConfigurationInstance.setEnableAutomaticUpdates(enableAutomaticUpdatesInstance);
                                        }
                                        if ((timeZoneValue = windowsConfigurationValue.get("timeZone")) != null && !(timeZoneValue instanceof NullNode)) {
                                            String timeZoneInstance = timeZoneValue.getTextValue();
                                            windowsConfigurationInstance.setTimeZone(timeZoneInstance);
                                        }
                                        if ((additionalUnattendContentArray = windowsConfigurationValue.get("additionalUnattendContent")) != null && !(additionalUnattendContentArray instanceof NullNode)) {
                                            createOptionValue2 = ((ArrayNode)additionalUnattendContentArray).iterator();
                                            while (createOptionValue2.hasNext()) {
                                                JsonNode contentValue;
                                                JsonNode settingNameValue;
                                                JsonNode componentNameValue;
                                                JsonNode additionalUnattendContentValue = (JsonNode)createOptionValue2.next();
                                                AdditionalUnattendContent additionalUnattendContentInstance = new AdditionalUnattendContent();
                                                windowsConfigurationInstance.getAdditionalUnattendContents().add(additionalUnattendContentInstance);
                                                JsonNode passNameValue = additionalUnattendContentValue.get("passName");
                                                if (passNameValue != null && !(passNameValue instanceof NullNode)) {
                                                    String passNameInstance = passNameValue.getTextValue();
                                                    additionalUnattendContentInstance.setPassName(passNameInstance);
                                                }
                                                if ((componentNameValue = additionalUnattendContentValue.get("componentName")) != null && !(componentNameValue instanceof NullNode)) {
                                                    String componentNameInstance = componentNameValue.getTextValue();
                                                    additionalUnattendContentInstance.setComponentName(componentNameInstance);
                                                }
                                                if ((settingNameValue = additionalUnattendContentValue.get("settingName")) != null && !(settingNameValue instanceof NullNode)) {
                                                    String settingNameInstance = settingNameValue.getTextValue();
                                                    additionalUnattendContentInstance.setSettingName(settingNameInstance);
                                                }
                                                if ((contentValue = additionalUnattendContentValue.get("content")) == null || contentValue instanceof NullNode) continue;
                                                String contentInstance = contentValue.getTextValue();
                                                additionalUnattendContentInstance.setContent(contentInstance);
                                            }
                                        }
                                        if ((winRMValue = windowsConfigurationValue.get("winRM")) != null && !(winRMValue instanceof NullNode)) {
                                            WinRMConfiguration winRMInstance = new WinRMConfiguration();
                                            windowsConfigurationInstance.setWinRMConfiguration(winRMInstance);
                                            JsonNode listenersArray = winRMValue.get("listeners");
                                            if (listenersArray != null && !(listenersArray instanceof NullNode)) {
                                                for (JsonNode listenersValue : (ArrayNode)listenersArray) {
                                                    JsonNode certificateUrlValue;
                                                    WinRMListener winRMListenerInstance = new WinRMListener();
                                                    winRMInstance.getListeners().add(winRMListenerInstance);
                                                    JsonNode protocolValue = listenersValue.get("protocol");
                                                    if (protocolValue != null && !(protocolValue instanceof NullNode)) {
                                                        String protocolInstance = protocolValue.getTextValue();
                                                        winRMListenerInstance.setProtocol(protocolInstance);
                                                    }
                                                    if ((certificateUrlValue = listenersValue.get("certificateUrl")) == null || certificateUrlValue instanceof NullNode) continue;
                                                    URI certificateUrlInstance = new URI(certificateUrlValue.getTextValue());
                                                    winRMListenerInstance.setCertificateUrl(certificateUrlInstance);
                                                }
                                            }
                                        }
                                    }
                                    if ((linuxConfigurationValue = osProfileValue.get("linuxConfiguration")) != null && !(linuxConfigurationValue instanceof NullNode)) {
                                        JsonNode sshValue;
                                        LinuxConfiguration linuxConfigurationInstance = new LinuxConfiguration();
                                        osProfileInstance.setLinuxConfiguration(linuxConfigurationInstance);
                                        Iterator disablePasswordAuthenticationValue = linuxConfigurationValue.get("disablePasswordAuthentication");
                                        if (disablePasswordAuthenticationValue != null && !(disablePasswordAuthenticationValue instanceof NullNode)) {
                                            boolean disablePasswordAuthenticationInstance = disablePasswordAuthenticationValue.getBooleanValue();
                                            linuxConfigurationInstance.setDisablePasswordAuthentication(disablePasswordAuthenticationInstance);
                                        }
                                        if ((sshValue = linuxConfigurationValue.get("ssh")) != null && !(sshValue instanceof NullNode)) {
                                            SshConfiguration sshInstance = new SshConfiguration();
                                            linuxConfigurationInstance.setSshConfiguration(sshInstance);
                                            JsonNode publicKeysArray = sshValue.get("publicKeys");
                                            if (publicKeysArray != null && !(publicKeysArray instanceof NullNode)) {
                                                for (JsonNode publicKeysValue : (ArrayNode)publicKeysArray) {
                                                    JsonNode keyDataValue;
                                                    SshPublicKey sshPublicKeyInstance = new SshPublicKey();
                                                    sshInstance.getPublicKeys().add(sshPublicKeyInstance);
                                                    JsonNode pathValue = publicKeysValue.get("path");
                                                    if (pathValue != null && !(pathValue instanceof NullNode)) {
                                                        String pathInstance = pathValue.getTextValue();
                                                        sshPublicKeyInstance.setPath(pathInstance);
                                                    }
                                                    if ((keyDataValue = publicKeysValue.get("keyData")) == null || keyDataValue instanceof NullNode) continue;
                                                    String keyDataInstance = keyDataValue.getTextValue();
                                                    sshPublicKeyInstance.setKeyData(keyDataInstance);
                                                }
                                            }
                                        }
                                    }
                                    if ((secretsArray = osProfileValue.get("secrets")) != null && !(secretsArray instanceof NullNode)) {
                                        for (JsonNode secretsValue : (ArrayNode)secretsArray) {
                                            JsonNode vaultCertificatesArray;
                                            VaultSecretGroup vaultSecretGroupInstance = new VaultSecretGroup();
                                            osProfileInstance.getSecrets().add(vaultSecretGroupInstance);
                                            JsonNode sourceVaultValue = secretsValue.get("sourceVault");
                                            if (sourceVaultValue != null && !(sourceVaultValue instanceof NullNode)) {
                                                SourceVaultReference sourceVaultInstance = new SourceVaultReference();
                                                vaultSecretGroupInstance.setSourceVault(sourceVaultInstance);
                                                Iterator idValue = sourceVaultValue.get("id");
                                                if (idValue != null && !(idValue instanceof NullNode)) {
                                                    String idInstance = idValue.getTextValue();
                                                    sourceVaultInstance.setReferenceUri(idInstance);
                                                }
                                            }
                                            if ((vaultCertificatesArray = secretsValue.get("vaultCertificates")) == null || vaultCertificatesArray instanceof NullNode) continue;
                                            for (JsonNode vaultCertificatesValue : (ArrayNode)vaultCertificatesArray) {
                                                JsonNode certificateStoreValue;
                                                VaultCertificate vaultCertificateInstance = new VaultCertificate();
                                                vaultSecretGroupInstance.getVaultCertificates().add(vaultCertificateInstance);
                                                JsonNode certificateUrlValue2 = vaultCertificatesValue.get("certificateUrl");
                                                if (certificateUrlValue2 != null && !(certificateUrlValue2 instanceof NullNode)) {
                                                    String certificateUrlInstance2 = certificateUrlValue2.getTextValue();
                                                    vaultCertificateInstance.setCertificateUrl(certificateUrlInstance2);
                                                }
                                                if ((certificateStoreValue = vaultCertificatesValue.get("certificateStore")) == null || certificateStoreValue instanceof NullNode) continue;
                                                String certificateStoreInstance = certificateStoreValue.getTextValue();
                                                vaultCertificateInstance.setCertificateStore(certificateStoreInstance);
                                            }
                                        }
                                    }
                                }
                                if ((networkProfileValue = propertiesValue.get("networkProfile")) != null && !(networkProfileValue instanceof NullNode)) {
                                    NetworkProfile networkProfileInstance = new NetworkProfile();
                                    virtualMachineJsonInstance.setNetworkProfile(networkProfileInstance);
                                    JsonNode networkInterfacesArray = networkProfileValue.get("networkInterfaces");
                                    if (networkInterfacesArray != null && !(networkInterfacesArray instanceof NullNode)) {
                                        adminPasswordValue = ((ArrayNode)networkInterfacesArray).iterator();
                                        while (adminPasswordValue.hasNext()) {
                                            JsonNode idValue2;
                                            JsonNode primaryValue;
                                            JsonNode networkInterfacesValue = (JsonNode)adminPasswordValue.next();
                                            NetworkInterfaceReference networkInterfaceReferenceJsonInstance = new NetworkInterfaceReference();
                                            networkProfileInstance.getNetworkInterfaces().add(networkInterfaceReferenceJsonInstance);
                                            JsonNode propertiesValue2 = networkInterfacesValue.get("properties");
                                            if (propertiesValue2 != null && !(propertiesValue2 instanceof NullNode) && (primaryValue = propertiesValue2.get("primary")) != null && !(primaryValue instanceof NullNode)) {
                                                boolean primaryInstance = primaryValue.getBooleanValue();
                                                networkInterfaceReferenceJsonInstance.setPrimary(primaryInstance);
                                            }
                                            if ((idValue2 = networkInterfacesValue.get("id")) == null || idValue2 instanceof NullNode) continue;
                                            String idInstance2 = idValue2.getTextValue();
                                            networkInterfaceReferenceJsonInstance.setReferenceUri(idInstance2);
                                        }
                                    }
                                }
                                if ((diagnosticsProfileValue = propertiesValue.get("diagnosticsProfile")) != null && !(diagnosticsProfileValue instanceof NullNode)) {
                                    DiagnosticsProfile diagnosticsProfileInstance = new DiagnosticsProfile();
                                    virtualMachineJsonInstance.setDiagnosticsProfile(diagnosticsProfileInstance);
                                    JsonNode bootDiagnosticsValue = diagnosticsProfileValue.get("bootDiagnostics");
                                    if (bootDiagnosticsValue != null && !(bootDiagnosticsValue instanceof NullNode)) {
                                        JsonNode storageUriValue;
                                        BootDiagnostics bootDiagnosticsInstance = new BootDiagnostics();
                                        diagnosticsProfileInstance.setBootDiagnostics(bootDiagnosticsInstance);
                                        JsonNode enabledValue = bootDiagnosticsValue.get("enabled");
                                        if (enabledValue != null && !(enabledValue instanceof NullNode)) {
                                            boolean enabledInstance = enabledValue.getBooleanValue();
                                            bootDiagnosticsInstance.setEnabled(enabledInstance);
                                        }
                                        if ((storageUriValue = bootDiagnosticsValue.get("storageUri")) != null && !(storageUriValue instanceof NullNode)) {
                                            URI storageUriInstance = new URI(storageUriValue.getTextValue());
                                            bootDiagnosticsInstance.setStorageUri(storageUriInstance);
                                        }
                                    }
                                }
                                if ((availabilitySetValue = propertiesValue.get("availabilitySet")) != null && !(availabilitySetValue instanceof NullNode)) {
                                    AvailabilitySetReference availabilitySetInstance = new AvailabilitySetReference();
                                    virtualMachineJsonInstance.setAvailabilitySetReference(availabilitySetInstance);
                                    JsonNode idValue3 = availabilitySetValue.get("id");
                                    if (idValue3 != null && !(idValue3 instanceof NullNode)) {
                                        String idInstance3 = idValue3.getTextValue();
                                        availabilitySetInstance.setReferenceUri(idInstance3);
                                    }
                                }
                                if ((provisioningStateValue = propertiesValue.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                                    String provisioningStateInstance = provisioningStateValue.getTextValue();
                                    virtualMachineJsonInstance.setProvisioningState(provisioningStateInstance);
                                }
                                if ((instanceViewValue = propertiesValue.get("instanceView")) != null && !(instanceViewValue instanceof NullNode)) {
                                    JsonNode statusesArray4;
                                    JsonNode bootDiagnosticsValue2;
                                    JsonNode extensionsArray;
                                    JsonNode disksArray;
                                    JsonNode vmAgentValue;
                                    JsonNode rdpThumbPrintValue;
                                    JsonNode platformFaultDomainValue;
                                    VirtualMachineInstanceView instanceViewInstance = new VirtualMachineInstanceView();
                                    virtualMachineJsonInstance.setInstanceView(instanceViewInstance);
                                    JsonNode platformUpdateDomainValue = instanceViewValue.get("platformUpdateDomain");
                                    if (platformUpdateDomainValue != null && !(platformUpdateDomainValue instanceof NullNode)) {
                                        int platformUpdateDomainInstance = platformUpdateDomainValue.getIntValue();
                                        instanceViewInstance.setPlatformUpdateDomain(platformUpdateDomainInstance);
                                    }
                                    if ((platformFaultDomainValue = instanceViewValue.get("platformFaultDomain")) != null && !(platformFaultDomainValue instanceof NullNode)) {
                                        int platformFaultDomainInstance = platformFaultDomainValue.getIntValue();
                                        instanceViewInstance.setPlatformFaultDomain(platformFaultDomainInstance);
                                    }
                                    if ((rdpThumbPrintValue = instanceViewValue.get("rdpThumbPrint")) != null && !(rdpThumbPrintValue instanceof NullNode)) {
                                        String rdpThumbPrintInstance = rdpThumbPrintValue.getTextValue();
                                        instanceViewInstance.setRemoteDesktopThumbprint(rdpThumbPrintInstance);
                                    }
                                    if ((vmAgentValue = instanceViewValue.get("vmAgent")) != null && !(vmAgentValue instanceof NullNode)) {
                                        JsonNode statusesArray;
                                        JsonNode extensionHandlersArray;
                                        VirtualMachineAgentInstanceView vmAgentInstance = new VirtualMachineAgentInstanceView();
                                        instanceViewInstance.setVMAgent(vmAgentInstance);
                                        Iterator vmAgentVersionValue = vmAgentValue.get("vmAgentVersion");
                                        if (vmAgentVersionValue != null && !(vmAgentVersionValue instanceof NullNode)) {
                                            String vmAgentVersionInstance = vmAgentVersionValue.getTextValue();
                                            vmAgentInstance.setVMAgentVersion(vmAgentVersionInstance);
                                        }
                                        if ((extensionHandlersArray = vmAgentValue.get("extensionHandlers")) != null && !(extensionHandlersArray instanceof NullNode)) {
                                            for (Iterator extensionHandlersValue : (ArrayNode)extensionHandlersArray) {
                                                JsonNode timeValue;
                                                JsonNode messageValue;
                                                JsonNode displayStatusValue;
                                                JsonNode levelValue;
                                                JsonNode statusValue;
                                                JsonNode typeHandlerVersionValue;
                                                VirtualMachineExtensionHandlerInstanceView virtualMachineExtensionHandlerInstanceViewInstance = new VirtualMachineExtensionHandlerInstanceView();
                                                vmAgentInstance.getExtensionHandlers().add(virtualMachineExtensionHandlerInstanceViewInstance);
                                                JsonNode typeValue = extensionHandlersValue.get("type");
                                                if (typeValue != null && !(typeValue instanceof NullNode)) {
                                                    String typeInstance = typeValue.getTextValue();
                                                    virtualMachineExtensionHandlerInstanceViewInstance.setType(typeInstance);
                                                }
                                                if ((typeHandlerVersionValue = extensionHandlersValue.get("typeHandlerVersion")) != null && !(typeHandlerVersionValue instanceof NullNode)) {
                                                    String typeHandlerVersionInstance = typeHandlerVersionValue.getTextValue();
                                                    virtualMachineExtensionHandlerInstanceViewInstance.setTypeHandlerVersion(typeHandlerVersionInstance);
                                                }
                                                if ((statusValue = extensionHandlersValue.get("status")) == null || statusValue instanceof NullNode) continue;
                                                InstanceViewStatus statusInstance = new InstanceViewStatus();
                                                virtualMachineExtensionHandlerInstanceViewInstance.setStatus(statusInstance);
                                                JsonNode codeValue = statusValue.get("code");
                                                if (codeValue != null && !(codeValue instanceof NullNode)) {
                                                    String codeInstance = codeValue.getTextValue();
                                                    statusInstance.setCode(codeInstance);
                                                }
                                                if ((levelValue = statusValue.get("level")) != null && !(levelValue instanceof NullNode)) {
                                                    String levelInstance = levelValue.getTextValue();
                                                    statusInstance.setLevel(levelInstance);
                                                }
                                                if ((displayStatusValue = statusValue.get("displayStatus")) != null && !(displayStatusValue instanceof NullNode)) {
                                                    String displayStatusInstance = displayStatusValue.getTextValue();
                                                    statusInstance.setDisplayStatus(displayStatusInstance);
                                                }
                                                if ((messageValue = statusValue.get("message")) != null && !(messageValue instanceof NullNode)) {
                                                    String messageInstance = messageValue.getTextValue();
                                                    statusInstance.setMessage(messageInstance);
                                                }
                                                if ((timeValue = statusValue.get("time")) == null || timeValue instanceof NullNode) continue;
                                                Calendar timeInstance = DatatypeConverter.parseDateTime((String)timeValue.getTextValue());
                                                statusInstance.setTime(timeInstance);
                                            }
                                        }
                                        if ((statusesArray = vmAgentValue.get("statuses")) != null && !(statusesArray instanceof NullNode)) {
                                            Iterator extensionHandlersValue;
                                            extensionHandlersValue = ((ArrayNode)statusesArray).iterator();
                                            while (extensionHandlersValue.hasNext()) {
                                                JsonNode timeValue2;
                                                JsonNode messageValue2;
                                                JsonNode displayStatusValue2;
                                                JsonNode levelValue2;
                                                JsonNode statusesValue = (JsonNode)extensionHandlersValue.next();
                                                InstanceViewStatus instanceViewStatusInstance = new InstanceViewStatus();
                                                vmAgentInstance.getStatuses().add(instanceViewStatusInstance);
                                                JsonNode codeValue2 = statusesValue.get("code");
                                                if (codeValue2 != null && !(codeValue2 instanceof NullNode)) {
                                                    String codeInstance2 = codeValue2.getTextValue();
                                                    instanceViewStatusInstance.setCode(codeInstance2);
                                                }
                                                if ((levelValue2 = statusesValue.get("level")) != null && !(levelValue2 instanceof NullNode)) {
                                                    String levelInstance2 = levelValue2.getTextValue();
                                                    instanceViewStatusInstance.setLevel(levelInstance2);
                                                }
                                                if ((displayStatusValue2 = statusesValue.get("displayStatus")) != null && !(displayStatusValue2 instanceof NullNode)) {
                                                    String displayStatusInstance2 = displayStatusValue2.getTextValue();
                                                    instanceViewStatusInstance.setDisplayStatus(displayStatusInstance2);
                                                }
                                                if ((messageValue2 = statusesValue.get("message")) != null && !(messageValue2 instanceof NullNode)) {
                                                    String messageInstance2 = messageValue2.getTextValue();
                                                    instanceViewStatusInstance.setMessage(messageInstance2);
                                                }
                                                if ((timeValue2 = statusesValue.get("time")) == null || timeValue2 instanceof NullNode) continue;
                                                Calendar timeInstance2 = DatatypeConverter.parseDateTime((String)timeValue2.getTextValue());
                                                instanceViewStatusInstance.setTime(timeInstance2);
                                            }
                                        }
                                    }
                                    if ((disksArray = instanceViewValue.get("disks")) != null && !(disksArray instanceof NullNode)) {
                                        for (Iterator disksValue : (ArrayNode)disksArray) {
                                            JsonNode statusesArray2;
                                            DiskInstanceView diskInstanceViewInstance = new DiskInstanceView();
                                            instanceViewInstance.getDisks().add(diskInstanceViewInstance);
                                            JsonNode nameValue4 = disksValue.get("name");
                                            if (nameValue4 != null && !(nameValue4 instanceof NullNode)) {
                                                String nameInstance4 = nameValue4.getTextValue();
                                                diskInstanceViewInstance.setName(nameInstance4);
                                            }
                                            if ((statusesArray2 = disksValue.get("statuses")) == null || statusesArray2 instanceof NullNode) continue;
                                            for (JsonNode statusesValue2 : (ArrayNode)statusesArray2) {
                                                JsonNode timeValue3;
                                                JsonNode messageValue3;
                                                JsonNode displayStatusValue3;
                                                JsonNode levelValue3;
                                                InstanceViewStatus instanceViewStatusInstance2 = new InstanceViewStatus();
                                                diskInstanceViewInstance.getStatuses().add(instanceViewStatusInstance2);
                                                Iterator codeValue3 = statusesValue2.get("code");
                                                if (codeValue3 != null && !(codeValue3 instanceof NullNode)) {
                                                    String codeInstance3 = codeValue3.getTextValue();
                                                    instanceViewStatusInstance2.setCode(codeInstance3);
                                                }
                                                if ((levelValue3 = statusesValue2.get("level")) != null && !(levelValue3 instanceof NullNode)) {
                                                    String levelInstance3 = levelValue3.getTextValue();
                                                    instanceViewStatusInstance2.setLevel(levelInstance3);
                                                }
                                                if ((displayStatusValue3 = statusesValue2.get("displayStatus")) != null && !(displayStatusValue3 instanceof NullNode)) {
                                                    String displayStatusInstance3 = displayStatusValue3.getTextValue();
                                                    instanceViewStatusInstance2.setDisplayStatus(displayStatusInstance3);
                                                }
                                                if ((messageValue3 = statusesValue2.get("message")) != null && !(messageValue3 instanceof NullNode)) {
                                                    String messageInstance3 = messageValue3.getTextValue();
                                                    instanceViewStatusInstance2.setMessage(messageInstance3);
                                                }
                                                if ((timeValue3 = statusesValue2.get("time")) == null || timeValue3 instanceof NullNode) continue;
                                                Calendar timeInstance3 = DatatypeConverter.parseDateTime((String)timeValue3.getTextValue());
                                                instanceViewStatusInstance2.setTime(timeInstance3);
                                            }
                                        }
                                    }
                                    if ((extensionsArray = instanceViewValue.get("extensions")) != null && !(extensionsArray instanceof NullNode)) {
                                        Iterator disksValue;
                                        disksValue = ((ArrayNode)extensionsArray).iterator();
                                        while (disksValue.hasNext()) {
                                            JsonNode statusesArray3;
                                            Iterator substatusesValue2;
                                            JsonNode substatusesArray;
                                            JsonNode typeHandlerVersionValue2;
                                            JsonNode typeValue2;
                                            JsonNode extensionsValue = (JsonNode)disksValue.next();
                                            VirtualMachineExtensionInstanceView virtualMachineExtensionInstanceViewInstance = new VirtualMachineExtensionInstanceView();
                                            instanceViewInstance.getExtensions().add(virtualMachineExtensionInstanceViewInstance);
                                            JsonNode nameValue5 = extensionsValue.get("name");
                                            if (nameValue5 != null && !(nameValue5 instanceof NullNode)) {
                                                String nameInstance5 = nameValue5.getTextValue();
                                                virtualMachineExtensionInstanceViewInstance.setName(nameInstance5);
                                            }
                                            if ((typeValue2 = extensionsValue.get("type")) != null && !(typeValue2 instanceof NullNode)) {
                                                String typeInstance2 = typeValue2.getTextValue();
                                                virtualMachineExtensionInstanceViewInstance.setExtensionType(typeInstance2);
                                            }
                                            if ((typeHandlerVersionValue2 = extensionsValue.get("typeHandlerVersion")) != null && !(typeHandlerVersionValue2 instanceof NullNode)) {
                                                String typeHandlerVersionInstance2 = typeHandlerVersionValue2.getTextValue();
                                                virtualMachineExtensionInstanceViewInstance.setTypeHandlerVersion(typeHandlerVersionInstance2);
                                            }
                                            if ((substatusesArray = extensionsValue.get("substatuses")) != null && !(substatusesArray instanceof NullNode)) {
                                                for (Iterator substatusesValue2 : (ArrayNode)substatusesArray) {
                                                    JsonNode timeValue4;
                                                    JsonNode messageValue4;
                                                    JsonNode displayStatusValue4;
                                                    JsonNode levelValue4;
                                                    InstanceViewStatus instanceViewStatusInstance3 = new InstanceViewStatus();
                                                    virtualMachineExtensionInstanceViewInstance.getSubStatuses().add(instanceViewStatusInstance3);
                                                    JsonNode codeValue4 = substatusesValue2.get("code");
                                                    if (codeValue4 != null && !(codeValue4 instanceof NullNode)) {
                                                        String codeInstance4 = codeValue4.getTextValue();
                                                        instanceViewStatusInstance3.setCode(codeInstance4);
                                                    }
                                                    if ((levelValue4 = substatusesValue2.get("level")) != null && !(levelValue4 instanceof NullNode)) {
                                                        String levelInstance4 = levelValue4.getTextValue();
                                                        instanceViewStatusInstance3.setLevel(levelInstance4);
                                                    }
                                                    if ((displayStatusValue4 = substatusesValue2.get("displayStatus")) != null && !(displayStatusValue4 instanceof NullNode)) {
                                                        String displayStatusInstance4 = displayStatusValue4.getTextValue();
                                                        instanceViewStatusInstance3.setDisplayStatus(displayStatusInstance4);
                                                    }
                                                    if ((messageValue4 = substatusesValue2.get("message")) != null && !(messageValue4 instanceof NullNode)) {
                                                        String messageInstance4 = messageValue4.getTextValue();
                                                        instanceViewStatusInstance3.setMessage(messageInstance4);
                                                    }
                                                    if ((timeValue4 = substatusesValue2.get("time")) == null || timeValue4 instanceof NullNode) continue;
                                                    Calendar timeInstance4 = DatatypeConverter.parseDateTime((String)timeValue4.getTextValue());
                                                    instanceViewStatusInstance3.setTime(timeInstance4);
                                                }
                                            }
                                            if ((statusesArray3 = extensionsValue.get("statuses")) == null || statusesArray3 instanceof NullNode) continue;
                                            substatusesValue2 = ((ArrayNode)statusesArray3).iterator();
                                            while (substatusesValue2.hasNext()) {
                                                JsonNode timeValue5;
                                                JsonNode messageValue5;
                                                JsonNode displayStatusValue5;
                                                JsonNode levelValue5;
                                                JsonNode statusesValue3 = (JsonNode)substatusesValue2.next();
                                                InstanceViewStatus instanceViewStatusInstance4 = new InstanceViewStatus();
                                                virtualMachineExtensionInstanceViewInstance.getStatuses().add(instanceViewStatusInstance4);
                                                JsonNode codeValue5 = statusesValue3.get("code");
                                                if (codeValue5 != null && !(codeValue5 instanceof NullNode)) {
                                                    String codeInstance5 = codeValue5.getTextValue();
                                                    instanceViewStatusInstance4.setCode(codeInstance5);
                                                }
                                                if ((levelValue5 = statusesValue3.get("level")) != null && !(levelValue5 instanceof NullNode)) {
                                                    String levelInstance5 = levelValue5.getTextValue();
                                                    instanceViewStatusInstance4.setLevel(levelInstance5);
                                                }
                                                if ((displayStatusValue5 = statusesValue3.get("displayStatus")) != null && !(displayStatusValue5 instanceof NullNode)) {
                                                    String displayStatusInstance5 = displayStatusValue5.getTextValue();
                                                    instanceViewStatusInstance4.setDisplayStatus(displayStatusInstance5);
                                                }
                                                if ((messageValue5 = statusesValue3.get("message")) != null && !(messageValue5 instanceof NullNode)) {
                                                    String messageInstance5 = messageValue5.getTextValue();
                                                    instanceViewStatusInstance4.setMessage(messageInstance5);
                                                }
                                                if ((timeValue5 = statusesValue3.get("time")) == null || timeValue5 instanceof NullNode) continue;
                                                Calendar timeInstance5 = DatatypeConverter.parseDateTime((String)timeValue5.getTextValue());
                                                instanceViewStatusInstance4.setTime(timeInstance5);
                                            }
                                        }
                                    }
                                    if ((bootDiagnosticsValue2 = instanceViewValue.get("bootDiagnostics")) != null && !(bootDiagnosticsValue2 instanceof NullNode)) {
                                        JsonNode serialConsoleLogBlobUriValue;
                                        BootDiagnosticsInstanceView bootDiagnosticsInstance2 = new BootDiagnosticsInstanceView();
                                        instanceViewInstance.setBootDiagnostics(bootDiagnosticsInstance2);
                                        Iterator consoleScreenshotBlobUriValue = bootDiagnosticsValue2.get("consoleScreenshotBlobUri");
                                        if (consoleScreenshotBlobUriValue != null && !(consoleScreenshotBlobUriValue instanceof NullNode)) {
                                            URI consoleScreenshotBlobUriInstance = new URI(consoleScreenshotBlobUriValue.getTextValue());
                                            bootDiagnosticsInstance2.setConsoleScreenshotBlobUri(consoleScreenshotBlobUriInstance);
                                        }
                                        if ((serialConsoleLogBlobUriValue = bootDiagnosticsValue2.get("serialConsoleLogBlobUri")) != null && !(serialConsoleLogBlobUriValue instanceof NullNode)) {
                                            URI serialConsoleLogBlobUriInstance = new URI(serialConsoleLogBlobUriValue.getTextValue());
                                            bootDiagnosticsInstance2.setSerialConsoleLogBlobUri(serialConsoleLogBlobUriInstance);
                                        }
                                    }
                                    if ((statusesArray4 = instanceViewValue.get("statuses")) != null && !(statusesArray4 instanceof NullNode)) {
                                        for (Object statusesValue4 : (ArrayNode)statusesArray4) {
                                            JsonNode timeValue6;
                                            JsonNode messageValue6;
                                            JsonNode displayStatusValue6;
                                            JsonNode levelValue6;
                                            InstanceViewStatus instanceViewStatusInstance5 = new InstanceViewStatus();
                                            instanceViewInstance.getStatuses().add(instanceViewStatusInstance5);
                                            JsonNode codeValue6 = statusesValue4.get("code");
                                            if (codeValue6 != null && !(codeValue6 instanceof NullNode)) {
                                                String codeInstance6 = codeValue6.getTextValue();
                                                instanceViewStatusInstance5.setCode(codeInstance6);
                                            }
                                            if ((levelValue6 = statusesValue4.get("level")) != null && !(levelValue6 instanceof NullNode)) {
                                                String levelInstance6 = levelValue6.getTextValue();
                                                instanceViewStatusInstance5.setLevel(levelInstance6);
                                            }
                                            if ((displayStatusValue6 = statusesValue4.get("displayStatus")) != null && !(displayStatusValue6 instanceof NullNode)) {
                                                String displayStatusInstance6 = displayStatusValue6.getTextValue();
                                                instanceViewStatusInstance5.setDisplayStatus(displayStatusInstance6);
                                            }
                                            if ((messageValue6 = statusesValue4.get("message")) != null && !(messageValue6 instanceof NullNode)) {
                                                String messageInstance6 = messageValue6.getTextValue();
                                                instanceViewStatusInstance5.setMessage(messageInstance6);
                                            }
                                            if ((timeValue6 = statusesValue4.get("time")) == null || timeValue6 instanceof NullNode) continue;
                                            Calendar timeInstance6 = DatatypeConverter.parseDateTime((String)timeValue6.getTextValue());
                                            instanceViewStatusInstance5.setTime(timeInstance6);
                                        }
                                    }
                                }
                            }
                            if ((resourcesArray = valueValue.get("resources")) != null && !(resourcesArray instanceof NullNode)) {
                                virtualMachineJsonInstance.setExtensions(new ArrayList<VirtualMachineExtension>());
                                storageProfileValue = ((ArrayNode)resourcesArray).iterator();
                                while (storageProfileValue.hasNext()) {
                                    JsonNode tagsSequenceElement;
                                    JsonNode locationValue;
                                    JsonNode typeValue5;
                                    JsonNode nameValue7;
                                    JsonNode idValue4;
                                    JsonNode resourcesValue = (JsonNode)storageProfileValue.next();
                                    VirtualMachineExtension virtualMachineExtensionJsonInstance = new VirtualMachineExtension();
                                    virtualMachineJsonInstance.getExtensions().add(virtualMachineExtensionJsonInstance);
                                    JsonNode propertiesValue3 = resourcesValue.get("properties");
                                    if (propertiesValue3 != null && !(propertiesValue3 instanceof NullNode)) {
                                        JsonNode instanceViewValue2;
                                        JsonNode provisioningStateValue2;
                                        JsonNode protectedSettingsValue;
                                        JsonNode settingsValue;
                                        JsonNode autoUpgradeMinorVersionValue;
                                        JsonNode typeHandlerVersionValue3;
                                        JsonNode typeValue3;
                                        JsonNode publisherValue3 = propertiesValue3.get("publisher");
                                        if (publisherValue3 != null && !(publisherValue3 instanceof NullNode)) {
                                            String publisherInstance3 = publisherValue3.getTextValue();
                                            virtualMachineExtensionJsonInstance.setPublisher(publisherInstance3);
                                        }
                                        if ((typeValue3 = propertiesValue3.get("type")) != null && !(typeValue3 instanceof NullNode)) {
                                            String typeInstance3 = typeValue3.getTextValue();
                                            virtualMachineExtensionJsonInstance.setExtensionType(typeInstance3);
                                        }
                                        if ((typeHandlerVersionValue3 = propertiesValue3.get("typeHandlerVersion")) != null && !(typeHandlerVersionValue3 instanceof NullNode)) {
                                            String typeHandlerVersionInstance3 = typeHandlerVersionValue3.getTextValue();
                                            virtualMachineExtensionJsonInstance.setTypeHandlerVersion(typeHandlerVersionInstance3);
                                        }
                                        if ((autoUpgradeMinorVersionValue = propertiesValue3.get("autoUpgradeMinorVersion")) != null && !(autoUpgradeMinorVersionValue instanceof NullNode)) {
                                            boolean autoUpgradeMinorVersionInstance = autoUpgradeMinorVersionValue.getBooleanValue();
                                            virtualMachineExtensionJsonInstance.setAutoUpgradeMinorVersion(autoUpgradeMinorVersionInstance);
                                        }
                                        if ((settingsValue = propertiesValue3.get("settings")) != null && !(settingsValue instanceof NullNode)) {
                                            String settingsInstance = settingsValue.getTextValue();
                                            virtualMachineExtensionJsonInstance.setSettings(settingsInstance);
                                        }
                                        if ((protectedSettingsValue = propertiesValue3.get("protectedSettings")) != null && !(protectedSettingsValue instanceof NullNode)) {
                                            String protectedSettingsInstance = protectedSettingsValue.getTextValue();
                                            virtualMachineExtensionJsonInstance.setProtectedSettings(protectedSettingsInstance);
                                        }
                                        if ((provisioningStateValue2 = propertiesValue3.get("provisioningState")) != null && !(provisioningStateValue2 instanceof NullNode)) {
                                            String provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                            virtualMachineExtensionJsonInstance.setProvisioningState(provisioningStateInstance2);
                                        }
                                        if ((instanceViewValue2 = propertiesValue3.get("instanceView")) != null && !(instanceViewValue2 instanceof NullNode)) {
                                            JsonNode statusesArray5;
                                            JsonNode substatusesArray2;
                                            JsonNode typeHandlerVersionValue4;
                                            JsonNode typeValue4;
                                            VirtualMachineExtensionInstanceView instanceViewInstance2 = new VirtualMachineExtensionInstanceView();
                                            virtualMachineExtensionJsonInstance.setInstanceView(instanceViewInstance2);
                                            JsonNode nameValue6 = instanceViewValue2.get("name");
                                            if (nameValue6 != null && !(nameValue6 instanceof NullNode)) {
                                                String nameInstance6 = nameValue6.getTextValue();
                                                instanceViewInstance2.setName(nameInstance6);
                                            }
                                            if ((typeValue4 = instanceViewValue2.get("type")) != null && !(typeValue4 instanceof NullNode)) {
                                                String typeInstance4 = typeValue4.getTextValue();
                                                instanceViewInstance2.setExtensionType(typeInstance4);
                                            }
                                            if ((typeHandlerVersionValue4 = instanceViewValue2.get("typeHandlerVersion")) != null && !(typeHandlerVersionValue4 instanceof NullNode)) {
                                                String typeHandlerVersionInstance4 = typeHandlerVersionValue4.getTextValue();
                                                instanceViewInstance2.setTypeHandlerVersion(typeHandlerVersionInstance4);
                                            }
                                            if ((substatusesArray2 = instanceViewValue2.get("substatuses")) != null && !(substatusesArray2 instanceof NullNode)) {
                                                Object statusesValue4;
                                                statusesValue4 = ((ArrayNode)substatusesArray2).iterator();
                                                while (statusesValue4.hasNext()) {
                                                    JsonNode timeValue7;
                                                    JsonNode messageValue7;
                                                    JsonNode displayStatusValue7;
                                                    JsonNode levelValue7;
                                                    JsonNode substatusesValue2 = (JsonNode)statusesValue4.next();
                                                    InstanceViewStatus instanceViewStatusInstance6 = new InstanceViewStatus();
                                                    instanceViewInstance2.getSubStatuses().add(instanceViewStatusInstance6);
                                                    JsonNode codeValue7 = substatusesValue2.get("code");
                                                    if (codeValue7 != null && !(codeValue7 instanceof NullNode)) {
                                                        String codeInstance7 = codeValue7.getTextValue();
                                                        instanceViewStatusInstance6.setCode(codeInstance7);
                                                    }
                                                    if ((levelValue7 = substatusesValue2.get("level")) != null && !(levelValue7 instanceof NullNode)) {
                                                        String levelInstance7 = levelValue7.getTextValue();
                                                        instanceViewStatusInstance6.setLevel(levelInstance7);
                                                    }
                                                    if ((displayStatusValue7 = substatusesValue2.get("displayStatus")) != null && !(displayStatusValue7 instanceof NullNode)) {
                                                        String displayStatusInstance7 = displayStatusValue7.getTextValue();
                                                        instanceViewStatusInstance6.setDisplayStatus(displayStatusInstance7);
                                                    }
                                                    if ((messageValue7 = substatusesValue2.get("message")) != null && !(messageValue7 instanceof NullNode)) {
                                                        String messageInstance7 = messageValue7.getTextValue();
                                                        instanceViewStatusInstance6.setMessage(messageInstance7);
                                                    }
                                                    if ((timeValue7 = substatusesValue2.get("time")) == null || timeValue7 instanceof NullNode) continue;
                                                    Calendar timeInstance7 = DatatypeConverter.parseDateTime((String)timeValue7.getTextValue());
                                                    instanceViewStatusInstance6.setTime(timeInstance7);
                                                }
                                            }
                                            if ((statusesArray5 = instanceViewValue2.get("statuses")) != null && !(statusesArray5 instanceof NullNode)) {
                                                for (JsonNode statusesValue5 : (ArrayNode)statusesArray5) {
                                                    JsonNode timeValue8;
                                                    JsonNode messageValue8;
                                                    JsonNode displayStatusValue8;
                                                    JsonNode levelValue8;
                                                    InstanceViewStatus instanceViewStatusInstance7 = new InstanceViewStatus();
                                                    instanceViewInstance2.getStatuses().add(instanceViewStatusInstance7);
                                                    JsonNode codeValue8 = statusesValue5.get("code");
                                                    if (codeValue8 != null && !(codeValue8 instanceof NullNode)) {
                                                        String codeInstance8 = codeValue8.getTextValue();
                                                        instanceViewStatusInstance7.setCode(codeInstance8);
                                                    }
                                                    if ((levelValue8 = statusesValue5.get("level")) != null && !(levelValue8 instanceof NullNode)) {
                                                        String levelInstance8 = levelValue8.getTextValue();
                                                        instanceViewStatusInstance7.setLevel(levelInstance8);
                                                    }
                                                    if ((displayStatusValue8 = statusesValue5.get("displayStatus")) != null && !(displayStatusValue8 instanceof NullNode)) {
                                                        String displayStatusInstance8 = displayStatusValue8.getTextValue();
                                                        instanceViewStatusInstance7.setDisplayStatus(displayStatusInstance8);
                                                    }
                                                    if ((messageValue8 = statusesValue5.get("message")) != null && !(messageValue8 instanceof NullNode)) {
                                                        String messageInstance8 = messageValue8.getTextValue();
                                                        instanceViewStatusInstance7.setMessage(messageInstance8);
                                                    }
                                                    if ((timeValue8 = statusesValue5.get("time")) == null || timeValue8 instanceof NullNode) continue;
                                                    Calendar timeInstance8 = DatatypeConverter.parseDateTime((String)timeValue8.getTextValue());
                                                    instanceViewStatusInstance7.setTime(timeInstance8);
                                                }
                                            }
                                        }
                                    }
                                    if ((idValue4 = resourcesValue.get("id")) != null && !(idValue4 instanceof NullNode)) {
                                        String idInstance4 = idValue4.getTextValue();
                                        virtualMachineExtensionJsonInstance.setId(idInstance4);
                                    }
                                    if ((nameValue7 = resourcesValue.get("name")) != null && !(nameValue7 instanceof NullNode)) {
                                        String nameInstance7 = nameValue7.getTextValue();
                                        virtualMachineExtensionJsonInstance.setName(nameInstance7);
                                    }
                                    if ((typeValue5 = resourcesValue.get("type")) != null && !(typeValue5 instanceof NullNode)) {
                                        String typeInstance5 = typeValue5.getTextValue();
                                        virtualMachineExtensionJsonInstance.setType(typeInstance5);
                                    }
                                    if ((locationValue = resourcesValue.get("location")) != null && !(locationValue instanceof NullNode)) {
                                        String locationInstance = locationValue.getTextValue();
                                        virtualMachineExtensionJsonInstance.setLocation(locationInstance);
                                    }
                                    if ((tagsSequenceElement = resourcesValue.get("tags")) == null || tagsSequenceElement instanceof NullNode) continue;
                                    Iterator itr = tagsSequenceElement.getFields();
                                    while (itr.hasNext()) {
                                        Map.Entry property = (Map.Entry)itr.next();
                                        String tagsKey = (String)property.getKey();
                                        String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                                        virtualMachineExtensionJsonInstance.getTags().put(tagsKey, tagsValue);
                                    }
                                }
                            }
                            if ((idValue5 = valueValue.get("id")) != null && !(idValue5 instanceof NullNode)) {
                                String idInstance5 = idValue5.getTextValue();
                                virtualMachineJsonInstance.setId(idInstance5);
                            }
                            if ((nameValue8 = valueValue.get("name")) != null && !(nameValue8 instanceof NullNode)) {
                                String nameInstance8 = nameValue8.getTextValue();
                                virtualMachineJsonInstance.setName(nameInstance8);
                            }
                            if ((typeValue6 = valueValue.get("type")) != null && !(typeValue6 instanceof NullNode)) {
                                String typeInstance6 = typeValue6.getTextValue();
                                virtualMachineJsonInstance.setType(typeInstance6);
                            }
                            if ((locationValue2 = valueValue.get("location")) != null && !(locationValue2 instanceof NullNode)) {
                                String locationInstance2 = locationValue2.getTextValue();
                                virtualMachineJsonInstance.setLocation(locationInstance2);
                            }
                            if ((tagsSequenceElement2 = valueValue.get("tags")) == null || tagsSequenceElement2 instanceof NullNode) continue;
                            Iterator itr2 = tagsSequenceElement2.getFields();
                            while (itr2.hasNext()) {
                                Map.Entry property2 = (Map.Entry)itr2.next();
                                String tagsKey2 = (String)property2.getKey();
                                String tagsValue2 = ((JsonNode)property2.getValue()).getTextValue();
                                virtualMachineJsonInstance.getTags().put(tagsKey2, tagsValue2);
                            }
                        }
                    }
                    if ((nextLinkValue = responseDoc.get("nextLink")) != null && !(nextLinkValue instanceof NullNode)) {
                        String nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            VirtualMachineListResponse virtualMachineListResponse = result;
            return virtualMachineListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<VirtualMachineListResponse> listAllAsync(final ListParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineListResponse>(){

            @Override
            public VirtualMachineListResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.listAll(parameters);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualMachineListResponse listAll(ListParameters parameters) throws IOException, ServiceException, URISyntaxException {
        String baseUrl;
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, ListParameters> tracingParameters = new HashMap<String, ListParameters>();
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAllAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/";
        url = url + "virtualMachines";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualMachineListResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualMachineListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString((InputStream)responseContent);
                if (!(responseDocContent == null) && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode nextLinkValue;
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && !(valueArray instanceof NullNode)) {
                        for (JsonNode valueValue : (ArrayNode)valueArray) {
                            JsonNode tagsSequenceElement2;
                            JsonNode locationValue2;
                            JsonNode typeValue6;
                            JsonNode nameValue8;
                            JsonNode idValue5;
                            JsonNode resourcesArray;
                            Object storageProfileValue;
                            JsonNode propertiesValue;
                            VirtualMachine virtualMachineJsonInstance = new VirtualMachine();
                            result.getVirtualMachines().add(virtualMachineJsonInstance);
                            JsonNode planValue = valueValue.get("plan");
                            if (planValue != null && !(planValue instanceof NullNode)) {
                                JsonNode promotionCodeValue;
                                JsonNode productValue;
                                JsonNode publisherValue;
                                Plan planInstance = new Plan();
                                virtualMachineJsonInstance.setPlan(planInstance);
                                JsonNode nameValue = planValue.get("name");
                                if (nameValue != null && !(nameValue instanceof NullNode)) {
                                    String nameInstance = nameValue.getTextValue();
                                    planInstance.setName(nameInstance);
                                }
                                if ((publisherValue = planValue.get("publisher")) != null && !(publisherValue instanceof NullNode)) {
                                    String publisherInstance = publisherValue.getTextValue();
                                    planInstance.setPublisher(publisherInstance);
                                }
                                if ((productValue = planValue.get("product")) != null && !(productValue instanceof NullNode)) {
                                    String productInstance = productValue.getTextValue();
                                    planInstance.setProduct(productInstance);
                                }
                                if ((promotionCodeValue = planValue.get("promotionCode")) != null && !(promotionCodeValue instanceof NullNode)) {
                                    String promotionCodeInstance = promotionCodeValue.getTextValue();
                                    planInstance.setPromotionCode(promotionCodeInstance);
                                }
                            }
                            if ((propertiesValue = valueValue.get("properties")) != null && !(propertiesValue instanceof NullNode)) {
                                JsonNode instanceViewValue;
                                JsonNode provisioningStateValue;
                                JsonNode availabilitySetValue;
                                JsonNode diagnosticsProfileValue;
                                JsonNode networkProfileValue;
                                Object adminPasswordValue;
                                JsonNode osProfileValue;
                                Object createOptionValue2;
                                JsonNode hardwareProfileValue = propertiesValue.get("hardwareProfile");
                                if (hardwareProfileValue != null && !(hardwareProfileValue instanceof NullNode)) {
                                    HardwareProfile hardwareProfileInstance = new HardwareProfile();
                                    virtualMachineJsonInstance.setHardwareProfile(hardwareProfileInstance);
                                    JsonNode vmSizeValue = hardwareProfileValue.get("vmSize");
                                    if (vmSizeValue != null && !(vmSizeValue instanceof NullNode)) {
                                        String vmSizeInstance = vmSizeValue.getTextValue();
                                        hardwareProfileInstance.setVirtualMachineSize(vmSizeInstance);
                                    }
                                }
                                if ((storageProfileValue = propertiesValue.get("storageProfile")) != null && !(storageProfileValue instanceof NullNode)) {
                                    JsonNode dataDisksArray;
                                    JsonNode osDiskValue;
                                    StorageProfile storageProfileInstance = new StorageProfile();
                                    virtualMachineJsonInstance.setStorageProfile(storageProfileInstance);
                                    JsonNode imageReferenceValue = storageProfileValue.get("imageReference");
                                    if (imageReferenceValue != null && !(imageReferenceValue instanceof NullNode)) {
                                        JsonNode versionValue;
                                        JsonNode skuValue;
                                        JsonNode offerValue;
                                        ImageReference imageReferenceInstance = new ImageReference();
                                        storageProfileInstance.setImageReference(imageReferenceInstance);
                                        JsonNode publisherValue2 = imageReferenceValue.get("publisher");
                                        if (publisherValue2 != null && !(publisherValue2 instanceof NullNode)) {
                                            String publisherInstance2 = publisherValue2.getTextValue();
                                            imageReferenceInstance.setPublisher(publisherInstance2);
                                        }
                                        if ((offerValue = imageReferenceValue.get("offer")) != null && !(offerValue instanceof NullNode)) {
                                            String offerInstance = offerValue.getTextValue();
                                            imageReferenceInstance.setOffer(offerInstance);
                                        }
                                        if ((skuValue = imageReferenceValue.get("sku")) != null && !(skuValue instanceof NullNode)) {
                                            String skuInstance = skuValue.getTextValue();
                                            imageReferenceInstance.setSku(skuInstance);
                                        }
                                        if ((versionValue = imageReferenceValue.get("version")) != null && !(versionValue instanceof NullNode)) {
                                            String versionInstance = versionValue.getTextValue();
                                            imageReferenceInstance.setVersion(versionInstance);
                                        }
                                    }
                                    if ((osDiskValue = storageProfileValue.get("osDisk")) != null && !(osDiskValue instanceof NullNode)) {
                                        JsonNode diskSizeGBValue;
                                        JsonNode createOptionValue;
                                        JsonNode cachingValue;
                                        JsonNode imageValue;
                                        JsonNode vhdValue;
                                        JsonNode nameValue2;
                                        OSDisk osDiskInstance = new OSDisk();
                                        storageProfileInstance.setOSDisk(osDiskInstance);
                                        Iterator osTypeValue = osDiskValue.get("osType");
                                        if (osTypeValue != null && !(osTypeValue instanceof NullNode)) {
                                            String osTypeInstance = osTypeValue.getTextValue();
                                            osDiskInstance.setOperatingSystemType(osTypeInstance);
                                        }
                                        if ((nameValue2 = osDiskValue.get("name")) != null && !(nameValue2 instanceof NullNode)) {
                                            String nameInstance2 = nameValue2.getTextValue();
                                            osDiskInstance.setName(nameInstance2);
                                        }
                                        if ((vhdValue = osDiskValue.get("vhd")) != null && !(vhdValue instanceof NullNode)) {
                                            VirtualHardDisk vhdInstance = new VirtualHardDisk();
                                            osDiskInstance.setVirtualHardDisk(vhdInstance);
                                            JsonNode uriValue = vhdValue.get("uri");
                                            if (uriValue != null && !(uriValue instanceof NullNode)) {
                                                String uriInstance = uriValue.getTextValue();
                                                vhdInstance.setUri(uriInstance);
                                            }
                                        }
                                        if ((imageValue = osDiskValue.get("image")) != null && !(imageValue instanceof NullNode)) {
                                            VirtualHardDisk imageInstance = new VirtualHardDisk();
                                            osDiskInstance.setSourceImage(imageInstance);
                                            JsonNode uriValue2 = imageValue.get("uri");
                                            if (uriValue2 != null && !(uriValue2 instanceof NullNode)) {
                                                String uriInstance2 = uriValue2.getTextValue();
                                                imageInstance.setUri(uriInstance2);
                                            }
                                        }
                                        if ((cachingValue = osDiskValue.get("caching")) != null && !(cachingValue instanceof NullNode)) {
                                            String cachingInstance = cachingValue.getTextValue();
                                            osDiskInstance.setCaching(cachingInstance);
                                        }
                                        if ((createOptionValue = osDiskValue.get("createOption")) != null && !(createOptionValue instanceof NullNode)) {
                                            String createOptionInstance = createOptionValue.getTextValue();
                                            osDiskInstance.setCreateOption(createOptionInstance);
                                        }
                                        if ((diskSizeGBValue = osDiskValue.get("diskSizeGB")) != null && !(diskSizeGBValue instanceof NullNode)) {
                                            int diskSizeGBInstance = diskSizeGBValue.getIntValue();
                                            osDiskInstance.setDiskSizeGB(diskSizeGBInstance);
                                        }
                                    }
                                    if ((dataDisksArray = storageProfileValue.get("dataDisks")) != null && !(dataDisksArray instanceof NullNode)) {
                                        for (JsonNode dataDisksValue : (ArrayNode)dataDisksArray) {
                                            JsonNode diskSizeGBValue2;
                                            JsonNode cachingValue2;
                                            JsonNode imageValue2;
                                            JsonNode vhdValue2;
                                            JsonNode nameValue3;
                                            DataDisk dataDiskInstance = new DataDisk();
                                            storageProfileInstance.getDataDisks().add(dataDiskInstance);
                                            JsonNode lunValue = dataDisksValue.get("lun");
                                            if (lunValue != null && !(lunValue instanceof NullNode)) {
                                                int lunInstance = lunValue.getIntValue();
                                                dataDiskInstance.setLun(lunInstance);
                                            }
                                            if ((nameValue3 = dataDisksValue.get("name")) != null && !(nameValue3 instanceof NullNode)) {
                                                String nameInstance3 = nameValue3.getTextValue();
                                                dataDiskInstance.setName(nameInstance3);
                                            }
                                            if ((vhdValue2 = dataDisksValue.get("vhd")) != null && !(vhdValue2 instanceof NullNode)) {
                                                VirtualHardDisk vhdInstance2 = new VirtualHardDisk();
                                                dataDiskInstance.setVirtualHardDisk(vhdInstance2);
                                                JsonNode uriValue3 = vhdValue2.get("uri");
                                                if (uriValue3 != null && !(uriValue3 instanceof NullNode)) {
                                                    String uriInstance3 = uriValue3.getTextValue();
                                                    vhdInstance2.setUri(uriInstance3);
                                                }
                                            }
                                            if ((imageValue2 = dataDisksValue.get("image")) != null && !(imageValue2 instanceof NullNode)) {
                                                VirtualHardDisk imageInstance2 = new VirtualHardDisk();
                                                dataDiskInstance.setSourceImage(imageInstance2);
                                                JsonNode uriValue4 = imageValue2.get("uri");
                                                if (uriValue4 != null && !(uriValue4 instanceof NullNode)) {
                                                    String uriInstance4 = uriValue4.getTextValue();
                                                    imageInstance2.setUri(uriInstance4);
                                                }
                                            }
                                            if ((cachingValue2 = dataDisksValue.get("caching")) != null && !(cachingValue2 instanceof NullNode)) {
                                                String cachingInstance2 = cachingValue2.getTextValue();
                                                dataDiskInstance.setCaching(cachingInstance2);
                                            }
                                            if ((createOptionValue2 = dataDisksValue.get("createOption")) != null && !(createOptionValue2 instanceof NullNode)) {
                                                String createOptionInstance2 = createOptionValue2.getTextValue();
                                                dataDiskInstance.setCreateOption(createOptionInstance2);
                                            }
                                            if ((diskSizeGBValue2 = dataDisksValue.get("diskSizeGB")) == null || diskSizeGBValue2 instanceof NullNode) continue;
                                            int diskSizeGBInstance2 = diskSizeGBValue2.getIntValue();
                                            dataDiskInstance.setDiskSizeGB(diskSizeGBInstance2);
                                        }
                                    }
                                }
                                if ((osProfileValue = propertiesValue.get("osProfile")) != null && !(osProfileValue instanceof NullNode)) {
                                    JsonNode secretsArray;
                                    JsonNode linuxConfigurationValue;
                                    JsonNode windowsConfigurationValue;
                                    JsonNode customDataValue;
                                    JsonNode adminUsernameValue;
                                    OSProfile osProfileInstance = new OSProfile();
                                    virtualMachineJsonInstance.setOSProfile(osProfileInstance);
                                    JsonNode computerNameValue = osProfileValue.get("computerName");
                                    if (computerNameValue != null && !(computerNameValue instanceof NullNode)) {
                                        String computerNameInstance = computerNameValue.getTextValue();
                                        osProfileInstance.setComputerName(computerNameInstance);
                                    }
                                    if ((adminUsernameValue = osProfileValue.get("adminUsername")) != null && !(adminUsernameValue instanceof NullNode)) {
                                        String adminUsernameInstance = adminUsernameValue.getTextValue();
                                        osProfileInstance.setAdminUsername(adminUsernameInstance);
                                    }
                                    if ((adminPasswordValue = osProfileValue.get("adminPassword")) != null && !(adminPasswordValue instanceof NullNode)) {
                                        String adminPasswordInstance = adminPasswordValue.getTextValue();
                                        osProfileInstance.setAdminPassword(adminPasswordInstance);
                                    }
                                    if ((customDataValue = osProfileValue.get("customData")) != null && !(customDataValue instanceof NullNode)) {
                                        String customDataInstance = customDataValue.getTextValue();
                                        osProfileInstance.setCustomData(customDataInstance);
                                    }
                                    if ((windowsConfigurationValue = osProfileValue.get("windowsConfiguration")) != null && !(windowsConfigurationValue instanceof NullNode)) {
                                        JsonNode winRMValue;
                                        JsonNode additionalUnattendContentArray;
                                        JsonNode timeZoneValue;
                                        JsonNode enableAutomaticUpdatesValue;
                                        WindowsConfiguration windowsConfigurationInstance = new WindowsConfiguration();
                                        osProfileInstance.setWindowsConfiguration(windowsConfigurationInstance);
                                        JsonNode provisionVMAgentValue = windowsConfigurationValue.get("provisionVMAgent");
                                        if (provisionVMAgentValue != null && !(provisionVMAgentValue instanceof NullNode)) {
                                            boolean provisionVMAgentInstance = provisionVMAgentValue.getBooleanValue();
                                            windowsConfigurationInstance.setProvisionVMAgent(provisionVMAgentInstance);
                                        }
                                        if ((enableAutomaticUpdatesValue = windowsConfigurationValue.get("enableAutomaticUpdates")) != null && !(enableAutomaticUpdatesValue instanceof NullNode)) {
                                            boolean enableAutomaticUpdatesInstance = enableAutomaticUpdatesValue.getBooleanValue();
                                            windowsConfigurationInstance.setEnableAutomaticUpdates(enableAutomaticUpdatesInstance);
                                        }
                                        if ((timeZoneValue = windowsConfigurationValue.get("timeZone")) != null && !(timeZoneValue instanceof NullNode)) {
                                            String timeZoneInstance = timeZoneValue.getTextValue();
                                            windowsConfigurationInstance.setTimeZone(timeZoneInstance);
                                        }
                                        if ((additionalUnattendContentArray = windowsConfigurationValue.get("additionalUnattendContent")) != null && !(additionalUnattendContentArray instanceof NullNode)) {
                                            createOptionValue2 = ((ArrayNode)additionalUnattendContentArray).iterator();
                                            while (createOptionValue2.hasNext()) {
                                                JsonNode contentValue;
                                                JsonNode settingNameValue;
                                                JsonNode componentNameValue;
                                                JsonNode additionalUnattendContentValue = (JsonNode)createOptionValue2.next();
                                                AdditionalUnattendContent additionalUnattendContentInstance = new AdditionalUnattendContent();
                                                windowsConfigurationInstance.getAdditionalUnattendContents().add(additionalUnattendContentInstance);
                                                JsonNode passNameValue = additionalUnattendContentValue.get("passName");
                                                if (passNameValue != null && !(passNameValue instanceof NullNode)) {
                                                    String passNameInstance = passNameValue.getTextValue();
                                                    additionalUnattendContentInstance.setPassName(passNameInstance);
                                                }
                                                if ((componentNameValue = additionalUnattendContentValue.get("componentName")) != null && !(componentNameValue instanceof NullNode)) {
                                                    String componentNameInstance = componentNameValue.getTextValue();
                                                    additionalUnattendContentInstance.setComponentName(componentNameInstance);
                                                }
                                                if ((settingNameValue = additionalUnattendContentValue.get("settingName")) != null && !(settingNameValue instanceof NullNode)) {
                                                    String settingNameInstance = settingNameValue.getTextValue();
                                                    additionalUnattendContentInstance.setSettingName(settingNameInstance);
                                                }
                                                if ((contentValue = additionalUnattendContentValue.get("content")) == null || contentValue instanceof NullNode) continue;
                                                String contentInstance = contentValue.getTextValue();
                                                additionalUnattendContentInstance.setContent(contentInstance);
                                            }
                                        }
                                        if ((winRMValue = windowsConfigurationValue.get("winRM")) != null && !(winRMValue instanceof NullNode)) {
                                            WinRMConfiguration winRMInstance = new WinRMConfiguration();
                                            windowsConfigurationInstance.setWinRMConfiguration(winRMInstance);
                                            JsonNode listenersArray = winRMValue.get("listeners");
                                            if (listenersArray != null && !(listenersArray instanceof NullNode)) {
                                                for (JsonNode listenersValue : (ArrayNode)listenersArray) {
                                                    JsonNode certificateUrlValue;
                                                    WinRMListener winRMListenerInstance = new WinRMListener();
                                                    winRMInstance.getListeners().add(winRMListenerInstance);
                                                    JsonNode protocolValue = listenersValue.get("protocol");
                                                    if (protocolValue != null && !(protocolValue instanceof NullNode)) {
                                                        String protocolInstance = protocolValue.getTextValue();
                                                        winRMListenerInstance.setProtocol(protocolInstance);
                                                    }
                                                    if ((certificateUrlValue = listenersValue.get("certificateUrl")) == null || certificateUrlValue instanceof NullNode) continue;
                                                    URI certificateUrlInstance = new URI(certificateUrlValue.getTextValue());
                                                    winRMListenerInstance.setCertificateUrl(certificateUrlInstance);
                                                }
                                            }
                                        }
                                    }
                                    if ((linuxConfigurationValue = osProfileValue.get("linuxConfiguration")) != null && !(linuxConfigurationValue instanceof NullNode)) {
                                        JsonNode sshValue;
                                        LinuxConfiguration linuxConfigurationInstance = new LinuxConfiguration();
                                        osProfileInstance.setLinuxConfiguration(linuxConfigurationInstance);
                                        Iterator disablePasswordAuthenticationValue = linuxConfigurationValue.get("disablePasswordAuthentication");
                                        if (disablePasswordAuthenticationValue != null && !(disablePasswordAuthenticationValue instanceof NullNode)) {
                                            boolean disablePasswordAuthenticationInstance = disablePasswordAuthenticationValue.getBooleanValue();
                                            linuxConfigurationInstance.setDisablePasswordAuthentication(disablePasswordAuthenticationInstance);
                                        }
                                        if ((sshValue = linuxConfigurationValue.get("ssh")) != null && !(sshValue instanceof NullNode)) {
                                            SshConfiguration sshInstance = new SshConfiguration();
                                            linuxConfigurationInstance.setSshConfiguration(sshInstance);
                                            JsonNode publicKeysArray = sshValue.get("publicKeys");
                                            if (publicKeysArray != null && !(publicKeysArray instanceof NullNode)) {
                                                for (JsonNode publicKeysValue : (ArrayNode)publicKeysArray) {
                                                    JsonNode keyDataValue;
                                                    SshPublicKey sshPublicKeyInstance = new SshPublicKey();
                                                    sshInstance.getPublicKeys().add(sshPublicKeyInstance);
                                                    JsonNode pathValue = publicKeysValue.get("path");
                                                    if (pathValue != null && !(pathValue instanceof NullNode)) {
                                                        String pathInstance = pathValue.getTextValue();
                                                        sshPublicKeyInstance.setPath(pathInstance);
                                                    }
                                                    if ((keyDataValue = publicKeysValue.get("keyData")) == null || keyDataValue instanceof NullNode) continue;
                                                    String keyDataInstance = keyDataValue.getTextValue();
                                                    sshPublicKeyInstance.setKeyData(keyDataInstance);
                                                }
                                            }
                                        }
                                    }
                                    if ((secretsArray = osProfileValue.get("secrets")) != null && !(secretsArray instanceof NullNode)) {
                                        for (JsonNode secretsValue : (ArrayNode)secretsArray) {
                                            JsonNode vaultCertificatesArray;
                                            VaultSecretGroup vaultSecretGroupInstance = new VaultSecretGroup();
                                            osProfileInstance.getSecrets().add(vaultSecretGroupInstance);
                                            JsonNode sourceVaultValue = secretsValue.get("sourceVault");
                                            if (sourceVaultValue != null && !(sourceVaultValue instanceof NullNode)) {
                                                SourceVaultReference sourceVaultInstance = new SourceVaultReference();
                                                vaultSecretGroupInstance.setSourceVault(sourceVaultInstance);
                                                Iterator idValue = sourceVaultValue.get("id");
                                                if (idValue != null && !(idValue instanceof NullNode)) {
                                                    String idInstance = idValue.getTextValue();
                                                    sourceVaultInstance.setReferenceUri(idInstance);
                                                }
                                            }
                                            if ((vaultCertificatesArray = secretsValue.get("vaultCertificates")) == null || vaultCertificatesArray instanceof NullNode) continue;
                                            for (JsonNode vaultCertificatesValue : (ArrayNode)vaultCertificatesArray) {
                                                JsonNode certificateStoreValue;
                                                VaultCertificate vaultCertificateInstance = new VaultCertificate();
                                                vaultSecretGroupInstance.getVaultCertificates().add(vaultCertificateInstance);
                                                JsonNode certificateUrlValue2 = vaultCertificatesValue.get("certificateUrl");
                                                if (certificateUrlValue2 != null && !(certificateUrlValue2 instanceof NullNode)) {
                                                    String certificateUrlInstance2 = certificateUrlValue2.getTextValue();
                                                    vaultCertificateInstance.setCertificateUrl(certificateUrlInstance2);
                                                }
                                                if ((certificateStoreValue = vaultCertificatesValue.get("certificateStore")) == null || certificateStoreValue instanceof NullNode) continue;
                                                String certificateStoreInstance = certificateStoreValue.getTextValue();
                                                vaultCertificateInstance.setCertificateStore(certificateStoreInstance);
                                            }
                                        }
                                    }
                                }
                                if ((networkProfileValue = propertiesValue.get("networkProfile")) != null && !(networkProfileValue instanceof NullNode)) {
                                    NetworkProfile networkProfileInstance = new NetworkProfile();
                                    virtualMachineJsonInstance.setNetworkProfile(networkProfileInstance);
                                    JsonNode networkInterfacesArray = networkProfileValue.get("networkInterfaces");
                                    if (networkInterfacesArray != null && !(networkInterfacesArray instanceof NullNode)) {
                                        adminPasswordValue = ((ArrayNode)networkInterfacesArray).iterator();
                                        while (adminPasswordValue.hasNext()) {
                                            JsonNode idValue2;
                                            JsonNode primaryValue;
                                            JsonNode networkInterfacesValue = (JsonNode)adminPasswordValue.next();
                                            NetworkInterfaceReference networkInterfaceReferenceJsonInstance = new NetworkInterfaceReference();
                                            networkProfileInstance.getNetworkInterfaces().add(networkInterfaceReferenceJsonInstance);
                                            JsonNode propertiesValue2 = networkInterfacesValue.get("properties");
                                            if (propertiesValue2 != null && !(propertiesValue2 instanceof NullNode) && (primaryValue = propertiesValue2.get("primary")) != null && !(primaryValue instanceof NullNode)) {
                                                boolean primaryInstance = primaryValue.getBooleanValue();
                                                networkInterfaceReferenceJsonInstance.setPrimary(primaryInstance);
                                            }
                                            if ((idValue2 = networkInterfacesValue.get("id")) == null || idValue2 instanceof NullNode) continue;
                                            String idInstance2 = idValue2.getTextValue();
                                            networkInterfaceReferenceJsonInstance.setReferenceUri(idInstance2);
                                        }
                                    }
                                }
                                if ((diagnosticsProfileValue = propertiesValue.get("diagnosticsProfile")) != null && !(diagnosticsProfileValue instanceof NullNode)) {
                                    DiagnosticsProfile diagnosticsProfileInstance = new DiagnosticsProfile();
                                    virtualMachineJsonInstance.setDiagnosticsProfile(diagnosticsProfileInstance);
                                    JsonNode bootDiagnosticsValue = diagnosticsProfileValue.get("bootDiagnostics");
                                    if (bootDiagnosticsValue != null && !(bootDiagnosticsValue instanceof NullNode)) {
                                        JsonNode storageUriValue;
                                        BootDiagnostics bootDiagnosticsInstance = new BootDiagnostics();
                                        diagnosticsProfileInstance.setBootDiagnostics(bootDiagnosticsInstance);
                                        JsonNode enabledValue = bootDiagnosticsValue.get("enabled");
                                        if (enabledValue != null && !(enabledValue instanceof NullNode)) {
                                            boolean enabledInstance = enabledValue.getBooleanValue();
                                            bootDiagnosticsInstance.setEnabled(enabledInstance);
                                        }
                                        if ((storageUriValue = bootDiagnosticsValue.get("storageUri")) != null && !(storageUriValue instanceof NullNode)) {
                                            URI storageUriInstance = new URI(storageUriValue.getTextValue());
                                            bootDiagnosticsInstance.setStorageUri(storageUriInstance);
                                        }
                                    }
                                }
                                if ((availabilitySetValue = propertiesValue.get("availabilitySet")) != null && !(availabilitySetValue instanceof NullNode)) {
                                    AvailabilitySetReference availabilitySetInstance = new AvailabilitySetReference();
                                    virtualMachineJsonInstance.setAvailabilitySetReference(availabilitySetInstance);
                                    JsonNode idValue3 = availabilitySetValue.get("id");
                                    if (idValue3 != null && !(idValue3 instanceof NullNode)) {
                                        String idInstance3 = idValue3.getTextValue();
                                        availabilitySetInstance.setReferenceUri(idInstance3);
                                    }
                                }
                                if ((provisioningStateValue = propertiesValue.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                                    String provisioningStateInstance = provisioningStateValue.getTextValue();
                                    virtualMachineJsonInstance.setProvisioningState(provisioningStateInstance);
                                }
                                if ((instanceViewValue = propertiesValue.get("instanceView")) != null && !(instanceViewValue instanceof NullNode)) {
                                    JsonNode statusesArray4;
                                    JsonNode bootDiagnosticsValue2;
                                    JsonNode extensionsArray;
                                    JsonNode disksArray;
                                    JsonNode vmAgentValue;
                                    JsonNode rdpThumbPrintValue;
                                    JsonNode platformFaultDomainValue;
                                    VirtualMachineInstanceView instanceViewInstance = new VirtualMachineInstanceView();
                                    virtualMachineJsonInstance.setInstanceView(instanceViewInstance);
                                    JsonNode platformUpdateDomainValue = instanceViewValue.get("platformUpdateDomain");
                                    if (platformUpdateDomainValue != null && !(platformUpdateDomainValue instanceof NullNode)) {
                                        int platformUpdateDomainInstance = platformUpdateDomainValue.getIntValue();
                                        instanceViewInstance.setPlatformUpdateDomain(platformUpdateDomainInstance);
                                    }
                                    if ((platformFaultDomainValue = instanceViewValue.get("platformFaultDomain")) != null && !(platformFaultDomainValue instanceof NullNode)) {
                                        int platformFaultDomainInstance = platformFaultDomainValue.getIntValue();
                                        instanceViewInstance.setPlatformFaultDomain(platformFaultDomainInstance);
                                    }
                                    if ((rdpThumbPrintValue = instanceViewValue.get("rdpThumbPrint")) != null && !(rdpThumbPrintValue instanceof NullNode)) {
                                        String rdpThumbPrintInstance = rdpThumbPrintValue.getTextValue();
                                        instanceViewInstance.setRemoteDesktopThumbprint(rdpThumbPrintInstance);
                                    }
                                    if ((vmAgentValue = instanceViewValue.get("vmAgent")) != null && !(vmAgentValue instanceof NullNode)) {
                                        JsonNode statusesArray;
                                        JsonNode extensionHandlersArray;
                                        VirtualMachineAgentInstanceView vmAgentInstance = new VirtualMachineAgentInstanceView();
                                        instanceViewInstance.setVMAgent(vmAgentInstance);
                                        Iterator vmAgentVersionValue = vmAgentValue.get("vmAgentVersion");
                                        if (vmAgentVersionValue != null && !(vmAgentVersionValue instanceof NullNode)) {
                                            String vmAgentVersionInstance = vmAgentVersionValue.getTextValue();
                                            vmAgentInstance.setVMAgentVersion(vmAgentVersionInstance);
                                        }
                                        if ((extensionHandlersArray = vmAgentValue.get("extensionHandlers")) != null && !(extensionHandlersArray instanceof NullNode)) {
                                            for (Iterator extensionHandlersValue : (ArrayNode)extensionHandlersArray) {
                                                JsonNode timeValue;
                                                JsonNode messageValue;
                                                JsonNode displayStatusValue;
                                                JsonNode levelValue;
                                                JsonNode statusValue;
                                                JsonNode typeHandlerVersionValue;
                                                VirtualMachineExtensionHandlerInstanceView virtualMachineExtensionHandlerInstanceViewInstance = new VirtualMachineExtensionHandlerInstanceView();
                                                vmAgentInstance.getExtensionHandlers().add(virtualMachineExtensionHandlerInstanceViewInstance);
                                                JsonNode typeValue = extensionHandlersValue.get("type");
                                                if (typeValue != null && !(typeValue instanceof NullNode)) {
                                                    String typeInstance = typeValue.getTextValue();
                                                    virtualMachineExtensionHandlerInstanceViewInstance.setType(typeInstance);
                                                }
                                                if ((typeHandlerVersionValue = extensionHandlersValue.get("typeHandlerVersion")) != null && !(typeHandlerVersionValue instanceof NullNode)) {
                                                    String typeHandlerVersionInstance = typeHandlerVersionValue.getTextValue();
                                                    virtualMachineExtensionHandlerInstanceViewInstance.setTypeHandlerVersion(typeHandlerVersionInstance);
                                                }
                                                if ((statusValue = extensionHandlersValue.get("status")) == null || statusValue instanceof NullNode) continue;
                                                InstanceViewStatus statusInstance = new InstanceViewStatus();
                                                virtualMachineExtensionHandlerInstanceViewInstance.setStatus(statusInstance);
                                                JsonNode codeValue = statusValue.get("code");
                                                if (codeValue != null && !(codeValue instanceof NullNode)) {
                                                    String codeInstance = codeValue.getTextValue();
                                                    statusInstance.setCode(codeInstance);
                                                }
                                                if ((levelValue = statusValue.get("level")) != null && !(levelValue instanceof NullNode)) {
                                                    String levelInstance = levelValue.getTextValue();
                                                    statusInstance.setLevel(levelInstance);
                                                }
                                                if ((displayStatusValue = statusValue.get("displayStatus")) != null && !(displayStatusValue instanceof NullNode)) {
                                                    String displayStatusInstance = displayStatusValue.getTextValue();
                                                    statusInstance.setDisplayStatus(displayStatusInstance);
                                                }
                                                if ((messageValue = statusValue.get("message")) != null && !(messageValue instanceof NullNode)) {
                                                    String messageInstance = messageValue.getTextValue();
                                                    statusInstance.setMessage(messageInstance);
                                                }
                                                if ((timeValue = statusValue.get("time")) == null || timeValue instanceof NullNode) continue;
                                                Calendar timeInstance = DatatypeConverter.parseDateTime((String)timeValue.getTextValue());
                                                statusInstance.setTime(timeInstance);
                                            }
                                        }
                                        if ((statusesArray = vmAgentValue.get("statuses")) != null && !(statusesArray instanceof NullNode)) {
                                            Iterator extensionHandlersValue;
                                            extensionHandlersValue = ((ArrayNode)statusesArray).iterator();
                                            while (extensionHandlersValue.hasNext()) {
                                                JsonNode timeValue2;
                                                JsonNode messageValue2;
                                                JsonNode displayStatusValue2;
                                                JsonNode levelValue2;
                                                JsonNode statusesValue = (JsonNode)extensionHandlersValue.next();
                                                InstanceViewStatus instanceViewStatusInstance = new InstanceViewStatus();
                                                vmAgentInstance.getStatuses().add(instanceViewStatusInstance);
                                                JsonNode codeValue2 = statusesValue.get("code");
                                                if (codeValue2 != null && !(codeValue2 instanceof NullNode)) {
                                                    String codeInstance2 = codeValue2.getTextValue();
                                                    instanceViewStatusInstance.setCode(codeInstance2);
                                                }
                                                if ((levelValue2 = statusesValue.get("level")) != null && !(levelValue2 instanceof NullNode)) {
                                                    String levelInstance2 = levelValue2.getTextValue();
                                                    instanceViewStatusInstance.setLevel(levelInstance2);
                                                }
                                                if ((displayStatusValue2 = statusesValue.get("displayStatus")) != null && !(displayStatusValue2 instanceof NullNode)) {
                                                    String displayStatusInstance2 = displayStatusValue2.getTextValue();
                                                    instanceViewStatusInstance.setDisplayStatus(displayStatusInstance2);
                                                }
                                                if ((messageValue2 = statusesValue.get("message")) != null && !(messageValue2 instanceof NullNode)) {
                                                    String messageInstance2 = messageValue2.getTextValue();
                                                    instanceViewStatusInstance.setMessage(messageInstance2);
                                                }
                                                if ((timeValue2 = statusesValue.get("time")) == null || timeValue2 instanceof NullNode) continue;
                                                Calendar timeInstance2 = DatatypeConverter.parseDateTime((String)timeValue2.getTextValue());
                                                instanceViewStatusInstance.setTime(timeInstance2);
                                            }
                                        }
                                    }
                                    if ((disksArray = instanceViewValue.get("disks")) != null && !(disksArray instanceof NullNode)) {
                                        for (Iterator disksValue : (ArrayNode)disksArray) {
                                            JsonNode statusesArray2;
                                            DiskInstanceView diskInstanceViewInstance = new DiskInstanceView();
                                            instanceViewInstance.getDisks().add(diskInstanceViewInstance);
                                            JsonNode nameValue4 = disksValue.get("name");
                                            if (nameValue4 != null && !(nameValue4 instanceof NullNode)) {
                                                String nameInstance4 = nameValue4.getTextValue();
                                                diskInstanceViewInstance.setName(nameInstance4);
                                            }
                                            if ((statusesArray2 = disksValue.get("statuses")) == null || statusesArray2 instanceof NullNode) continue;
                                            for (JsonNode statusesValue2 : (ArrayNode)statusesArray2) {
                                                JsonNode timeValue3;
                                                JsonNode messageValue3;
                                                JsonNode displayStatusValue3;
                                                JsonNode levelValue3;
                                                InstanceViewStatus instanceViewStatusInstance2 = new InstanceViewStatus();
                                                diskInstanceViewInstance.getStatuses().add(instanceViewStatusInstance2);
                                                Iterator codeValue3 = statusesValue2.get("code");
                                                if (codeValue3 != null && !(codeValue3 instanceof NullNode)) {
                                                    String codeInstance3 = codeValue3.getTextValue();
                                                    instanceViewStatusInstance2.setCode(codeInstance3);
                                                }
                                                if ((levelValue3 = statusesValue2.get("level")) != null && !(levelValue3 instanceof NullNode)) {
                                                    String levelInstance3 = levelValue3.getTextValue();
                                                    instanceViewStatusInstance2.setLevel(levelInstance3);
                                                }
                                                if ((displayStatusValue3 = statusesValue2.get("displayStatus")) != null && !(displayStatusValue3 instanceof NullNode)) {
                                                    String displayStatusInstance3 = displayStatusValue3.getTextValue();
                                                    instanceViewStatusInstance2.setDisplayStatus(displayStatusInstance3);
                                                }
                                                if ((messageValue3 = statusesValue2.get("message")) != null && !(messageValue3 instanceof NullNode)) {
                                                    String messageInstance3 = messageValue3.getTextValue();
                                                    instanceViewStatusInstance2.setMessage(messageInstance3);
                                                }
                                                if ((timeValue3 = statusesValue2.get("time")) == null || timeValue3 instanceof NullNode) continue;
                                                Calendar timeInstance3 = DatatypeConverter.parseDateTime((String)timeValue3.getTextValue());
                                                instanceViewStatusInstance2.setTime(timeInstance3);
                                            }
                                        }
                                    }
                                    if ((extensionsArray = instanceViewValue.get("extensions")) != null && !(extensionsArray instanceof NullNode)) {
                                        Iterator disksValue;
                                        disksValue = ((ArrayNode)extensionsArray).iterator();
                                        while (disksValue.hasNext()) {
                                            JsonNode statusesArray3;
                                            Iterator substatusesValue2;
                                            JsonNode substatusesArray;
                                            JsonNode typeHandlerVersionValue2;
                                            JsonNode typeValue2;
                                            JsonNode extensionsValue = (JsonNode)disksValue.next();
                                            VirtualMachineExtensionInstanceView virtualMachineExtensionInstanceViewInstance = new VirtualMachineExtensionInstanceView();
                                            instanceViewInstance.getExtensions().add(virtualMachineExtensionInstanceViewInstance);
                                            JsonNode nameValue5 = extensionsValue.get("name");
                                            if (nameValue5 != null && !(nameValue5 instanceof NullNode)) {
                                                String nameInstance5 = nameValue5.getTextValue();
                                                virtualMachineExtensionInstanceViewInstance.setName(nameInstance5);
                                            }
                                            if ((typeValue2 = extensionsValue.get("type")) != null && !(typeValue2 instanceof NullNode)) {
                                                String typeInstance2 = typeValue2.getTextValue();
                                                virtualMachineExtensionInstanceViewInstance.setExtensionType(typeInstance2);
                                            }
                                            if ((typeHandlerVersionValue2 = extensionsValue.get("typeHandlerVersion")) != null && !(typeHandlerVersionValue2 instanceof NullNode)) {
                                                String typeHandlerVersionInstance2 = typeHandlerVersionValue2.getTextValue();
                                                virtualMachineExtensionInstanceViewInstance.setTypeHandlerVersion(typeHandlerVersionInstance2);
                                            }
                                            if ((substatusesArray = extensionsValue.get("substatuses")) != null && !(substatusesArray instanceof NullNode)) {
                                                for (Iterator substatusesValue2 : (ArrayNode)substatusesArray) {
                                                    JsonNode timeValue4;
                                                    JsonNode messageValue4;
                                                    JsonNode displayStatusValue4;
                                                    JsonNode levelValue4;
                                                    InstanceViewStatus instanceViewStatusInstance3 = new InstanceViewStatus();
                                                    virtualMachineExtensionInstanceViewInstance.getSubStatuses().add(instanceViewStatusInstance3);
                                                    JsonNode codeValue4 = substatusesValue2.get("code");
                                                    if (codeValue4 != null && !(codeValue4 instanceof NullNode)) {
                                                        String codeInstance4 = codeValue4.getTextValue();
                                                        instanceViewStatusInstance3.setCode(codeInstance4);
                                                    }
                                                    if ((levelValue4 = substatusesValue2.get("level")) != null && !(levelValue4 instanceof NullNode)) {
                                                        String levelInstance4 = levelValue4.getTextValue();
                                                        instanceViewStatusInstance3.setLevel(levelInstance4);
                                                    }
                                                    if ((displayStatusValue4 = substatusesValue2.get("displayStatus")) != null && !(displayStatusValue4 instanceof NullNode)) {
                                                        String displayStatusInstance4 = displayStatusValue4.getTextValue();
                                                        instanceViewStatusInstance3.setDisplayStatus(displayStatusInstance4);
                                                    }
                                                    if ((messageValue4 = substatusesValue2.get("message")) != null && !(messageValue4 instanceof NullNode)) {
                                                        String messageInstance4 = messageValue4.getTextValue();
                                                        instanceViewStatusInstance3.setMessage(messageInstance4);
                                                    }
                                                    if ((timeValue4 = substatusesValue2.get("time")) == null || timeValue4 instanceof NullNode) continue;
                                                    Calendar timeInstance4 = DatatypeConverter.parseDateTime((String)timeValue4.getTextValue());
                                                    instanceViewStatusInstance3.setTime(timeInstance4);
                                                }
                                            }
                                            if ((statusesArray3 = extensionsValue.get("statuses")) == null || statusesArray3 instanceof NullNode) continue;
                                            substatusesValue2 = ((ArrayNode)statusesArray3).iterator();
                                            while (substatusesValue2.hasNext()) {
                                                JsonNode timeValue5;
                                                JsonNode messageValue5;
                                                JsonNode displayStatusValue5;
                                                JsonNode levelValue5;
                                                JsonNode statusesValue3 = (JsonNode)substatusesValue2.next();
                                                InstanceViewStatus instanceViewStatusInstance4 = new InstanceViewStatus();
                                                virtualMachineExtensionInstanceViewInstance.getStatuses().add(instanceViewStatusInstance4);
                                                JsonNode codeValue5 = statusesValue3.get("code");
                                                if (codeValue5 != null && !(codeValue5 instanceof NullNode)) {
                                                    String codeInstance5 = codeValue5.getTextValue();
                                                    instanceViewStatusInstance4.setCode(codeInstance5);
                                                }
                                                if ((levelValue5 = statusesValue3.get("level")) != null && !(levelValue5 instanceof NullNode)) {
                                                    String levelInstance5 = levelValue5.getTextValue();
                                                    instanceViewStatusInstance4.setLevel(levelInstance5);
                                                }
                                                if ((displayStatusValue5 = statusesValue3.get("displayStatus")) != null && !(displayStatusValue5 instanceof NullNode)) {
                                                    String displayStatusInstance5 = displayStatusValue5.getTextValue();
                                                    instanceViewStatusInstance4.setDisplayStatus(displayStatusInstance5);
                                                }
                                                if ((messageValue5 = statusesValue3.get("message")) != null && !(messageValue5 instanceof NullNode)) {
                                                    String messageInstance5 = messageValue5.getTextValue();
                                                    instanceViewStatusInstance4.setMessage(messageInstance5);
                                                }
                                                if ((timeValue5 = statusesValue3.get("time")) == null || timeValue5 instanceof NullNode) continue;
                                                Calendar timeInstance5 = DatatypeConverter.parseDateTime((String)timeValue5.getTextValue());
                                                instanceViewStatusInstance4.setTime(timeInstance5);
                                            }
                                        }
                                    }
                                    if ((bootDiagnosticsValue2 = instanceViewValue.get("bootDiagnostics")) != null && !(bootDiagnosticsValue2 instanceof NullNode)) {
                                        JsonNode serialConsoleLogBlobUriValue;
                                        BootDiagnosticsInstanceView bootDiagnosticsInstance2 = new BootDiagnosticsInstanceView();
                                        instanceViewInstance.setBootDiagnostics(bootDiagnosticsInstance2);
                                        Iterator consoleScreenshotBlobUriValue = bootDiagnosticsValue2.get("consoleScreenshotBlobUri");
                                        if (consoleScreenshotBlobUriValue != null && !(consoleScreenshotBlobUriValue instanceof NullNode)) {
                                            URI consoleScreenshotBlobUriInstance = new URI(consoleScreenshotBlobUriValue.getTextValue());
                                            bootDiagnosticsInstance2.setConsoleScreenshotBlobUri(consoleScreenshotBlobUriInstance);
                                        }
                                        if ((serialConsoleLogBlobUriValue = bootDiagnosticsValue2.get("serialConsoleLogBlobUri")) != null && !(serialConsoleLogBlobUriValue instanceof NullNode)) {
                                            URI serialConsoleLogBlobUriInstance = new URI(serialConsoleLogBlobUriValue.getTextValue());
                                            bootDiagnosticsInstance2.setSerialConsoleLogBlobUri(serialConsoleLogBlobUriInstance);
                                        }
                                    }
                                    if ((statusesArray4 = instanceViewValue.get("statuses")) != null && !(statusesArray4 instanceof NullNode)) {
                                        for (Object statusesValue4 : (ArrayNode)statusesArray4) {
                                            JsonNode timeValue6;
                                            JsonNode messageValue6;
                                            JsonNode displayStatusValue6;
                                            JsonNode levelValue6;
                                            InstanceViewStatus instanceViewStatusInstance5 = new InstanceViewStatus();
                                            instanceViewInstance.getStatuses().add(instanceViewStatusInstance5);
                                            JsonNode codeValue6 = statusesValue4.get("code");
                                            if (codeValue6 != null && !(codeValue6 instanceof NullNode)) {
                                                String codeInstance6 = codeValue6.getTextValue();
                                                instanceViewStatusInstance5.setCode(codeInstance6);
                                            }
                                            if ((levelValue6 = statusesValue4.get("level")) != null && !(levelValue6 instanceof NullNode)) {
                                                String levelInstance6 = levelValue6.getTextValue();
                                                instanceViewStatusInstance5.setLevel(levelInstance6);
                                            }
                                            if ((displayStatusValue6 = statusesValue4.get("displayStatus")) != null && !(displayStatusValue6 instanceof NullNode)) {
                                                String displayStatusInstance6 = displayStatusValue6.getTextValue();
                                                instanceViewStatusInstance5.setDisplayStatus(displayStatusInstance6);
                                            }
                                            if ((messageValue6 = statusesValue4.get("message")) != null && !(messageValue6 instanceof NullNode)) {
                                                String messageInstance6 = messageValue6.getTextValue();
                                                instanceViewStatusInstance5.setMessage(messageInstance6);
                                            }
                                            if ((timeValue6 = statusesValue4.get("time")) == null || timeValue6 instanceof NullNode) continue;
                                            Calendar timeInstance6 = DatatypeConverter.parseDateTime((String)timeValue6.getTextValue());
                                            instanceViewStatusInstance5.setTime(timeInstance6);
                                        }
                                    }
                                }
                            }
                            if ((resourcesArray = valueValue.get("resources")) != null && !(resourcesArray instanceof NullNode)) {
                                virtualMachineJsonInstance.setExtensions(new ArrayList<VirtualMachineExtension>());
                                storageProfileValue = ((ArrayNode)resourcesArray).iterator();
                                while (storageProfileValue.hasNext()) {
                                    JsonNode tagsSequenceElement;
                                    JsonNode locationValue;
                                    JsonNode typeValue5;
                                    JsonNode nameValue7;
                                    JsonNode idValue4;
                                    JsonNode resourcesValue = (JsonNode)storageProfileValue.next();
                                    VirtualMachineExtension virtualMachineExtensionJsonInstance = new VirtualMachineExtension();
                                    virtualMachineJsonInstance.getExtensions().add(virtualMachineExtensionJsonInstance);
                                    JsonNode propertiesValue3 = resourcesValue.get("properties");
                                    if (propertiesValue3 != null && !(propertiesValue3 instanceof NullNode)) {
                                        JsonNode instanceViewValue2;
                                        JsonNode provisioningStateValue2;
                                        JsonNode protectedSettingsValue;
                                        JsonNode settingsValue;
                                        JsonNode autoUpgradeMinorVersionValue;
                                        JsonNode typeHandlerVersionValue3;
                                        JsonNode typeValue3;
                                        JsonNode publisherValue3 = propertiesValue3.get("publisher");
                                        if (publisherValue3 != null && !(publisherValue3 instanceof NullNode)) {
                                            String publisherInstance3 = publisherValue3.getTextValue();
                                            virtualMachineExtensionJsonInstance.setPublisher(publisherInstance3);
                                        }
                                        if ((typeValue3 = propertiesValue3.get("type")) != null && !(typeValue3 instanceof NullNode)) {
                                            String typeInstance3 = typeValue3.getTextValue();
                                            virtualMachineExtensionJsonInstance.setExtensionType(typeInstance3);
                                        }
                                        if ((typeHandlerVersionValue3 = propertiesValue3.get("typeHandlerVersion")) != null && !(typeHandlerVersionValue3 instanceof NullNode)) {
                                            String typeHandlerVersionInstance3 = typeHandlerVersionValue3.getTextValue();
                                            virtualMachineExtensionJsonInstance.setTypeHandlerVersion(typeHandlerVersionInstance3);
                                        }
                                        if ((autoUpgradeMinorVersionValue = propertiesValue3.get("autoUpgradeMinorVersion")) != null && !(autoUpgradeMinorVersionValue instanceof NullNode)) {
                                            boolean autoUpgradeMinorVersionInstance = autoUpgradeMinorVersionValue.getBooleanValue();
                                            virtualMachineExtensionJsonInstance.setAutoUpgradeMinorVersion(autoUpgradeMinorVersionInstance);
                                        }
                                        if ((settingsValue = propertiesValue3.get("settings")) != null && !(settingsValue instanceof NullNode)) {
                                            String settingsInstance = settingsValue.getTextValue();
                                            virtualMachineExtensionJsonInstance.setSettings(settingsInstance);
                                        }
                                        if ((protectedSettingsValue = propertiesValue3.get("protectedSettings")) != null && !(protectedSettingsValue instanceof NullNode)) {
                                            String protectedSettingsInstance = protectedSettingsValue.getTextValue();
                                            virtualMachineExtensionJsonInstance.setProtectedSettings(protectedSettingsInstance);
                                        }
                                        if ((provisioningStateValue2 = propertiesValue3.get("provisioningState")) != null && !(provisioningStateValue2 instanceof NullNode)) {
                                            String provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                            virtualMachineExtensionJsonInstance.setProvisioningState(provisioningStateInstance2);
                                        }
                                        if ((instanceViewValue2 = propertiesValue3.get("instanceView")) != null && !(instanceViewValue2 instanceof NullNode)) {
                                            JsonNode statusesArray5;
                                            JsonNode substatusesArray2;
                                            JsonNode typeHandlerVersionValue4;
                                            JsonNode typeValue4;
                                            VirtualMachineExtensionInstanceView instanceViewInstance2 = new VirtualMachineExtensionInstanceView();
                                            virtualMachineExtensionJsonInstance.setInstanceView(instanceViewInstance2);
                                            JsonNode nameValue6 = instanceViewValue2.get("name");
                                            if (nameValue6 != null && !(nameValue6 instanceof NullNode)) {
                                                String nameInstance6 = nameValue6.getTextValue();
                                                instanceViewInstance2.setName(nameInstance6);
                                            }
                                            if ((typeValue4 = instanceViewValue2.get("type")) != null && !(typeValue4 instanceof NullNode)) {
                                                String typeInstance4 = typeValue4.getTextValue();
                                                instanceViewInstance2.setExtensionType(typeInstance4);
                                            }
                                            if ((typeHandlerVersionValue4 = instanceViewValue2.get("typeHandlerVersion")) != null && !(typeHandlerVersionValue4 instanceof NullNode)) {
                                                String typeHandlerVersionInstance4 = typeHandlerVersionValue4.getTextValue();
                                                instanceViewInstance2.setTypeHandlerVersion(typeHandlerVersionInstance4);
                                            }
                                            if ((substatusesArray2 = instanceViewValue2.get("substatuses")) != null && !(substatusesArray2 instanceof NullNode)) {
                                                Object statusesValue4;
                                                statusesValue4 = ((ArrayNode)substatusesArray2).iterator();
                                                while (statusesValue4.hasNext()) {
                                                    JsonNode timeValue7;
                                                    JsonNode messageValue7;
                                                    JsonNode displayStatusValue7;
                                                    JsonNode levelValue7;
                                                    JsonNode substatusesValue2 = (JsonNode)statusesValue4.next();
                                                    InstanceViewStatus instanceViewStatusInstance6 = new InstanceViewStatus();
                                                    instanceViewInstance2.getSubStatuses().add(instanceViewStatusInstance6);
                                                    JsonNode codeValue7 = substatusesValue2.get("code");
                                                    if (codeValue7 != null && !(codeValue7 instanceof NullNode)) {
                                                        String codeInstance7 = codeValue7.getTextValue();
                                                        instanceViewStatusInstance6.setCode(codeInstance7);
                                                    }
                                                    if ((levelValue7 = substatusesValue2.get("level")) != null && !(levelValue7 instanceof NullNode)) {
                                                        String levelInstance7 = levelValue7.getTextValue();
                                                        instanceViewStatusInstance6.setLevel(levelInstance7);
                                                    }
                                                    if ((displayStatusValue7 = substatusesValue2.get("displayStatus")) != null && !(displayStatusValue7 instanceof NullNode)) {
                                                        String displayStatusInstance7 = displayStatusValue7.getTextValue();
                                                        instanceViewStatusInstance6.setDisplayStatus(displayStatusInstance7);
                                                    }
                                                    if ((messageValue7 = substatusesValue2.get("message")) != null && !(messageValue7 instanceof NullNode)) {
                                                        String messageInstance7 = messageValue7.getTextValue();
                                                        instanceViewStatusInstance6.setMessage(messageInstance7);
                                                    }
                                                    if ((timeValue7 = substatusesValue2.get("time")) == null || timeValue7 instanceof NullNode) continue;
                                                    Calendar timeInstance7 = DatatypeConverter.parseDateTime((String)timeValue7.getTextValue());
                                                    instanceViewStatusInstance6.setTime(timeInstance7);
                                                }
                                            }
                                            if ((statusesArray5 = instanceViewValue2.get("statuses")) != null && !(statusesArray5 instanceof NullNode)) {
                                                for (JsonNode statusesValue5 : (ArrayNode)statusesArray5) {
                                                    JsonNode timeValue8;
                                                    JsonNode messageValue8;
                                                    JsonNode displayStatusValue8;
                                                    JsonNode levelValue8;
                                                    InstanceViewStatus instanceViewStatusInstance7 = new InstanceViewStatus();
                                                    instanceViewInstance2.getStatuses().add(instanceViewStatusInstance7);
                                                    JsonNode codeValue8 = statusesValue5.get("code");
                                                    if (codeValue8 != null && !(codeValue8 instanceof NullNode)) {
                                                        String codeInstance8 = codeValue8.getTextValue();
                                                        instanceViewStatusInstance7.setCode(codeInstance8);
                                                    }
                                                    if ((levelValue8 = statusesValue5.get("level")) != null && !(levelValue8 instanceof NullNode)) {
                                                        String levelInstance8 = levelValue8.getTextValue();
                                                        instanceViewStatusInstance7.setLevel(levelInstance8);
                                                    }
                                                    if ((displayStatusValue8 = statusesValue5.get("displayStatus")) != null && !(displayStatusValue8 instanceof NullNode)) {
                                                        String displayStatusInstance8 = displayStatusValue8.getTextValue();
                                                        instanceViewStatusInstance7.setDisplayStatus(displayStatusInstance8);
                                                    }
                                                    if ((messageValue8 = statusesValue5.get("message")) != null && !(messageValue8 instanceof NullNode)) {
                                                        String messageInstance8 = messageValue8.getTextValue();
                                                        instanceViewStatusInstance7.setMessage(messageInstance8);
                                                    }
                                                    if ((timeValue8 = statusesValue5.get("time")) == null || timeValue8 instanceof NullNode) continue;
                                                    Calendar timeInstance8 = DatatypeConverter.parseDateTime((String)timeValue8.getTextValue());
                                                    instanceViewStatusInstance7.setTime(timeInstance8);
                                                }
                                            }
                                        }
                                    }
                                    if ((idValue4 = resourcesValue.get("id")) != null && !(idValue4 instanceof NullNode)) {
                                        String idInstance4 = idValue4.getTextValue();
                                        virtualMachineExtensionJsonInstance.setId(idInstance4);
                                    }
                                    if ((nameValue7 = resourcesValue.get("name")) != null && !(nameValue7 instanceof NullNode)) {
                                        String nameInstance7 = nameValue7.getTextValue();
                                        virtualMachineExtensionJsonInstance.setName(nameInstance7);
                                    }
                                    if ((typeValue5 = resourcesValue.get("type")) != null && !(typeValue5 instanceof NullNode)) {
                                        String typeInstance5 = typeValue5.getTextValue();
                                        virtualMachineExtensionJsonInstance.setType(typeInstance5);
                                    }
                                    if ((locationValue = resourcesValue.get("location")) != null && !(locationValue instanceof NullNode)) {
                                        String locationInstance = locationValue.getTextValue();
                                        virtualMachineExtensionJsonInstance.setLocation(locationInstance);
                                    }
                                    if ((tagsSequenceElement = resourcesValue.get("tags")) == null || tagsSequenceElement instanceof NullNode) continue;
                                    Iterator itr = tagsSequenceElement.getFields();
                                    while (itr.hasNext()) {
                                        Map.Entry property = (Map.Entry)itr.next();
                                        String tagsKey = (String)property.getKey();
                                        String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                                        virtualMachineExtensionJsonInstance.getTags().put(tagsKey, tagsValue);
                                    }
                                }
                            }
                            if ((idValue5 = valueValue.get("id")) != null && !(idValue5 instanceof NullNode)) {
                                String idInstance5 = idValue5.getTextValue();
                                virtualMachineJsonInstance.setId(idInstance5);
                            }
                            if ((nameValue8 = valueValue.get("name")) != null && !(nameValue8 instanceof NullNode)) {
                                String nameInstance8 = nameValue8.getTextValue();
                                virtualMachineJsonInstance.setName(nameInstance8);
                            }
                            if ((typeValue6 = valueValue.get("type")) != null && !(typeValue6 instanceof NullNode)) {
                                String typeInstance6 = typeValue6.getTextValue();
                                virtualMachineJsonInstance.setType(typeInstance6);
                            }
                            if ((locationValue2 = valueValue.get("location")) != null && !(locationValue2 instanceof NullNode)) {
                                String locationInstance2 = locationValue2.getTextValue();
                                virtualMachineJsonInstance.setLocation(locationInstance2);
                            }
                            if ((tagsSequenceElement2 = valueValue.get("tags")) == null || tagsSequenceElement2 instanceof NullNode) continue;
                            Iterator itr2 = tagsSequenceElement2.getFields();
                            while (itr2.hasNext()) {
                                Map.Entry property2 = (Map.Entry)itr2.next();
                                String tagsKey2 = (String)property2.getKey();
                                String tagsValue2 = ((JsonNode)property2.getValue()).getTextValue();
                                virtualMachineJsonInstance.getTags().put(tagsKey2, tagsValue2);
                            }
                        }
                    }
                    if ((nextLinkValue = responseDoc.get("nextLink")) != null && !(nextLinkValue instanceof NullNode)) {
                        String nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            VirtualMachineListResponse virtualMachineListResponse = result;
            return virtualMachineListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<VirtualMachineSizeListResponse> listAvailableSizesAsync(final String resourceGroupName, final String vmName) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineSizeListResponse>(){

            @Override
            public VirtualMachineSizeListResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.listAvailableSizes(resourceGroupName, vmName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualMachineSizeListResponse listAvailableSizes(String resourceGroupName, String vmName) throws IOException, ServiceException {
        String baseUrl;
        if (resourceGroupName == null) {
            throw new NullPointerException("resourceGroupName");
        }
        if (vmName == null) {
            throw new NullPointerException("vmName");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("vmName", vmName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listAvailableSizesAsync", tracingParameters);
        }
        String url = "";
        url = url + "/subscriptions/";
        if (this.getClient().getCredentials().getSubscriptionId() != null) {
            url = url + URLEncoder.encode(this.getClient().getCredentials().getSubscriptionId(), "UTF-8");
        }
        url = url + "/resourceGroups/";
        url = url + URLEncoder.encode(resourceGroupName, "UTF-8");
        url = url + "/providers/";
        url = url + "Microsoft.Compute";
        url = url + "/";
        url = url + "virtualMachines";
        url = url + "/";
        url = url + URLEncoder.encode(vmName, "UTF-8");
        url = url + "/vmSizes";
        ArrayList<String> queryParameters = new ArrayList<String>();
        queryParameters.add("api-version=2015-06-15");
        if (queryParameters.size() > 0) {
            url = url + "?" + CollectionStringBuilder.join(queryParameters, (String)"&");
        }
        if ((baseUrl = this.getClient().getBaseUri().toString()).charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1 + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualMachineSizeListResponse result = null;
            if (statusCode == 200) {
                JsonNode valueArray;
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualMachineSizeListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString((InputStream)responseContent);
                if (!(responseDocContent == null) && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode) && (valueArray = responseDoc.get("value")) != null && !(valueArray instanceof NullNode)) {
                    for (JsonNode valueValue : (ArrayNode)valueArray) {
                        JsonNode maxDataDiskCountValue;
                        JsonNode memoryInMBValue;
                        JsonNode resourceDiskSizeInMBValue;
                        JsonNode osDiskSizeInMBValue;
                        JsonNode numberOfCoresValue;
                        VirtualMachineSize virtualMachineSizeInstance = new VirtualMachineSize();
                        result.getVirtualMachineSizes().add(virtualMachineSizeInstance);
                        JsonNode nameValue = valueValue.get("name");
                        if (nameValue != null && !(nameValue instanceof NullNode)) {
                            String nameInstance = nameValue.getTextValue();
                            virtualMachineSizeInstance.setName(nameInstance);
                        }
                        if ((numberOfCoresValue = valueValue.get("numberOfCores")) != null && !(numberOfCoresValue instanceof NullNode)) {
                            int numberOfCoresInstance = numberOfCoresValue.getIntValue();
                            virtualMachineSizeInstance.setNumberOfCores(numberOfCoresInstance);
                        }
                        if ((osDiskSizeInMBValue = valueValue.get("osDiskSizeInMB")) != null && !(osDiskSizeInMBValue instanceof NullNode)) {
                            int osDiskSizeInMBInstance = osDiskSizeInMBValue.getIntValue();
                            virtualMachineSizeInstance.setOSDiskSizeInMB(osDiskSizeInMBInstance);
                        }
                        if ((resourceDiskSizeInMBValue = valueValue.get("resourceDiskSizeInMB")) != null && !(resourceDiskSizeInMBValue instanceof NullNode)) {
                            int resourceDiskSizeInMBInstance = resourceDiskSizeInMBValue.getIntValue();
                            virtualMachineSizeInstance.setResourceDiskSizeInMB(resourceDiskSizeInMBInstance);
                        }
                        if ((memoryInMBValue = valueValue.get("memoryInMB")) != null && !(memoryInMBValue instanceof NullNode)) {
                            int memoryInMBInstance = memoryInMBValue.getIntValue();
                            virtualMachineSizeInstance.setMemoryInMB(memoryInMBInstance);
                        }
                        if ((maxDataDiskCountValue = valueValue.get("maxDataDiskCount")) == null || maxDataDiskCountValue instanceof NullNode) continue;
                        int maxDataDiskCountInstance = maxDataDiskCountValue.getIntValue();
                        virtualMachineSizeInstance.setMaxDataDiskCount(maxDataDiskCountInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)result);
            }
            VirtualMachineSizeListResponse virtualMachineSizeListResponse = result;
            return virtualMachineSizeListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<VirtualMachineListResponse> listNextAsync(final String nextLink) {
        return this.getClient().getExecutorService().submit(new Callable<VirtualMachineListResponse>(){

            @Override
            public VirtualMachineListResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.listNext(nextLink);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VirtualMachineListResponse listNext(String nextLink) throws IOException, ServiceException, URISyntaxException {
        if (nextLink == null) {
            throw new NullPointerException("nextLink");
        }
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("nextLink", nextLink);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"listNextAsync", tracingParameters);
        }
        String url = "";
        url = url + nextLink;
        url = url.replace(" ", "%20");
        HttpGet httpRequest = new HttpGet(url);
        httpRequest.setHeader("Content-Type", "application/json; charset=utf-8");
        CloseableHttpResponse httpResponse = null;
        try {
            int statusCode;
            if (shouldTrace) {
                CloudTracing.sendRequest((String)invocationId, (HttpRequest)httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute((HttpUriRequest)httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse((String)invocationId, (HttpResponse)httpResponse);
            }
            if ((statusCode = httpResponse.getStatusLine().getStatusCode()) != 200) {
                ServiceException ex = ServiceException.createFromJson((HttpRequest)httpRequest, null, (HttpResponse)httpResponse, (HttpEntity)httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error((String)invocationId, (Exception)ex);
                }
                throw ex;
            }
            VirtualMachineListResponse result = null;
            if (statusCode == 200) {
                InputStream responseContent = httpResponse.getEntity().getContent();
                result = new VirtualMachineListResponse();
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode responseDoc = null;
                String responseDocContent = IOUtils.toString((InputStream)responseContent);
                if (!(responseDocContent == null) && responseDocContent.length() > 0) {
                    responseDoc = objectMapper.readTree(responseDocContent);
                }
                if (responseDoc != null && !(responseDoc instanceof NullNode)) {
                    JsonNode nextLinkValue;
                    JsonNode valueArray = responseDoc.get("value");
                    if (valueArray != null && !(valueArray instanceof NullNode)) {
                        for (JsonNode valueValue : (ArrayNode)valueArray) {
                            JsonNode tagsSequenceElement2;
                            JsonNode locationValue2;
                            JsonNode typeValue6;
                            JsonNode nameValue8;
                            JsonNode idValue5;
                            JsonNode resourcesArray;
                            Object storageProfileValue;
                            JsonNode propertiesValue;
                            VirtualMachine virtualMachineJsonInstance = new VirtualMachine();
                            result.getVirtualMachines().add(virtualMachineJsonInstance);
                            JsonNode planValue = valueValue.get("plan");
                            if (planValue != null && !(planValue instanceof NullNode)) {
                                JsonNode promotionCodeValue;
                                JsonNode productValue;
                                JsonNode publisherValue;
                                Plan planInstance = new Plan();
                                virtualMachineJsonInstance.setPlan(planInstance);
                                JsonNode nameValue = planValue.get("name");
                                if (nameValue != null && !(nameValue instanceof NullNode)) {
                                    String nameInstance = nameValue.getTextValue();
                                    planInstance.setName(nameInstance);
                                }
                                if ((publisherValue = planValue.get("publisher")) != null && !(publisherValue instanceof NullNode)) {
                                    String publisherInstance = publisherValue.getTextValue();
                                    planInstance.setPublisher(publisherInstance);
                                }
                                if ((productValue = planValue.get("product")) != null && !(productValue instanceof NullNode)) {
                                    String productInstance = productValue.getTextValue();
                                    planInstance.setProduct(productInstance);
                                }
                                if ((promotionCodeValue = planValue.get("promotionCode")) != null && !(promotionCodeValue instanceof NullNode)) {
                                    String promotionCodeInstance = promotionCodeValue.getTextValue();
                                    planInstance.setPromotionCode(promotionCodeInstance);
                                }
                            }
                            if ((propertiesValue = valueValue.get("properties")) != null && !(propertiesValue instanceof NullNode)) {
                                JsonNode instanceViewValue;
                                JsonNode provisioningStateValue;
                                JsonNode availabilitySetValue;
                                JsonNode diagnosticsProfileValue;
                                JsonNode networkProfileValue;
                                Object adminPasswordValue;
                                JsonNode osProfileValue;
                                Object createOptionValue2;
                                JsonNode hardwareProfileValue = propertiesValue.get("hardwareProfile");
                                if (hardwareProfileValue != null && !(hardwareProfileValue instanceof NullNode)) {
                                    HardwareProfile hardwareProfileInstance = new HardwareProfile();
                                    virtualMachineJsonInstance.setHardwareProfile(hardwareProfileInstance);
                                    JsonNode vmSizeValue = hardwareProfileValue.get("vmSize");
                                    if (vmSizeValue != null && !(vmSizeValue instanceof NullNode)) {
                                        String vmSizeInstance = vmSizeValue.getTextValue();
                                        hardwareProfileInstance.setVirtualMachineSize(vmSizeInstance);
                                    }
                                }
                                if ((storageProfileValue = propertiesValue.get("storageProfile")) != null && !(storageProfileValue instanceof NullNode)) {
                                    JsonNode dataDisksArray;
                                    JsonNode osDiskValue;
                                    StorageProfile storageProfileInstance = new StorageProfile();
                                    virtualMachineJsonInstance.setStorageProfile(storageProfileInstance);
                                    JsonNode imageReferenceValue = storageProfileValue.get("imageReference");
                                    if (imageReferenceValue != null && !(imageReferenceValue instanceof NullNode)) {
                                        JsonNode versionValue;
                                        JsonNode skuValue;
                                        JsonNode offerValue;
                                        ImageReference imageReferenceInstance = new ImageReference();
                                        storageProfileInstance.setImageReference(imageReferenceInstance);
                                        JsonNode publisherValue2 = imageReferenceValue.get("publisher");
                                        if (publisherValue2 != null && !(publisherValue2 instanceof NullNode)) {
                                            String publisherInstance2 = publisherValue2.getTextValue();
                                            imageReferenceInstance.setPublisher(publisherInstance2);
                                        }
                                        if ((offerValue = imageReferenceValue.get("offer")) != null && !(offerValue instanceof NullNode)) {
                                            String offerInstance = offerValue.getTextValue();
                                            imageReferenceInstance.setOffer(offerInstance);
                                        }
                                        if ((skuValue = imageReferenceValue.get("sku")) != null && !(skuValue instanceof NullNode)) {
                                            String skuInstance = skuValue.getTextValue();
                                            imageReferenceInstance.setSku(skuInstance);
                                        }
                                        if ((versionValue = imageReferenceValue.get("version")) != null && !(versionValue instanceof NullNode)) {
                                            String versionInstance = versionValue.getTextValue();
                                            imageReferenceInstance.setVersion(versionInstance);
                                        }
                                    }
                                    if ((osDiskValue = storageProfileValue.get("osDisk")) != null && !(osDiskValue instanceof NullNode)) {
                                        JsonNode diskSizeGBValue;
                                        JsonNode createOptionValue;
                                        JsonNode cachingValue;
                                        JsonNode imageValue;
                                        JsonNode vhdValue;
                                        JsonNode nameValue2;
                                        OSDisk osDiskInstance = new OSDisk();
                                        storageProfileInstance.setOSDisk(osDiskInstance);
                                        Iterator osTypeValue = osDiskValue.get("osType");
                                        if (osTypeValue != null && !(osTypeValue instanceof NullNode)) {
                                            String osTypeInstance = osTypeValue.getTextValue();
                                            osDiskInstance.setOperatingSystemType(osTypeInstance);
                                        }
                                        if ((nameValue2 = osDiskValue.get("name")) != null && !(nameValue2 instanceof NullNode)) {
                                            String nameInstance2 = nameValue2.getTextValue();
                                            osDiskInstance.setName(nameInstance2);
                                        }
                                        if ((vhdValue = osDiskValue.get("vhd")) != null && !(vhdValue instanceof NullNode)) {
                                            VirtualHardDisk vhdInstance = new VirtualHardDisk();
                                            osDiskInstance.setVirtualHardDisk(vhdInstance);
                                            JsonNode uriValue = vhdValue.get("uri");
                                            if (uriValue != null && !(uriValue instanceof NullNode)) {
                                                String uriInstance = uriValue.getTextValue();
                                                vhdInstance.setUri(uriInstance);
                                            }
                                        }
                                        if ((imageValue = osDiskValue.get("image")) != null && !(imageValue instanceof NullNode)) {
                                            VirtualHardDisk imageInstance = new VirtualHardDisk();
                                            osDiskInstance.setSourceImage(imageInstance);
                                            JsonNode uriValue2 = imageValue.get("uri");
                                            if (uriValue2 != null && !(uriValue2 instanceof NullNode)) {
                                                String uriInstance2 = uriValue2.getTextValue();
                                                imageInstance.setUri(uriInstance2);
                                            }
                                        }
                                        if ((cachingValue = osDiskValue.get("caching")) != null && !(cachingValue instanceof NullNode)) {
                                            String cachingInstance = cachingValue.getTextValue();
                                            osDiskInstance.setCaching(cachingInstance);
                                        }
                                        if ((createOptionValue = osDiskValue.get("createOption")) != null && !(createOptionValue instanceof NullNode)) {
                                            String createOptionInstance = createOptionValue.getTextValue();
                                            osDiskInstance.setCreateOption(createOptionInstance);
                                        }
                                        if ((diskSizeGBValue = osDiskValue.get("diskSizeGB")) != null && !(diskSizeGBValue instanceof NullNode)) {
                                            int diskSizeGBInstance = diskSizeGBValue.getIntValue();
                                            osDiskInstance.setDiskSizeGB(diskSizeGBInstance);
                                        }
                                    }
                                    if ((dataDisksArray = storageProfileValue.get("dataDisks")) != null && !(dataDisksArray instanceof NullNode)) {
                                        for (JsonNode dataDisksValue : (ArrayNode)dataDisksArray) {
                                            JsonNode diskSizeGBValue2;
                                            JsonNode cachingValue2;
                                            JsonNode imageValue2;
                                            JsonNode vhdValue2;
                                            JsonNode nameValue3;
                                            DataDisk dataDiskInstance = new DataDisk();
                                            storageProfileInstance.getDataDisks().add(dataDiskInstance);
                                            JsonNode lunValue = dataDisksValue.get("lun");
                                            if (lunValue != null && !(lunValue instanceof NullNode)) {
                                                int lunInstance = lunValue.getIntValue();
                                                dataDiskInstance.setLun(lunInstance);
                                            }
                                            if ((nameValue3 = dataDisksValue.get("name")) != null && !(nameValue3 instanceof NullNode)) {
                                                String nameInstance3 = nameValue3.getTextValue();
                                                dataDiskInstance.setName(nameInstance3);
                                            }
                                            if ((vhdValue2 = dataDisksValue.get("vhd")) != null && !(vhdValue2 instanceof NullNode)) {
                                                VirtualHardDisk vhdInstance2 = new VirtualHardDisk();
                                                dataDiskInstance.setVirtualHardDisk(vhdInstance2);
                                                JsonNode uriValue3 = vhdValue2.get("uri");
                                                if (uriValue3 != null && !(uriValue3 instanceof NullNode)) {
                                                    String uriInstance3 = uriValue3.getTextValue();
                                                    vhdInstance2.setUri(uriInstance3);
                                                }
                                            }
                                            if ((imageValue2 = dataDisksValue.get("image")) != null && !(imageValue2 instanceof NullNode)) {
                                                VirtualHardDisk imageInstance2 = new VirtualHardDisk();
                                                dataDiskInstance.setSourceImage(imageInstance2);
                                                JsonNode uriValue4 = imageValue2.get("uri");
                                                if (uriValue4 != null && !(uriValue4 instanceof NullNode)) {
                                                    String uriInstance4 = uriValue4.getTextValue();
                                                    imageInstance2.setUri(uriInstance4);
                                                }
                                            }
                                            if ((cachingValue2 = dataDisksValue.get("caching")) != null && !(cachingValue2 instanceof NullNode)) {
                                                String cachingInstance2 = cachingValue2.getTextValue();
                                                dataDiskInstance.setCaching(cachingInstance2);
                                            }
                                            if ((createOptionValue2 = dataDisksValue.get("createOption")) != null && !(createOptionValue2 instanceof NullNode)) {
                                                String createOptionInstance2 = createOptionValue2.getTextValue();
                                                dataDiskInstance.setCreateOption(createOptionInstance2);
                                            }
                                            if ((diskSizeGBValue2 = dataDisksValue.get("diskSizeGB")) == null || diskSizeGBValue2 instanceof NullNode) continue;
                                            int diskSizeGBInstance2 = diskSizeGBValue2.getIntValue();
                                            dataDiskInstance.setDiskSizeGB(diskSizeGBInstance2);
                                        }
                                    }
                                }
                                if ((osProfileValue = propertiesValue.get("osProfile")) != null && !(osProfileValue instanceof NullNode)) {
                                    JsonNode secretsArray;
                                    JsonNode linuxConfigurationValue;
                                    JsonNode windowsConfigurationValue;
                                    JsonNode customDataValue;
                                    JsonNode adminUsernameValue;
                                    OSProfile osProfileInstance = new OSProfile();
                                    virtualMachineJsonInstance.setOSProfile(osProfileInstance);
                                    JsonNode computerNameValue = osProfileValue.get("computerName");
                                    if (computerNameValue != null && !(computerNameValue instanceof NullNode)) {
                                        String computerNameInstance = computerNameValue.getTextValue();
                                        osProfileInstance.setComputerName(computerNameInstance);
                                    }
                                    if ((adminUsernameValue = osProfileValue.get("adminUsername")) != null && !(adminUsernameValue instanceof NullNode)) {
                                        String adminUsernameInstance = adminUsernameValue.getTextValue();
                                        osProfileInstance.setAdminUsername(adminUsernameInstance);
                                    }
                                    if ((adminPasswordValue = osProfileValue.get("adminPassword")) != null && !(adminPasswordValue instanceof NullNode)) {
                                        String adminPasswordInstance = adminPasswordValue.getTextValue();
                                        osProfileInstance.setAdminPassword(adminPasswordInstance);
                                    }
                                    if ((customDataValue = osProfileValue.get("customData")) != null && !(customDataValue instanceof NullNode)) {
                                        String customDataInstance = customDataValue.getTextValue();
                                        osProfileInstance.setCustomData(customDataInstance);
                                    }
                                    if ((windowsConfigurationValue = osProfileValue.get("windowsConfiguration")) != null && !(windowsConfigurationValue instanceof NullNode)) {
                                        JsonNode winRMValue;
                                        JsonNode additionalUnattendContentArray;
                                        JsonNode timeZoneValue;
                                        JsonNode enableAutomaticUpdatesValue;
                                        WindowsConfiguration windowsConfigurationInstance = new WindowsConfiguration();
                                        osProfileInstance.setWindowsConfiguration(windowsConfigurationInstance);
                                        JsonNode provisionVMAgentValue = windowsConfigurationValue.get("provisionVMAgent");
                                        if (provisionVMAgentValue != null && !(provisionVMAgentValue instanceof NullNode)) {
                                            boolean provisionVMAgentInstance = provisionVMAgentValue.getBooleanValue();
                                            windowsConfigurationInstance.setProvisionVMAgent(provisionVMAgentInstance);
                                        }
                                        if ((enableAutomaticUpdatesValue = windowsConfigurationValue.get("enableAutomaticUpdates")) != null && !(enableAutomaticUpdatesValue instanceof NullNode)) {
                                            boolean enableAutomaticUpdatesInstance = enableAutomaticUpdatesValue.getBooleanValue();
                                            windowsConfigurationInstance.setEnableAutomaticUpdates(enableAutomaticUpdatesInstance);
                                        }
                                        if ((timeZoneValue = windowsConfigurationValue.get("timeZone")) != null && !(timeZoneValue instanceof NullNode)) {
                                            String timeZoneInstance = timeZoneValue.getTextValue();
                                            windowsConfigurationInstance.setTimeZone(timeZoneInstance);
                                        }
                                        if ((additionalUnattendContentArray = windowsConfigurationValue.get("additionalUnattendContent")) != null && !(additionalUnattendContentArray instanceof NullNode)) {
                                            createOptionValue2 = ((ArrayNode)additionalUnattendContentArray).iterator();
                                            while (createOptionValue2.hasNext()) {
                                                JsonNode contentValue;
                                                JsonNode settingNameValue;
                                                JsonNode componentNameValue;
                                                JsonNode additionalUnattendContentValue = (JsonNode)createOptionValue2.next();
                                                AdditionalUnattendContent additionalUnattendContentInstance = new AdditionalUnattendContent();
                                                windowsConfigurationInstance.getAdditionalUnattendContents().add(additionalUnattendContentInstance);
                                                JsonNode passNameValue = additionalUnattendContentValue.get("passName");
                                                if (passNameValue != null && !(passNameValue instanceof NullNode)) {
                                                    String passNameInstance = passNameValue.getTextValue();
                                                    additionalUnattendContentInstance.setPassName(passNameInstance);
                                                }
                                                if ((componentNameValue = additionalUnattendContentValue.get("componentName")) != null && !(componentNameValue instanceof NullNode)) {
                                                    String componentNameInstance = componentNameValue.getTextValue();
                                                    additionalUnattendContentInstance.setComponentName(componentNameInstance);
                                                }
                                                if ((settingNameValue = additionalUnattendContentValue.get("settingName")) != null && !(settingNameValue instanceof NullNode)) {
                                                    String settingNameInstance = settingNameValue.getTextValue();
                                                    additionalUnattendContentInstance.setSettingName(settingNameInstance);
                                                }
                                                if ((contentValue = additionalUnattendContentValue.get("content")) == null || contentValue instanceof NullNode) continue;
                                                String contentInstance = contentValue.getTextValue();
                                                additionalUnattendContentInstance.setContent(contentInstance);
                                            }
                                        }
                                        if ((winRMValue = windowsConfigurationValue.get("winRM")) != null && !(winRMValue instanceof NullNode)) {
                                            WinRMConfiguration winRMInstance = new WinRMConfiguration();
                                            windowsConfigurationInstance.setWinRMConfiguration(winRMInstance);
                                            JsonNode listenersArray = winRMValue.get("listeners");
                                            if (listenersArray != null && !(listenersArray instanceof NullNode)) {
                                                for (JsonNode listenersValue : (ArrayNode)listenersArray) {
                                                    JsonNode certificateUrlValue;
                                                    WinRMListener winRMListenerInstance = new WinRMListener();
                                                    winRMInstance.getListeners().add(winRMListenerInstance);
                                                    JsonNode protocolValue = listenersValue.get("protocol");
                                                    if (protocolValue != null && !(protocolValue instanceof NullNode)) {
                                                        String protocolInstance = protocolValue.getTextValue();
                                                        winRMListenerInstance.setProtocol(protocolInstance);
                                                    }
                                                    if ((certificateUrlValue = listenersValue.get("certificateUrl")) == null || certificateUrlValue instanceof NullNode) continue;
                                                    URI certificateUrlInstance = new URI(certificateUrlValue.getTextValue());
                                                    winRMListenerInstance.setCertificateUrl(certificateUrlInstance);
                                                }
                                            }
                                        }
                                    }
                                    if ((linuxConfigurationValue = osProfileValue.get("linuxConfiguration")) != null && !(linuxConfigurationValue instanceof NullNode)) {
                                        JsonNode sshValue;
                                        LinuxConfiguration linuxConfigurationInstance = new LinuxConfiguration();
                                        osProfileInstance.setLinuxConfiguration(linuxConfigurationInstance);
                                        Iterator disablePasswordAuthenticationValue = linuxConfigurationValue.get("disablePasswordAuthentication");
                                        if (disablePasswordAuthenticationValue != null && !(disablePasswordAuthenticationValue instanceof NullNode)) {
                                            boolean disablePasswordAuthenticationInstance = disablePasswordAuthenticationValue.getBooleanValue();
                                            linuxConfigurationInstance.setDisablePasswordAuthentication(disablePasswordAuthenticationInstance);
                                        }
                                        if ((sshValue = linuxConfigurationValue.get("ssh")) != null && !(sshValue instanceof NullNode)) {
                                            SshConfiguration sshInstance = new SshConfiguration();
                                            linuxConfigurationInstance.setSshConfiguration(sshInstance);
                                            JsonNode publicKeysArray = sshValue.get("publicKeys");
                                            if (publicKeysArray != null && !(publicKeysArray instanceof NullNode)) {
                                                for (JsonNode publicKeysValue : (ArrayNode)publicKeysArray) {
                                                    JsonNode keyDataValue;
                                                    SshPublicKey sshPublicKeyInstance = new SshPublicKey();
                                                    sshInstance.getPublicKeys().add(sshPublicKeyInstance);
                                                    JsonNode pathValue = publicKeysValue.get("path");
                                                    if (pathValue != null && !(pathValue instanceof NullNode)) {
                                                        String pathInstance = pathValue.getTextValue();
                                                        sshPublicKeyInstance.setPath(pathInstance);
                                                    }
                                                    if ((keyDataValue = publicKeysValue.get("keyData")) == null || keyDataValue instanceof NullNode) continue;
                                                    String keyDataInstance = keyDataValue.getTextValue();
                                                    sshPublicKeyInstance.setKeyData(keyDataInstance);
                                                }
                                            }
                                        }
                                    }
                                    if ((secretsArray = osProfileValue.get("secrets")) != null && !(secretsArray instanceof NullNode)) {
                                        for (JsonNode secretsValue : (ArrayNode)secretsArray) {
                                            JsonNode vaultCertificatesArray;
                                            VaultSecretGroup vaultSecretGroupInstance = new VaultSecretGroup();
                                            osProfileInstance.getSecrets().add(vaultSecretGroupInstance);
                                            JsonNode sourceVaultValue = secretsValue.get("sourceVault");
                                            if (sourceVaultValue != null && !(sourceVaultValue instanceof NullNode)) {
                                                SourceVaultReference sourceVaultInstance = new SourceVaultReference();
                                                vaultSecretGroupInstance.setSourceVault(sourceVaultInstance);
                                                Iterator idValue = sourceVaultValue.get("id");
                                                if (idValue != null && !(idValue instanceof NullNode)) {
                                                    String idInstance = idValue.getTextValue();
                                                    sourceVaultInstance.setReferenceUri(idInstance);
                                                }
                                            }
                                            if ((vaultCertificatesArray = secretsValue.get("vaultCertificates")) == null || vaultCertificatesArray instanceof NullNode) continue;
                                            for (JsonNode vaultCertificatesValue : (ArrayNode)vaultCertificatesArray) {
                                                JsonNode certificateStoreValue;
                                                VaultCertificate vaultCertificateInstance = new VaultCertificate();
                                                vaultSecretGroupInstance.getVaultCertificates().add(vaultCertificateInstance);
                                                JsonNode certificateUrlValue2 = vaultCertificatesValue.get("certificateUrl");
                                                if (certificateUrlValue2 != null && !(certificateUrlValue2 instanceof NullNode)) {
                                                    String certificateUrlInstance2 = certificateUrlValue2.getTextValue();
                                                    vaultCertificateInstance.setCertificateUrl(certificateUrlInstance2);
                                                }
                                                if ((certificateStoreValue = vaultCertificatesValue.get("certificateStore")) == null || certificateStoreValue instanceof NullNode) continue;
                                                String certificateStoreInstance = certificateStoreValue.getTextValue();
                                                vaultCertificateInstance.setCertificateStore(certificateStoreInstance);
                                            }
                                        }
                                    }
                                }
                                if ((networkProfileValue = propertiesValue.get("networkProfile")) != null && !(networkProfileValue instanceof NullNode)) {
                                    NetworkProfile networkProfileInstance = new NetworkProfile();
                                    virtualMachineJsonInstance.setNetworkProfile(networkProfileInstance);
                                    JsonNode networkInterfacesArray = networkProfileValue.get("networkInterfaces");
                                    if (networkInterfacesArray != null && !(networkInterfacesArray instanceof NullNode)) {
                                        adminPasswordValue = ((ArrayNode)networkInterfacesArray).iterator();
                                        while (adminPasswordValue.hasNext()) {
                                            JsonNode idValue2;
                                            JsonNode primaryValue;
                                            JsonNode networkInterfacesValue = (JsonNode)adminPasswordValue.next();
                                            NetworkInterfaceReference networkInterfaceReferenceJsonInstance = new NetworkInterfaceReference();
                                            networkProfileInstance.getNetworkInterfaces().add(networkInterfaceReferenceJsonInstance);
                                            JsonNode propertiesValue2 = networkInterfacesValue.get("properties");
                                            if (propertiesValue2 != null && !(propertiesValue2 instanceof NullNode) && (primaryValue = propertiesValue2.get("primary")) != null && !(primaryValue instanceof NullNode)) {
                                                boolean primaryInstance = primaryValue.getBooleanValue();
                                                networkInterfaceReferenceJsonInstance.setPrimary(primaryInstance);
                                            }
                                            if ((idValue2 = networkInterfacesValue.get("id")) == null || idValue2 instanceof NullNode) continue;
                                            String idInstance2 = idValue2.getTextValue();
                                            networkInterfaceReferenceJsonInstance.setReferenceUri(idInstance2);
                                        }
                                    }
                                }
                                if ((diagnosticsProfileValue = propertiesValue.get("diagnosticsProfile")) != null && !(diagnosticsProfileValue instanceof NullNode)) {
                                    DiagnosticsProfile diagnosticsProfileInstance = new DiagnosticsProfile();
                                    virtualMachineJsonInstance.setDiagnosticsProfile(diagnosticsProfileInstance);
                                    JsonNode bootDiagnosticsValue = diagnosticsProfileValue.get("bootDiagnostics");
                                    if (bootDiagnosticsValue != null && !(bootDiagnosticsValue instanceof NullNode)) {
                                        JsonNode storageUriValue;
                                        BootDiagnostics bootDiagnosticsInstance = new BootDiagnostics();
                                        diagnosticsProfileInstance.setBootDiagnostics(bootDiagnosticsInstance);
                                        JsonNode enabledValue = bootDiagnosticsValue.get("enabled");
                                        if (enabledValue != null && !(enabledValue instanceof NullNode)) {
                                            boolean enabledInstance = enabledValue.getBooleanValue();
                                            bootDiagnosticsInstance.setEnabled(enabledInstance);
                                        }
                                        if ((storageUriValue = bootDiagnosticsValue.get("storageUri")) != null && !(storageUriValue instanceof NullNode)) {
                                            URI storageUriInstance = new URI(storageUriValue.getTextValue());
                                            bootDiagnosticsInstance.setStorageUri(storageUriInstance);
                                        }
                                    }
                                }
                                if ((availabilitySetValue = propertiesValue.get("availabilitySet")) != null && !(availabilitySetValue instanceof NullNode)) {
                                    AvailabilitySetReference availabilitySetInstance = new AvailabilitySetReference();
                                    virtualMachineJsonInstance.setAvailabilitySetReference(availabilitySetInstance);
                                    JsonNode idValue3 = availabilitySetValue.get("id");
                                    if (idValue3 != null && !(idValue3 instanceof NullNode)) {
                                        String idInstance3 = idValue3.getTextValue();
                                        availabilitySetInstance.setReferenceUri(idInstance3);
                                    }
                                }
                                if ((provisioningStateValue = propertiesValue.get("provisioningState")) != null && !(provisioningStateValue instanceof NullNode)) {
                                    String provisioningStateInstance = provisioningStateValue.getTextValue();
                                    virtualMachineJsonInstance.setProvisioningState(provisioningStateInstance);
                                }
                                if ((instanceViewValue = propertiesValue.get("instanceView")) != null && !(instanceViewValue instanceof NullNode)) {
                                    JsonNode statusesArray4;
                                    JsonNode bootDiagnosticsValue2;
                                    JsonNode extensionsArray;
                                    JsonNode disksArray;
                                    JsonNode vmAgentValue;
                                    JsonNode rdpThumbPrintValue;
                                    JsonNode platformFaultDomainValue;
                                    VirtualMachineInstanceView instanceViewInstance = new VirtualMachineInstanceView();
                                    virtualMachineJsonInstance.setInstanceView(instanceViewInstance);
                                    JsonNode platformUpdateDomainValue = instanceViewValue.get("platformUpdateDomain");
                                    if (platformUpdateDomainValue != null && !(platformUpdateDomainValue instanceof NullNode)) {
                                        int platformUpdateDomainInstance = platformUpdateDomainValue.getIntValue();
                                        instanceViewInstance.setPlatformUpdateDomain(platformUpdateDomainInstance);
                                    }
                                    if ((platformFaultDomainValue = instanceViewValue.get("platformFaultDomain")) != null && !(platformFaultDomainValue instanceof NullNode)) {
                                        int platformFaultDomainInstance = platformFaultDomainValue.getIntValue();
                                        instanceViewInstance.setPlatformFaultDomain(platformFaultDomainInstance);
                                    }
                                    if ((rdpThumbPrintValue = instanceViewValue.get("rdpThumbPrint")) != null && !(rdpThumbPrintValue instanceof NullNode)) {
                                        String rdpThumbPrintInstance = rdpThumbPrintValue.getTextValue();
                                        instanceViewInstance.setRemoteDesktopThumbprint(rdpThumbPrintInstance);
                                    }
                                    if ((vmAgentValue = instanceViewValue.get("vmAgent")) != null && !(vmAgentValue instanceof NullNode)) {
                                        JsonNode statusesArray;
                                        JsonNode extensionHandlersArray;
                                        VirtualMachineAgentInstanceView vmAgentInstance = new VirtualMachineAgentInstanceView();
                                        instanceViewInstance.setVMAgent(vmAgentInstance);
                                        Iterator vmAgentVersionValue = vmAgentValue.get("vmAgentVersion");
                                        if (vmAgentVersionValue != null && !(vmAgentVersionValue instanceof NullNode)) {
                                            String vmAgentVersionInstance = vmAgentVersionValue.getTextValue();
                                            vmAgentInstance.setVMAgentVersion(vmAgentVersionInstance);
                                        }
                                        if ((extensionHandlersArray = vmAgentValue.get("extensionHandlers")) != null && !(extensionHandlersArray instanceof NullNode)) {
                                            for (Iterator extensionHandlersValue : (ArrayNode)extensionHandlersArray) {
                                                JsonNode timeValue;
                                                JsonNode messageValue;
                                                JsonNode displayStatusValue;
                                                JsonNode levelValue;
                                                JsonNode statusValue;
                                                JsonNode typeHandlerVersionValue;
                                                VirtualMachineExtensionHandlerInstanceView virtualMachineExtensionHandlerInstanceViewInstance = new VirtualMachineExtensionHandlerInstanceView();
                                                vmAgentInstance.getExtensionHandlers().add(virtualMachineExtensionHandlerInstanceViewInstance);
                                                JsonNode typeValue = extensionHandlersValue.get("type");
                                                if (typeValue != null && !(typeValue instanceof NullNode)) {
                                                    String typeInstance = typeValue.getTextValue();
                                                    virtualMachineExtensionHandlerInstanceViewInstance.setType(typeInstance);
                                                }
                                                if ((typeHandlerVersionValue = extensionHandlersValue.get("typeHandlerVersion")) != null && !(typeHandlerVersionValue instanceof NullNode)) {
                                                    String typeHandlerVersionInstance = typeHandlerVersionValue.getTextValue();
                                                    virtualMachineExtensionHandlerInstanceViewInstance.setTypeHandlerVersion(typeHandlerVersionInstance);
                                                }
                                                if ((statusValue = extensionHandlersValue.get("status")) == null || statusValue instanceof NullNode) continue;
                                                InstanceViewStatus statusInstance = new InstanceViewStatus();
                                                virtualMachineExtensionHandlerInstanceViewInstance.setStatus(statusInstance);
                                                JsonNode codeValue = statusValue.get("code");
                                                if (codeValue != null && !(codeValue instanceof NullNode)) {
                                                    String codeInstance = codeValue.getTextValue();
                                                    statusInstance.setCode(codeInstance);
                                                }
                                                if ((levelValue = statusValue.get("level")) != null && !(levelValue instanceof NullNode)) {
                                                    String levelInstance = levelValue.getTextValue();
                                                    statusInstance.setLevel(levelInstance);
                                                }
                                                if ((displayStatusValue = statusValue.get("displayStatus")) != null && !(displayStatusValue instanceof NullNode)) {
                                                    String displayStatusInstance = displayStatusValue.getTextValue();
                                                    statusInstance.setDisplayStatus(displayStatusInstance);
                                                }
                                                if ((messageValue = statusValue.get("message")) != null && !(messageValue instanceof NullNode)) {
                                                    String messageInstance = messageValue.getTextValue();
                                                    statusInstance.setMessage(messageInstance);
                                                }
                                                if ((timeValue = statusValue.get("time")) == null || timeValue instanceof NullNode) continue;
                                                Calendar timeInstance = DatatypeConverter.parseDateTime((String)timeValue.getTextValue());
                                                statusInstance.setTime(timeInstance);
                                            }
                                        }
                                        if ((statusesArray = vmAgentValue.get("statuses")) != null && !(statusesArray instanceof NullNode)) {
                                            Iterator extensionHandlersValue;
                                            extensionHandlersValue = ((ArrayNode)statusesArray).iterator();
                                            while (extensionHandlersValue.hasNext()) {
                                                JsonNode timeValue2;
                                                JsonNode messageValue2;
                                                JsonNode displayStatusValue2;
                                                JsonNode levelValue2;
                                                JsonNode statusesValue = (JsonNode)extensionHandlersValue.next();
                                                InstanceViewStatus instanceViewStatusInstance = new InstanceViewStatus();
                                                vmAgentInstance.getStatuses().add(instanceViewStatusInstance);
                                                JsonNode codeValue2 = statusesValue.get("code");
                                                if (codeValue2 != null && !(codeValue2 instanceof NullNode)) {
                                                    String codeInstance2 = codeValue2.getTextValue();
                                                    instanceViewStatusInstance.setCode(codeInstance2);
                                                }
                                                if ((levelValue2 = statusesValue.get("level")) != null && !(levelValue2 instanceof NullNode)) {
                                                    String levelInstance2 = levelValue2.getTextValue();
                                                    instanceViewStatusInstance.setLevel(levelInstance2);
                                                }
                                                if ((displayStatusValue2 = statusesValue.get("displayStatus")) != null && !(displayStatusValue2 instanceof NullNode)) {
                                                    String displayStatusInstance2 = displayStatusValue2.getTextValue();
                                                    instanceViewStatusInstance.setDisplayStatus(displayStatusInstance2);
                                                }
                                                if ((messageValue2 = statusesValue.get("message")) != null && !(messageValue2 instanceof NullNode)) {
                                                    String messageInstance2 = messageValue2.getTextValue();
                                                    instanceViewStatusInstance.setMessage(messageInstance2);
                                                }
                                                if ((timeValue2 = statusesValue.get("time")) == null || timeValue2 instanceof NullNode) continue;
                                                Calendar timeInstance2 = DatatypeConverter.parseDateTime((String)timeValue2.getTextValue());
                                                instanceViewStatusInstance.setTime(timeInstance2);
                                            }
                                        }
                                    }
                                    if ((disksArray = instanceViewValue.get("disks")) != null && !(disksArray instanceof NullNode)) {
                                        for (Iterator disksValue : (ArrayNode)disksArray) {
                                            JsonNode statusesArray2;
                                            DiskInstanceView diskInstanceViewInstance = new DiskInstanceView();
                                            instanceViewInstance.getDisks().add(diskInstanceViewInstance);
                                            JsonNode nameValue4 = disksValue.get("name");
                                            if (nameValue4 != null && !(nameValue4 instanceof NullNode)) {
                                                String nameInstance4 = nameValue4.getTextValue();
                                                diskInstanceViewInstance.setName(nameInstance4);
                                            }
                                            if ((statusesArray2 = disksValue.get("statuses")) == null || statusesArray2 instanceof NullNode) continue;
                                            for (JsonNode statusesValue2 : (ArrayNode)statusesArray2) {
                                                JsonNode timeValue3;
                                                JsonNode messageValue3;
                                                JsonNode displayStatusValue3;
                                                JsonNode levelValue3;
                                                InstanceViewStatus instanceViewStatusInstance2 = new InstanceViewStatus();
                                                diskInstanceViewInstance.getStatuses().add(instanceViewStatusInstance2);
                                                Iterator codeValue3 = statusesValue2.get("code");
                                                if (codeValue3 != null && !(codeValue3 instanceof NullNode)) {
                                                    String codeInstance3 = codeValue3.getTextValue();
                                                    instanceViewStatusInstance2.setCode(codeInstance3);
                                                }
                                                if ((levelValue3 = statusesValue2.get("level")) != null && !(levelValue3 instanceof NullNode)) {
                                                    String levelInstance3 = levelValue3.getTextValue();
                                                    instanceViewStatusInstance2.setLevel(levelInstance3);
                                                }
                                                if ((displayStatusValue3 = statusesValue2.get("displayStatus")) != null && !(displayStatusValue3 instanceof NullNode)) {
                                                    String displayStatusInstance3 = displayStatusValue3.getTextValue();
                                                    instanceViewStatusInstance2.setDisplayStatus(displayStatusInstance3);
                                                }
                                                if ((messageValue3 = statusesValue2.get("message")) != null && !(messageValue3 instanceof NullNode)) {
                                                    String messageInstance3 = messageValue3.getTextValue();
                                                    instanceViewStatusInstance2.setMessage(messageInstance3);
                                                }
                                                if ((timeValue3 = statusesValue2.get("time")) == null || timeValue3 instanceof NullNode) continue;
                                                Calendar timeInstance3 = DatatypeConverter.parseDateTime((String)timeValue3.getTextValue());
                                                instanceViewStatusInstance2.setTime(timeInstance3);
                                            }
                                        }
                                    }
                                    if ((extensionsArray = instanceViewValue.get("extensions")) != null && !(extensionsArray instanceof NullNode)) {
                                        Iterator disksValue;
                                        disksValue = ((ArrayNode)extensionsArray).iterator();
                                        while (disksValue.hasNext()) {
                                            JsonNode statusesArray3;
                                            Iterator substatusesValue2;
                                            JsonNode substatusesArray;
                                            JsonNode typeHandlerVersionValue2;
                                            JsonNode typeValue2;
                                            JsonNode extensionsValue = (JsonNode)disksValue.next();
                                            VirtualMachineExtensionInstanceView virtualMachineExtensionInstanceViewInstance = new VirtualMachineExtensionInstanceView();
                                            instanceViewInstance.getExtensions().add(virtualMachineExtensionInstanceViewInstance);
                                            JsonNode nameValue5 = extensionsValue.get("name");
                                            if (nameValue5 != null && !(nameValue5 instanceof NullNode)) {
                                                String nameInstance5 = nameValue5.getTextValue();
                                                virtualMachineExtensionInstanceViewInstance.setName(nameInstance5);
                                            }
                                            if ((typeValue2 = extensionsValue.get("type")) != null && !(typeValue2 instanceof NullNode)) {
                                                String typeInstance2 = typeValue2.getTextValue();
                                                virtualMachineExtensionInstanceViewInstance.setExtensionType(typeInstance2);
                                            }
                                            if ((typeHandlerVersionValue2 = extensionsValue.get("typeHandlerVersion")) != null && !(typeHandlerVersionValue2 instanceof NullNode)) {
                                                String typeHandlerVersionInstance2 = typeHandlerVersionValue2.getTextValue();
                                                virtualMachineExtensionInstanceViewInstance.setTypeHandlerVersion(typeHandlerVersionInstance2);
                                            }
                                            if ((substatusesArray = extensionsValue.get("substatuses")) != null && !(substatusesArray instanceof NullNode)) {
                                                for (Iterator substatusesValue2 : (ArrayNode)substatusesArray) {
                                                    JsonNode timeValue4;
                                                    JsonNode messageValue4;
                                                    JsonNode displayStatusValue4;
                                                    JsonNode levelValue4;
                                                    InstanceViewStatus instanceViewStatusInstance3 = new InstanceViewStatus();
                                                    virtualMachineExtensionInstanceViewInstance.getSubStatuses().add(instanceViewStatusInstance3);
                                                    JsonNode codeValue4 = substatusesValue2.get("code");
                                                    if (codeValue4 != null && !(codeValue4 instanceof NullNode)) {
                                                        String codeInstance4 = codeValue4.getTextValue();
                                                        instanceViewStatusInstance3.setCode(codeInstance4);
                                                    }
                                                    if ((levelValue4 = substatusesValue2.get("level")) != null && !(levelValue4 instanceof NullNode)) {
                                                        String levelInstance4 = levelValue4.getTextValue();
                                                        instanceViewStatusInstance3.setLevel(levelInstance4);
                                                    }
                                                    if ((displayStatusValue4 = substatusesValue2.get("displayStatus")) != null && !(displayStatusValue4 instanceof NullNode)) {
                                                        String displayStatusInstance4 = displayStatusValue4.getTextValue();
                                                        instanceViewStatusInstance3.setDisplayStatus(displayStatusInstance4);
                                                    }
                                                    if ((messageValue4 = substatusesValue2.get("message")) != null && !(messageValue4 instanceof NullNode)) {
                                                        String messageInstance4 = messageValue4.getTextValue();
                                                        instanceViewStatusInstance3.setMessage(messageInstance4);
                                                    }
                                                    if ((timeValue4 = substatusesValue2.get("time")) == null || timeValue4 instanceof NullNode) continue;
                                                    Calendar timeInstance4 = DatatypeConverter.parseDateTime((String)timeValue4.getTextValue());
                                                    instanceViewStatusInstance3.setTime(timeInstance4);
                                                }
                                            }
                                            if ((statusesArray3 = extensionsValue.get("statuses")) == null || statusesArray3 instanceof NullNode) continue;
                                            substatusesValue2 = ((ArrayNode)statusesArray3).iterator();
                                            while (substatusesValue2.hasNext()) {
                                                JsonNode timeValue5;
                                                JsonNode messageValue5;
                                                JsonNode displayStatusValue5;
                                                JsonNode levelValue5;
                                                JsonNode statusesValue3 = (JsonNode)substatusesValue2.next();
                                                InstanceViewStatus instanceViewStatusInstance4 = new InstanceViewStatus();
                                                virtualMachineExtensionInstanceViewInstance.getStatuses().add(instanceViewStatusInstance4);
                                                JsonNode codeValue5 = statusesValue3.get("code");
                                                if (codeValue5 != null && !(codeValue5 instanceof NullNode)) {
                                                    String codeInstance5 = codeValue5.getTextValue();
                                                    instanceViewStatusInstance4.setCode(codeInstance5);
                                                }
                                                if ((levelValue5 = statusesValue3.get("level")) != null && !(levelValue5 instanceof NullNode)) {
                                                    String levelInstance5 = levelValue5.getTextValue();
                                                    instanceViewStatusInstance4.setLevel(levelInstance5);
                                                }
                                                if ((displayStatusValue5 = statusesValue3.get("displayStatus")) != null && !(displayStatusValue5 instanceof NullNode)) {
                                                    String displayStatusInstance5 = displayStatusValue5.getTextValue();
                                                    instanceViewStatusInstance4.setDisplayStatus(displayStatusInstance5);
                                                }
                                                if ((messageValue5 = statusesValue3.get("message")) != null && !(messageValue5 instanceof NullNode)) {
                                                    String messageInstance5 = messageValue5.getTextValue();
                                                    instanceViewStatusInstance4.setMessage(messageInstance5);
                                                }
                                                if ((timeValue5 = statusesValue3.get("time")) == null || timeValue5 instanceof NullNode) continue;
                                                Calendar timeInstance5 = DatatypeConverter.parseDateTime((String)timeValue5.getTextValue());
                                                instanceViewStatusInstance4.setTime(timeInstance5);
                                            }
                                        }
                                    }
                                    if ((bootDiagnosticsValue2 = instanceViewValue.get("bootDiagnostics")) != null && !(bootDiagnosticsValue2 instanceof NullNode)) {
                                        JsonNode serialConsoleLogBlobUriValue;
                                        BootDiagnosticsInstanceView bootDiagnosticsInstance2 = new BootDiagnosticsInstanceView();
                                        instanceViewInstance.setBootDiagnostics(bootDiagnosticsInstance2);
                                        Iterator consoleScreenshotBlobUriValue = bootDiagnosticsValue2.get("consoleScreenshotBlobUri");
                                        if (consoleScreenshotBlobUriValue != null && !(consoleScreenshotBlobUriValue instanceof NullNode)) {
                                            URI consoleScreenshotBlobUriInstance = new URI(consoleScreenshotBlobUriValue.getTextValue());
                                            bootDiagnosticsInstance2.setConsoleScreenshotBlobUri(consoleScreenshotBlobUriInstance);
                                        }
                                        if ((serialConsoleLogBlobUriValue = bootDiagnosticsValue2.get("serialConsoleLogBlobUri")) != null && !(serialConsoleLogBlobUriValue instanceof NullNode)) {
                                            URI serialConsoleLogBlobUriInstance = new URI(serialConsoleLogBlobUriValue.getTextValue());
                                            bootDiagnosticsInstance2.setSerialConsoleLogBlobUri(serialConsoleLogBlobUriInstance);
                                        }
                                    }
                                    if ((statusesArray4 = instanceViewValue.get("statuses")) != null && !(statusesArray4 instanceof NullNode)) {
                                        for (Object statusesValue4 : (ArrayNode)statusesArray4) {
                                            JsonNode timeValue6;
                                            JsonNode messageValue6;
                                            JsonNode displayStatusValue6;
                                            JsonNode levelValue6;
                                            InstanceViewStatus instanceViewStatusInstance5 = new InstanceViewStatus();
                                            instanceViewInstance.getStatuses().add(instanceViewStatusInstance5);
                                            JsonNode codeValue6 = statusesValue4.get("code");
                                            if (codeValue6 != null && !(codeValue6 instanceof NullNode)) {
                                                String codeInstance6 = codeValue6.getTextValue();
                                                instanceViewStatusInstance5.setCode(codeInstance6);
                                            }
                                            if ((levelValue6 = statusesValue4.get("level")) != null && !(levelValue6 instanceof NullNode)) {
                                                String levelInstance6 = levelValue6.getTextValue();
                                                instanceViewStatusInstance5.setLevel(levelInstance6);
                                            }
                                            if ((displayStatusValue6 = statusesValue4.get("displayStatus")) != null && !(displayStatusValue6 instanceof NullNode)) {
                                                String displayStatusInstance6 = displayStatusValue6.getTextValue();
                                                instanceViewStatusInstance5.setDisplayStatus(displayStatusInstance6);
                                            }
                                            if ((messageValue6 = statusesValue4.get("message")) != null && !(messageValue6 instanceof NullNode)) {
                                                String messageInstance6 = messageValue6.getTextValue();
                                                instanceViewStatusInstance5.setMessage(messageInstance6);
                                            }
                                            if ((timeValue6 = statusesValue4.get("time")) == null || timeValue6 instanceof NullNode) continue;
                                            Calendar timeInstance6 = DatatypeConverter.parseDateTime((String)timeValue6.getTextValue());
                                            instanceViewStatusInstance5.setTime(timeInstance6);
                                        }
                                    }
                                }
                            }
                            if ((resourcesArray = valueValue.get("resources")) != null && !(resourcesArray instanceof NullNode)) {
                                virtualMachineJsonInstance.setExtensions(new ArrayList<VirtualMachineExtension>());
                                storageProfileValue = ((ArrayNode)resourcesArray).iterator();
                                while (storageProfileValue.hasNext()) {
                                    JsonNode tagsSequenceElement;
                                    JsonNode locationValue;
                                    JsonNode typeValue5;
                                    JsonNode nameValue7;
                                    JsonNode idValue4;
                                    JsonNode resourcesValue = (JsonNode)storageProfileValue.next();
                                    VirtualMachineExtension virtualMachineExtensionJsonInstance = new VirtualMachineExtension();
                                    virtualMachineJsonInstance.getExtensions().add(virtualMachineExtensionJsonInstance);
                                    JsonNode propertiesValue3 = resourcesValue.get("properties");
                                    if (propertiesValue3 != null && !(propertiesValue3 instanceof NullNode)) {
                                        JsonNode instanceViewValue2;
                                        JsonNode provisioningStateValue2;
                                        JsonNode protectedSettingsValue;
                                        JsonNode settingsValue;
                                        JsonNode autoUpgradeMinorVersionValue;
                                        JsonNode typeHandlerVersionValue3;
                                        JsonNode typeValue3;
                                        JsonNode publisherValue3 = propertiesValue3.get("publisher");
                                        if (publisherValue3 != null && !(publisherValue3 instanceof NullNode)) {
                                            String publisherInstance3 = publisherValue3.getTextValue();
                                            virtualMachineExtensionJsonInstance.setPublisher(publisherInstance3);
                                        }
                                        if ((typeValue3 = propertiesValue3.get("type")) != null && !(typeValue3 instanceof NullNode)) {
                                            String typeInstance3 = typeValue3.getTextValue();
                                            virtualMachineExtensionJsonInstance.setExtensionType(typeInstance3);
                                        }
                                        if ((typeHandlerVersionValue3 = propertiesValue3.get("typeHandlerVersion")) != null && !(typeHandlerVersionValue3 instanceof NullNode)) {
                                            String typeHandlerVersionInstance3 = typeHandlerVersionValue3.getTextValue();
                                            virtualMachineExtensionJsonInstance.setTypeHandlerVersion(typeHandlerVersionInstance3);
                                        }
                                        if ((autoUpgradeMinorVersionValue = propertiesValue3.get("autoUpgradeMinorVersion")) != null && !(autoUpgradeMinorVersionValue instanceof NullNode)) {
                                            boolean autoUpgradeMinorVersionInstance = autoUpgradeMinorVersionValue.getBooleanValue();
                                            virtualMachineExtensionJsonInstance.setAutoUpgradeMinorVersion(autoUpgradeMinorVersionInstance);
                                        }
                                        if ((settingsValue = propertiesValue3.get("settings")) != null && !(settingsValue instanceof NullNode)) {
                                            String settingsInstance = settingsValue.getTextValue();
                                            virtualMachineExtensionJsonInstance.setSettings(settingsInstance);
                                        }
                                        if ((protectedSettingsValue = propertiesValue3.get("protectedSettings")) != null && !(protectedSettingsValue instanceof NullNode)) {
                                            String protectedSettingsInstance = protectedSettingsValue.getTextValue();
                                            virtualMachineExtensionJsonInstance.setProtectedSettings(protectedSettingsInstance);
                                        }
                                        if ((provisioningStateValue2 = propertiesValue3.get("provisioningState")) != null && !(provisioningStateValue2 instanceof NullNode)) {
                                            String provisioningStateInstance2 = provisioningStateValue2.getTextValue();
                                            virtualMachineExtensionJsonInstance.setProvisioningState(provisioningStateInstance2);
                                        }
                                        if ((instanceViewValue2 = propertiesValue3.get("instanceView")) != null && !(instanceViewValue2 instanceof NullNode)) {
                                            JsonNode statusesArray5;
                                            JsonNode substatusesArray2;
                                            JsonNode typeHandlerVersionValue4;
                                            JsonNode typeValue4;
                                            VirtualMachineExtensionInstanceView instanceViewInstance2 = new VirtualMachineExtensionInstanceView();
                                            virtualMachineExtensionJsonInstance.setInstanceView(instanceViewInstance2);
                                            JsonNode nameValue6 = instanceViewValue2.get("name");
                                            if (nameValue6 != null && !(nameValue6 instanceof NullNode)) {
                                                String nameInstance6 = nameValue6.getTextValue();
                                                instanceViewInstance2.setName(nameInstance6);
                                            }
                                            if ((typeValue4 = instanceViewValue2.get("type")) != null && !(typeValue4 instanceof NullNode)) {
                                                String typeInstance4 = typeValue4.getTextValue();
                                                instanceViewInstance2.setExtensionType(typeInstance4);
                                            }
                                            if ((typeHandlerVersionValue4 = instanceViewValue2.get("typeHandlerVersion")) != null && !(typeHandlerVersionValue4 instanceof NullNode)) {
                                                String typeHandlerVersionInstance4 = typeHandlerVersionValue4.getTextValue();
                                                instanceViewInstance2.setTypeHandlerVersion(typeHandlerVersionInstance4);
                                            }
                                            if ((substatusesArray2 = instanceViewValue2.get("substatuses")) != null && !(substatusesArray2 instanceof NullNode)) {
                                                Object statusesValue4;
                                                statusesValue4 = ((ArrayNode)substatusesArray2).iterator();
                                                while (statusesValue4.hasNext()) {
                                                    JsonNode timeValue7;
                                                    JsonNode messageValue7;
                                                    JsonNode displayStatusValue7;
                                                    JsonNode levelValue7;
                                                    JsonNode substatusesValue2 = (JsonNode)statusesValue4.next();
                                                    InstanceViewStatus instanceViewStatusInstance6 = new InstanceViewStatus();
                                                    instanceViewInstance2.getSubStatuses().add(instanceViewStatusInstance6);
                                                    JsonNode codeValue7 = substatusesValue2.get("code");
                                                    if (codeValue7 != null && !(codeValue7 instanceof NullNode)) {
                                                        String codeInstance7 = codeValue7.getTextValue();
                                                        instanceViewStatusInstance6.setCode(codeInstance7);
                                                    }
                                                    if ((levelValue7 = substatusesValue2.get("level")) != null && !(levelValue7 instanceof NullNode)) {
                                                        String levelInstance7 = levelValue7.getTextValue();
                                                        instanceViewStatusInstance6.setLevel(levelInstance7);
                                                    }
                                                    if ((displayStatusValue7 = substatusesValue2.get("displayStatus")) != null && !(displayStatusValue7 instanceof NullNode)) {
                                                        String displayStatusInstance7 = displayStatusValue7.getTextValue();
                                                        instanceViewStatusInstance6.setDisplayStatus(displayStatusInstance7);
                                                    }
                                                    if ((messageValue7 = substatusesValue2.get("message")) != null && !(messageValue7 instanceof NullNode)) {
                                                        String messageInstance7 = messageValue7.getTextValue();
                                                        instanceViewStatusInstance6.setMessage(messageInstance7);
                                                    }
                                                    if ((timeValue7 = substatusesValue2.get("time")) == null || timeValue7 instanceof NullNode) continue;
                                                    Calendar timeInstance7 = DatatypeConverter.parseDateTime((String)timeValue7.getTextValue());
                                                    instanceViewStatusInstance6.setTime(timeInstance7);
                                                }
                                            }
                                            if ((statusesArray5 = instanceViewValue2.get("statuses")) != null && !(statusesArray5 instanceof NullNode)) {
                                                for (JsonNode statusesValue5 : (ArrayNode)statusesArray5) {
                                                    JsonNode timeValue8;
                                                    JsonNode messageValue8;
                                                    JsonNode displayStatusValue8;
                                                    JsonNode levelValue8;
                                                    InstanceViewStatus instanceViewStatusInstance7 = new InstanceViewStatus();
                                                    instanceViewInstance2.getStatuses().add(instanceViewStatusInstance7);
                                                    JsonNode codeValue8 = statusesValue5.get("code");
                                                    if (codeValue8 != null && !(codeValue8 instanceof NullNode)) {
                                                        String codeInstance8 = codeValue8.getTextValue();
                                                        instanceViewStatusInstance7.setCode(codeInstance8);
                                                    }
                                                    if ((levelValue8 = statusesValue5.get("level")) != null && !(levelValue8 instanceof NullNode)) {
                                                        String levelInstance8 = levelValue8.getTextValue();
                                                        instanceViewStatusInstance7.setLevel(levelInstance8);
                                                    }
                                                    if ((displayStatusValue8 = statusesValue5.get("displayStatus")) != null && !(displayStatusValue8 instanceof NullNode)) {
                                                        String displayStatusInstance8 = displayStatusValue8.getTextValue();
                                                        instanceViewStatusInstance7.setDisplayStatus(displayStatusInstance8);
                                                    }
                                                    if ((messageValue8 = statusesValue5.get("message")) != null && !(messageValue8 instanceof NullNode)) {
                                                        String messageInstance8 = messageValue8.getTextValue();
                                                        instanceViewStatusInstance7.setMessage(messageInstance8);
                                                    }
                                                    if ((timeValue8 = statusesValue5.get("time")) == null || timeValue8 instanceof NullNode) continue;
                                                    Calendar timeInstance8 = DatatypeConverter.parseDateTime((String)timeValue8.getTextValue());
                                                    instanceViewStatusInstance7.setTime(timeInstance8);
                                                }
                                            }
                                        }
                                    }
                                    if ((idValue4 = resourcesValue.get("id")) != null && !(idValue4 instanceof NullNode)) {
                                        String idInstance4 = idValue4.getTextValue();
                                        virtualMachineExtensionJsonInstance.setId(idInstance4);
                                    }
                                    if ((nameValue7 = resourcesValue.get("name")) != null && !(nameValue7 instanceof NullNode)) {
                                        String nameInstance7 = nameValue7.getTextValue();
                                        virtualMachineExtensionJsonInstance.setName(nameInstance7);
                                    }
                                    if ((typeValue5 = resourcesValue.get("type")) != null && !(typeValue5 instanceof NullNode)) {
                                        String typeInstance5 = typeValue5.getTextValue();
                                        virtualMachineExtensionJsonInstance.setType(typeInstance5);
                                    }
                                    if ((locationValue = resourcesValue.get("location")) != null && !(locationValue instanceof NullNode)) {
                                        String locationInstance = locationValue.getTextValue();
                                        virtualMachineExtensionJsonInstance.setLocation(locationInstance);
                                    }
                                    if ((tagsSequenceElement = resourcesValue.get("tags")) == null || tagsSequenceElement instanceof NullNode) continue;
                                    Iterator itr = tagsSequenceElement.getFields();
                                    while (itr.hasNext()) {
                                        Map.Entry property = (Map.Entry)itr.next();
                                        String tagsKey = (String)property.getKey();
                                        String tagsValue = ((JsonNode)property.getValue()).getTextValue();
                                        virtualMachineExtensionJsonInstance.getTags().put(tagsKey, tagsValue);
                                    }
                                }
                            }
                            if ((idValue5 = valueValue.get("id")) != null && !(idValue5 instanceof NullNode)) {
                                String idInstance5 = idValue5.getTextValue();
                                virtualMachineJsonInstance.setId(idInstance5);
                            }
                            if ((nameValue8 = valueValue.get("name")) != null && !(nameValue8 instanceof NullNode)) {
                                String nameInstance8 = nameValue8.getTextValue();
                                virtualMachineJsonInstance.setName(nameInstance8);
                            }
                            if ((typeValue6 = valueValue.get("type")) != null && !(typeValue6 instanceof NullNode)) {
                                String typeInstance6 = typeValue6.getTextValue();
                                virtualMachineJsonInstance.setType(typeInstance6);
                            }
                            if ((locationValue2 = valueValue.get("location")) != null && !(locationValue2 instanceof NullNode)) {
                                String locationInstance2 = locationValue2.getTextValue();
                                virtualMachineJsonInstance.setLocation(locationInstance2);
                            }
                            if ((tagsSequenceElement2 = valueValue.get("tags")) == null || tagsSequenceElement2 instanceof NullNode) continue;
                            Iterator itr2 = tagsSequenceElement2.getFields();
                            while (itr2.hasNext()) {
                                Map.Entry property2 = (Map.Entry)itr2.next();
                                String tagsKey2 = (String)property2.getKey();
                                String tagsValue2 = ((JsonNode)property2.getValue()).getTextValue();
                                virtualMachineJsonInstance.getTags().put(tagsKey2, tagsValue2);
                            }
                        }
                    }
                    if ((nextLinkValue = responseDoc.get("nextLink")) != null && !(nextLinkValue instanceof NullNode)) {
                        String nextLinkInstance = nextLinkValue.getTextValue();
                        result.setNextLink(nextLinkInstance);
                    }
                }
            }
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            VirtualMachineListResponse virtualMachineListResponse = result;
            return virtualMachineListResponse;
        }
        finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }

    @Override
    public Future<ComputeLongRunningOperationResponse> powerOffAsync(final String resourceGroupName, final String vmName) {
        return this.getClient().getExecutorService().submit(new Callable<ComputeLongRunningOperationResponse>(){

            @Override
            public ComputeLongRunningOperationResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.powerOff(resourceGroupName, vmName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComputeLongRunningOperationResponse powerOff(String resourceGroupName, String vmName) throws InterruptedException, ExecutionException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("vmName", vmName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"powerOffAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            ComputeOperationResponse response = client2.getVirtualMachinesOperations().beginPoweringOffAsync(resourceGroupName, vmName).get();
            ComputeLongRunningOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)ComputeOperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            ComputeLongRunningOperationResponse computeLongRunningOperationResponse = result;
            return computeLongRunningOperationResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<ComputeLongRunningOperationResponse> restartAsync(final String resourceGroupName, final String vmName) {
        return this.getClient().getExecutorService().submit(new Callable<ComputeLongRunningOperationResponse>(){

            @Override
            public ComputeLongRunningOperationResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.restart(resourceGroupName, vmName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComputeLongRunningOperationResponse restart(String resourceGroupName, String vmName) throws InterruptedException, ExecutionException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("vmName", vmName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"restartAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            ComputeOperationResponse response = client2.getVirtualMachinesOperations().beginRestartingAsync(resourceGroupName, vmName).get();
            ComputeLongRunningOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)ComputeOperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            ComputeLongRunningOperationResponse computeLongRunningOperationResponse = result;
            return computeLongRunningOperationResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }

    @Override
    public Future<ComputeLongRunningOperationResponse> startAsync(final String resourceGroupName, final String vmName) {
        return this.getClient().getExecutorService().submit(new Callable<ComputeLongRunningOperationResponse>(){

            @Override
            public ComputeLongRunningOperationResponse call() throws Exception {
                return VirtualMachineOperationsImpl.this.start(resourceGroupName, vmName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComputeLongRunningOperationResponse start(String resourceGroupName, String vmName) throws InterruptedException, ExecutionException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, String> tracingParameters = new HashMap<String, String>();
            tracingParameters.put("resourceGroupName", resourceGroupName);
            tracingParameters.put("vmName", vmName);
            CloudTracing.enter((String)invocationId, (Object)this, (String)"startAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = (ComputeManagementClient)((ComputeManagementClient)this.getClient().withRequestFilterLast((ServiceRequestFilter)new ClientRequestTrackingHandler(invocationId))).withResponseFilterLast((ServiceResponseFilter)new ClientRequestTrackingHandler(invocationId));
            }
            ComputeOperationResponse response = client2.getVirtualMachinesOperations().beginStartingAsync(resourceGroupName, vmName).get();
            ComputeLongRunningOperationResponse result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while (result.getStatus() != null && result.getStatus().equals((Object)ComputeOperationStatus.InProgress)) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getLongRunningOperationStatusAsync(response.getAzureAsyncOperation()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() < 0) continue;
                delayInSeconds = client2.getLongRunningOperationRetryTimeout();
            }
            if (shouldTrace) {
                CloudTracing.exit((String)invocationId, (Object)((Object)result));
            }
            ComputeLongRunningOperationResponse computeLongRunningOperationResponse = result;
            return computeLongRunningOperationResponse;
        }
        finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
}

