/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.utility;

import com.microsoft.azure.management.network.NetworkResourceProviderClient;
import com.microsoft.azure.management.network.models.AddressSpace;
import com.microsoft.azure.management.network.models.AzureAsyncOperationResponse;
import com.microsoft.azure.management.network.models.DhcpOptions;
import com.microsoft.azure.management.network.models.NetworkInterface;
import com.microsoft.azure.management.network.models.NetworkInterfaceIpConfiguration;
import com.microsoft.azure.management.network.models.PublicIpAddress;
import com.microsoft.azure.management.network.models.PublicIpAddressDnsSettings;
import com.microsoft.azure.management.network.models.ResourceId;
import com.microsoft.azure.management.network.models.Subnet;
import com.microsoft.azure.management.network.models.VirtualNetwork;
import com.microsoft.azure.utility.ResourceContext;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;

public class NetworkHelper {
    public static PublicIpAddress createPublicIpAddress(NetworkResourceProviderClient networkResourceProviderClient, ResourceContext context) throws Exception {
        PublicIpAddress publicIpParams = new PublicIpAddress("Dynamic", context.getLocation());
        String publicIpName = context.getPublicIpName();
        AzureAsyncOperationResponse response = networkResourceProviderClient.getPublicIpAddressesOperations().createOrUpdate(context.getResourceGroupName(), publicIpName, publicIpParams);
        PublicIpAddress ip = networkResourceProviderClient.getPublicIpAddressesOperations().get(context.getResourceGroupName(), publicIpName).getPublicIpAddress();
        context.setPublicIpAddress(ip);
        return ip;
    }

    public static VirtualNetwork createVirtualNetwork(NetworkResourceProviderClient networkResourceProviderClient, ResourceContext context) throws Exception {
        VirtualNetwork vnet = new VirtualNetwork(context.getLocation());
        String subnetName = context.getSubnetName();
        String vnetName = context.getVirtualNetworkName();
        AddressSpace asp = new AddressSpace();
        ArrayList<String> addrPrefixes = new ArrayList<String>(1);
        addrPrefixes.add("10.0.0.0/16");
        asp.setAddressPrefixes(addrPrefixes);
        vnet.setAddressSpace(asp);
        DhcpOptions dop = new DhcpOptions();
        ArrayList<String> dnsServers = new ArrayList<String>(2);
        dnsServers.add("10.1.1.1");
        dop.setDnsServers(dnsServers);
        vnet.setDhcpOptions(dop);
        Subnet subnet = new Subnet("10.0.0.0/24");
        subnet.setName(subnetName);
        ArrayList<Subnet> subNets = new ArrayList<Subnet>(1);
        subNets.add(subnet);
        vnet.setSubnets(subNets);
        try {
            AzureAsyncOperationResponse azureAsyncOperationResponse = networkResourceProviderClient.getVirtualNetworksOperations().createOrUpdate(context.getResourceGroupName(), vnetName, vnet);
        }
        catch (ExecutionException ee) {
            if (ee.getMessage().contains("RetryableError")) {
                AzureAsyncOperationResponse azureAsyncOperationResponse = networkResourceProviderClient.getVirtualNetworksOperations().createOrUpdate(context.getResourceGroupName(), vnetName, vnet);
            }
            throw ee;
        }
        VirtualNetwork createdVnet = networkResourceProviderClient.getVirtualNetworksOperations().get(context.getResourceGroupName(), vnetName).getVirtualNetwork();
        context.setVirtualNetwork(createdVnet);
        return createdVnet;
    }

    public static NetworkInterface createNIC(NetworkResourceProviderClient networkResourceProviderClient, ResourceContext context, Subnet subNet) throws Exception {
        ResourceId publicIpAddressId;
        NetworkInterface nic = new NetworkInterface(context.getLocation());
        String nicName = context.getNetworkInterfaceName();
        String ipConfigName = context.getIpConfigName();
        nic.setName(nicName);
        if (context.getTags() != null) {
            nic.setTags(context.getTags());
        }
        NetworkInterfaceIpConfiguration nicConfig = new NetworkInterfaceIpConfiguration();
        nicConfig.setName(ipConfigName);
        nicConfig.setPrivateIpAllocationMethod("Dynamic");
        nicConfig.setSubnet((ResourceId)subNet);
        ArrayList<NetworkInterfaceIpConfiguration> ipConfigs = new ArrayList<NetworkInterfaceIpConfiguration>(1);
        ipConfigs.add(nicConfig);
        nic.setIpConfigurations(ipConfigs);
        if (context.getPublicIpAddress() != null) {
            publicIpAddressId = new ResourceId();
            publicIpAddressId.setId(context.getPublicIpAddress().getId());
            ((NetworkInterfaceIpConfiguration)nic.getIpConfigurations().get(0)).setPublicIpAddress(publicIpAddressId);
        }
        try {
            publicIpAddressId = networkResourceProviderClient.getNetworkInterfacesOperations().createOrUpdate(context.getResourceGroupName(), nicName, nic);
        }
        catch (ExecutionException ee) {
            if (ee.getMessage().contains("RetryableError")) {
                AzureAsyncOperationResponse azureAsyncOperationResponse = networkResourceProviderClient.getNetworkInterfacesOperations().createOrUpdate(context.getResourceGroupName(), nicName, nic);
            }
            throw ee;
        }
        NetworkInterface createdNic = networkResourceProviderClient.getNetworkInterfacesOperations().get(context.getResourceGroupName(), nicName).getNetworkInterface();
        context.setNetworkInterface(createdNic);
        return createdNic;
    }

    public static PublicIpAddress updatePublicIpAddressDomainName(NetworkResourceProviderClient networkResourceProviderClient, String resourceGroupName, String publicIpAddressName, String domainPrefix) throws Exception {
        PublicIpAddress publicIp = networkResourceProviderClient.getPublicIpAddressesOperations().get(resourceGroupName, publicIpAddressName).getPublicIpAddress();
        if (publicIp.getDnsSettings() == null) {
            publicIp.setDnsSettings(new PublicIpAddressDnsSettings());
        }
        publicIp.getDnsSettings().setDomainNameLabel(domainPrefix);
        AzureAsyncOperationResponse response = networkResourceProviderClient.getPublicIpAddressesOperations().createOrUpdate(resourceGroupName, publicIpAddressName, publicIp);
        PublicIpAddress ip = networkResourceProviderClient.getPublicIpAddressesOperations().get(resourceGroupName, publicIpAddressName).getPublicIpAddress();
        return ip;
    }
}

