/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.utility;

import com.google.gson.Gson;
import com.microsoft.azure.management.resources.ResourceManagementClient;
import com.microsoft.azure.management.resources.models.Deployment;
import com.microsoft.azure.management.resources.models.DeploymentExtended;
import com.microsoft.azure.management.resources.models.DeploymentMode;
import com.microsoft.azure.management.resources.models.DeploymentProperties;
import com.microsoft.azure.management.resources.models.TemplateLink;
import com.microsoft.windowsazure.exception.ServiceException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;

public class ResourceHelper {
    public static DeploymentExtended createTemplateDeploymentFromURI(ResourceManagementClient resourceManagementClient, String resourceGroupName, DeploymentMode deploymentMode, String deploymentName, String templateUri, String templateContentVersion, Map<String, String> templateParameters) throws URISyntaxException, IOException, ServiceException {
        DeploymentProperties deploymentProperties = new DeploymentProperties();
        deploymentProperties.setMode(deploymentMode);
        TemplateLink templateLink = new TemplateLink(new URI(templateUri));
        templateLink.setContentVersion(templateContentVersion);
        deploymentProperties.setTemplateLink(templateLink);
        HashMap<String, ParameterValue> parameters = new HashMap<String, ParameterValue>();
        for (Map.Entry<String, String> entry : templateParameters.entrySet()) {
            parameters.put(entry.getKey(), new ParameterValue(entry.getValue()));
        }
        deploymentProperties.setParameters(new Gson().toJson(parameters));
        Deployment deployment = new Deployment();
        deployment.setProperties(deploymentProperties);
        return resourceManagementClient.getDeploymentsOperations().createOrUpdate(resourceGroupName, deploymentName, deployment).getDeployment();
    }

    private static class ParameterValue {
        String value;

        ParameterValue(String value) {
            this.value = value;
        }
    }
}

