/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseReferenceRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.Group;
import com.microsoft.graph.options.Option;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GroupReferenceRequest
extends BaseReferenceRequest<Group> {
    public GroupReferenceRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Group.class);
    }

    @Nonnull
    public GroupReferenceRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public GroupReferenceRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public CompletableFuture<Group> putAsync(@Nonnull Group srcGroup) {
        JsonObject payload = new JsonObject();
        payload.add("@odata.id", (JsonElement)new JsonPrimitive(this.getClient().getServiceRoot() + "/groups/" + srcGroup.id));
        return this.sendAsync(HttpMethod.PUT, payload);
    }

    @Nullable
    public Group put(@Nonnull Group srcGroup) throws ClientException {
        JsonObject payload = new JsonObject();
        payload.add("@odata.id", (JsonElement)new JsonPrimitive(this.getClient().getServiceRoot() + "/groups/" + srcGroup.id));
        return (Group)this.send(HttpMethod.PUT, payload);
    }
}

