"use strict";
/**
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.installDeps = void 0;
const child_process_1 = __importDefault(require("child_process"));
const os_1 = __importDefault(require("os"));
const ubuntuVersion_1 = require("../utils/ubuntuVersion");
const { deps } = require('../nativeDeps');
async function installDeps(browserTypes) {
    if (os_1.default.platform() !== 'linux')
        return;
    if (!browserTypes.length)
        browserTypes = ['chromium', 'firefox', 'webkit'];
    browserTypes.push('tools');
    const ubuntuVersion = await ubuntuVersion_1.getUbuntuVersion();
    if (ubuntuVersion !== '18.04' && ubuntuVersion !== '20.04') {
        console.warn('Cannot install dependencies for this linux distribution!'); // eslint-disable-line no-console
        return;
    }
    const libraries = [];
    for (const browserType of browserTypes) {
        if (ubuntuVersion === '18.04')
            libraries.push(...deps['bionic'][browserType]);
        else if (ubuntuVersion === '20.04')
            libraries.push(...deps['focal'][browserType]);
    }
    const uniqueLibraries = Array.from(new Set(libraries));
    console.log('Installing Ubuntu dependencies...'); // eslint-disable-line no-console
    const commands = [];
    commands.push('apt-get update');
    commands.push(['apt-get', 'install', '-y', '--no-install-recommends',
        ...uniqueLibraries,
    ].join(' '));
    const child = child_process_1.default.spawn('sudo', ['--', 'sh', '-c', `${commands.join('; ')}`], { stdio: 'inherit' });
    await new Promise(f => child.on('exit', f));
}
exports.installDeps = installDeps;
//# sourceMappingURL=installDeps.js.map