/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.gen;

import com.mockrunner.gen.proc.AdapterProcessor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractAdapterGenerator {
    protected void generate() throws Exception {
        List units = this.initialize();
        for (ProcessingUnit nextUnit : units) {
            AdapterProcessor processor = nextUnit.getProcessor();
            processor.process(nextUnit.getModule(), nextUnit.getExcludedMethods());
            this.writeOutputFile(processor);
        }
        System.out.println("Adapters successfully created");
    }

    private void writeOutputFile(AdapterProcessor processor) throws FileNotFoundException, IOException {
        System.out.println("Writing output file " + processor.getName());
        File currentFile = new File(this.getSrcDir() + "/" + processor.getName());
        FileOutputStream currentStream = new FileOutputStream(currentFile);
        OutputStreamWriter currentWriter = new OutputStreamWriter((OutputStream)currentStream, "ISO-8859-1");
        currentWriter.write(processor.getOutput());
        ((Writer)currentWriter).flush();
        ((Writer)currentWriter).close();
    }

    protected abstract List initialize();

    protected abstract String getSrcDir();

    protected class ProcessingUnit {
        private Class module;
        private AdapterProcessor processor;
        private List excludedMethods;

        public ProcessingUnit(Class module, AdapterProcessor processor) {
            this(module, processor, new ArrayList());
        }

        public ProcessingUnit(Class module, AdapterProcessor processor, List excludedMethods) {
            this.module = module;
            this.processor = processor;
            this.excludedMethods = excludedMethods;
        }

        public Class getModule() {
            return this.module;
        }

        public List getExcludedMethods() {
            return this.excludedMethods;
        }

        public AdapterProcessor getProcessor() {
            return this.processor;
        }
    }
}

