/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.gen;

import com.mockrunner.gen.proc.JavaLineParser;
import com.mockrunner.gen.proc.JavaLineProcessor;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class JavaLineProcessorTest
extends TestCase {
    private static final String NL = System.getProperty("line.separator");

    private String getValidTestCode() {
        StringBuffer testJava = new StringBuffer();
        testJava.append("package com.mockrunner.test.consistency;\n");
        testJava.append("\n");
        testJava.append("import java.io.FileInputStream;\n");
        testJava.append("import java.io.FileReader;\n");
        testJava.append("\n");
        testJava.append("import junit.framework.TestCase;\n");
        testJava.append("\n");
        testJava.append("public class JavaLineParserTest extends TestCase\n");
        testJava.append("{\n");
        testJava.append("    private String test;\n");
        testJava.append("    protected int myInt;\n");
        testJava.append("    public test()\n");
        testJava.append("{\n");
        testJava.append(" //do it\n");
        testJava.append(" if(true)\n");
        testJava.append("{\n");
        testJava.append("  \t}\n");
        testJava.append("}\n");
        testJava.append("\n");
        testJava.append("public anotherMethod()\n");
        testJava.append("{\n");
        testJava.append("}  \n");
        testJava.append("}");
        return testJava.toString();
    }

    private String getInvalidTestCode() {
        StringBuffer testJava = new StringBuffer();
        testJava.append("package com.mockrunner.test.consistency;\n");
        testJava.append("\n");
        testJava.append("import java.io.FileInputStream;\n");
        testJava.append("import java.io.FileReader;\n");
        testJava.append("");
        testJava.append("import junit.framework.TestCase;\n");
        testJava.append("\n");
        testJava.append("public class JavaLineParserTest extends TestCase\n");
        testJava.append("{\n");
        testJava.append("    private String test;\n");
        testJava.append("    protected int myInt;\n");
        testJava.append("    public test()\n");
        testJava.append("{\n");
        testJava.append(" //do it\n");
        testJava.append(" if(true)\n");
        testJava.append("{\n");
        testJava.append("{\n");
        testJava.append("  \t}\n");
        testJava.append("}}}}}}}}}}}}\n");
        return testJava.toString();
    }

    private String getNestedTestCode() {
        StringBuffer testJava = new StringBuffer();
        testJava.append("test\n");
        testJava.append("\n");
        testJava.append("\n");
        testJava.append("{\n");
        testJava.append("{\n");
        testJava.append("ff{sfs\n");
        testJava.append("yxv{yxvx\n");
        testJava.append("\n");
        testJava.append("abc\n");
        testJava.append("}}\n");
        testJava.append("abc\n");
        testJava.append("\n");
        testJava.append("\n");
        testJava.append("}\n");
        testJava.append("}\n");
        testJava.append("}}}\n");
        return testJava.toString();
    }

    public void testParseValid() throws Exception {
        JavaLineParser parser = new JavaLineParser();
        ArrayList<String> lineList = new ArrayList<String>();
        lineList.add("import java.io.FileReader");
        lineList.add("java.io.FileInputStream");
        parser.addLines(lineList);
        parser.addLine("blic clas");
        ArrayList<String> blockList = new ArrayList<String>();
        blockList.add("public test()");
        parser.addBlocks(blockList);
        parser.addBlock("anotherMethod");
        List result = parser.parse(this.getValidTestCode());
        JavaLineProcessorTest.assertEquals((int)5, (int)result.size());
        JavaLineParser.Line line1 = (JavaLineParser.Line)result.get(0);
        JavaLineProcessorTest.assertEquals((String)"import java.io.FileInputStream;", (String)line1.getLine());
        JavaLineProcessorTest.assertEquals((int)3, (int)line1.getLineNumber());
        JavaLineParser.Line line2 = (JavaLineParser.Line)result.get(1);
        JavaLineProcessorTest.assertEquals((String)"import java.io.FileReader;", (String)line2.getLine());
        JavaLineProcessorTest.assertEquals((int)4, (int)line2.getLineNumber());
        JavaLineParser.Line line3 = (JavaLineParser.Line)result.get(2);
        JavaLineProcessorTest.assertEquals((String)"public class JavaLineParserTest extends TestCase", (String)line3.getLine());
        JavaLineProcessorTest.assertEquals((int)8, (int)line3.getLineNumber());
        JavaLineParser.Block block1 = (JavaLineParser.Block)result.get(3);
        JavaLineProcessorTest.assertEquals((String)"    public test()", (String)block1.getLine());
        JavaLineProcessorTest.assertEquals((int)12, (int)block1.getLineNumber());
        JavaLineProcessorTest.assertEquals((int)18, (int)block1.getEndLineNumber());
        JavaLineParser.Block block2 = (JavaLineParser.Block)result.get(4);
        JavaLineProcessorTest.assertEquals((String)"public anotherMethod()", (String)block2.getLine());
        JavaLineProcessorTest.assertEquals((int)20, (int)block2.getLineNumber());
        JavaLineProcessorTest.assertEquals((int)22, (int)block2.getEndLineNumber());
    }

    public void testParseInvalid() throws Exception {
        JavaLineParser parser = new JavaLineParser();
        parser.addLine("import java.io.FileReader");
        parser.addBlock("public test()");
        try {
            parser.parse(this.getInvalidTestCode());
            JavaLineProcessorTest.fail();
        }
        catch (RuntimeException exc) {
            JavaLineProcessorTest.assertTrue((exc.getMessage().indexOf("Blocks not found") != -1 ? 1 : 0) != 0);
            JavaLineProcessorTest.assertTrue((exc.getMessage().indexOf("public test()") != -1 ? 1 : 0) != 0);
            JavaLineProcessorTest.assertTrue((exc.getMessage().indexOf("Lines not found") == -1 ? 1 : 0) != 0);
        }
    }

    public void testParseDeeplyNested() throws Exception {
        String testJava = this.getNestedTestCode();
        JavaLineParser parser = new JavaLineParser();
        parser.addBlock("test");
        List result = parser.parse(testJava);
        JavaLineProcessorTest.assertEquals((int)1, (int)result.size());
        JavaLineParser.Block block1 = (JavaLineParser.Block)result.get(0);
        JavaLineProcessorTest.assertEquals((String)"test", (String)block1.getLine());
        JavaLineProcessorTest.assertEquals((int)1, (int)block1.getLineNumber());
        JavaLineProcessorTest.assertEquals((int)16, (int)block1.getEndLineNumber());
    }

    public void testParseError() throws Exception {
        JavaLineParser parser = new JavaLineParser();
        ArrayList<String> lineList = new ArrayList<String>();
        lineList.add("imprt java.io.FileReader");
        lineList.add("java.io.FileInputStream");
        parser.addLines(lineList);
        parser.addLine("blic clas");
        ArrayList<String> blockList = new ArrayList<String>();
        blockList.add("public test)");
        parser.addBlocks(blockList);
        parser.addBlock("anotherethod");
        try {
            parser.parse(this.getValidTestCode());
            JavaLineProcessorTest.fail();
        }
        catch (RuntimeException exc) {
            JavaLineProcessorTest.assertTrue((exc.getMessage().indexOf("Lines not found") != -1 ? 1 : 0) != 0);
            JavaLineProcessorTest.assertTrue((exc.getMessage().indexOf("imprt java.io.FileReader") != -1 ? 1 : 0) != 0);
            JavaLineProcessorTest.assertTrue((exc.getMessage().indexOf("Blocks not found") != -1 ? 1 : 0) != 0);
            JavaLineProcessorTest.assertTrue((exc.getMessage().indexOf("public test)") != -1 ? 1 : 0) != 0);
            JavaLineProcessorTest.assertTrue((exc.getMessage().indexOf("anotherethod") != -1 ? 1 : 0) != 0);
        }
    }

    public void testProcessValid() throws Exception {
        String testCode = this.getValidTestCode();
        JavaLineProcessor processor = new JavaLineProcessor();
        ArrayList<String> lineList = new ArrayList<String>();
        lineList.add("import java.io.FileReader");
        processor.addLines(lineList);
        processor.addLine("java.io.FileInputStream");
        ArrayList<String> blockList = new ArrayList<String>();
        blockList.add("public test()");
        processor.addBlocks(blockList);
        processor.addBlock("anotherMethod");
        String result = processor.process(testCode);
        JavaLineProcessorTest.assertTrue((-1 != result.indexOf("//import java.io.FileReader") ? 1 : 0) != 0);
        JavaLineProcessorTest.assertTrue((-1 != result.indexOf("//import java.io.FileInputStream") ? 1 : 0) != 0);
        JavaLineProcessorTest.assertTrue((-1 != result.indexOf("    /*public test()" + NL + "{" + NL + " //do it" + NL + " if(true)" + NL + "{" + NL + "  \t}" + NL + "}*/") ? 1 : 0) != 0);
        JavaLineProcessorTest.assertTrue((-1 != result.indexOf("/*public anotherMethod()" + NL + "{" + NL + "}*/") ? 1 : 0) != 0);
        JavaLineProcessorTest.assertEquals((String)this.stripChars(testCode), (String)this.stripChars(result));
    }

    public void testProcessDeeplyNested() throws Exception {
        String testJava = this.getNestedTestCode();
        JavaLineProcessor processor = new JavaLineProcessor();
        ArrayList<String> blockList = new ArrayList<String>();
        blockList.add("test");
        processor.addBlocks(blockList);
        String result = processor.process(testJava);
        JavaLineProcessorTest.assertTrue((boolean)result.trim().startsWith("/*"));
        JavaLineProcessorTest.assertTrue((boolean)result.trim().endsWith("*/"));
    }

    public void testProcessCommentAll() throws Exception {
        String testCode = this.getValidTestCode();
        JavaLineProcessor processor = new JavaLineProcessor();
        ArrayList<String> lineList = new ArrayList<String>();
        lineList.add("");
        processor.addLines(lineList);
        String result = processor.process(testCode);
        BufferedReader reader = new BufferedReader(new StringReader(result));
        String currentLine = null;
        while ((currentLine = reader.readLine()) != null) {
            JavaLineProcessorTest.assertTrue((boolean)currentLine.trim().startsWith("//"));
        }
    }

    public void testProcessDoubleLine() throws Exception {
        String testCode = "First line\nSecond line\nFirst line";
        JavaLineProcessor processor = new JavaLineProcessor();
        ArrayList<String> lineList = new ArrayList<String>();
        lineList.add("First line");
        processor.addLines(lineList);
        String result = processor.process(testCode);
        BufferedReader reader = new BufferedReader(new StringReader(result));
        JavaLineProcessorTest.assertTrue((boolean)reader.readLine().trim().startsWith("//"));
        JavaLineProcessorTest.assertFalse((boolean)reader.readLine().trim().startsWith("//"));
        JavaLineProcessorTest.assertTrue((boolean)reader.readLine().trim().startsWith("//"));
    }

    public void testProcessDoubleBlock() throws Exception {
        String testCode = "Block\n{\n}\notherBlock\n{\n}\notherBlock\n{\n}\n";
        JavaLineProcessor processor = new JavaLineProcessor();
        ArrayList<String> blockList = new ArrayList<String>();
        blockList.add("otherBlock");
        processor.addBlocks(blockList);
        String result = processor.process(testCode);
        String expected = "Block" + NL + "{" + NL + "}" + NL + "/*otherBlock" + NL + "{" + NL + "}*/" + NL + "/*otherBlock" + NL + "{" + NL + "}*/" + NL;
        JavaLineProcessorTest.assertEquals((String)result, (String)expected);
    }

    private String stripChars(String theString) {
        StringBuffer buffer = new StringBuffer(theString);
        int ii = 0;
        while (ii < buffer.length()) {
            char currentChar = buffer.charAt(ii);
            if (Character.isWhitespace(currentChar) || currentChar == '/' || currentChar == '*') {
                buffer.deleteCharAt(ii);
                continue;
            }
            ++ii;
        }
        return buffer.toString();
    }
}

