/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.web;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.mock.web.MockBodyContent;
import com.mockrunner.mock.web.MockExpressionEvaluator;
import com.mockrunner.mock.web.MockJspWriter;
import com.mockrunner.mock.web.MockVariableResolver;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;
import javax.el.ELContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.el.ExpressionEvaluator;
import javax.servlet.jsp.el.VariableResolver;
import javax.servlet.jsp.tagext.BodyContent;

public class MockPageContext
extends PageContext {
    protected ServletConfig config;
    protected ServletRequest request;
    protected ServletResponse response;
    private JspWriter jspWriter;
    private Stack outStack;
    private Exception exception;
    private Object page;
    private HashMap attributes;
    private ExpressionEvaluator evaluator;
    private VariableResolver resolver;
    private ELContext elContext;

    public MockPageContext() {
        this(null, null, null);
    }

    public MockPageContext(ServletConfig config, ServletRequest request, ServletResponse response) {
        this.config = config;
        this.request = request;
        this.jspWriter = new MockJspWriter();
        this.initJspWriterWithResponse(response);
        this.outStack = new Stack();
        this.attributes = new HashMap();
        this.evaluator = new MockExpressionEvaluator();
        this.resolver = new MockVariableResolver();
    }

    private void initJspWriterWithResponse(ServletResponse response) {
        this.response = response;
        if (null != response && response instanceof HttpServletResponse) {
            try {
                this.jspWriter = new MockJspWriter((HttpServletResponse)response);
            }
            catch (IOException exc) {
                throw new NestedApplicationException((Throwable)exc);
            }
        }
    }

    public void setJspWriter(JspWriter jspWriter) {
        this.jspWriter = jspWriter;
    }

    public void setPage(Object page) {
        this.page = page;
    }

    public void setServletConfig(ServletConfig config) {
        this.config = config;
    }

    public void setServletRequest(ServletRequest request) {
        this.request = request;
    }

    public void setServletResponse(ServletResponse response) {
        this.response = response;
        this.initJspWriterWithResponse(response);
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public Object findAttribute(String name) {
        Object value = this.getAttribute(name, 1);
        if (value == null) {
            value = this.getAttribute(name, 2);
        }
        if (value == null) {
            value = this.getAttribute(name, 3);
        }
        if (value == null) {
            value = this.getAttribute(name, 4);
        }
        return value;
    }

    public Object getAttribute(String name) {
        return this.getAttribute(name, 1);
    }

    public Object getAttribute(String name, int scope) {
        if (scope == 1) {
            return this.attributes.get(name);
        }
        if (scope == 2) {
            if (null == this.request) {
                return null;
            }
            return this.request.getAttribute(name);
        }
        if (scope == 3) {
            if (null == this.getSession()) {
                return null;
            }
            return this.getSession().getAttribute(name);
        }
        if (scope == 4) {
            if (null == this.getServletContext()) {
                return null;
            }
            return this.getServletContext().getAttribute(name);
        }
        throw new IllegalArgumentException("Invalid scope " + scope);
    }

    public void removeAttribute(String name) {
        int scope = this.getAttributesScope(name);
        if (scope != 0) {
            this.removeAttribute(name, scope);
        }
    }

    public void removeAttribute(String name, int scope) {
        if (scope == 1) {
            this.attributes.remove(name);
        } else if (scope == 2) {
            if (this.request != null) {
                this.request.removeAttribute(name);
            }
        } else if (scope == 3) {
            if (this.getSession() != null) {
                this.getSession().removeAttribute(name);
            }
        } else if (scope == 4) {
            if (this.getServletContext() != null) {
                this.getServletContext().removeAttribute(name);
            }
        } else {
            throw new IllegalArgumentException("Invalid scope " + scope);
        }
    }

    public void setAttribute(String name, Object value) {
        this.setAttribute(name, value, 1);
    }

    public void setAttribute(String name, Object value, int scope) {
        if (scope == 1) {
            this.attributes.put(name, value);
        } else if (scope == 2) {
            if (this.request != null) {
                this.request.setAttribute(name, value);
            }
        } else if (scope == 3) {
            if (this.getSession() != null) {
                this.getSession().setAttribute(name, value);
            }
        } else if (scope == 4) {
            if (this.getServletContext() != null) {
                this.getServletContext().setAttribute(name, value);
            }
        } else {
            throw new IllegalArgumentException("Invalid scope " + scope);
        }
    }

    public int getAttributesScope(String name) {
        if (this.getAttribute(name, 1) != null) {
            return 1;
        }
        if (this.getAttribute(name, 2) != null) {
            return 2;
        }
        if (this.getAttribute(name, 3) != null) {
            return 3;
        }
        if (this.getAttribute(name, 4) != null) {
            return 4;
        }
        return 0;
    }

    public Enumeration getAttributeNamesInScope(int scope) {
        if (scope == 1) {
            return new WrappedEnumeration(this.attributes.keySet().iterator());
        }
        if (scope == 2) {
            if (this.request == null) {
                return new NullEnumeration();
            }
            return this.request.getAttributeNames();
        }
        if (scope == 3) {
            if (this.getSession() == null) {
                return new NullEnumeration();
            }
            return this.getSession().getAttributeNames();
        }
        if (scope == 4) {
            if (this.getServletContext() == null) {
                return new NullEnumeration();
            }
            return this.getServletContext().getAttributeNames();
        }
        throw new IllegalArgumentException("Invalid scope " + scope);
    }

    public JspWriter getOut() {
        return this.jspWriter;
    }

    public Exception getException() {
        return this.exception;
    }

    public Object getPage() {
        return this.page;
    }

    public ServletRequest getRequest() {
        return this.request;
    }

    public ServletResponse getResponse() {
        return this.response;
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public ServletContext getServletContext() {
        if (null == this.config) {
            return null;
        }
        return this.config.getServletContext();
    }

    public HttpSession getSession() {
        if (null == this.request) {
            return null;
        }
        return ((HttpServletRequest)this.request).getSession();
    }

    public void handlePageException(Exception exc) {
    }

    public void handlePageException(Throwable thr) {
    }

    public void forward(String path) throws ServletException, IOException {
        RequestDispatcher dispatcher;
        if (null != this.request && null != (dispatcher = this.request.getRequestDispatcher(path))) {
            dispatcher.forward(this.request, this.response);
        }
    }

    public void include(String path) throws ServletException, IOException {
        RequestDispatcher dispatcher;
        if (null != this.request && null != (dispatcher = this.request.getRequestDispatcher(path))) {
            dispatcher.include(this.request, this.response);
        }
    }

    public void include(String path, boolean flush) throws ServletException, IOException {
        if (flush) {
            this.jspWriter.flush();
        }
        this.include(path);
    }

    public void initialize(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoFlush) {
        this.config = servlet.getServletConfig();
        this.request = request;
        this.response = response;
        this.jspWriter = new MockJspWriter();
        this.outStack = new Stack();
        this.attributes = new HashMap();
    }

    public JspWriter popBody() {
        this.jspWriter = (JspWriter)this.outStack.pop();
        return this.jspWriter;
    }

    public BodyContent pushBody() {
        this.outStack.push(this.jspWriter);
        this.jspWriter = new MockBodyContent(this.jspWriter);
        return (BodyContent)this.jspWriter;
    }

    public JspWriter pushBody(Writer writer) {
        this.outStack.push(this.jspWriter);
        this.jspWriter = new MockJspWriter(writer);
        return this.jspWriter;
    }

    public void release() {
        this.jspWriter = new MockJspWriter();
        this.outStack = new Stack();
    }

    public void setExpressionEvaluator(ExpressionEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    public void setVariableResolver(VariableResolver resolver) {
        this.resolver = resolver;
    }

    public void setELContext(ELContext elContext) {
        this.elContext = elContext;
    }

    public ExpressionEvaluator getExpressionEvaluator() {
        return this.evaluator;
    }

    public VariableResolver getVariableResolver() {
        return this.resolver;
    }

    public ELContext getELContext() {
        return this.elContext;
    }

    private class WrappedEnumeration
    implements Enumeration {
        private Iterator iterator;

        public WrappedEnumeration(Iterator iterator) {
            this.iterator = iterator;
        }

        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        public Object nextElement() {
            return this.iterator.next();
        }
    }

    private class NullEnumeration
    implements Enumeration {
        private NullEnumeration() {
        }

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException();
        }
    }
}

