/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.maven.plugin.license.header;

import com.mycila.maven.plugin.license.util.FileUtils;
import com.mycila.maven.plugin.license.util.resource.ResourceFinder;
import java.io.IOException;
import java.net.URL;

public abstract class HeaderSource {
    protected final String content;
    private final boolean inline;

    public static HeaderSource of(String headerPath, String encoding, ResourceFinder finder) {
        return HeaderSource.of(null, encoding, finder);
    }

    public static HeaderSource of(String inlineHeader, String headerPath, String encoding, ResourceFinder finder) {
        if (inlineHeader != null && !inlineHeader.isEmpty()) {
            return new LiteralHeaderSource(inlineHeader);
        }
        if (headerPath == null) {
            throw new IllegalArgumentException("Either inlineHeader or header path need to be specified");
        }
        try {
            URL headerUrl = finder.findResource(headerPath);
            return new UrlHeaderSource(headerUrl, encoding);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot read header document " + headerPath + ". Cause: " + e.getMessage(), e);
        }
    }

    public HeaderSource(String content, boolean inline) {
        this.content = content;
        this.inline = inline;
    }

    public String getContent() {
        return this.content;
    }

    public boolean isInline() {
        return this.inline;
    }

    public abstract boolean isFromUrl(URL var1);

    public static class LiteralHeaderSource
    extends HeaderSource {
        public LiteralHeaderSource(String content) {
            super(content, true);
        }

        @Override
        public boolean isFromUrl(URL location) {
            return false;
        }

        public String toString() {
            return "inline: " + this.content;
        }
    }

    public static class UrlHeaderSource
    extends HeaderSource {
        private final URL url;

        public UrlHeaderSource(URL url, String encoding) throws IOException {
            super(FileUtils.read(url, encoding), false);
            this.url = url;
        }

        @Override
        public boolean isFromUrl(URL location) {
            return this.url.equals(location);
        }

        public String toString() {
            return this.url + ": " + this.content;
        }
    }
}

