/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose;

import com.nimbusds.jose.AlgorithmFamily;
import com.nimbusds.jose.ECKey;
import com.nimbusds.jose.RSAKey;
import com.nimbusds.jose.Use;
import com.nimbusds.jose.util.JSONObjectUtils;
import java.text.ParseException;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONObject;

public abstract class JWK
implements JSONAware {
    private final AlgorithmFamily alg;
    private final Use use;
    private final String kid;

    public JWK(AlgorithmFamily alg, Use use, String kid) {
        if (alg == null) {
            throw new IllegalArgumentException("The algorithm family \"alg\" must not be null");
        }
        this.alg = alg;
        this.use = use;
        this.kid = kid;
    }

    public AlgorithmFamily getAlgorithmFamily() {
        return this.alg;
    }

    public Use getKeyUse() {
        return this.use;
    }

    public String getKeyID() {
        return this.kid;
    }

    public JSONObject toJSONObject() {
        JSONObject o = new JSONObject();
        o.put((Object)"alg", (Object)this.alg.toString());
        if (this.use != null) {
            if (this.use == Use.SIGNATURE) {
                o.put((Object)"use", (Object)"sig");
            }
            if (this.use == Use.ENCRYPTION) {
                o.put((Object)"use", (Object)"enc");
            }
        }
        if (this.kid != null) {
            o.put((Object)"kid", (Object)this.kid);
        }
        return o;
    }

    public String toJSONString() {
        return this.toJSONObject().toString();
    }

    public String toString() {
        return this.toJSONObject().toString();
    }

    public static JWK parse(String s) throws ParseException {
        return JWK.parse(JSONObjectUtils.parseJSONObject(s));
    }

    public static JWK parse(JSONObject jsonObject) throws ParseException {
        AlgorithmFamily alg = AlgorithmFamily.parse(JSONObjectUtils.getString(jsonObject, "alg"));
        if (alg == AlgorithmFamily.EC) {
            return ECKey.parse(jsonObject);
        }
        if (alg == AlgorithmFamily.RSA) {
            return RSAKey.parse(jsonObject);
        }
        throw new ParseException("Unsupported algorithm family \"alg\" parameter: " + alg, 0);
    }

    protected static Use parseKeyUse(JSONObject jsonObject) throws ParseException {
        if (jsonObject.get((Object)"use") == null) {
            return null;
        }
        String useStr = JSONObjectUtils.getString(jsonObject, "use");
        if (useStr.equals("sig")) {
            return Use.SIGNATURE;
        }
        if (useStr.equals("enc")) {
            return Use.ENCRYPTION;
        }
        throw new ParseException("Invalid or unsupported key use \"use\" parameter, must be \"sig\" or \"enc\"", 0);
    }

    protected static String parseKeyID(JSONObject jsonObject) throws ParseException {
        if (jsonObject.get((Object)"kid") == null) {
            return null;
        }
        return JSONObjectUtils.getString(jsonObject, "kid");
    }
}

