/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose;

import com.nimbusds.jose.JWK;
import com.nimbusds.jose.util.JSONObjectUtils;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;

public class JWKSet {
    private final List<JWK> keys = new LinkedList<JWK>();
    private final Map<String, Object> customMembers = new HashMap<String, Object>();

    public JWKSet() {
    }

    public JWKSet(JWK key) {
        if (key == null) {
            throw new IllegalArgumentException("The JWK must not be null");
        }
        this.keys.add(key);
    }

    public JWKSet(List<JWK> keys) {
        if (keys == null) {
            throw new IllegalArgumentException("The JWK list must not be null");
        }
        this.keys.addAll(keys);
    }

    public JWKSet(List<JWK> keys, Map<String, Object> customMembers) {
        if (keys == null) {
            throw new IllegalArgumentException("The JWK list must not be null");
        }
        this.keys.addAll(keys);
        this.customMembers.putAll(customMembers);
    }

    public List<JWK> getKeys() {
        return this.keys;
    }

    public Map<String, Object> getAdditionalMembers() {
        return this.customMembers;
    }

    public JSONObject toJSONObject() {
        JSONArray a = new JSONArray();
        Iterator<JWK> it = this.keys.iterator();
        while (it.hasNext()) {
            a.add((Object)it.next().toJSONObject());
        }
        JSONObject o = new JSONObject();
        o.put((Object)"keys", (Object)a);
        o.putAll(this.customMembers);
        return o;
    }

    public String toString() {
        return this.toJSONObject().toString();
    }

    public static JWKSet parse(String s) throws ParseException {
        return JWKSet.parse(JSONObjectUtils.parseJSONObject(s));
    }

    public static JWKSet parse(JSONObject json) throws ParseException {
        JSONArray keyArray = JSONObjectUtils.getJSONArray(json, "keys");
        LinkedList<JWK> keys = new LinkedList<JWK>();
        for (int i = 0; i < keyArray.size(); ++i) {
            if (!(keyArray.get(i) instanceof JSONObject)) {
                throw new ParseException("The \"keys\" JSON array must contain JSON objects only", 0);
            }
            JSONObject keyJSON = (JSONObject)keyArray.get(i);
            try {
                keys.add(JWK.parse(keyJSON));
                continue;
            }
            catch (ParseException e) {
                throw new ParseException("Invalid JWK at position " + i + ": " + e.getMessage(), 0);
            }
        }
        JWKSet jwkSet = new JWKSet(keys);
        for (Map.Entry entry : json.entrySet()) {
            if (entry.getKey() == null || ((String)entry.getKey()).equals("keys")) continue;
            jwkSet.getAdditionalMembers().put((String)entry.getKey(), entry.getValue());
        }
        return jwkSet;
    }
}

