/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose;

import com.nimbusds.jose.AlgorithmFamily;
import com.nimbusds.jose.JWK;
import com.nimbusds.jose.Use;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jose.util.JSONObjectUtils;
import java.text.ParseException;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;

@Immutable
public final class RSAKey
extends JWK {
    private final Base64URL n;
    private final Base64URL e;

    public RSAKey(Base64URL n, Base64URL e, Use use, String kid) {
        super(AlgorithmFamily.RSA, use, kid);
        if (n == null) {
            throw new IllegalArgumentException("The modulus value must not be null");
        }
        this.n = n;
        if (e == null) {
            throw new IllegalArgumentException("The exponent value must not be null");
        }
        this.e = e;
    }

    public Base64URL getModulus() {
        return this.n;
    }

    public Base64URL getExponent() {
        return this.e;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject o = super.toJSONObject();
        o.put((Object)"n", (Object)this.n.toString());
        o.put((Object)"e", (Object)this.e.toString());
        return o;
    }

    public static RSAKey parse(JSONObject jsonObject) throws ParseException {
        AlgorithmFamily af = AlgorithmFamily.parse(JSONObjectUtils.getString(jsonObject, "alg"));
        Base64URL mod = new Base64URL(JSONObjectUtils.getString(jsonObject, "n"));
        Base64URL exp = new Base64URL(JSONObjectUtils.getString(jsonObject, "e"));
        Use use = JWK.parseKeyUse(jsonObject);
        String id = JWK.parseKeyID(jsonObject);
        if (af != AlgorithmFamily.RSA) {
            throw new ParseException("The algorithm family \"alg\" must be RSA", 0);
        }
        return new RSAKey(mod, exp, use, id);
    }
}

