/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.crypto.BaseJWSProvider;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.Mac;

abstract class MACProvider
extends BaseJWSProvider {
    private static final Set<JWSAlgorithm> SUPPORTED_ALGORITHMS;
    private final byte[] sharedSecret;

    protected MACProvider(byte[] sharedSecret) {
        super(SUPPORTED_ALGORITHMS);
        if (sharedSecret == null) {
            throw new IllegalArgumentException("The shared secret must not be null");
        }
        this.sharedSecret = sharedSecret;
    }

    public byte[] getSharedSecret() {
        return this.sharedSecret;
    }

    protected static Mac getMAC(JWSAlgorithm alg) throws JOSEException {
        String internalAlgName = null;
        if (alg.equals(JWSAlgorithm.HS256)) {
            internalAlgName = "HMACSHA256";
        } else if (alg.equals(JWSAlgorithm.HS384)) {
            internalAlgName = "HMACSHA384";
        } else if (alg.equals(JWSAlgorithm.HS512)) {
            internalAlgName = "HMACSHA512";
        } else {
            throw new JOSEException("Unsupported HMAC algorithm, must be HS256, HS384 or HS512");
        }
        try {
            return Mac.getInstance(internalAlgName);
        }
        catch (NoSuchAlgorithmException e) {
            throw new JOSEException("Unsupported HMAC algorithm: " + e.getMessage(), e);
        }
    }

    static {
        HashSet<JWSAlgorithm> algs = new HashSet<JWSAlgorithm>();
        algs.add(JWSAlgorithm.HS256);
        algs.add(JWSAlgorithm.HS384);
        algs.add(JWSAlgorithm.HS512);
        SUPPORTED_ALGORITHMS = algs;
    }
}

