/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.ReadOnlyJWSHeader;
import com.nimbusds.jose.crypto.MACProvider;
import com.nimbusds.jose.util.Base64URL;
import java.security.InvalidKeyException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class MACSigner
extends MACProvider
implements JWSSigner {
    public MACSigner(byte[] sharedSecret) {
        super(sharedSecret);
    }

    @Override
    public Base64URL sign(ReadOnlyJWSHeader header, byte[] signableContent) throws JOSEException {
        Mac mac = MACSigner.getMAC(header.getAlgorithm());
        try {
            mac.init(new SecretKeySpec(this.getSharedSecret(), mac.getAlgorithm()));
        }
        catch (InvalidKeyException e) {
            throw new JOSEException("Invalid HMAC key: " + e.getMessage(), e);
        }
        mac.update(signableContent);
        return Base64URL.encode(mac.doFinal());
    }
}

