/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSHeaderFilter;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.ReadOnlyJWSHeader;
import com.nimbusds.jose.crypto.DefaultJWSHeaderFilter;
import com.nimbusds.jose.crypto.MACProvider;
import com.nimbusds.jose.util.Base64URL;
import java.security.InvalidKeyException;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class MACVerifier
extends MACProvider
implements JWSVerifier {
    private static final Set<String> ACCEPTED_HEADER_PARAMETERS;
    private DefaultJWSHeaderFilter headerFilter = new DefaultJWSHeaderFilter(this.supportedAlgorithms(), ACCEPTED_HEADER_PARAMETERS);

    public MACVerifier(byte[] sharedSecret) {
        super(sharedSecret);
    }

    @Override
    public JWSHeaderFilter getJWSHeaderFilter() {
        return this.headerFilter;
    }

    @Override
    public boolean verify(ReadOnlyJWSHeader header, byte[] signedContent, Base64URL signature) throws JOSEException {
        Mac mac = MACVerifier.getMAC(header.getAlgorithm());
        try {
            mac.init(new SecretKeySpec(this.getSharedSecret(), mac.getAlgorithm()));
        }
        catch (InvalidKeyException e) {
            throw new JOSEException("Invalid HMAC key: " + e.getMessage(), e);
        }
        mac.update(signedContent);
        Base64URL expectedSignature = Base64URL.encode(mac.doFinal());
        return expectedSignature.equals(signature);
    }

    static {
        HashSet<String> params = new HashSet<String>();
        params.add("alg");
        params.add("typ");
        params.add("cty");
        ACCEPTED_HEADER_PARAMETERS = params;
    }
}

