/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jwt;

import com.nimbusds.jose.util.JSONObjectUtils;
import com.nimbusds.jwt.ReadOnlyClaimsSet;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minidev.json.JSONObject;

public class ClaimsSet
implements ReadOnlyClaimsSet {
    private static final Set<String> RESERVED_CLAIM_NAMES;
    private long exp = -1L;
    private long nbf = -1L;
    private long iat = -1L;
    private String iss = null;
    private String aud = null;
    private String prn = null;
    private String jti = null;
    private String typ = null;
    private Map<String, Object> customClaims = new HashMap<String, Object>();

    public static Set<String> getReservedNames() {
        return RESERVED_CLAIM_NAMES;
    }

    @Override
    public long getExpirationTimeClaim() {
        return this.exp;
    }

    public void setExpirationTimeClaim(long exp) {
        this.exp = exp;
    }

    @Override
    public long getNotBeforeClaim() {
        return this.nbf;
    }

    public void setNotBeforeClaim(long nbf) {
        this.nbf = nbf;
    }

    @Override
    public long getIssuedAtClaim() {
        return this.iat;
    }

    public void setIssuedAtClaim(long iat) {
        this.iat = iat;
    }

    @Override
    public String getIssuerClaim() {
        return this.iss;
    }

    public void setIssuerClaim(String iss) {
        this.iss = iss;
    }

    @Override
    public String getAudienceClaim() {
        return this.aud;
    }

    public void setAudienceClaim(String aud) {
        this.aud = aud;
    }

    @Override
    public String getPrincipalClaim() {
        return this.prn;
    }

    public void setPrincipalClaim(String prn) {
        this.prn = prn;
    }

    @Override
    public String getJWTIDClaim() {
        return this.jti;
    }

    public void setJWTIDClaim(String jti) {
        this.jti = jti;
    }

    @Override
    public String getTypeClaim() {
        return this.typ;
    }

    public void setTypeClaim(String typ) {
        this.typ = typ;
    }

    @Override
    public Object getCustomClaim(String name) {
        return this.customClaims.get(name);
    }

    public void setCustomClaim(String name, Object value) {
        if (ClaimsSet.getReservedNames().contains(name)) {
            throw new IllegalArgumentException("The claim name \"" + name + "\" matches a reserved name");
        }
        this.customClaims.put(name, value);
    }

    @Override
    public Map<String, Object> getCustomClaims() {
        return Collections.unmodifiableMap(this.customClaims);
    }

    public void setCustomClaims(Map<String, Object> customClaims) {
        if (customClaims == null) {
            return;
        }
        this.customClaims = customClaims;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject o = new JSONObject(this.customClaims);
        if (this.exp > -1L) {
            o.put((Object)"exp", (Object)this.exp);
        }
        if (this.nbf > -1L) {
            o.put((Object)"nbf", (Object)this.nbf);
        }
        if (this.iat > -1L) {
            o.put((Object)"iat", (Object)this.iat);
        }
        if (this.iss != null) {
            o.put((Object)"iss", (Object)this.iss);
        }
        if (this.aud != null) {
            o.put((Object)"aud", (Object)this.aud);
        }
        if (this.prn != null) {
            o.put((Object)"prn", (Object)this.prn);
        }
        if (this.jti != null) {
            o.put((Object)"jti", (Object)this.jti);
        }
        if (this.typ != null) {
            o.put((Object)"typ", (Object)this.typ);
        }
        return o;
    }

    public static ClaimsSet parse(JSONObject json) throws ParseException {
        ClaimsSet cs = new ClaimsSet();
        for (String name : json.keySet()) {
            if (name.equals("exp")) {
                cs.setExpirationTimeClaim(JSONObjectUtils.getLong(json, "exp"));
                continue;
            }
            if (name.equals("nbf")) {
                cs.setNotBeforeClaim(JSONObjectUtils.getLong(json, "nbf"));
                continue;
            }
            if (name.equals("iat")) {
                cs.setIssuedAtClaim(JSONObjectUtils.getLong(json, "iat"));
                continue;
            }
            if (name.equals("iss")) {
                cs.setIssuerClaim(JSONObjectUtils.getString(json, "iss"));
                continue;
            }
            if (name.equals("aud")) {
                cs.setAudienceClaim(JSONObjectUtils.getString(json, "aud"));
                continue;
            }
            if (name.equals("prn")) {
                cs.setPrincipalClaim(JSONObjectUtils.getString(json, "prn"));
                continue;
            }
            if (name.equals("jti")) {
                cs.setJWTIDClaim(JSONObjectUtils.getString(json, "jti"));
                continue;
            }
            if (name.equals("typ")) {
                cs.setTypeClaim(JSONObjectUtils.getString(json, "typ"));
                continue;
            }
            cs.setCustomClaim(name, json.get((Object)name));
        }
        return cs;
    }

    static {
        HashSet<String> n = new HashSet<String>();
        n.add("exp");
        n.add("nbf");
        n.add("iat");
        n.add("iss");
        n.add("aud");
        n.add("prn");
        n.add("jti");
        n.add("typ");
        RESERVED_CLAIM_NAMES = Collections.unmodifiableSet(n);
    }
}

