/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.op;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.ReadOnlyJWTClaimsSet;
import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.SerializeException;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.OIDCError;
import com.nimbusds.openid.connect.sdk.op.ResolveException;
import com.nimbusds.openid.connect.sdk.util.JWTDecoder;
import com.nimbusds.openid.connect.sdk.util.Resource;
import com.nimbusds.openid.connect.sdk.util.ResourceRetriever;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;
import net.minidev.json.JSONObject;

@ThreadSafe
public class AuthenticationRequestResolver {
    private final JWTDecoder jwtDecoder;
    private final ResourceRetriever jwtRetriever;

    public AuthenticationRequestResolver() {
        this.jwtDecoder = null;
        this.jwtRetriever = null;
    }

    public AuthenticationRequestResolver(JWTDecoder jwtDecoder) {
        if (jwtDecoder == null) {
            throw new IllegalArgumentException("The JWT decoder must not be null");
        }
        this.jwtDecoder = jwtDecoder;
        this.jwtRetriever = null;
    }

    public AuthenticationRequestResolver(JWTDecoder jwtDecoder, ResourceRetriever jwtRetriever) {
        if (jwtDecoder == null) {
            throw new IllegalArgumentException("The JWT decoder must not be null");
        }
        this.jwtDecoder = jwtDecoder;
        if (jwtRetriever == null) {
            throw new IllegalArgumentException("The JWT retriever must not be null");
        }
        this.jwtRetriever = jwtRetriever;
    }

    public JWTDecoder getJWTDecoder() {
        return this.jwtDecoder;
    }

    public ResourceRetriever getJWTRetriever() {
        return this.jwtRetriever;
    }

    private JWT retrieveRequestObject(URL url) throws ResolveException {
        Resource resource;
        if (this.jwtRetriever == null) {
            throw new ResolveException("OpenID Connect request object cannot be resolved: No JWT retriever is configured");
        }
        try {
            resource = this.jwtRetriever.retrieveResource(url);
        }
        catch (IOException e) {
            throw new ResolveException("Couldn't retrieve OpenID Connect request object: " + e.getMessage(), e);
        }
        try {
            return JWTParser.parse((String)resource.getContent());
        }
        catch (java.text.ParseException e) {
            throw new ResolveException("Couldn't parse OpenID Connect request object: " + e.getMessage(), e);
        }
    }

    private ReadOnlyJWTClaimsSet decodeRequestObject(JWT requestObject) throws ResolveException {
        if (this.jwtDecoder == null) {
            throw new ResolveException("OpenID Connect request object cannot be decoded: No JWT decoder is configured");
        }
        try {
            return this.jwtDecoder.decodeJWT(requestObject);
        }
        catch (JOSEException e) {
            throw new ResolveException("Couldn't decode OpenID Connect request object JWT: " + e.getMessage(), e);
        }
        catch (java.text.ParseException e) {
            throw new ResolveException("Couldn't parse OpenID Connect request object JWT claims: " + e.getMessage(), e);
        }
    }

    public static Map<String, String> reformatClaims(ReadOnlyJWTClaimsSet claimsSet) throws ResolveException {
        Map claims = claimsSet.getAllClaims();
        HashMap reformattedClaims = new HashMap();
        for (Map.Entry entry : claims.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof String) {
                reformattedClaims.put(entry.getKey(), (String)value);
                continue;
            }
            if (value instanceof Boolean) {
                Boolean bool = (Boolean)value;
                reformattedClaims.put(entry.getKey(), bool.toString());
                continue;
            }
            if (value instanceof Number) {
                Number number = (Number)value;
                reformattedClaims.put(entry.getKey(), number.toString());
                continue;
            }
            if (value instanceof JSONObject) {
                JSONObject jsonObject = (JSONObject)value;
                reformattedClaims.put(entry.getKey(), jsonObject.toString());
                continue;
            }
            throw new ResolveException("Couldn't process JWT claim \"" + (String)entry.getKey() + "\": Unsupported type");
        }
        return Collections.unmodifiableMap(reformattedClaims);
    }

    public AuthenticationRequest resolve(AuthenticationRequest request) throws ResolveException {
        if (!request.specifiesRequestObject()) {
            return request;
        }
        try {
            AuthenticationRequest finalAuthRequest;
            JWT jwt;
            if (request.getRequestURI() != null) {
                URL requestURL;
                try {
                    requestURL = request.getRequestURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new ResolveException(e.getMessage(), e);
                }
                jwt = this.retrieveRequestObject(requestURL);
            } else {
                jwt = request.getRequestObject();
            }
            ReadOnlyJWTClaimsSet jwtClaims = this.decodeRequestObject(jwt);
            Map<String, String> requestObjectParams = AuthenticationRequestResolver.reformatClaims(jwtClaims);
            HashMap<String, String> finalParams = new HashMap<String, String>();
            try {
                finalParams.putAll(request.toParameters());
            }
            catch (SerializeException e) {
                throw new ResolveException("Couldn't resolve final OpenID Connect authentication request: " + e.getMessage(), e);
            }
            finalParams.putAll(requestObjectParams);
            try {
                finalAuthRequest = AuthenticationRequest.parse(request.getEndpointURI(), finalParams);
            }
            catch (ParseException e) {
                throw new ResolveException("Couldn't create final OpenID Connect authentication request: " + e.getMessage(), e);
            }
            return new AuthenticationRequest(finalAuthRequest.getEndpointURI(), finalAuthRequest.getResponseType(), finalAuthRequest.getScope(), finalAuthRequest.getClientID(), finalAuthRequest.getRedirectionURI(), finalAuthRequest.getState(), finalAuthRequest.getNonce(), finalAuthRequest.getDisplay(), finalAuthRequest.getPrompt(), finalAuthRequest.getMaxAge(), finalAuthRequest.getUILocales(), finalAuthRequest.getClaimsLocales(), finalAuthRequest.getIDTokenHint(), finalAuthRequest.getLoginHint(), finalAuthRequest.getACRValues(), finalAuthRequest.getClaims(), null, null);
        }
        catch (ResolveException e) {
            ErrorObject err = request.getRequestURI() != null ? OIDCError.INVALID_REQUEST_URI : OIDCError.INVALID_REQUEST_OBJECT;
            throw new ResolveException(e.getMessage(), err, request.getClientID(), request.getRedirectionURI(), request.getState(), e.getCause());
        }
    }
}

