/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client;

import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.Response;
import com.ning.http.client.cookie.Cookie;
import com.ning.http.client.uri.Uri;
import com.ning.http.util.AsyncHttpProviderUtils;
import com.ning.http.util.MiscUtils;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;

public abstract class ResponseBase
implements Response {
    protected final HttpResponseStatus status;
    protected final HttpResponseHeaders headers;
    protected final List<HttpResponseBodyPart> bodyParts;
    private List<Cookie> cookies;

    protected ResponseBase(HttpResponseStatus status, HttpResponseHeaders headers, List<HttpResponseBodyPart> bodyParts) {
        this.bodyParts = bodyParts;
        this.headers = headers;
        this.status = status;
    }

    protected abstract List<Cookie> buildCookies();

    protected Charset calculateCharset(String charset) {
        String contentType;
        if (charset == null && (contentType = this.getContentType()) != null) {
            charset = AsyncHttpProviderUtils.parseCharset(contentType);
        }
        return charset != null ? Charset.forName(charset) : AsyncHttpProviderUtils.DEFAULT_CHARSET;
    }

    @Override
    public final int getStatusCode() {
        return this.status.getStatusCode();
    }

    @Override
    public final String getStatusText() {
        return this.status.getStatusText();
    }

    @Override
    public final Uri getUri() {
        return this.status.getUri();
    }

    @Override
    public final String getContentType() {
        return this.headers != null ? this.getHeader("Content-Type") : null;
    }

    @Override
    public final String getHeader(String name) {
        return this.headers != null ? this.getHeaders().getFirstValue(name) : null;
    }

    @Override
    public final List<String> getHeaders(String name) {
        return this.headers != null ? this.getHeaders().get(name) : Collections.emptyList();
    }

    @Override
    public final FluentCaseInsensitiveStringsMap getHeaders() {
        return this.headers != null ? this.headers.getHeaders() : new FluentCaseInsensitiveStringsMap();
    }

    @Override
    public final boolean isRedirected() {
        switch (this.status.getStatusCode()) {
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 308: {
                return true;
            }
        }
        return false;
    }

    @Override
    public List<Cookie> getCookies() {
        if (this.cookies == null) {
            this.cookies = this.headers != null ? this.buildCookies() : Collections.emptyList();
        }
        return this.cookies;
    }

    @Override
    public boolean hasResponseStatus() {
        return this.status != null;
    }

    @Override
    public boolean hasResponseHeaders() {
        return this.headers != null && MiscUtils.isNonEmpty(this.headers.getHeaders());
    }

    @Override
    public boolean hasResponseBody() {
        return MiscUtils.isNonEmpty(this.bodyParts);
    }
}

