/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc;

import com.oceanbase.jdbc.JDBC4ResultSet;
import com.oceanbase.jdbc.OceanBaseConnection;
import com.oceanbase.jdbc.UrlParser;
import com.oceanbase.jdbc.internal.ColumnType;
import com.oceanbase.jdbc.internal.com.read.resultset.SelectResultSet;
import com.oceanbase.jdbc.util.Options;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public abstract class OceanBaseOracleDatabaseMetadata
implements DatabaseMetaData {
    private final UrlParser urlParser;
    private final OceanBaseConnection connection;

    public OceanBaseOracleDatabaseMetadata(UrlParser urlParser, Connection connection) {
        this.urlParser = urlParser;
        this.connection = (OceanBaseConnection)connection;
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        Statement stmt = this.connection.getMetadataSafeStatement();
        SelectResultSet rs = (SelectResultSet)stmt.executeQuery(sql);
        if (!rs.getStatement().isCursorResultSet()) {
            rs.setStatement(null);
        }
        rs.setForceTableAlias();
        return rs;
    }

    @Override
    public ResultSet getTypeInfo() {
        String[] columnNames = new String[]{"TYPE_NAME", "DATA_TYPE", "PRECISION", "LITERAL_PREFIX", "LITERAL_SUFFIX", "CREATE_PARAMS", "NULLABLE", "CASE_SENSITIVE", "SEARCHABLE", "UNSIGNED_ATTRIBUTE", "FIXED_PREC_SCALE", "AUTO_INCREMENT", "LOCAL_TYPE_NAME", "MINIMUM_SCALE", "MAXIMUM_SCALE", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "NUM_PREC_RADIX"};
        ColumnType[] columnTypes = new ColumnType[]{ColumnType.VARCHAR, ColumnType.INTEGER, ColumnType.INTEGER, ColumnType.VARCHAR, ColumnType.VARCHAR, ColumnType.VARCHAR, ColumnType.INTEGER, ColumnType.BIT, ColumnType.SMALLINT, ColumnType.BIT, ColumnType.BIT, ColumnType.BIT, ColumnType.VARCHAR, ColumnType.SMALLINT, ColumnType.SMALLINT, ColumnType.INTEGER, ColumnType.INTEGER, ColumnType.INTEGER};
        String[][] data = new String[][]{{"INTERVALDS", "-104", "4", "INTERVAL '", "'", null, "1", "0", "3", "0", "0", "0", "INTERVALDS", "0", "0", null, null, "10"}, {"INTERVALYM", "-103", "5", "INTERVAL '", "'", null, "1", "0", "3", "0", "0", "0", "INTERVALYM", "0", "0", null, null, "10"}, {"TIMESTAMP WITH LOCAL TIME ZONE", "-102", "11", "TIMESTAMP '", "'", null, "1", "0", "3", "0", "0", "0", "TIMESTAMP WITH LOCAL TIME ZONE", "0", "0", null, null, "10"}, {"TIMESTAMP WITH TIME ZONE", "-101", "13", "TIMESTAMP '", "'", null, "1", "0", "3", "0", "0", "0", "TIMESTAMP WITH TIME ZONE", "0", "0", null, null, "10"}, {"NCHAR", "-5", "2000", "'", "'", null, "1", "1", "3", "0", "0", "0", "NCHAR", "0", "0", null, null, "10"}, {"NVARCHAR2", "-9", "32766", "'", "'", null, "1", "1", "3", "0", "0", "0", "nVARCHAR2", "0", "0", null, null, "10"}, {"NUMBER", "-7", "1", null, null, "(1)", "1", "0", "3", "0", "1", "0", "NUMBER", "-84", "127", null, null, "10"}, {"NUMBER", "-6", "3", null, null, "(3)", "1", "0", "3", "0", "1", "0", "NUMBER", "-84", "127", null, null, "10"}, {"NUMBER", "-5", "38", null, null, null, "1", "0", "3", "0", "1", "0", "NUMBER", "-84", "127", null, null, "10"}, {"LONG RAW", "-4", "2147483647", "'", "'", null, "1", "0", "0", "0", "0", "0", "LONG RAW", "0", "0", null, null, "10"}, {"RAW", "-3", "32767", "'", "'", null, "1", "0", "3", "0", "0", "0", "RAW", "0", "0", null, null, "10"}, {"LONG", "-1", "2147483647", "'", "'", null, "1", "1", "0", "0", "0", "0", "LONG", "0", "0", null, null, "10"}, {"CHAR", "1", "2000", "'", "'", null, "1", "1", "3", "0", "0", "0", "CHAR", "0", "0", null, null, "10"}, {"NUMBER", "2", "38", null, null, null, "1", "0", "3", "0", "1", "0", "NUMBER", "-84", "127", null, null, "10"}, {"NUMBER", "4", "10", null, null, "(10)", "1", "0", "3", "0", "1", "0", "NUMBER", "-84", "127", null, null, "10"}, {"NUMBER", "5", "5", null, null, "(5)", "1", "0", "3", "0", "1", "0", "NUMBER", "-84", "127", null, null, "10"}, {"FLOAT", "6", "63", null, null, null, "1", "0", "3", "0", "1", "0", "FLOAT", "-84", "127", null, null, "10"}, {"REAL", "7", "63", null, null, null, "1", "0", "3", "0", "1", "0", "REAL", "-84", "127", null, null, "10"}, {"VARCHAR2", "12", "32767", "'", "'", null, "1", "1", "3", "0", "0", "0", "VARCHAR2", "0", "0", null, null, "10"}, {"DATE", "92", "7", "DATE '", "'", null, "1", "0", "3", "0", "0", "0", "DATE", "0", "0", null, null, "10"}, {"DATE", "93", "7", "DATE '", "'", null, "1", "0", "3", "0", "0", "0", "DATE", "0", "0", null, null, "10"}, {"TIMESTAMP", "93", "11", "TIMESTAMP '", "'", null, "1", "0", "3", "0", "0", "0", "TIMESTAMP", "0", "0", null, null, "10"}, {"STRUCT", "2002", "0", "'", "'", null, "1", "1", "0", "0", "0", "0", "STRUCT", "0", "0", null, null, "10"}, {"ARRAY", "2003", "0", "'", "'", null, "1", "1", "0", "0", "0", "0", "ARRAY", "0", "0", null, null, "10"}, {"BLOB", "2004", "-1", null, null, null, "1", "0", "0", "0", "0", "0", "BLOB", "0", "0", null, null, "10"}, {"CLOB", "2005", "-1", "'", "'", null, "1", "1", "0", "0", "0", "0", "CLOB", "0", "0", null, null, "10"}, {"REF", "2005", "-1", "'", "'", null, "1", "1", "0", "0", "0", "0", "REF", "0", "0", null, null, "10"}, {"NCLOB", "2011", "-1", "'", "'", null, "1", "1", "0", "0", "0", "0", "NCLOB", "0", "0", null, null, "10"}};
        return SelectResultSet.createResultSet(columnNames, columnTypes, data, this.connection.getProtocol());
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        PreparedStatement stmt;
        String procedureStr;
        String schemaStr = schemaPattern == null ? "%" : (schemaPattern.equals("") ? this.getUserName().toUpperCase() : schemaPattern.toUpperCase());
        if (procedureNamePattern == null) {
            procedureStr = "%";
        } else {
            if (procedureNamePattern.equals("")) {
                throw new SQLException();
            }
            procedureStr = procedureNamePattern.toUpperCase();
        }
        if (catalog == null) {
            stmt = this.connection.prepareStatement("SELECT  NULL AS procedure_cat,owner AS procedure_schem,object_name AS procedure_name,NULL,NULL,NULL,'Standalone procedure or function' AS remarks,DECODE(object_type, 'PROCEDURE', 1,'FUNCTION', 2,0) AS procedure_type,  NULL AS specific_name FROM all_objects WHERE (object_type = 'PROCEDURE' OR object_type = 'FUNCTION') AND owner LIKE ?  AND object_name LIKE ? UNION ALL SELECT  package_name AS procedure_cat, owner AS procedure_schem,object_name AS procedure_name,NULL, NULL,NULL,'Packaged procedure' AS remarks, 1 AS procedure_type, NULL AS specific_name FROM all_arguments WHERE argument_name IS NULL   AND data_type IS NULL   AND package_name IS NOT NULL  AND owner LIKE ?  AND object_name LIKE ? UNION ALL SELECT  package_name AS procedure_cat, owner AS procedure_schem,object_name AS procedure_name,NULL, NULL,NULL,'Packaged procedure' AS remarks, 1 AS procedure_type, NULL AS specific_name FROM all_arguments WHERE argument_name IS NOT NULL  AND position = 1  AND position = sequence  AND package_name IS NOT NULL  AND owner LIKE ?  AND object_name LIKE ? UNION ALL SELECT  package_name AS procedure_cat, owner AS procedure_schem,object_name AS procedure_name,NULL, NULL,NULL,'Packaged function' AS remarks, 2 AS procedure_type,  NULL AS specific_name FROM all_arguments WHERE argument_name IS NULL  AND in_out = 'OUT'  AND   data_level = 0  AND package_name IS NOT NULL  AND owner LIKE ?  AND object_name LIKE ? ORDER BY procedure_schem, procedure_name");
            stmt.setString(1, schemaStr);
            stmt.setString(2, procedureStr);
            stmt.setString(3, schemaStr);
            stmt.setString(4, procedureStr);
            stmt.setString(5, schemaStr);
            stmt.setString(6, procedureStr);
            stmt.setString(7, schemaStr);
            stmt.setString(8, procedureStr);
        } else if (catalog.equals("")) {
            stmt = this.connection.prepareStatement("SELECT  NULL AS procedure_cat,owner AS procedure_schem,object_name AS procedure_name,NULL,NULL,NULL,'Standalone procedure or function' AS remarks,DECODE(object_type, 'PROCEDURE', 1,'FUNCTION', 2,0) AS procedure_type,  NULL AS specific_name FROM all_objects WHERE (object_type = 'PROCEDURE' OR object_type = 'FUNCTION') AND owner LIKE ?  AND object_name LIKE ? ");
            stmt.setString(1, schemaStr);
            stmt.setString(2, procedureStr);
        } else {
            stmt = this.connection.prepareStatement("SELECT  package_name AS procedure_cat, owner AS procedure_schem,object_name AS procedure_name,NULL, NULL,NULL,'Packaged procedure' AS remarks, 1 AS procedure_type, NULL AS specific_name FROM all_arguments WHERE argument_name IS NULL   AND data_type IS NULL   AND package_name LIKE ?  AND owner LIKE ?   AND object_name LIKE ? UNION ALL SELECT  package_name AS procedure_cat, owner AS procedure_schem,object_name AS procedure_name,NULL, NULL,NULL,'Packaged procedure' AS remarks, 1 AS procedure_type, NULL AS specific_name FROM all_arguments WHERE argument_name IS NOT NULL  AND position = 1  AND position = sequence  AND package_name LIKE ?  AND owner LIKE ?   AND object_name LIKE ? UNION ALL SELECT  package_name AS procedure_cat, owner AS procedure_schem,object_name AS procedure_name,NULL, NULL,NULL,'Packaged function' AS remarks, 2 AS procedure_type,  NULL AS specific_name FROM all_arguments WHERE argument_name IS NULL  AND in_out = 'OUT'  AND   data_level = 0  AND package_name LIKE ?  AND owner LIKE ?   AND object_name LIKE ? ORDER BY procedure_schem, procedure_name");
            stmt.setString(1, catalog);
            stmt.setString(2, schemaStr);
            stmt.setString(3, procedureStr);
            stmt.setString(4, catalog);
            stmt.setString(5, schemaStr);
            stmt.setString(6, procedureStr);
            stmt.setString(7, catalog);
            stmt.setString(8, schemaStr);
            stmt.setString(9, procedureStr);
        }
        stmt.closeOnCompletion();
        ResultSet rs = stmt.executeQuery();
        return rs;
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        String typeList;
        if (types != null) {
            typeList = "  AND o.object_type IN ('xxx'";
            for (int i = 0; i < types.length; ++i) {
                typeList = types[i].equals("SYNONYM") ? typeList + ", '" + types[i] + "'" : typeList + ", '" + types[i] + "'";
            }
            typeList = typeList + ")\n";
        } else {
            typeList = "  AND o.object_type IN ('TABLE', 'SYNONYM', 'VIEW') ";
        }
        String orderBy = "  ORDER BY table_type, table_schem, table_name ";
        String sql = "";
        sql = this.connection.getRemarksReporting() ? "SELECT NULL AS table_cat,o.owner AS table_schem,o.object_name AS table_name,o.object_type AS table_type,c.comments AS remarks FROM all_objects o, all_tab_comments c WHERE o.owner LIKE ? ESCAPE '/' AND o.object_name LIKE ? ESCAPE '/' AND o.owner = c.owner (+)  AND o.object_name = c.table_name (+)  AND o.owner != '__recyclebin' " + typeList + orderBy : "SELECT NULL AS table_cat,o.owner AS table_schem,o.object_name AS table_name,o.object_type AS table_type,NULL AS remarks FROM all_objects o WHERE o.owner LIKE ? ESCAPE '/' AND o.object_name LIKE ? ESCAPE '/' AND o.owner != '__recyclebin' " + typeList + orderBy;
        PreparedStatement stmt = this.connection.prepareStatement(sql);
        stmt.setString(1, schemaPattern == null ? "%" : schemaPattern);
        stmt.setString(2, tableNamePattern == null ? "%" : tableNamePattern);
        stmt.closeOnCompletion();
        ResultSet rs = stmt.executeQuery();
        return rs;
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        Statement stmt = this.connection.createStatement();
        stmt.closeOnCompletion();
        ResultSet rs = stmt.executeQuery("SELECT username AS table_schem,null as table_catalog  FROM all_users ORDER BY table_schem");
        return rs;
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        return this.executeQuery("select 'getCatalog return null' as table_cat from dual where 2=1");
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        boolean remarksReporting = this.connection.getRemarksReporting();
        String querySql = String.format("SELECT  NULL AS table_cat,\n       t.owner AS table_schem,\n       t.table_name AS table_name,\n       t.column_name AS column_name,\nDECODE (t.data_type, 'CHAR', 1, 'VARCHAR2', 12, 'NVARCHAR2', -9, 'NUMBER', %s,\n      'LONG', -1, 'DATE', 93, 'RAW', -3, 'LONG RAW', -4,  \n               'BLOB', 2004, 'CLOB', 2005, 'BFILE', -13, 'FLOAT', 6, \n               'TIMESTAMP(6)', 93, 'TIMESTAMP(6) WITH TIME ZONE', -101, \n               'TIMESTAMP(6) WITH LOCAL TIME ZONE', -102, \n               'INTERVAL YEAR(2) TO MONTH', -103, \n               'INTERVAL DAY(2) TO SECOND(6)', -104, \n               'BINARY_FLOAT', 100, 'BINARY_DOUBLE', 101, \n               'XMLTYPE', 2009, \n               1111)\n              AS data_type,\n       t.data_type AS type_name,\nDECODE (t.data_precision, null, DECODE (t.data_type, 'CHAR', t.char_length, 'VARCHAR', t.char_length, 'VARCHAR2', t.char_length, 'NVARCHAR2', t.char_length, 'NCHAR', t.char_length, 'NUMBER', 0, t.data_length), t.data_precision)\n              AS column_size,\n       0 AS buffer_length,\nDECODE (t.data_type, 'NUMBER', DECODE (t.data_precision, null, -127, t.data_scale), t.data_scale)\n      AS decimal_digits,\n       10 AS num_prec_radix,\nDECODE (t.nullable, 'N', 0, 1)       AS nullable,\n       %s AS remarks,\n       t.data_default AS column_def,\n       0 AS sql_data_type,\n       0 AS sql_datetime_sub,\n       t.data_length AS char_octet_length,\n       t.column_id AS ordinal_position,\nDECODE (t.nullable, 'N', 'NO', 'YES')        AS is_nullable\nFROM all_tab_columns t %s\nWHERE t.owner LIKE '%s' ESCAPE '/'\n  AND t.table_name LIKE '%s' ESCAPE '/'\n  AND t.column_name LIKE '%s' ESCAPE '/'\n %s AND t.owner != '__recyclebin'\nORDER BY table_schem, table_name, ordinal_position", this.connection.getProtocol().getOptions().compatibleOjdbcVersion == 8 ? 2 : 3, remarksReporting ? "c.comments" : "NULL", remarksReporting ? ",all_col_comments c " : "", schemaPattern == null ? "%" : schemaPattern, tableNamePattern == null ? "%" : tableNamePattern, columnNamePattern == null ? Character.valueOf('%') : columnNamePattern, remarksReporting ? "    AND t.owner = c.owner (+)\n    AND t.table_name = c.table_name (+)\n    AND t.column_name = c.column_name (+)" : "");
        String[] data = new String[24];
        ArrayList<String[]> list = new ArrayList<String[]>();
        try (ResultSet results = this.executeQuery(querySql);){
            while (results.next()) {
                data[0] = null;
                data[1] = results.getString("TABLE_SCHEM");
                data[2] = results.getString("TABLE_NAME");
                data[3] = results.getString("COLUMN_NAME");
                data[4] = results.getString("DATA_TYPE");
                data[5] = results.getString("TYPE_NAME");
                data[6] = results.getString("COLUMN_SIZE");
                data[7] = results.getString("BUFFER_LENGTH");
                data[8] = results.getString("DECIMAL_DIGITS");
                data[9] = results.getString("NUM_PREC_RADIX");
                String nullabilityInfo = results.getString("IS_NULLABLE");
                String isNullable = null;
                int nullability = 0;
                if (nullabilityInfo != null) {
                    if (nullabilityInfo.equals("YES")) {
                        nullability = 1;
                        isNullable = "YES";
                    } else if (nullabilityInfo.equals("UNKNOWN")) {
                        nullability = 2;
                        isNullable = "";
                    } else {
                        nullability = 0;
                        isNullable = "NO";
                    }
                } else {
                    nullability = 0;
                    isNullable = "NO";
                }
                data[10] = Integer.toString(nullability);
                data[11] = results.getString("REMARKS");
                data[12] = results.getString("COLUMN_DEF");
                data[13] = results.getString("SQL_DATA_TYPE");
                data[14] = results.getString("SQL_DATETIME_SUB");
                data[15] = results.getString("CHAR_OCTET_LENGTH");
                data[16] = Integer.toString(results.getInt("ORDINAL_POSITION") - 15);
                data[17] = isNullable;
                data[18] = null;
                data[19] = null;
                data[20] = null;
                data[21] = null;
                data[22] = "NO";
                data[23] = null;
                String[] tmp = new String[24];
                System.arraycopy(data, 0, tmp, 0, data.length);
                list.add(tmp);
            }
        }
        String[][] val = new String[list.size()][];
        for (int j = 0; j < list.size(); ++j) {
            val[j] = (String[])list.get(j);
        }
        String[] columnNames = new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE", "SCOPE_CATALOG", "SCOPE_SCHEMA", "SCOPE_TABLE", "SOURCE_DATA_TYPE", "IS_AUTOINCREMENT", "IS_GENERATEDCOLUMN"};
        ColumnType[] columnTypes = new ColumnType[]{ColumnType.ENUM, ColumnType.ENUM, ColumnType.ENUM, ColumnType.ENUM, ColumnType.INTEGER, ColumnType.ENUM, ColumnType.INTEGER, ColumnType.INTEGER, ColumnType.INTEGER, ColumnType.INTEGER, ColumnType.INTEGER, ColumnType.ENUM, ColumnType.ENUM, ColumnType.INTEGER, ColumnType.INTEGER, ColumnType.INTEGER, ColumnType.INTEGER, ColumnType.ENUM, ColumnType.ENUM, ColumnType.ENUM, ColumnType.ENUM, ColumnType.SMALLINT, ColumnType.ENUM, ColumnType.ENUM};
        JDBC4ResultSet rs = SelectResultSet.createResultSet(columnNames, columnTypes, val, this.connection.getProtocol());
        return rs;
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        if (schemaPattern == null) {
            return this.getSchemas();
        }
        PreparedStatement stmt = this.connection.prepareStatement("SELECT username AS table_schem,null as table_catalog FROM all_users WHERE username LIKE ? ORDER BY table_schem");
        stmt.setString(1, schemaPattern);
        stmt.closeOnCompletion();
        ResultSet rs = stmt.executeQuery();
        return rs;
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        PreparedStatement stmt;
        String schemaName = schemaPattern == null ? "%" : (schemaPattern.equals("") ? this.getUserName().toUpperCase() : schemaPattern.toUpperCase());
        String functionName = functionNamePattern;
        if (functionNamePattern == null) {
            functionName = "%";
        } else {
            if (functionNamePattern.equals("")) {
                throw new SQLException();
            }
            functionName = functionNamePattern.toUpperCase();
        }
        if (catalog == null) {
            stmt = this.connection.prepareStatement("SELECT NULL   AS function_cat,owner AS function_schem,object_name AS function_name,'Standalone function' AS remarks,0 AS function_type,NULL AS specific_name FROM all_objects WHERE object_type = 'FUNCTION'  AND owner LIKE ?   AND object_name LIKE ?  UNION ALL SELECT package_name AS function_cat,owner AS function_schem,object_name AS function_name,'Packaged function' AS remarks,DECODE (data_type, 'TABLE', 2, 'PL/SQL TABLE', 2, 1)AS function_type, NULL AS specific_name FROM all_arguments WHERE argument_name IS NULL  AND in_out = 'OUT'  AND data_level = 0   AND package_name IS NOT NULL  AND owner LIKE ?   AND object_name LIKE ?  ORDER BY function_schem, function_name");
            stmt.setString(1, schemaName);
            stmt.setString(2, functionName);
            stmt.setString(3, schemaName);
            stmt.setString(4, functionName);
        } else if (catalog.equals("")) {
            stmt = this.connection.prepareStatement("SELECT NULL  AS function_cat,owner AS function_schem,object_name AS function_name,'Standalone function' AS remarks,0 AS function_type,NULL AS specific_name FROM all_objects WHERE object_type = 'FUNCTION'  AND owner LIKE ?   AND object_name LIKE ?  ");
            stmt.setString(1, schemaName);
            stmt.setString(2, functionName);
        } else {
            stmt = this.connection.prepareStatement("SELECT package_name AS function_cat,owner AS function_schem,object_name AS function_name,'Packaged function' AS remarks,DECODE (data_type, 'TABLE', 2, 'PL/SQL TABLE', 2, 1)AS function_type, NULL AS specific_name FROM all_arguments WHERE argument_name IS NULL  AND in_out = 'OUT'  ");
            stmt.setString(1, schemaName);
            stmt.setString(2, schemaName);
            stmt.setString(3, functionName);
        }
        stmt.closeOnCompletion();
        ResultSet rs = stmt.executeQuery();
        return rs;
    }

    @Override
    public String getUserName() throws SQLException {
        if (this.urlParser.getConnectedUsername() != null) {
            return this.urlParser.getConnectedUsername();
        }
        try (ResultSet rs = this.executeQuery("SELECT USER FROM DUAL");){
            String userName;
            rs.next();
            String string = userName = rs.getString(1);
            return string;
        }
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        return this.executeQuery("select 'TABLE' as table_type from dual union select 'VIEW' as table_type from dual union select 'SYNONYM' as table_type from dual");
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        PreparedStatement stmt = this.connection.prepareStatement("SELECT NULL AS table_cat, table_schema AS table_schem, table_name, grantor,grantee, privilege,grantable AS is_grantable FROM all_tab_privs WHERE table_schema LIKE ? ESCAPE '/'  AND table_name LIKE ? ESCAPE '/' ORDER BY table_schem, table_name, privilege");
        stmt.setString(1, schemaPattern == null ? "%" : schemaPattern);
        stmt.setString(2, tableNamePattern == null ? "%" : tableNamePattern.toUpperCase());
        stmt.closeOnCompletion();
        ResultSet rs = stmt.executeQuery();
        return rs;
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        String schemaFilter = "";
        String schemaTableAliasFilter = "";
        if (schema != null && !schema.isEmpty()) {
            schemaFilter = " owner = '" + schema + "' and ";
            schemaTableAliasFilter = " i.owner = '" + schema + "' and ";
        }
        String prepare = String.format("select null as table_cat, owner as table_schem,table_name, 0 as NON_UNIQUE,null as index_qualifier,null as index_name, 0 as type,0 as ordinal_position, null as column_name,null as asc_or_desc, num_rows as cardinality,blocks as pages,null as filter_condition from all_tables where %s table_name = '%s' union  select null as table_cat,i.owner as table_schem,i.table_name,DECODE (i.uniqueness, 'UNIQUE', 0, 1),null as index_qualifier,i.index_name,1 as type,c.column_position as ordinal_position,c.column_name,null as asc_or_desc,i.distinct_keys as cardinality,i.leaf_blocks as pages, null as filter_condition from (select /*+no_merge*/ * from all_indexes i where %s i.table_name = '%s') i, all_ind_columns c where %s i.table_name = '%s'  %s   and i.index_name = c.index_name  and i.table_owner = c.table_owner  and i.table_name = c.table_name  and i.owner = c.index_owner  order by non_unique, type, index_name, ordinal_position ", schemaFilter, table, schemaTableAliasFilter, table, schemaTableAliasFilter, table, unique ? "  and i.uniqueness = 'UNIQUE'" : "");
        return this.executeQuery(prepare);
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        PreparedStatement stmt = this.connection.prepareStatement("SELECT NULL AS table_cat,c.owner AS table_schem,c.table_name, c.column_name, c.position AS key_seq, c.constraint_name AS pk_name FROM all_cons_columns c, all_constraints k WHERE k.constraint_type = 'P'  AND k.table_name = ?  AND k.owner like ? escape '/'  AND k.constraint_name = c.constraint_name  AND k.table_name = c.table_name   AND k.owner = c.owner ORDER BY column_name ");
        stmt.setString(1, table);
        stmt.setString(2, schema == null ? "%" : schema);
        stmt.closeOnCompletion();
        ResultSet rs = stmt.executeQuery();
        return rs;
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        PreparedStatement stmt = this.connection.prepareStatement("SELECT 1 AS scope, 'ROWID' AS column_name, -8 AS data_type,\n 'ROWID' AS type_name, 0 AS column_size, 0 AS buffer_length,\n       0 AS decimal_digits, 2 AS pseudo_column\nFROM DUAL\nWHERE ? = 1\nUNION\nSELECT 2 AS scope,\n t.column_name,\n  DECODE(substr(t.data_type, 1, 9), 'TIMESTAMP', \n      DECODE(substr(t.data_type, 10, 1), '(',DECODE(substr(t.data_type, 19, 5), 'LOCAL', -102, 'TIME ', -101, 93), DECODE(substr(t.data_type, 16, 5), \n      'LOCAL', -102, 'TIME ', -101, 93)),'INTERVAL ',DECODE(substr(t.data_type, 10, 3), 'DAY', -104, 'YEA', -103), \n      DECODE(t.data_type, \n      'BINARY_DOUBLE', 101, \n      'BINARY_FLOAT', 100, \n      'BFILE', -13, \n      'BLOB', 2004, \n      'CHAR', 1, \n      'CLOB', 2005, \n      'COLLECTION', 2003, \n      'DATE', 93, \n      'FLOAT', 6, \n      'LONG', -1, \n      'LONG RAW', -4, \n      'NCHAR', -15, \n      'NCLOB', 2011, \n      'NUMBER', 2, \n      'NVARCHAR', -9, \n      'NVARCHAR2', -9, \n      'OBJECT', 2002, \n      'OPAQUE/XMLTYPE', 2009, \n      'RAW', -3, \n      'REF', 2006, \n      'ROWID', -8, \n      'SQLXML', 2009, \n      'UROWID', -8, \n      'VARCHAR2', 12, \n      'VARRAY', 2003, \n      'XMLTYPE', 2009, \n       DECODE((SELECT a.typecode FROM ALL_TYPES a WHERE a.type_name = t.data_type AND ((a.owner IS NULL AND t.data_type_owner IS NULL) OR (a.owner = t.data_type_owner))), \n        'OBJECT', 2002,'COLLECTION', 2003, 1111))) \n AS data_type,\n t.data_type AS type_name,\n DECODE (t.data_precision, null,  DECODE (t.data_type, 'CHAR', t.char_length, 'VARCHAR', t.char_length, 'VARCHAR2', t.char_length, 'NVARCHAR2', t.char_length, 'NCHAR', t.char_length, t.data_length), t.data_precision)\n  AS column_size,\n  0 AS buffer_length,\n  t.data_scale AS decimal_digits,\n       1 AS pseudo_column\nFROM all_tab_columns t, all_ind_columns i\nWHERE ? = 1\n  AND t.table_name = ?\n  AND t.owner like ? escape '/'\n  AND t.nullable != ?\n  AND t.owner = i.table_owner\n  AND t.table_name = i.table_name\n  AND t.column_name = i.column_name order by 1\n");
        switch (scope) {
            case 1: {
                stmt.setInt(1, 1);
                stmt.setInt(2, 1);
                break;
            }
            case 2: {
                stmt.setInt(1, 0);
                stmt.setInt(2, 1);
                break;
            }
            default: {
                stmt.setInt(1, 0);
                stmt.setInt(2, 0);
            }
        }
        stmt.setString(3, table);
        stmt.setString(4, schema == null ? "%" : schema);
        stmt.setString(5, nullable ? "X" : "Y");
        stmt.closeOnCompletion();
        ResultSet rs = stmt.executeQuery();
        return rs;
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        PreparedStatement stmt = this.connection.prepareStatement("SELECT NULL AS table_cat,OWNER AS table_schem,table_name,column_name,grantor,grantee,privilege,grantable AS is_grantable FROM all_col_privs WHERE OWNER LIKE ? ESCAPE '/' AND table_name LIKE ? ESCAPE '/' AND column_name LIKE ? ESCAPE '/' ORDER BY column_name, privilege");
        stmt.setString(1, schema == null ? "%" : schema);
        stmt.setString(2, table == null ? "%" : table.toUpperCase());
        stmt.setString(3, columnNamePattern == null ? "%" : columnNamePattern);
        stmt.closeOnCompletion();
        return stmt.executeQuery();
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() {
        return false;
    }

    @Override
    public boolean allProceduresAreCallable() {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() {
        return false;
    }

    @Override
    public boolean locatorsUpdateCopy() {
        return true;
    }

    @Override
    public boolean supportsANSI92FullSQL() {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() {
        return true;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() {
        return true;
    }

    @Override
    public boolean supportsConvert() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() {
        return true;
    }

    public ResultSet keysQuery(String parentSchema, String parentTable, String foreignSchema, String foreignTable, String orderBy) throws SQLException {
        int index = 1;
        int parentTableIndex = parentTable != null ? index++ : 0;
        int foreignTableIndex = foreignTable != null ? index++ : 0;
        int parentSchemaIndex = parentSchema != null && parentSchema.length() > 0 ? index++ : 0;
        int foreignSchemaIndex = foreignSchema != null && foreignSchema.length() > 0 ? index++ : 0;
        String sql = String.format("SELECT NULL AS pktable_cat, p_cons.owner as pktable_schem,p_cons.table_name as pktable_name, p_cons_cols.column_name as pkcolumn_name,NULL as fktable_cat,f_cons.owner as fktable_schem,f_cons.table_name as fktable_name,f_cons_cols.column_name as fkcolumn_name, f_cons_cols.position as key_seq,NULL as update_rule,decode (f_cons.delete_rule, 'CASCADE', 0, 'SET NULL', 2, 1) as delete_rule,f_cons.constraint_name as fk_name, p_cons.constraint_name as pk_name, decode(f_cons.deferrable,'DEFERRABLE',5,'NOT DEFERRABLE',7 ,'DEFERRED', 6) deferrability  FROM all_cons_columns p_cons_cols, all_constraints p_cons,all_cons_columns f_cons_cols, all_constraints f_cons WHERE 1 = 1  %s %s %s %s  AND f_cons.constraint_type = 'R'   AND p_cons.owner = f_cons.r_owner  AND p_cons.constraint_name = f_cons.r_constraint_name  AND p_cons.constraint_type = 'P'  AND p_cons_cols.owner = p_cons.owner  AND p_cons_cols.constraint_name = p_cons.constraint_name  AND p_cons_cols.table_name = p_cons.table_name  AND f_cons_cols.owner = f_cons.owner  AND f_cons_cols.constraint_name = f_cons.constraint_name  AND f_cons_cols.table_name = f_cons.table_name  AND f_cons_cols.position = p_cons_cols.position ", parentTableIndex != 0 ? "  AND p_cons.table_name = ? " : "", foreignTableIndex != 0 ? "  AND f_cons.table_name = ? " : "", parentSchemaIndex != 0 ? "  AND p_cons.owner = ? " : "", foreignSchemaIndex != 0 ? "  AND f_cons.owner = ? " : "");
        PreparedStatement stmt = this.connection.prepareStatement(sql + orderBy);
        if (parentTableIndex != 0) {
            stmt.setString(parentTableIndex, parentTable);
        }
        if (foreignTableIndex != 0) {
            stmt.setString(foreignTableIndex, foreignTable);
        }
        if (parentSchemaIndex != 0) {
            stmt.setString(parentSchemaIndex, parentSchema);
        }
        if (foreignSchemaIndex != 0) {
            stmt.setString(foreignSchemaIndex, foreignSchema);
        }
        stmt.closeOnCompletion();
        ResultSet rs = stmt.executeQuery();
        return rs;
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        if (schemaPattern == null) {
            schemaPattern = "%";
        } else if (schemaPattern.isEmpty()) {
            schemaPattern = this.getUserName().toUpperCase();
        }
        if (functionNamePattern == null) {
            functionNamePattern = "%";
        } else if (functionNamePattern.isEmpty()) {
            throw new SQLException("Invalid name or pattern");
        }
        if (columnNamePattern != null && columnNamePattern.isEmpty()) {
            throw new SQLException("Invalid name or pattern");
        }
        if (columnNamePattern == null) {
            columnNamePattern = "%";
        }
        String actualSql = this.buildFunctionColumnsSql();
        if (catalog != null) {
            actualSql = catalog.isEmpty() ? actualSql + " AND arg.package_name IS NULL" : actualSql + " AND arg.package_name LIKE ? ESCAPE '/'";
        }
        actualSql = columnNamePattern.equals("%") ? actualSql + " AND (arg.argument_name LIKE ? ESCAPE '/' OR (arg.argument_name IS NULL AND arg.data_type IS NOT NULL)) " : actualSql + " AND arg.argument_name LIKE ? ESCAPE '/'";
        actualSql = actualSql + " ORDER BY function_schem, function_name, overload, sequence";
        PreparedStatement ps = this.connection.prepareStatement(actualSql);
        ps.setString(1, schemaPattern);
        ps.setString(2, functionNamePattern);
        if (catalog == null || catalog.isEmpty()) {
            ps.setString(3, columnNamePattern);
        } else {
            ps.setString(3, catalog);
            ps.setString(4, columnNamePattern);
        }
        ps.closeOnCompletion();
        return ps.executeQuery();
    }

    private String buildFunctionColumnsSql() {
        Options options = this.connection.getProtocol().getOptions();
        if (options.compatibleOjdbcVersion == 8) {
            return String.format(" SELECT package_name AS function_cat,\n     arg.owner AS function_schem,\n     arg.object_name AS function_name,\n     arg.argument_name AS column_name,\n     DECODE(arg.position,\n            0, 5,\n            DECODE(arg.in_out,\n                   'IN', 1,\n                   'OUT', 3,\n                   'IN/OUT', 2,\n                   0)) AS column_type,\nDECODE(  (SELECT a.typecode \n     FROM ALL_TYPES A \n     WHERE a.type_name = arg.data_type), \n  'OBJECT', 2002, \n  'COLLECTION', 2003, \n  DECODE(substr(arg.data_type, 1, 9), \n    'TIMESTAMP', \n      DECODE(substr(arg.data_type, 10, 1), \n        '(', \n          DECODE(substr(arg.data_type, 19, 5), \n            'LOCAL', -102, 'TIME ', -101, 93), \n        DECODE(substr(arg.data_type, 16, 5), \n          'LOCAL', -102, 'TIME ', -101, 93)), \n    'INTERVAL ', \n      DECODE(substr(arg.data_type, 10, 3), \n       'DAY', -104, 'YEA', -103), \n    DECODE(arg.data_type, \n      'BINARY_DOUBLE', 101, \n      'BINARY_FLOAT', 100, \n      'BFILE', -13, \n      'BLOB', 2004, \n      'CHAR', 1, \n      'CLOB', 2005, \n      'COLLECTION', 2003, \n      'DATE', %s, \n      'FLOAT', 6, \n      'LONG', -1, \n      'LONG RAW', -4, \n      'NCHAR', -15, \n      'NCLOB', 2011, \n      'NUMBER', 2, \n      'NVARCHAR', -9, \n      'NVARCHAR2', -9, \n      'OBJECT', 2002, \n      'OPAQUE/XMLTYPE', 2009, \n      'RAW', -3, \n      'REF', 2006, \n      'ROWID', -8, \n      'SQLXML', 2009, \n      'UROWID', -8, \n      'VARCHAR2', 12, \n      'VARRAY', 2003, \n      'XMLTYPE', 2009, \n      1111)))\n AS data_type,\n     DECODE(arg.data_type,\n            'OBJECT', arg.type_owner || '.' || arg.type_name, arg.data_type) AS type_name,\n     DECODE(arg.data_precision,\n            NULL, arg.data_length,\n            arg.data_precision) AS precision,\n     arg.data_length AS length,\n     arg.data_scale AS scale,\n     10 AS radix,\n     1 AS nullable,\n     NULL AS remarks,\n     null AS column_def,\n     NULL as sql_data_type,\n     NULL AS sql_datetime_sub,\n     DECODE(arg.data_type,\n            'CHAR', 32767,\n            'VARCHAR2', 32767,\n            'LONG', 32767,\n            'RAW', 32767,\n            'LONG RAW', 32767,\n            NULL) AS char_octet_length,\n     (arg.sequence - 1) AS ordinal_position,\n     'YES' AS is_nullable,\n     NULL AS specific_name,\n     arg.sequence,\n     arg.overload,\n     null as default_value\n FROM all_arguments arg, all_procedures proc\n WHERE arg.owner LIKE ? ESCAPE '/'\n  AND arg.object_name LIKE ? ESCAPE '/'\n  AND proc.object_id = arg.object_id\n  AND ((proc.object_type = 'FUNCTION')\n       OR\n       (proc.object_type = 'PACKAGE'\n        AND\n        proc.procedure_name IS NOT NULL)) \n", options.mapDateToTimestamp ? "93 " : "91 ");
        }
        return String.format(" SELECT package_name AS function_cat,\n       arg.owner AS function_schem,\n       arg.object_name AS function_name,\n       arg.argument_name AS column_name,\n       DECODE(arg.position, 0, 5,\n                        DECODE(arg.in_out, 'IN', 1,\n                                       'OUT', 4,\n                                       'IN/OUT', 2,\n                                       0)) AS column_type,\n       DECODE (arg.data_type, 'CHAR', 1,\n                          'VARCHAR2', 12,\n                          'NUMBER', 3,\n                          'LONG', -1,\n                          'DATE', %s, \n                          'RAW', -3,\n                          'LONG RAW', -4,\n                          'TIMESTAMP', 93, \n                          'TIMESTAMP WITH TIME ZONE', -101, \n               'TIMESTAMP WITH LOCAL TIME ZONE', -102, \n               'INTERVAL YEAR TO MONTH', -103, \n               'INTERVAL DAY TO SECOND', -104, \n               'BINARY_FLOAT', 100, 'BINAvRY_DOUBLE', 101, 1111) AS data_type,\n       DECODE(arg.data_type, 'OBJECT', arg.type_owner || '.' || arg.type_name, arg.data_type) AS type_name,\n       DECODE (arg.data_precision, NULL, arg.data_length,\n                               arg.data_precision) AS precision,\n       arg.data_length AS length,\n       arg.data_scale AS scale,\n       10 AS radix,\n       1 AS nullable,\n       NULL AS remarks,\n       NULL AS column_def,\n       NULL as sql_data_type,\n       NULL AS sql_datetime_sub,\n       DECODE(arg.data_type,\n                         'CHAR', 32767,\n                         'VARCHAR2', 32767,\n                         'LONG', 32767,\n                         'RAW', 32767,\n                         'LONG RAW', 32767,\n                         NULL) AS char_octet_length,\n       (arg.sequence - 1) AS ordinal_position,\n       'YES' AS is_nullable,\n       NULL AS specific_name,\n       arg.sequence,\n       arg.overload,\n       null as default_value\n FROM all_arguments arg, all_procedures proc\n WHERE arg.owner LIKE ? ESCAPE '/'\n  AND arg.object_name LIKE ? ESCAPE '/'\n  AND proc.object_id = arg.object_id\n  AND proc.object_type = 'FUNCTION'\n", options.mapDateToTimestamp ? "93 " : "91 ");
    }
}

