/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.extend.datatype;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public abstract class Datum
implements Serializable {
    protected byte[] data;

    public Datum() {
    }

    public Datum(byte[] bytes) {
        this.data = bytes;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof Datum) {
            if (this.getClass() == object.getClass()) {
                Datum datum = (Datum)object;
                if (this.data == null && datum.data == null) {
                    return true;
                }
                if (this.data == null && datum.data != null || this.data != null && datum.data == null) {
                    return false;
                }
                if (this.data.length != datum.data.length) {
                    return false;
                }
                for (int i = 0; i < this.data.length; ++i) {
                    if (this.data[i] == datum.data[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public byte[] shareBytes() {
        return this.data;
    }

    public long getLength() {
        return null == this.data ? 0L : (long)this.data.length;
    }

    public void setBytes(byte[] bytes) {
        int len = bytes.length;
        this.data = new byte[len];
        System.arraycopy(bytes, 0, this.data, 0, len);
    }

    public void setShareBytes(byte[] bytes) {
        this.data = bytes;
    }

    public byte[] getBytes() {
        if (this.data == null) {
            return new byte[0];
        }
        byte[] bytes = new byte[this.data.length];
        System.arraycopy(this.data, 0, bytes, 0, this.data.length);
        return bytes;
    }

    public void setByte(int index, byte b) {
        if (index < this.data.length) {
            this.data[index] = b;
        }
    }

    public InputStream getStream() {
        return new ByteArrayInputStream(this.data);
    }

    public String stringValue() throws SQLException {
        throw new SQLException("Conversion to String failed");
    }

    public String stringValue(Connection connection) throws SQLException {
        return this.stringValue();
    }

    public boolean booleanValue() throws SQLException {
        throw new SQLException("Conversion to boolean failed");
    }

    public int intValue() throws SQLException {
        throw new SQLException("Conversion to integer failed");
    }

    public long longValue() throws SQLException {
        throw new SQLException("Conversion to long failed");
    }

    public float floatValue() throws SQLException {
        throw new SQLException("Conversion to float failed");
    }

    public double doubleValue() throws SQLException {
        throw new SQLException("Conversion to double failed");
    }

    public byte byteValue() throws SQLException {
        throw new SQLException("Conversion to byte failed");
    }

    public BigDecimal bigDecimalValue() throws SQLException {
        throw new SQLException("Conversion to BigDecimal failed");
    }

    public Date dateValue() throws SQLException {
        throw new SQLException("Conversion to Date failed");
    }

    public Time timeValue() throws SQLException {
        throw new SQLException("Conversion to Time failed");
    }

    public Time timeValue(Calendar calendar) throws SQLException {
        throw new SQLException("Conversion to Time failed");
    }

    public Timestamp timestampValue() throws SQLException {
        throw new SQLException("Conversion to Timestamp failed");
    }

    public Timestamp timestampValue(Calendar calendar) throws SQLException {
        throw new SQLException("Conversion to Timestamp failed");
    }

    public Reader characterStreamValue() throws SQLException {
        throw new SQLException("Conversion to character stream failed");
    }

    public InputStream asciiStreamValue() throws SQLException {
        throw new SQLException("Conversion to ascii stream failed");
    }

    public InputStream binaryStreamValue() throws SQLException {
        throw new SQLException("Conversion to binary stream failed");
    }

    public abstract boolean isConvertibleTo(Class var1);

    public abstract Object toJdbc() throws SQLException;

    public abstract Object makeJdbcArray(int var1);
}

