/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.util;

import com.oceanbase.jdbc.TnsDaemon;
import com.oceanbase.jdbc.UrlParser;
import com.oceanbase.jdbc.internal.com.send.parameters.ParameterHolder;
import com.oceanbase.jdbc.internal.failover.FailoverProxy;
import com.oceanbase.jdbc.internal.failover.impl.AuroraListener;
import com.oceanbase.jdbc.internal.failover.impl.MastersFailoverListener;
import com.oceanbase.jdbc.internal.failover.impl.MastersSlavesListener;
import com.oceanbase.jdbc.internal.failover.utils.ConfigParser;
import com.oceanbase.jdbc.internal.io.LruTraceCache;
import com.oceanbase.jdbc.internal.io.socket.SocketHandlerFunction;
import com.oceanbase.jdbc.internal.io.socket.SocketUtility;
import com.oceanbase.jdbc.internal.logging.ProtocolLoggingProxy;
import com.oceanbase.jdbc.internal.protocol.AuroraProtocol;
import com.oceanbase.jdbc.internal.protocol.MasterProtocol;
import com.oceanbase.jdbc.internal.protocol.MastersSlavesProtocol;
import com.oceanbase.jdbc.internal.protocol.Protocol;
import com.oceanbase.jdbc.internal.util.ParsedCallParameters;
import com.oceanbase.jdbc.internal.util.pool.GlobalStateInfo;
import com.oceanbase.jdbc.util.ConfigurableSocketFactory;
import com.oceanbase.jdbc.util.Options;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.SocketFactory;

public class Utils {
    private static final char[] hexArray;
    private static final Pattern IP_V4;
    private static final Pattern IP_V6;
    private static final Pattern IP_V6_COMPRESSED;
    private static final SocketHandlerFunction socketHandler;
    public static TnsDaemon tnsDaemon;
    private static final char[] DIGITS_LOWER;
    private static final char[] DIGITS_UPPER;

    public static Socket standardSocket(Options options, String host) throws IOException {
        String socketFactoryName = options.socketFactory;
        if (socketFactoryName != null) {
            try {
                Class<?> socketFactoryClass = Class.forName(socketFactoryName);
                if (socketFactoryClass != null) {
                    Constructor<?> constructor = socketFactoryClass.getConstructor(new Class[0]);
                    SocketFactory socketFactory = (SocketFactory)constructor.newInstance(new Object[0]);
                    if (socketFactoryClass.isInstance(ConfigurableSocketFactory.class)) {
                        ((ConfigurableSocketFactory)socketFactory).setConfiguration(options, host);
                    }
                    return socketFactory.createSocket();
                }
            }
            catch (Exception exp) {
                throw new IOException("Socket factory failed to initialized with option \"socketFactory\" set to \"" + options.socketFactory + "\"", exp);
            }
        }
        SocketFactory socketFactory = SocketFactory.getDefault();
        return socketFactory.createSocket();
    }

    public static Socket socksSocket(Options options) {
        String socksProxyHost = options.socksProxyHost;
        int socksProxyPort = options.socksProxyPort;
        return new Socket(new java.net.Proxy(Proxy.Type.SOCKS, new InetSocketAddress(socksProxyHost, socksProxyPort)));
    }

    public static String escapeString(String value, boolean noBackslashEscapes) {
        if (!value.contains("'")) {
            if (noBackslashEscapes) {
                return value;
            }
            if (!value.contains("\\")) {
                return value;
            }
        }
        String escaped = value.replace("'", "''");
        if (noBackslashEscapes) {
            return escaped;
        }
        return escaped.replace("\\", "\\\\");
    }

    public static byte[] encryptPassword(String password, byte[] seed, String passwordCharacterEncoding) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        if (password == null || password.isEmpty()) {
            return new byte[0];
        }
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        byte[] bytePwd = passwordCharacterEncoding != null && !passwordCharacterEncoding.isEmpty() ? password.getBytes(passwordCharacterEncoding) : password.getBytes();
        byte[] stage1 = messageDigest.digest(bytePwd);
        messageDigest.reset();
        byte[] stage2 = messageDigest.digest(stage1);
        messageDigest.reset();
        messageDigest.update(seed);
        messageDigest.update(stage2);
        byte[] digest = messageDigest.digest();
        byte[] returnBytes = new byte[digest.length];
        for (int i = 0; i < digest.length; ++i) {
            returnBytes[i] = (byte)(stage1[i] ^ digest[i]);
        }
        return returnBytes;
    }

    public static byte[] copyWithLength(byte[] orig, int length) {
        byte[] result = new byte[length];
        int howMuchToCopy = length < orig.length ? length : orig.length;
        System.arraycopy(orig, 0, result, 0, howMuchToCopy);
        return result;
    }

    public static byte[] copyRange(byte[] orig, int from, int to) {
        int length = to - from;
        byte[] result = new byte[length];
        int howMuchToCopy = orig.length - from < length ? orig.length - from : length;
        System.arraycopy(orig, from, result, 0, howMuchToCopy);
        return result;
    }

    private static String replaceFunctionParameter(String functionString, Protocol protocol) {
        String func;
        int index;
        char[] input = functionString.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (index = 0; index < input.length && input[index] == ' '; ++index) {
        }
        while ((input[index] >= 'a' && input[index] <= 'z' || input[index] >= 'A' && input[index] <= 'Z') && index < input.length) {
            sb.append(input[index]);
            ++index;
        }
        switch (func = sb.toString().toLowerCase(Locale.ROOT)) {
            case "convert": {
                int endParam;
                int lastCommaIndex = functionString.lastIndexOf(44);
                int firstParentheses = functionString.indexOf(40);
                String value = functionString.substring(firstParentheses + 1, lastCommaIndex);
                for (index = lastCommaIndex + 1; index < input.length && Character.isWhitespace(input[index]); ++index) {
                }
                for (endParam = index + 1; endParam < input.length && (input[endParam] >= 'a' && input[endParam] <= 'z' || input[endParam] >= 'A' && input[endParam] <= 'Z' || input[endParam] == '_'); ++endParam) {
                }
                String typeParam = new String(input, index, endParam - index).toUpperCase(Locale.ROOT);
                if (typeParam.startsWith("SQL_")) {
                    typeParam = typeParam.substring(4);
                }
                switch (typeParam) {
                    case "BOOLEAN": {
                        return "1=" + value;
                    }
                    case "BIGINT": 
                    case "SMALLINT": 
                    case "TINYINT": {
                        typeParam = "SIGNED INTEGER";
                        break;
                    }
                    case "BIT": {
                        typeParam = "UNSIGNED INTEGER";
                        break;
                    }
                    case "BLOB": 
                    case "VARBINARY": 
                    case "LONGVARBINARY": 
                    case "ROWID": {
                        typeParam = "BINARY";
                        break;
                    }
                    case "NCHAR": 
                    case "CLOB": 
                    case "NCLOB": 
                    case "DATALINK": 
                    case "VARCHAR": 
                    case "NVARCHAR": 
                    case "LONGVARCHAR": 
                    case "LONGNVARCHAR": 
                    case "SQLXML": 
                    case "LONGNCHAR": {
                        typeParam = "CHAR";
                        break;
                    }
                    case "DOUBLE": 
                    case "FLOAT": {
                        if (protocol.isServerMariaDb() || protocol.versionGreaterOrEqual(8, 0, 17)) {
                            typeParam = "DOUBLE";
                            break;
                        }
                        return "0.0+" + value;
                    }
                    case "REAL": 
                    case "NUMERIC": {
                        typeParam = "DECIMAL";
                        break;
                    }
                    case "TIMESTAMP": {
                        typeParam = "DATETIME";
                        break;
                    }
                }
                return new String(input, 0, index) + typeParam + new String(input, endParam, input.length - endParam);
            }
            case "timestampdiff": 
            case "timestampadd": {
                String paramPrefix;
                while (index < input.length && (Character.isWhitespace(input[index]) || input[index] == '(')) {
                    ++index;
                }
                if (index < input.length - 8 && "SQL_TSI_".equals(paramPrefix = new String(input, index, 8))) {
                    return new String(input, 0, index) + new String(input, index + 8, input.length - (index + 8));
                }
                return functionString;
            }
        }
        return functionString;
    }

    private static String resolveEscapes(String escaped, Protocol protocol) throws SQLException {
        block15: {
            block14: {
                if (escaped.charAt(0) != '{' || escaped.charAt(escaped.length() - 1) != '}') {
                    throw new SQLException("unexpected escaped string");
                }
                int endIndex = escaped.length() - 1;
                String escapedLower = escaped.toLowerCase(Locale.ROOT);
                if (escaped.startsWith("{fn ")) {
                    String resolvedParams = Utils.replaceFunctionParameter(escaped.substring(4, endIndex), protocol);
                    return Utils.nativeSql(resolvedParams, protocol);
                }
                if (escapedLower.startsWith("{oj ")) {
                    return Utils.nativeSql(escaped.substring(4, endIndex), protocol);
                }
                if (escaped.startsWith("{d ")) {
                    return escaped.substring(3, endIndex);
                }
                if (escaped.startsWith("{t ")) {
                    return escaped.substring(3, endIndex);
                }
                if (escaped.startsWith("{ts ")) {
                    return escaped.substring(4, endIndex);
                }
                if (escaped.startsWith("{d'")) {
                    return escaped.substring(2, endIndex);
                }
                if (escaped.startsWith("{t'")) {
                    return escaped.substring(2, endIndex);
                }
                if (escaped.startsWith("{ts'")) {
                    return escaped.substring(3, endIndex);
                }
                if (escaped.startsWith("{call ") || escaped.startsWith("{CALL ")) {
                    return Utils.nativeSql(escaped.substring(1, endIndex), protocol);
                }
                if (escaped.startsWith("{escape ")) {
                    return escaped.substring(1, endIndex);
                }
                if (escaped.startsWith("{?")) {
                    return Utils.nativeSql(escaped.substring(1, endIndex), protocol);
                }
                if (!escaped.startsWith("{ ") && !escaped.startsWith("{\n")) break block14;
                for (int i = 2; i < escaped.length(); ++i) {
                    if (Character.isWhitespace(escaped.charAt(i))) continue;
                    return Utils.resolveEscapes("{" + escaped.substring(i), protocol);
                }
                break block15;
            }
            if (!escaped.startsWith("{\r\n")) break block15;
            for (int i = 3; i < escaped.length(); ++i) {
                if (Character.isWhitespace(escaped.charAt(i))) continue;
                return Utils.resolveEscapes("{" + escaped.substring(i), protocol);
            }
        }
        throw new SQLException("unknown escape sequence " + escaped);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String nativeSql(String sql, Protocol protocol) throws SQLException {
        if (!sql.contains("{")) {
            return sql;
        }
        StringBuilder escapeSequenceBuf = new StringBuilder();
        StringBuilder sqlBuffer = new StringBuilder();
        char[] charArray = sql.toCharArray();
        char lastChar = '\u0000';
        boolean inQuote = false;
        char quoteChar = '\u0000';
        boolean inComment = false;
        boolean isSlashSlashComment = false;
        int inEscapeSeq = 0;
        boolean isOracleMode = protocol.isOracleMode();
        block8: for (int i = 0; i < charArray.length; ++i) {
            char car = charArray[i];
            if (!isOracleMode && lastChar == '\\' && !protocol.noBackslashEscapes()) {
                sqlBuffer.append(car);
                lastChar = ' ';
                continue;
            }
            switch (car) {
                case '\"': 
                case '\'': 
                case '`': {
                    if (inComment) break;
                    if (inQuote) {
                        if (quoteChar != car) break;
                        inQuote = false;
                        break;
                    }
                    inQuote = true;
                    quoteChar = car;
                    break;
                }
                case '*': {
                    if (inQuote || inComment || lastChar != 47) break;
                    inComment = true;
                    isSlashSlashComment = false;
                    break;
                }
                case '-': 
                case '/': {
                    if (inQuote) break;
                    if (inComment) {
                        if (lastChar != 42 || isSlashSlashComment) break;
                        inComment = false;
                        break;
                    }
                    if (lastChar == car) {
                        inComment = true;
                        isSlashSlashComment = true;
                        break;
                    }
                    if (lastChar != 42) break;
                    inComment = true;
                    isSlashSlashComment = false;
                    break;
                }
                case '\n': {
                    if (!inComment || !isSlashSlashComment) break;
                    inComment = false;
                    break;
                }
                case '{': {
                    if (inQuote || inComment) break;
                    ++inEscapeSeq;
                    break;
                }
                case '}': {
                    if (inQuote || inComment || --inEscapeSeq != 0) break;
                    escapeSequenceBuf.append(car);
                    sqlBuffer.append(Utils.resolveEscapes(escapeSequenceBuf.toString(), protocol));
                    escapeSequenceBuf.setLength(0);
                    lastChar = car;
                    continue block8;
                }
            }
            lastChar = car;
            if (inEscapeSeq > 0) {
                escapeSequenceBuf.append(car);
                continue;
            }
            sqlBuffer.append(car);
        }
        if (inEscapeSeq > 0) {
            throw new SQLException("Invalid escape sequence , missing closing '}' character in '" + sqlBuffer);
        }
        return sqlBuffer.toString();
    }

    public static String getSQLWithoutCommentMysql(String sql) throws SQLException {
        StringBuilder escapeSequenceBuf = new StringBuilder();
        StringBuilder sqlBuffer = new StringBuilder();
        char[] charArray = sql.toCharArray();
        char lastChar = '\u0000';
        boolean inQuote = false;
        char quoteChar = '\u0000';
        boolean inComment = false;
        boolean isSlashSlashComment = false;
        boolean isDoubleDashComment = false;
        boolean inDoubleDashComment = false;
        boolean add = false;
        boolean skip = false;
        boolean afterDoubleDash = false;
        for (int i = 0; i < charArray.length; ++i) {
            char car = charArray[i];
            if (afterDoubleDash && isDoubleDashComment && inComment) {
                if (car == '\u007f' || car < '!') {
                    inDoubleDashComment = true;
                    afterDoubleDash = false;
                } else {
                    isDoubleDashComment = false;
                    afterDoubleDash = false;
                    inComment = false;
                    inDoubleDashComment = false;
                }
            } else {
                switch (car) {
                    case '\"': 
                    case '\'': 
                    case '`': {
                        if (inComment) break;
                        if (inQuote) {
                            if (quoteChar != car) break;
                            inQuote = false;
                            add = true;
                            break;
                        }
                        inQuote = true;
                        quoteChar = car;
                        break;
                    }
                    case '*': {
                        if (inQuote || inComment || lastChar != 47) break;
                        inComment = true;
                        isSlashSlashComment = false;
                        isDoubleDashComment = false;
                        break;
                    }
                    case '/': {
                        if (inQuote) break;
                        if (inComment) {
                            if (lastChar != 42 || isSlashSlashComment || isDoubleDashComment) break;
                            inComment = false;
                            skip = true;
                            break;
                        }
                        inComment = true;
                        break;
                    }
                    case '-': {
                        if (inQuote) break;
                        if (inComment && !isDoubleDashComment) {
                            isDoubleDashComment = false;
                            break;
                        }
                        if (inComment && isDoubleDashComment && lastChar == '-') {
                            afterDoubleDash = true;
                            inComment = true;
                            isDoubleDashComment = true;
                            break;
                        }
                        if (inComment) break;
                        isDoubleDashComment = true;
                        inComment = true;
                        break;
                    }
                    case '#': {
                        if (inQuote) break;
                        if (inComment) {
                            isSlashSlashComment = false;
                            break;
                        }
                        inComment = true;
                        isSlashSlashComment = true;
                        break;
                    }
                    case '\n': {
                        if (inComment && isSlashSlashComment || inComment && isDoubleDashComment && inDoubleDashComment) {
                            inComment = false;
                            skip = true;
                            isDoubleDashComment = false;
                            isSlashSlashComment = false;
                            inDoubleDashComment = false;
                            afterDoubleDash = false;
                            break;
                        }
                        car = ' ';
                        break;
                    }
                    default: {
                        if (inQuote || inComment || isSlashSlashComment || isDoubleDashComment) break;
                        add = true;
                    }
                }
            }
            lastChar = car;
            if (i == charArray.length - 1) {
                add = true;
            }
            escapeSequenceBuf.append(car);
            if (skip) {
                escapeSequenceBuf.setLength(0);
                skip = false;
            }
            if (!add) continue;
            sqlBuffer.append((CharSequence)escapeSequenceBuf);
            add = false;
            escapeSequenceBuf.setLength(0);
        }
        return sqlBuffer.toString().trim();
    }

    public static String trimSQLString(String queryString, boolean noBackslashEscapes, boolean isOracleMode) {
        return Utils.trimSQLString(queryString, noBackslashEscapes, isOracleMode, false);
    }

    public static String trimSQLString(String queryString, boolean noBackslashEscapes, boolean isOracleMode, boolean skipComment) {
        return Utils.trimSQLStringInternal(queryString, noBackslashEscapes, isOracleMode, skipComment).getTrimedString();
    }

    public static TrimSQLInfo trimSQLStringInternal(String queryString, boolean noBackslashEscapes, boolean isOracleMode, boolean skipComment) {
        char[] query = queryString.toCharArray();
        int queryLength = query.length;
        int parameterCount = 0;
        StringBuilder trimedSqlString = new StringBuilder();
        StringBuilder paramSb = new StringBuilder();
        boolean multipleQueriesPrepare = true;
        ArrayList<Integer> paramIndexs = new ArrayList<Integer>();
        LexState state = LexState.Normal;
        char lastChar = '\u0000';
        boolean includeCurChar = false;
        boolean singleQuotes = false;
        int selectEndPos = -1;
        int whereEndPos = -1;
        int lastParamPos = 0;
        int commentStart = 0;
        boolean slashEnd = false;
        int lastCommentEndStarPos = -2;
        int lastCommentBeginSlashPos = 0;
        boolean semicolonEnd = false;
        KeyState keyState = KeyState.Normal;
        boolean nameBindingEnd = false;
        int onDuplicateKeyUpdateIndex = -1;
        for (int i = 0; i < queryLength; ++i) {
            if (i == queryLength - 1 && state == LexState.NameBinding && isOracleMode) {
                nameBindingEnd = true;
                includeCurChar = true;
            }
            char car = query[i];
            if (!(state != LexState.Escape || car == '\'' && singleQuotes || car == '\"' && !singleQuotes)) {
                state = LexState.String;
                lastChar = car;
                continue;
            }
            switch (car) {
                case '*': {
                    if (state != LexState.Normal || lastChar != '/' || i <= lastCommentEndStarPos + 2) break;
                    state = LexState.SlashStarComment;
                    commentStart = i - 1;
                    lastCommentBeginSlashPos = i - 1;
                    break;
                }
                case '/': {
                    if (state == LexState.SlashStarComment && lastChar == '*' && i > lastCommentBeginSlashPos + 2) {
                        state = LexState.Normal;
                        slashEnd = true;
                        if (skipComment) {
                            trimedSqlString.append(queryString.substring(lastParamPos, i + 1));
                        } else if (commentStart != 0) {
                            trimedSqlString.append(queryString.substring(lastParamPos, commentStart));
                        }
                        lastParamPos = i + 1;
                        lastCommentEndStarPos = i - 1;
                        break;
                    }
                    if (state != LexState.Normal || lastChar != 47) break;
                    if (slashEnd) {
                        slashEnd = false;
                        break;
                    }
                    state = LexState.EOLComment;
                    lastParamPos = i + 1;
                    commentStart = i - 1;
                    break;
                }
                case '#': {
                    if (state != LexState.Normal || isOracleMode) break;
                    state = LexState.EOLComment;
                    commentStart = i;
                    break;
                }
                case '-': {
                    if (state != LexState.Normal || lastChar != 45) break;
                    state = LexState.EOLComment;
                    multipleQueriesPrepare = false;
                    commentStart = i - 1;
                    break;
                }
                case '\n': {
                    if (state == LexState.EOLComment) {
                        multipleQueriesPrepare = true;
                        state = LexState.Normal;
                        if (skipComment) {
                            trimedSqlString.append(queryString.substring(lastParamPos, i + 1));
                        } else if (commentStart != 0) {
                            trimedSqlString.append(queryString.substring(lastParamPos, commentStart));
                        }
                        lastParamPos = i + 1;
                        break;
                    }
                    if (state != LexState.NameBinding || !isOracleMode) break;
                    nameBindingEnd = true;
                    includeCurChar = false;
                    break;
                }
                case '\"': {
                    if (state == LexState.Normal) {
                        state = LexState.String;
                        singleQuotes = false;
                        break;
                    }
                    if (state == LexState.String && !singleQuotes) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Escape || singleQuotes) break;
                    state = LexState.String;
                    break;
                }
                case '\'': {
                    if (state == LexState.Normal) {
                        state = LexState.String;
                        singleQuotes = true;
                        break;
                    }
                    if (state == LexState.String && singleQuotes) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Escape || !singleQuotes) break;
                    state = LexState.String;
                    break;
                }
                case '\\': {
                    if (noBackslashEscapes || state != LexState.String || isOracleMode) break;
                    state = LexState.Escape;
                    break;
                }
                case ';': {
                    if (state == LexState.Normal) {
                        semicolonEnd = true;
                        multipleQueriesPrepare = false;
                        break;
                    }
                    if (state != LexState.NameBinding || !isOracleMode) break;
                    nameBindingEnd = true;
                    includeCurChar = false;
                    break;
                }
                case '?': {
                    if (state != LexState.Normal) break;
                    trimedSqlString.append(queryString.substring(lastParamPos, i));
                    trimedSqlString.append("?");
                    lastParamPos = i + 1;
                    ++parameterCount;
                    paramIndexs.add(trimedSqlString.length() - 1);
                    break;
                }
                case '`': {
                    if (state == LexState.Backtick) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Normal) break;
                    state = LexState.Backtick;
                    break;
                }
                case ':': {
                    if (state != LexState.Normal || !isOracleMode) break;
                    state = LexState.NameBinding;
                    if (!semicolonEnd || car < 40) break;
                    semicolonEnd = false;
                    multipleQueriesPrepare = true;
                    break;
                }
                case '=': {
                    if (!isOracleMode) break;
                    if (state == LexState.NameBinding) {
                        state = LexState.Normal;
                        paramSb.setLength(0);
                        break;
                    }
                    if (state != LexState.Normal || !semicolonEnd || car < 40) break;
                    semicolonEnd = false;
                    multipleQueriesPrepare = true;
                    break;
                }
                case ' ': 
                case ')': 
                case ',': 
                case '}': {
                    if (state != LexState.NameBinding || !isOracleMode) break;
                    nameBindingEnd = true;
                    includeCurChar = false;
                    break;
                }
                default: {
                    if (state != LexState.Normal) break;
                    if (semicolonEnd && car >= '(') {
                        semicolonEnd = false;
                        multipleQueriesPrepare = true;
                    }
                    switch (car) {
                        case 'O': 
                        case 'o': {
                            if (state != LexState.Normal || queryLength <= i + 1 || query[i + 1] != 'n' && query[i + 1] != 'N') break;
                            onDuplicateKeyUpdateIndex = trimedSqlString.length();
                            keyState = KeyState.No;
                            break;
                        }
                        case 'D': 
                        case 'd': {
                            if (state != LexState.Normal || keyState != KeyState.No || queryLength <= i + 8 || query[i + 1] != 'u' && query[i + 1] != 'U' || query[i + 2] != 'p' && query[i + 2] != 'P' || query[i + 3] != 'l' && query[i + 3] != 'L' || query[i + 4] != 'i' && query[i + 4] != 'I' || query[i + 5] != 'c' && query[i + 5] != 'C' || query[i + 6] != 'a' && query[i + 6] != 'A' || query[i + 7] != 't' && query[i + 7] != 'T' || query[i + 8] != 'e' && query[i + 8] != 'E') break;
                            keyState = KeyState.Duplicate;
                            break;
                        }
                        case 'K': 
                        case 'k': {
                            if (state != LexState.Normal || keyState != KeyState.Duplicate || queryLength <= i + 2 || query[i + 1] != 'e' && query[i + 1] != 'E' || query[i + 2] != 'y' && query[i + 2] != 'Y') break;
                            keyState = KeyState.Key;
                            break;
                        }
                        case 'U': 
                        case 'u': {
                            if (state != LexState.Normal || keyState != KeyState.Key || queryLength <= i + 5 || query[i + 1] != 'p' && query[i + 1] != 'P' || query[i + 2] != 'd' && query[i + 2] != 'D' || query[i + 3] != 'a' && query[i + 3] != 'A' || query[i + 4] != 't' && query[i + 4] != 'T' || query[i + 5] != 'e' && query[i + 5] != 'E') break;
                            keyState = KeyState.Update;
                        }
                    }
                    if (selectEndPos == -1 && (car == 't' || car == 'T') && i >= 5 && queryString.substring(i - 5, i + 1).equalsIgnoreCase("select")) {
                        selectEndPos = i;
                        break;
                    }
                    if (whereEndPos != -1 || car != 'e' && car != 69 || i < 4 || !queryString.substring(i - 4, i + 1).equalsIgnoreCase("where")) break;
                    whereEndPos = i;
                }
            }
            if (state == LexState.NameBinding && isOracleMode) {
                if (!nameBindingEnd) {
                    if (Character.isLetter(car) || Character.isDigit(car) || car == '_' || car == ':' || car == '.') {
                        paramSb.append(car);
                    } else {
                        nameBindingEnd = true;
                        includeCurChar = false;
                    }
                }
                if (nameBindingEnd) {
                    int index;
                    String tmp;
                    if (!includeCurChar) {
                        tmp = paramSb.toString();
                        if (tmp != null) {
                            index = tmp.indexOf(46);
                            if (index != -1) {
                                trimedSqlString.append(queryString.substring(lastParamPos, i));
                            } else {
                                trimedSqlString.append(queryString.substring(lastParamPos, i - paramSb.length()));
                                trimedSqlString.append("?");
                                ++parameterCount;
                                paramIndexs.add(trimedSqlString.length() - 1);
                            }
                        }
                        lastParamPos = i;
                    } else {
                        paramSb.append(car);
                        tmp = paramSb.toString();
                        if (tmp != null) {
                            index = tmp.indexOf(46);
                            if (index != -1) {
                                trimedSqlString.append(queryString.substring(lastParamPos, i + 1));
                            } else {
                                trimedSqlString.append(queryString.substring(lastParamPos, i - paramSb.length() + 1));
                                trimedSqlString.append("?");
                                ++parameterCount;
                                paramIndexs.add(trimedSqlString.length() - 1);
                            }
                        }
                        lastParamPos = i + 1;
                        includeCurChar = false;
                    }
                    paramSb.setLength(0);
                    nameBindingEnd = false;
                    state = LexState.Normal;
                }
            }
            lastChar = car;
        }
        if (lastParamPos == 0) {
            trimedSqlString.append(queryString);
        } else {
            trimedSqlString.append(queryString.substring(lastParamPos, queryLength));
        }
        return new TrimSQLInfo(trimedSqlString.toString(), parameterCount, selectEndPos, whereEndPos, paramIndexs, onDuplicateKeyUpdateIndex);
    }

    private static int nextCharIndex(int startPos, int stopPos, String searchedString, String leftMarks, String rightMarks) {
        if (searchedString == null) {
            return -1;
        }
        int searchStringLength = searchedString.length();
        if (startPos >= searchStringLength) {
            return -1;
        }
        char charVal0 = '\u0000';
        char charVal1 = searchedString.charAt(startPos);
        char charVal2 = startPos + 1 < searchStringLength ? searchedString.charAt(startPos + 1) : (char)'\u0000';
        for (int i = startPos; i <= stopPos; ++i) {
            charVal0 = charVal1;
            charVal1 = charVal2;
            charVal2 = i + 2 < searchStringLength ? searchedString.charAt(i + 2) : (char)'\u0000';
            int markerIndex = -1;
            markerIndex = leftMarks.indexOf(charVal0);
            if (markerIndex != -1) {
                int nestedMarkersCount = 0;
                char openingMarker = charVal0;
                char closingMarker = rightMarks.charAt(markerIndex);
                while (++i <= stopPos && ((charVal0 = searchedString.charAt(i)) != closingMarker || nestedMarkersCount != 0)) {
                    if (charVal0 == openingMarker) {
                        ++nestedMarkersCount;
                        continue;
                    }
                    if (charVal0 == closingMarker) {
                        --nestedMarkersCount;
                        continue;
                    }
                    if (charVal0 != '\\') continue;
                    ++i;
                }
            } else {
                return i;
            }
            charVal1 = i + 1 < searchStringLength ? searchedString.charAt(i + 1) : (char)'\u0000';
            charVal2 = i + 2 < searchStringLength ? searchedString.charAt(i + 2) : (char)'\u0000';
        }
        return -1;
    }

    public static int nextDelimiterPos(String stringToSearched, int startingPosition, String stringToSearch, String leftMarks, String rightMarks) {
        int stringToSearchLen;
        if (stringToSearched == null || stringToSearch == null) {
            return -1;
        }
        int stringToSearchedLen = stringToSearched.length();
        int stopSearchingAt = stringToSearchedLen - (stringToSearchLen = stringToSearch.length());
        if (startingPosition > stopSearchingAt || stringToSearchLen == 0) {
            return -1;
        }
        char firstUc = Character.toUpperCase(stringToSearch.charAt(0));
        char firstLc = Character.toLowerCase(stringToSearch.charAt(0));
        for (int i = startingPosition; i <= stopSearchingAt; ++i) {
            if ((i = Utils.nextCharIndex(i, stopSearchingAt, stringToSearched, leftMarks, rightMarks)) == -1) {
                return -1;
            }
            char c = stringToSearched.charAt(i);
            if (c != firstLc && c != firstUc || !stringToSearched.toUpperCase(Locale.ROOT).substring(i).startsWith(stringToSearch)) continue;
            return i;
        }
        return -1;
    }

    public static List<ParsedCallParameters> argumentsSplit(String arguments, String delimiter, String markers, String markerCloses) {
        String token;
        if (arguments == null) {
            return null;
        }
        arguments = arguments.substring(arguments.indexOf("(") + 1, arguments.lastIndexOf(")"));
        ArrayList<ParsedCallParameters> retList = new ArrayList<ParsedCallParameters>();
        boolean trim = true;
        if (delimiter == null) {
            throw new IllegalArgumentException();
        }
        int delimPos = 0;
        int currentPos = 0;
        while ((delimPos = Utils.nextDelimiterPos(arguments, currentPos, delimiter, markers, markerCloses)) != -1) {
            token = arguments.substring(currentPos, delimPos);
            if (trim) {
                token = token.trim();
            }
            if (token.startsWith(":") || token.startsWith("?")) {
                retList.add(new ParsedCallParameters(true, token));
            } else {
                retList.add(new ParsedCallParameters(false, token));
            }
            currentPos = delimPos + 1;
        }
        if (currentPos < arguments.length()) {
            token = arguments.substring(currentPos);
            if (trim) {
                token = token.trim();
            }
            if (token.startsWith(":") || token.startsWith("?")) {
                retList.add(new ParsedCallParameters(true, token));
            } else {
                retList.add(new ParsedCallParameters(false, token));
            }
        }
        return retList;
    }

    public static List<Integer> findParamIndex(String sqlString, String delimiter, String markers, String markerCloses) {
        String token;
        if (sqlString == null) {
            return null;
        }
        sqlString = sqlString.substring(sqlString.indexOf("(") + 1, sqlString.lastIndexOf(")"));
        ArrayList<Integer> retList = new ArrayList<Integer>();
        boolean trim = true;
        if (delimiter == null) {
            throw new IllegalArgumentException();
        }
        int delimPos = 0;
        int currentPos = 0;
        while ((delimPos = Utils.nextDelimiterPos(sqlString, currentPos, delimiter, markers, markerCloses)) != -1) {
            token = sqlString.substring(currentPos, delimPos);
            if (trim) {
                token = token.trim();
            }
            if (token.startsWith("?")) {
                retList.add(currentPos);
            }
            currentPos = delimPos + 1;
        }
        if (currentPos < sqlString.length()) {
            token = sqlString.substring(currentPos);
            if (trim) {
                token = token.trim();
            }
            if (token.startsWith("?")) {
                retList.add(currentPos);
            }
        }
        return retList;
    }

    public static int getStatementType(String queryString) {
        String subStr;
        int index;
        if (queryString == null) {
            return 0;
        }
        char[] query = queryString.toCharArray();
        for (index = 0; index < query.length && (query[index] == ' ' || query[index] == '\r' || query[index] == '\n' || query[index] == '\t'); ++index) {
        }
        String str = queryString.substring(index);
        int len = str.length();
        if (len >= 4) {
            subStr = str.substring(0, 4);
            if (subStr.equalsIgnoreCase("with")) {
                return 1;
            }
            if (subStr.equalsIgnoreCase("drop")) {
                return 6;
            }
            if (subStr.equalsIgnoreCase("call")) {
                return 10;
            }
        }
        if (len >= 5) {
            subStr = str.substring(0, 5);
            if (subStr.equalsIgnoreCase("alter")) {
                return 7;
            }
            if (subStr.equalsIgnoreCase("begin")) {
                return 8;
            }
        }
        if (len >= 6) {
            subStr = str.substring(0, 6);
            if (subStr.equalsIgnoreCase("select")) {
                return 1;
            }
            if (subStr.equalsIgnoreCase("update")) {
                return 2;
            }
            if (subStr.equalsIgnoreCase("delete")) {
                return 3;
            }
            if (subStr.equalsIgnoreCase("insert")) {
                return 4;
            }
            if (subStr.equalsIgnoreCase("create")) {
                return 5;
            }
        }
        if (len >= 7 && (subStr = str.substring(0, 7)).equalsIgnoreCase("declare")) {
            return 9;
        }
        return 0;
    }

    public static Protocol retrieveProxy(UrlParser urlParser, GlobalStateInfo globalInfo) throws SQLException {
        ReentrantLock lock = new ReentrantLock();
        boolean tnsFlag = true;
        if (tnsFlag) {
            // empty if block
        }
        LruTraceCache traceCache = urlParser.getOptions().enablePacketDebug ? new LruTraceCache() : null;
        switch (urlParser.getHaMode()) {
            case AURORA: {
                return Utils.getProxyLoggingIfNeeded(urlParser, (Protocol)Proxy.newProxyInstance(AuroraProtocol.class.getClassLoader(), new Class[]{Protocol.class}, (InvocationHandler)new FailoverProxy(new AuroraListener(urlParser, globalInfo), lock, traceCache)));
            }
            case REPLICATION: {
                return Utils.getProxyLoggingIfNeeded(urlParser, (Protocol)Proxy.newProxyInstance(MastersSlavesProtocol.class.getClassLoader(), new Class[]{Protocol.class}, (InvocationHandler)new FailoverProxy(new MastersSlavesListener(urlParser, globalInfo), lock, traceCache)));
            }
            case LOADBALANCE: 
            case SEQUENTIAL: {
                return Utils.getProxyLoggingIfNeeded(urlParser, (Protocol)Proxy.newProxyInstance(MasterProtocol.class.getClassLoader(), new Class[]{Protocol.class}, (InvocationHandler)new FailoverProxy(new MastersFailoverListener(urlParser, globalInfo), lock, traceCache)));
            }
        }
        Protocol protocol = Utils.getProxyLoggingIfNeeded(urlParser, new MasterProtocol(urlParser, globalInfo, lock, traceCache));
        protocol.connectWithoutProxy();
        return protocol;
    }

    private static Protocol getProxyLoggingIfNeeded(UrlParser urlParser, Protocol protocol) {
        if (urlParser.getOptions().profileSql || urlParser.getOptions().slowQueryThresholdNanos != null) {
            return (Protocol)Proxy.newProxyInstance(MasterProtocol.class.getClassLoader(), new Class[]{Protocol.class}, (InvocationHandler)new ProtocolLoggingProxy(protocol, urlParser.getOptions()));
        }
        return protocol;
    }

    public static TimeZone getTimeZone(String id) throws SQLException {
        TimeZone tz = TimeZone.getTimeZone(id);
        if ("GMT".equals(tz.getID()) && !"GMT".equals(id)) {
            throw new SQLException("invalid timezone id '" + id + "'");
        }
        return tz;
    }

    public static Socket createSocket(Options options, String host) throws IOException {
        return socketHandler.apply(options, host);
    }

    public static String hexdump(byte[] ... bytes) {
        return Utils.hexdump(Integer.MAX_VALUE, 0, Integer.MAX_VALUE, bytes);
    }

    public static String hexdump(int maxQuerySizeToLog, int offset, int length, byte[] ... byteArr) {
        byte[] concat;
        switch (byteArr.length) {
            case 0: {
                return "";
            }
            case 1: {
                byte[] bytes = byteArr[0];
                if (bytes.length <= offset) {
                    return "";
                }
                int dataLength = Math.min(maxQuerySizeToLog, Math.min(bytes.length - offset, length));
                StringBuilder outputBuilder = new StringBuilder(dataLength * 5);
                outputBuilder.append("\n");
                Utils.writeHex(bytes, offset, dataLength, outputBuilder);
                return outputBuilder.toString();
            }
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            outputStream.write(byteArr[0]);
            outputStream.write(byteArr[1], offset, Math.min(length, byteArr[1].length));
            for (int i = 2; i < byteArr.length; ++i) {
                outputStream.write(byteArr[i]);
            }
        }
        catch (IOException i) {
            // empty catch block
        }
        if ((concat = outputStream.toByteArray()).length <= offset) {
            return "";
        }
        int stlength = Math.min(maxQuerySizeToLog, outputStream.size());
        StringBuilder out = new StringBuilder(stlength * 3 + 80);
        out.append("\n");
        Utils.writeHex(outputStream.toByteArray(), 0, outputStream.size(), out);
        return out.toString();
    }

    private static void writeHex(byte[] bytes, int offset, int dataLength, StringBuilder outputBuilder) {
        if (bytes == null || bytes.length == 0) {
            return;
        }
        char[] hexaValue = new char[16];
        hexaValue[8] = 32;
        int posHexa = 0;
        outputBuilder.append("+--------------------------------------------------+\n|  0  1  2  3  4  5  6  7   8  9  a  b  c  d  e  f |\n+--------------------------------------------------+------------------+\n| ");
        for (int pos = offset; pos < dataLength + offset; ++pos) {
            int byteValue = bytes[pos] & 0xFF;
            outputBuilder.append(hexArray[byteValue >>> 4]).append(hexArray[byteValue & 0xF]).append(" ");
            int n = hexaValue[posHexa++] = byteValue > 31 && byteValue < 127 ? (int)byteValue : 46;
            if (posHexa == 8) {
                outputBuilder.append(" ");
            }
            if (posHexa != 16) continue;
            outputBuilder.append("| ").append(hexaValue).append(" |\n");
            if (pos + 1 != dataLength + offset) {
                outputBuilder.append("| ");
            }
            posHexa = 0;
        }
        int remaining = posHexa;
        if (remaining > 0) {
            if (remaining < 8) {
                while (remaining < 8) {
                    outputBuilder.append("   ");
                    ++remaining;
                }
                outputBuilder.append(" ");
            }
            while (remaining < 16) {
                outputBuilder.append("   ");
                ++remaining;
            }
            while (posHexa < 16) {
                hexaValue[posHexa] = 32;
                ++posHexa;
            }
            outputBuilder.append("| ").append(hexaValue).append(" |\n");
        }
        outputBuilder.append("+--------------------------------------------------+------------------+\n");
    }

    private static String getHex(byte[] raw) {
        StringBuilder hex = new StringBuilder(2 * raw.length);
        for (byte b : raw) {
            hex.append(hexArray[(b & 0xF0) >> 4]).append(hexArray[b & 0xF]);
        }
        return hex.toString();
    }

    public static String byteArrayToHexString(byte[] bytes) {
        return bytes != null ? Utils.getHex(bytes) : "";
    }

    public static String intToHexString(int value) {
        StringBuilder hex = new StringBuilder(8);
        boolean nullEnd = false;
        for (int offset = 24; offset >= 0; offset -= 8) {
            byte b = (byte)(value >> offset);
            if (b == 0 && !nullEnd) continue;
            nullEnd = true;
            hex.append(hexArray[(b & 0xF0) >> 4]).append(hexArray[b & 0xF]);
        }
        return hex.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String parseSessionVariables(String sessionVariable) {
        char[] chars;
        StringBuilder out = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        Parse state = Parse.Normal;
        boolean iskey = true;
        boolean singleQuotes = true;
        boolean first = true;
        String key = null;
        block7: for (char car : chars = sessionVariable.toCharArray()) {
            if (state == Parse.Escape) {
                sb.append(car);
                state = singleQuotes ? Parse.Quote : Parse.String;
                continue;
            }
            switch (car) {
                case '\"': {
                    if (state == Parse.Normal) {
                        state = Parse.String;
                        singleQuotes = false;
                        break;
                    }
                    if (state != Parse.String || singleQuotes) break;
                    state = Parse.Normal;
                    break;
                }
                case '\'': {
                    if (state == Parse.Normal) {
                        state = Parse.String;
                        singleQuotes = true;
                        break;
                    }
                    if (state != Parse.String || !singleQuotes) break;
                    state = Parse.Normal;
                    break;
                }
                case '\\': {
                    if (state != Parse.String) break;
                    state = Parse.Escape;
                    break;
                }
                case ',': 
                case ';': {
                    if (state != Parse.Normal) break;
                    if (!iskey) {
                        if (!first) {
                            out.append(",");
                        }
                        out.append(key);
                        out.append(sb.toString());
                        first = false;
                    } else {
                        key = sb.toString().trim();
                        if (!key.isEmpty()) {
                            if (!first) {
                                out.append(",");
                            }
                            out.append(key);
                            first = false;
                        }
                    }
                    iskey = true;
                    key = null;
                    sb = new StringBuilder();
                    continue block7;
                }
                case '=': {
                    if (state != Parse.Normal || !iskey) break;
                    key = sb.toString().trim();
                    iskey = false;
                    sb = new StringBuilder();
                }
            }
            sb.append(car);
        }
        if (!iskey) {
            if (!first) {
                out.append(",");
            }
            out.append(key);
            out.append(sb.toString());
            return out.toString();
        }
        String tmpkey = sb.toString().trim();
        if (!tmpkey.isEmpty() && !first) {
            out.append(",");
        }
        out.append(tmpkey);
        return out.toString();
    }

    public static boolean isIPv4(String ip) {
        return IP_V4.matcher(ip).matches();
    }

    public static boolean isIPv6(String ip) {
        return IP_V6.matcher(ip).matches() || IP_V6_COMPRESSED.matcher(ip).matches();
    }

    public static int transactionFromString(String txIsolation) throws SQLException {
        switch (txIsolation) {
            case "READ-UNCOMMITTED": {
                return 1;
            }
            case "READ-COMMITTED": {
                return 2;
            }
            case "REPEATABLE-READ": {
                return 4;
            }
            case "SERIALIZABLE": {
                return 8;
            }
        }
        throw new SQLException("unknown transaction isolation level");
    }

    public static boolean validateFileName(String sql, ParameterHolder[] parameters, String fileName) {
        Pattern pattern = Pattern.compile("^(?:\\s*\\/\\*.*?\\*\\/\\s*)*LOAD\\s+DATA\\s+(?:LOW_PRIORITY\\s+|CONCURRENT\\s+)?(?:\\s*\\/\\*.*?\\*\\/\\s*)*LOCAL\\s+INFILE\\s*'(.+?)'\\s*(?:\\/\\*.*?\\*\\/\\s*)*INTO\\s+TABLE\\s+(?:\\s*\\/\\*.*?\\*\\/\\s*)*(?:\\w+(?:\\.\\w+)?)(?:\\s*\\/\\*.*?\\*\\/\\s*)*", 2);
        Matcher matcher = pattern.matcher(sql);
        if (matcher.find()) {
            String fileNameFromSql = matcher.group(1);
            if (fileName.replaceAll("[/\\\\]", "").equalsIgnoreCase(fileNameFromSql.replaceAll("[/\\\\]", ""))) {
                return true;
            }
        }
        if (parameters != null && (pattern = Pattern.compile("^(?:\\s*\\/\\*.*?\\*\\/\\s*)*LOAD\\s+DATA\\s+(?:LOW_PRIORITY\\s+|CONCURRENT\\s+)?(?:\\s*\\/\\*.*?\\*\\/\\s*)*LOCAL\\s+INFILE\\s+", 2)).matcher(sql).find() && parameters.length > 0) {
            return parameters[0].toString().toLowerCase().replaceAll("[/\\\\]", "").equals("'" + fileName.toLowerCase().replaceAll("[/\\\\]", "") + "'");
        }
        return false;
    }

    protected static char[] encodeHex(byte[] data, char[] toDigits) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = toDigits[(0xF0 & data[i]) >>> 4];
            out[j++] = toDigits[0xF & data[i]];
        }
        return out;
    }

    public static String encodeHexStr(byte[] data) {
        return Utils.encodeHexStr(data, false);
    }

    public static String encodeHexStr(byte[] data, boolean toLowerCase) {
        return Utils.encodeHexStr(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    protected static String encodeHexStr(byte[] data, char[] toDigits) {
        return new String(Utils.encodeHex(data, toDigits));
    }

    public static String toHexString(byte[] data) {
        return Utils.encodeHexStr(data);
    }

    public static boolean convertStringToBoolean(String str) {
        if (str != null && str.length() > 0) {
            char c = Character.toLowerCase(str.charAt(0));
            return c == 't' || c == 'y' || c == '1' || str.equals("-1");
        }
        return false;
    }

    public static boolean convertBytesToBoolean(byte[] bytes) {
        if (bytes == null) {
            return false;
        }
        if (bytes.length == 0) {
            return false;
        }
        if (bytes[0] == 49) {
            return true;
        }
        if (bytes[0] == 48) {
            return false;
        }
        return bytes[0] == -1 || bytes[0] > 0;
    }

    static {
        SocketHandlerFunction init;
        hexArray = "0123456789ABCDEF".toCharArray();
        IP_V4 = Pattern.compile("^(([1-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){1}(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){2}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$");
        IP_V6 = Pattern.compile("^[0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4}){7}$");
        IP_V6_COMPRESSED = Pattern.compile("^(([0-9A-Fa-f]{1,4}(:[0-9A-Fa-f]{1,4}){0,5})?)::(([0-9A-Fa-f]{1,4}(:[0-9A-Fa-f]{1,4}){0,5})?)$");
        try {
            init = SocketUtility.getSocketHandler();
        }
        catch (Throwable t) {
            SocketHandlerFunction defaultSocketHandler;
            init = defaultSocketHandler = (options, host) -> Utils.standardSocket(options, host);
        }
        socketHandler = init;
        String tnsDaemonFlag = System.getProperty("oceanbase.tns_admin_deamon");
        String tnsDaemonFlagEnv = System.getenv("OCEANBASE_TNS_ADMIN_DEAMON");
        if (tnsDaemonFlag == null) {
            tnsDaemonFlag = tnsDaemonFlagEnv;
        }
        if (tnsDaemonFlag == null || tnsDaemonFlag != null && tnsDaemonFlag.equalsIgnoreCase("FALSE")) {
            tnsDaemon = null;
        } else {
            try {
                ConfigParser.ConfigInfo tnsFileInfo = ConfigParser.getTnsFilePath();
                String filePath = tnsFileInfo.path + "/" + tnsFileInfo.name;
                File file = new File(filePath);
                InputStreamReader reader = new InputStreamReader(new FileInputStream(file));
                ConfigParser.readLoadBalanceInfosFromTns(reader);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            tnsDaemon = new TnsDaemon();
            tnsDaemon.start();
        }
        DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }

    private static enum Parse {
        Normal,
        String,
        Quote,
        Escape;

    }

    static enum KeyState {
        Normal,
        No,
        Duplicate,
        Key,
        Update;

    }

    public static class TrimSQLInfo {
        String trimedString;
        int paramCount;
        int selectEndPos;
        int whereEndPos;
        List<Integer> paramsIndexs;
        int onDuplicateKeyUpdateIndex;

        public void setOnDuplicateKeyUpdateIndex(int onDuplicateKeyUpdateIndex) {
            this.onDuplicateKeyUpdateIndex = onDuplicateKeyUpdateIndex;
        }

        public int getOnDuplicateKeyUpdateIndex() {
            return this.onDuplicateKeyUpdateIndex;
        }

        public TrimSQLInfo(String trimedString, int paramCount, int selectEndPos, int whereEndPos, List<Integer> paramsIndexs, int onDuplicateKeyUpdateIndex) {
            this.trimedString = trimedString;
            this.paramCount = paramCount;
            this.selectEndPos = selectEndPos;
            this.whereEndPos = whereEndPos;
            this.paramsIndexs = paramsIndexs;
            this.onDuplicateKeyUpdateIndex = onDuplicateKeyUpdateIndex;
        }

        public String getTrimedString() {
            return this.trimedString;
        }

        public int getParamCount() {
            return this.paramCount;
        }

        public int getSelectEndPos() {
            return this.selectEndPos;
        }

        public int getWhereEndPos() {
            return this.whereEndPos;
        }

        public List<Integer> getParamsIndexs() {
            return this.paramsIndexs;
        }

        public String toString() {
            return "TrimSQLInfo{trimedString='" + this.trimedString + '\'' + ", paramCount=" + this.paramCount + ", selectEndPos=" + this.selectEndPos + ", whereEndPos=" + this.whereEndPos + ", paramsIndexs=" + this.paramsIndexs + ", onDuplicateKeyUpdateIndex=" + this.onDuplicateKeyUpdateIndex + '}';
        }
    }

    static enum LexState {
        Normal,
        String,
        SlashStarComment,
        Escape,
        EOLComment,
        Backtick,
        NameBinding;

    }
}

