/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import android.util.Log;
import com.loopj.android.http.AsyncHttpResponseHandler;
import java.io.UnsupportedEncodingException;
import org.apache.http.Header;

public abstract class TextHttpResponseHandler
extends AsyncHttpResponseHandler {
    private static final String LOG_TAG = "TextHttpResponseHandler";

    public TextHttpResponseHandler() {
        this("UTF-8");
    }

    public TextHttpResponseHandler(String encoding) {
        this.setCharset(encoding);
    }

    public abstract void onFailure(int var1, Header[] var2, String var3, Throwable var4);

    public abstract void onSuccess(int var1, Header[] var2, String var3);

    @Override
    public void onSuccess(int statusCode, Header[] headers, byte[] responseBytes) {
        this.onSuccess(statusCode, headers, TextHttpResponseHandler.getResponseString(responseBytes, this.getCharset()));
    }

    @Override
    public void onFailure(int statusCode, Header[] headers, byte[] responseBytes, Throwable throwable) {
        this.onFailure(statusCode, headers, TextHttpResponseHandler.getResponseString(responseBytes, this.getCharset()), throwable);
    }

    public static String getResponseString(byte[] stringBytes, String charset) {
        try {
            String toReturn;
            String string = toReturn = stringBytes == null ? null : new String(stringBytes, charset);
            if (toReturn != null && toReturn.startsWith("\ufeff")) {
                return toReturn.substring(1);
            }
            return toReturn;
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)LOG_TAG, (String)"Encoding response into string failed", (Throwable)e);
            return null;
        }
    }
}

