/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.ContentResolver;
import android.content.Context;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import com.onesignal.AdvertisingIdentifierProvider;
import java.util.Arrays;
import java.util.List;

class AdvertisingIdProviderFallback
implements AdvertisingIdentifierProvider {
    private static final List<String> INVALID_PHONE_IDS = Arrays.asList("", "0", "unknown", "739463", "000000000000000", "111111111111111", "352005048247251", "012345678912345", "012345678901237", "88508850885050", "0123456789abcde", "004999010640000", "862280010599525", "52443443484950", "355195000000017", "001068000000006", "358673013795895", "355692547693084", "004400152020000", "8552502717594321", "113456798945455", "012379000772883", "111111111111119", "358701042909755", "358000043654134", "345630000000115", "356299046587760", "356591000000222");

    AdvertisingIdProviderFallback() {
    }

    @Override
    public String getIdentifier(Context appContext) {
        String id = this.getPhoneId(appContext);
        if (id != null) {
            return id;
        }
        id = this.getAndroidId(appContext);
        if (id != null) {
            return id;
        }
        return this.getWifiMac(appContext);
    }

    private String getPhoneId(Context appContext) {
        try {
            String phoneId = ((TelephonyManager)appContext.getSystemService("phone")).getDeviceId();
            if (phoneId != null && !INVALID_PHONE_IDS.contains(phoneId)) {
                return phoneId;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return null;
    }

    private String getAndroidId(Context appContext) {
        try {
            String androidId = Settings.Secure.getString((ContentResolver)appContext.getContentResolver(), (String)"android_id");
            if (androidId != "9774d56d682e549c") {
                return androidId;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return null;
    }

    private String getWifiMac(Context appContext) {
        try {
            if (Build.VERSION.SDK_INT < 23) {
                return ((WifiManager)appContext.getSystemService("wifi")).getConnectionInfo().getMacAddress();
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return null;
    }
}

