/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.R;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Notification;
import android.app.PendingIntent;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.NotificationManagerCompat;
import android.text.SpannableString;
import android.text.style.StyleSpan;
import com.onesignal.ActivityLifecycleHandler;
import com.onesignal.NotificationBundleProcessor;
import com.onesignal.NotificationOpenedActivity;
import com.onesignal.NotificationOpenedProcessor;
import com.onesignal.NotificationOpenedReceiver;
import com.onesignal.OSUtils;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalDbHelper;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class GenerateNotification {
    private static Context currentContext = null;
    private static String packageName = null;
    private static Resources contextResources = null;
    private static Class<?> notificationOpenedClass;
    private static boolean openerIsBroadcast;

    GenerateNotification() {
    }

    static void setStatics(Context inContext) {
        currentContext = inContext;
        packageName = currentContext.getPackageName();
        contextResources = currentContext.getResources();
        PackageManager packageManager = currentContext.getPackageManager();
        Intent intent = new Intent(currentContext, NotificationOpenedReceiver.class);
        intent.setPackage(currentContext.getPackageName());
        if (packageManager.queryBroadcastReceivers(intent, 0).size() > 0) {
            openerIsBroadcast = true;
            notificationOpenedClass = NotificationOpenedReceiver.class;
        } else {
            notificationOpenedClass = NotificationOpenedActivity.class;
        }
    }

    public static int fromBundle(Context inContext, Bundle bundle, boolean showAsAlert) {
        GenerateNotification.setStatics(inContext);
        JSONObject jsonBundle = NotificationBundleProcessor.bundleAsJSONObject(bundle);
        if (showAsAlert && ActivityLifecycleHandler.curActivity != null) {
            return GenerateNotification.showNotificationAsAlert(jsonBundle, ActivityLifecycleHandler.curActivity);
        }
        return GenerateNotification.showNotification(jsonBundle);
    }

    private static int showNotificationAsAlert(final JSONObject gcmJson, final Activity activity) {
        final int aNotificationId = new Random().nextInt();
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
                builder.setTitle(GenerateNotification.getTitle(gcmJson));
                try {
                    builder.setMessage((CharSequence)gcmJson.getString("alert"));
                }
                catch (Throwable t) {
                    // empty catch block
                }
                ArrayList buttonsLabels = new ArrayList();
                ArrayList buttonIds = new ArrayList();
                GenerateNotification.addAlertButtons(gcmJson, buttonsLabels, buttonIds);
                final ArrayList finalButtonIds = buttonIds;
                Intent buttonIntent = GenerateNotification.getNewBaseIntent(aNotificationId);
                buttonIntent.putExtra("action_button", true);
                buttonIntent.putExtra("from_alert", true);
                buttonIntent.putExtra("onesignal_data", gcmJson.toString());
                try {
                    if (gcmJson.has("grp")) {
                        buttonIntent.putExtra("grp", gcmJson.getString("grp"));
                    }
                }
                catch (JSONException e) {
                    // empty catch block
                }
                final Intent finalButtonIntent = buttonIntent;
                DialogInterface.OnClickListener buttonListener = new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        int index = which + 3;
                        if (finalButtonIds.size() > 1) {
                            try {
                                JSONObject customJson = new JSONObject(gcmJson.getString("custom"));
                                JSONObject additionalDataJSON = customJson.getJSONObject("a");
                                additionalDataJSON.put("actionSelected", finalButtonIds.get(index));
                                JSONObject newJsonData = new JSONObject(gcmJson.toString());
                                newJsonData.put("custom", (Object)customJson.toString());
                                finalButtonIntent.putExtra("onesignal_data", newJsonData.toString());
                                NotificationOpenedProcessor.processIntent((Context)activity, finalButtonIntent);
                            }
                            catch (Throwable t) {}
                        } else {
                            NotificationOpenedProcessor.processIntent((Context)activity, finalButtonIntent);
                        }
                    }
                };
                builder.setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialogInterface) {
                        NotificationOpenedProcessor.processIntent((Context)activity, finalButtonIntent);
                    }
                });
                for (int i = 0; i < buttonsLabels.size(); ++i) {
                    if (i == 0) {
                        builder.setNeutralButton((CharSequence)buttonsLabels.get(i), buttonListener);
                        continue;
                    }
                    if (i == 1) {
                        builder.setNegativeButton((CharSequence)buttonsLabels.get(i), buttonListener);
                        continue;
                    }
                    if (i != 2) continue;
                    builder.setPositiveButton((CharSequence)buttonsLabels.get(i), buttonListener);
                }
                AlertDialog alertDialog = builder.create();
                alertDialog.setCanceledOnTouchOutside(false);
                alertDialog.show();
            }
        });
        return aNotificationId;
    }

    private static CharSequence getTitle(JSONObject gcmBundle) {
        String title = null;
        try {
            title = gcmBundle.getString("title");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (title != null) {
            return title;
        }
        return currentContext.getPackageManager().getApplicationLabel(currentContext.getApplicationInfo());
    }

    private static PendingIntent getNewActionPendingIntent(int requestCode, Intent intent) {
        if (openerIsBroadcast) {
            return PendingIntent.getBroadcast((Context)currentContext, (int)requestCode, (Intent)intent, (int)0x8000000);
        }
        return PendingIntent.getActivity((Context)currentContext, (int)requestCode, (Intent)intent, (int)0x8000000);
    }

    private static Intent getNewBaseIntent(int notificationId) {
        Intent intent = new Intent(currentContext, notificationOpenedClass).putExtra("notificationId", notificationId);
        if (openerIsBroadcast) {
            return intent;
        }
        return intent.addFlags(0x24000000);
    }

    private static Intent getNewBaseDeleteIntent(int notificationId) {
        Intent intent = new Intent(currentContext, notificationOpenedClass).putExtra("notificationId", notificationId).putExtra("dismissed", true);
        if (openerIsBroadcast) {
            return intent;
        }
        return intent.addFlags(0x18010000);
    }

    private static NotificationCompat.Builder getBaseNotificationCompatBuilder(JSONObject gcmBundle, boolean notify) {
        Bitmap bigPictureIcon;
        int notificationIcon = GenerateNotification.getSmallIconId(gcmBundle);
        int notificationDefaults = 0;
        if (OneSignal.getVibrate(currentContext)) {
            notificationDefaults = 2;
        }
        String message = null;
        try {
            message = gcmBundle.getString("alert");
        }
        catch (Throwable t) {
            // empty catch block
        }
        NotificationCompat.Builder notifBuilder = new NotificationCompat.Builder(currentContext).setAutoCancel(true).setSmallIcon(notificationIcon).setContentTitle(GenerateNotification.getTitle(gcmBundle)).setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)message)).setContentText((CharSequence)message);
        if (notify) {
            notifBuilder.setTicker((CharSequence)message);
        }
        try {
            BigInteger accentColor = GenerateNotification.getAccentColor(gcmBundle);
            if (accentColor != null) {
                notifBuilder.setColor(accentColor.intValue());
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        BigInteger ledColor = null;
        if (notify && gcmBundle.has("ledc")) {
            try {
                ledColor = new BigInteger(gcmBundle.getString("ledc"), 16);
                notifBuilder.setLights(ledColor.intValue(), 2000, 5000);
            }
            catch (Throwable t) {
                notificationDefaults |= 4;
            }
        } else {
            notificationDefaults |= 4;
        }
        try {
            int visibility = 1;
            if (gcmBundle.has("vis")) {
                visibility = Integer.parseInt(gcmBundle.getString("vis"));
            }
            notifBuilder.setVisibility(visibility);
        }
        catch (Throwable t) {
            // empty catch block
        }
        Bitmap largeIcon = GenerateNotification.getLargeIcon(gcmBundle);
        if (largeIcon != null) {
            notifBuilder.setLargeIcon(largeIcon);
        }
        if ((bigPictureIcon = GenerateNotification.getBitmapIcon(gcmBundle, "bicon")) != null) {
            notifBuilder.setStyle((NotificationCompat.Style)new NotificationCompat.BigPictureStyle().bigPicture(bigPictureIcon).setSummaryText((CharSequence)message));
        }
        if (notify && OneSignal.getSoundEnabled(currentContext)) {
            Uri soundUri = GenerateNotification.getCustomSound(gcmBundle);
            if (soundUri != null) {
                notifBuilder.setSound(soundUri);
            } else {
                notificationDefaults |= 1;
            }
        }
        if (!notify) {
            notificationDefaults = 0;
        }
        notifBuilder.setDefaults(notificationDefaults);
        return notifBuilder;
    }

    private static int showNotification(JSONObject gcmBundle) {
        Random random = new Random();
        String group = null;
        try {
            group = gcmBundle.getString("grp");
        }
        catch (Throwable t) {
            // empty catch block
        }
        int notificationId = random.nextInt();
        NotificationCompat.Builder notifBuilder = GenerateNotification.getBaseNotificationCompatBuilder(gcmBundle, true);
        GenerateNotification.addNotificationActionButtons(gcmBundle, notifBuilder, notificationId, null);
        if (group != null) {
            PendingIntent contentIntent = GenerateNotification.getNewActionPendingIntent(random.nextInt(), GenerateNotification.getNewBaseIntent(notificationId).putExtra("onesignal_data", gcmBundle.toString()).putExtra("grp", group));
            notifBuilder.setContentIntent(contentIntent);
            PendingIntent deleteIntent = GenerateNotification.getNewActionPendingIntent(random.nextInt(), GenerateNotification.getNewBaseDeleteIntent(notificationId).putExtra("grp", group));
            notifBuilder.setDeleteIntent(deleteIntent);
            notifBuilder.setGroup(group);
            GenerateNotification.createSummaryNotification(gcmBundle);
        } else {
            PendingIntent contentIntent = GenerateNotification.getNewActionPendingIntent(random.nextInt(), GenerateNotification.getNewBaseIntent(notificationId).putExtra("onesignal_data", gcmBundle.toString()));
            notifBuilder.setContentIntent(contentIntent);
            PendingIntent deleteIntent = GenerateNotification.getNewActionPendingIntent(random.nextInt(), GenerateNotification.getNewBaseDeleteIntent(notificationId));
            notifBuilder.setDeleteIntent(deleteIntent);
        }
        if (group == null || Build.VERSION.SDK_INT > 17) {
            NotificationManagerCompat.from((Context)currentContext).notify(notificationId, notifBuilder.build());
        }
        return notificationId;
    }

    private static void createSummaryNotification(JSONObject gcmBundle) {
        GenerateNotification.createSummaryNotification(null, false, gcmBundle);
    }

    static void createSummaryNotification(Context inContext, boolean updateSummary, JSONObject gcmBundle) {
        Notification summaryNotification;
        if (updateSummary) {
            GenerateNotification.setStatics(inContext);
        }
        String group = null;
        try {
            group = gcmBundle.getString("grp");
        }
        catch (Throwable t) {
            // empty catch block
        }
        Random random = new Random();
        PendingIntent summaryDeleteIntent = GenerateNotification.getNewActionPendingIntent(random.nextInt(), GenerateNotification.getNewBaseDeleteIntent(0).putExtra("summary", group));
        OneSignalDbHelper dbHelper = new OneSignalDbHelper(currentContext);
        SQLiteDatabase writableDb = dbHelper.getWritableDatabase();
        String[] retColumn = new String[]{"android_notification_id", "full_data", "is_summary", "title", "message"};
        String[] whereArgs = new String[]{group};
        Cursor cursor = writableDb.query("notification", retColumn, "group_id = ? AND dismissed = 0 AND opened = 0", whereArgs, null, null, "_id DESC");
        int summaryNotificationId = random.nextInt();
        String firstFullData = null;
        ArrayList<SpannableString> summeryList = null;
        if (cursor.moveToFirst()) {
            summeryList = new ArrayList<SpannableString>();
            do {
                if (cursor.getInt(cursor.getColumnIndex("is_summary")) == 1) {
                    summaryNotificationId = cursor.getInt(cursor.getColumnIndex("android_notification_id"));
                    continue;
                }
                String title = cursor.getString(cursor.getColumnIndex("title"));
                title = title == null ? "" : title + " ";
                String msg = cursor.getString(cursor.getColumnIndex("message"));
                SpannableString spannableString = new SpannableString((CharSequence)(title + msg));
                if (title.length() > 0) {
                    spannableString.setSpan((Object)new StyleSpan(1), 0, title.length(), 0);
                }
                summeryList.add(spannableString);
                if (firstFullData != null) continue;
                firstFullData = cursor.getString(cursor.getColumnIndex("full_data"));
            } while (cursor.moveToNext());
            if (updateSummary) {
                try {
                    gcmBundle = new JSONObject(firstFullData);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
        if (!(summeryList == null || updateSummary && summeryList.size() <= 1)) {
            int notificationCount = summeryList.size() + (updateSummary ? 0 : 1);
            String summaryMessage = null;
            if (gcmBundle.has("grp_msg")) {
                try {
                    summaryMessage = gcmBundle.getString("grp_msg").replace("$[notif_count]", "" + notificationCount);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            if (summaryMessage == null) {
                summaryMessage = notificationCount + " new messages";
            }
            JSONObject summaryDataBundle = new JSONObject();
            try {
                summaryDataBundle.put("alert", (Object)summaryMessage);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            Intent summaryIntent = GenerateNotification.getNewBaseIntent(summaryNotificationId).putExtra("summary", group).putExtra("onesignal_data", summaryDataBundle.toString());
            PendingIntent summaryContentIntent = GenerateNotification.getNewActionPendingIntent(random.nextInt(), summaryIntent);
            NotificationCompat.Builder summeryBuilder = GenerateNotification.getBaseNotificationCompatBuilder(gcmBundle, !updateSummary);
            summeryBuilder.setContentIntent(summaryContentIntent).setDeleteIntent(summaryDeleteIntent).setContentTitle(currentContext.getPackageManager().getApplicationLabel(currentContext.getApplicationInfo())).setContentText((CharSequence)summaryMessage).setNumber(notificationCount).setOnlyAlertOnce(updateSummary).setGroup(group).setGroupSummary(true);
            if (!updateSummary) {
                summeryBuilder.setTicker((CharSequence)summaryMessage);
            }
            NotificationCompat.InboxStyle inboxStyle = new NotificationCompat.InboxStyle();
            String line1Title = null;
            if (!updateSummary) {
                try {
                    line1Title = gcmBundle.getString("title");
                }
                catch (Throwable t) {
                    // empty catch block
                }
                line1Title = line1Title == null ? "" : line1Title + " ";
                String message = "";
                try {
                    message = gcmBundle.getString("alert");
                }
                catch (Throwable t) {
                    // empty catch block
                }
                SpannableString spannableString = new SpannableString((CharSequence)(line1Title + message));
                if (line1Title.length() > 0) {
                    spannableString.setSpan((Object)new StyleSpan(1), 0, line1Title.length(), 0);
                }
                inboxStyle.addLine((CharSequence)spannableString);
            }
            for (SpannableString line : summeryList) {
                inboxStyle.addLine((CharSequence)line);
            }
            inboxStyle.setBigContentTitle((CharSequence)summaryMessage);
            summeryBuilder.setStyle((NotificationCompat.Style)inboxStyle);
            summaryNotification = summeryBuilder.build();
        } else {
            ContentValues values = new ContentValues();
            values.put("android_notification_id", Integer.valueOf(summaryNotificationId));
            values.put("group_id", group);
            values.put("is_summary", Integer.valueOf(1));
            writableDb.insert("notification", null, values);
            NotificationCompat.Builder notifBuilder = GenerateNotification.getBaseNotificationCompatBuilder(gcmBundle, !updateSummary);
            PendingIntent summaryContentIntent = GenerateNotification.getNewActionPendingIntent(random.nextInt(), GenerateNotification.getNewBaseIntent(summaryNotificationId).putExtra("onesignal_data", gcmBundle.toString()).putExtra("summary", group));
            GenerateNotification.addNotificationActionButtons(gcmBundle, notifBuilder, summaryNotificationId, group);
            notifBuilder.setContentIntent(summaryContentIntent).setDeleteIntent(summaryDeleteIntent).setOnlyAlertOnce(updateSummary).setGroup(group).setGroupSummary(true);
            summaryNotification = notifBuilder.build();
        }
        NotificationManagerCompat.from((Context)currentContext).notify(summaryNotificationId, summaryNotification);
        cursor.close();
        writableDb.close();
    }

    private static boolean isValidResourceName(String name) {
        return name != null && !name.matches("^[0-9]");
    }

    private static Bitmap getLargeIcon(JSONObject gcmBundle) {
        if (Build.VERSION.SDK_INT < 11) {
            return null;
        }
        Bitmap bitmap = GenerateNotification.getBitmapIcon(gcmBundle, "licon");
        if (bitmap == null) {
            bitmap = GenerateNotification.getBitmapFromAssetsOrResourceName("ic_onesignal_large_icon_default");
        }
        if (bitmap == null) {
            bitmap = GenerateNotification.getBitmapFromAssetsOrResourceName("ic_gamethrive_large_icon_default");
        }
        if (bitmap == null) {
            return null;
        }
        try {
            int systemLargeIconHeight = (int)contextResources.getDimension(17104902);
            int systemLargeIconWidth = (int)contextResources.getDimension(0x1050005);
            int bitmapHeight = bitmap.getHeight();
            int bitmapWidth = bitmap.getWidth();
            if (bitmapWidth > systemLargeIconWidth || bitmapHeight > systemLargeIconHeight) {
                int newWidth = systemLargeIconWidth;
                int newHeight = systemLargeIconHeight;
                if (bitmapHeight > bitmapWidth) {
                    float ratio = (float)bitmapWidth / (float)bitmapHeight;
                    newWidth = (int)((float)newHeight * ratio);
                } else if (bitmapWidth > bitmapHeight) {
                    float ratio = (float)bitmapHeight / (float)bitmapWidth;
                    newHeight = (int)((float)newWidth * ratio);
                }
                return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)newWidth, (int)newHeight, (boolean)true);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bitmap;
    }

    private static Bitmap getBitmapFromAssetsOrResourceName(String bitmapStr) {
        try {
            Bitmap bitmap = null;
            try {
                bitmap = BitmapFactory.decodeStream((InputStream)currentContext.getAssets().open(bitmapStr));
            }
            catch (Throwable t) {
                // empty catch block
            }
            if (bitmap != null) {
                return bitmap;
            }
            List<String> image_extensions = Arrays.asList(".png", ".webp", ".jpg", ".gif", ".bmp");
            for (String extension : image_extensions) {
                try {
                    bitmap = BitmapFactory.decodeStream((InputStream)currentContext.getAssets().open(bitmapStr + extension));
                }
                catch (Throwable t) {
                    // empty catch block
                }
                if (bitmap == null) continue;
                return bitmap;
            }
            int bitmapId = GenerateNotification.getResourceIcon(bitmapStr);
            if (bitmapId != 0) {
                return BitmapFactory.decodeResource((Resources)contextResources, (int)bitmapId);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static Bitmap getBitmapFromURL(String location) {
        try {
            return BitmapFactory.decodeStream((InputStream)new URL(location).openConnection().getInputStream());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Bitmap getBitmapIcon(JSONObject gcmBundle, String key) {
        if (gcmBundle.has(key)) {
            String bitmapStr = null;
            try {
                bitmapStr = gcmBundle.getString(key);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (bitmapStr.startsWith("http://") || bitmapStr.startsWith("https://")) {
                return GenerateNotification.getBitmapFromURL(bitmapStr);
            }
            return GenerateNotification.getBitmapFromAssetsOrResourceName(bitmapStr);
        }
        return null;
    }

    private static int getResourceIcon(String iconName) {
        if (!GenerateNotification.isValidResourceName(iconName)) {
            return 0;
        }
        int notificationIcon = GenerateNotification.getDrawableId(iconName);
        if (notificationIcon != 0) {
            return notificationIcon;
        }
        try {
            return R.drawable.class.getField(iconName).getInt(null);
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    private static int getSmallIconId(JSONObject gcmBundle) {
        int notificationIcon = 0;
        if (gcmBundle.has("sicon")) {
            try {
                notificationIcon = GenerateNotification.getResourceIcon(gcmBundle.getString("sicon"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (notificationIcon != 0) {
                return notificationIcon;
            }
        }
        if ((notificationIcon = GenerateNotification.getDrawableId("ic_stat_onesignal_default")) != 0) {
            return notificationIcon;
        }
        notificationIcon = GenerateNotification.getDrawableId("ic_stat_gamethrive_default");
        if (notificationIcon != 0) {
            return notificationIcon;
        }
        notificationIcon = GenerateNotification.getDrawableId("corona_statusbar_icon_default");
        if (notificationIcon != 0) {
            return notificationIcon;
        }
        notificationIcon = GenerateNotification.currentContext.getApplicationInfo().icon;
        if (notificationIcon != 0) {
            return notificationIcon;
        }
        return 17301651;
    }

    private static int getDrawableId(String name) {
        return contextResources.getIdentifier(name, "drawable", packageName);
    }

    private static Uri getCustomSound(JSONObject gcmBundle) {
        int soundId;
        String sound = null;
        try {
            if (gcmBundle.has("sound")) {
                sound = gcmBundle.getString("sound");
            }
        }
        catch (Throwable t) {
            return null;
        }
        if (GenerateNotification.isValidResourceName(sound) && (soundId = contextResources.getIdentifier(sound, "raw", packageName)) != 0) {
            return Uri.parse((String)("android.resource://" + packageName + "/" + soundId));
        }
        soundId = contextResources.getIdentifier("onesignal_default_sound", "raw", packageName);
        if (soundId != 0) {
            return Uri.parse((String)("android.resource://" + packageName + "/" + soundId));
        }
        soundId = contextResources.getIdentifier("gamethrive_default_sound", "raw", packageName);
        if (soundId != 0) {
            return Uri.parse((String)("android.resource://" + packageName + "/" + soundId));
        }
        return null;
    }

    private static BigInteger getAccentColor(JSONObject gcmBundle) {
        try {
            if (gcmBundle.has("bgac")) {
                return new BigInteger(gcmBundle.getString("bgac"), 16);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            String defaultColor = OSUtils.getManifestMeta(currentContext, "com.onesignal.NotificationAccentColor.DEFAULT");
            if (defaultColor != null) {
                return new BigInteger(defaultColor, 16);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static void addNotificationActionButtons(JSONObject gcmBundle, NotificationCompat.Builder mBuilder, int notificationId, String groupSummary) {
        try {
            JSONObject additionalDataJSON;
            JSONObject customJson = new JSONObject(gcmBundle.getString("custom"));
            if (customJson.has("a") && (additionalDataJSON = customJson.getJSONObject("a")).has("actionButtons")) {
                JSONArray buttons = additionalDataJSON.getJSONArray("actionButtons");
                for (int i = 0; i < buttons.length(); ++i) {
                    JSONObject button = buttons.getJSONObject(i);
                    additionalDataJSON.put("actionSelected", (Object)button.getString("id"));
                    JSONObject bundle = new JSONObject(gcmBundle.toString());
                    bundle.put("custom", (Object)customJson.toString());
                    Intent buttonIntent = GenerateNotification.getNewBaseIntent(notificationId);
                    buttonIntent.setAction("" + i);
                    buttonIntent.putExtra("action_button", true);
                    buttonIntent.putExtra("onesignal_data", bundle.toString());
                    if (groupSummary != null) {
                        buttonIntent.putExtra("summary", groupSummary);
                    } else if (gcmBundle.has("grp")) {
                        buttonIntent.putExtra("grp", gcmBundle.getString("grp"));
                    }
                    PendingIntent buttonPIntent = GenerateNotification.getNewActionPendingIntent(notificationId, buttonIntent);
                    int buttonIcon = 0;
                    if (button.has("icon")) {
                        buttonIcon = GenerateNotification.getResourceIcon(button.getString("icon"));
                    }
                    mBuilder.addAction(buttonIcon, (CharSequence)button.getString("text"), buttonPIntent);
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private static void addAlertButtons(JSONObject gcmBundle, List<String> buttonsLabels, List<String> buttonsIds) {
        try {
            JSONObject additionalDataJSON;
            JSONObject customJson = new JSONObject(gcmBundle.getString("custom"));
            if (customJson.has("a") && (additionalDataJSON = customJson.getJSONObject("a")).has("actionButtons")) {
                JSONArray buttons = additionalDataJSON.getJSONArray("actionButtons");
                for (int i = 0; i < buttons.length(); ++i) {
                    JSONObject button = buttons.getJSONObject(i);
                    buttonsLabels.add(button.getString("text"));
                    buttonsIds.add(button.getString("id"));
                }
            }
            if (buttonsLabels.size() < 3) {
                buttonsLabels.add("Close");
                buttonsIds.add("__DEFAULT__");
            }
        }
        catch (JSONException e) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Failed to parse buttons for alert dialog.", e);
        }
    }
}

