/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.support.v4.app.NotificationCompat;
import com.onesignal.GcmBroadcastReceiver;
import com.onesignal.NotificationBundleProcessor;
import com.onesignal.OSNotificationDisplayedResult;
import com.onesignal.OSNotificationPayload;
import com.onesignal.OneSignal;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class NotificationExtenderService
extends IntentService {
    private OSNotificationDisplayedResult osNotificationDisplayedResult;
    private JSONObject currentJsonPayload;
    private boolean currentlyRestoring;
    private OverrideSettings currentBaseOverrideSettings = null;

    public NotificationExtenderService() {
        super("NotificationExtenderService");
    }

    protected final OSNotificationDisplayedResult displayNotification(OverrideSettings overrideSettings) {
        if (this.osNotificationDisplayedResult != null || overrideSettings == null) {
            return null;
        }
        overrideSettings.override(this.currentBaseOverrideSettings);
        this.osNotificationDisplayedResult = new OSNotificationDisplayedResult();
        this.osNotificationDisplayedResult.notificationId = NotificationBundleProcessor.Process((Context)this, this.currentlyRestoring, this.currentJsonPayload, overrideSettings);
        return this.osNotificationDisplayedResult;
    }

    protected abstract boolean onNotificationProcessing(OSNotificationPayload var1);

    protected final void onHandleIntent(Intent intent) {
        this.processIntent(intent);
        GcmBroadcastReceiver.completeWakefulIntent((Intent)intent);
    }

    private void processIntent(Intent intent) {
        Bundle bundle = intent.getExtras();
        try {
            this.currentJsonPayload = new JSONObject(bundle.getString("json_payload"));
            this.currentlyRestoring = bundle.getBoolean("restoring", false);
            if (bundle.containsKey("android_notif_id")) {
                this.currentBaseOverrideSettings = new OverrideSettings();
                this.currentBaseOverrideSettings.androidNotificationId = bundle.getInt("android_notif_id");
            }
            if (!this.currentlyRestoring && OneSignal.notValidOrDuplicated((Context)this, this.currentJsonPayload)) {
                return;
            }
            this.processJsonObject(this.currentJsonPayload, this.currentlyRestoring);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    void processJsonObject(JSONObject currentJsonPayload, boolean restoring) {
        OSNotificationPayload notification = new OSNotificationPayload();
        try {
            JSONObject customJson = new JSONObject(currentJsonPayload.optString("custom"));
            notification.notificationId = customJson.optString("i");
            notification.additionalData = customJson.optJSONObject("a");
            notification.launchUrl = customJson.optString("u", null);
            notification.message = currentJsonPayload.optString("alert", null);
            notification.title = currentJsonPayload.optString("title", null);
            notification.smallIcon = currentJsonPayload.optString("sicon", null);
            notification.bigPicture = currentJsonPayload.optString("bicon", null);
            notification.largeIcon = currentJsonPayload.optString("licon", null);
            notification.sound = currentJsonPayload.optString("sound", null);
            notification.group = currentJsonPayload.optString("grp", null);
            notification.groupMessage = currentJsonPayload.optString("grp_msg", null);
            notification.backgroundColor = currentJsonPayload.optString("bgac", null);
            notification.ledColor = currentJsonPayload.optString("ledc", null);
            String visibility = currentJsonPayload.optString("vis", null);
            if (visibility != null) {
                notification.visibility = Integer.parseInt(visibility);
            }
            notification.backgroundData = "1".equals(currentJsonPayload.optString("bgn", null));
            notification.fromProjectNumber = currentJsonPayload.optString("from", null);
            notification.restoring = restoring;
            if (notification.additionalData != null && notification.additionalData.has("actionButtons")) {
                JSONArray jsonActionButtons = notification.additionalData.getJSONArray("actionButtons");
                notification.actionButtons = new ArrayList<OSNotificationPayload.ActionButton>();
                for (int i = 0; i < jsonActionButtons.length(); ++i) {
                    JSONObject jsonActionButton = jsonActionButtons.getJSONObject(i);
                    OSNotificationPayload.ActionButton actionButton = new OSNotificationPayload.ActionButton();
                    actionButton.id = jsonActionButton.getString("id");
                    actionButton.text = jsonActionButton.getString("text");
                    actionButton.icon = jsonActionButton.optString("icon", null);
                    notification.actionButtons.add(actionButton);
                }
                notification.additionalData.remove("actionSelected");
                notification.additionalData.remove("actionButtons");
            }
        }
        catch (Throwable t) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error assigning OSNotificationPayload values!", t);
        }
        this.osNotificationDisplayedResult = null;
        boolean developerProcessed = false;
        try {
            developerProcessed = this.onNotificationProcessing(notification);
        }
        catch (Throwable t) {
            if (this.osNotificationDisplayedResult == null) {
                OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "onNotificationProcessing throw an exception. Displaying normal OneSignal notification.", t);
            }
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "onNotificationProcessing throw an exception. Extended notification displayed but custom processing did not finish.", t);
        }
        if (this.osNotificationDisplayedResult == null) {
            if (developerProcessed) {
                if (!restoring) {
                    NotificationBundleProcessor.saveNotification((Context)this, currentJsonPayload, true, -1);
                }
            } else {
                NotificationBundleProcessor.Process((Context)this, this.currentlyRestoring, currentJsonPayload, this.currentBaseOverrideSettings);
            }
        }
    }

    static Intent getIntent(Context context) {
        Intent intent;
        PackageManager packageManager = context.getPackageManager();
        List resolveInfo = packageManager.queryIntentServices(intent = new Intent().setAction("com.onesignal.NotificationExtender").setPackage(context.getPackageName()), 128);
        if (resolveInfo.size() < 1) {
            return null;
        }
        return intent;
    }

    public static class OverrideSettings {
        public NotificationCompat.Extender extender;
        public Integer androidNotificationId;

        void override(OverrideSettings overrideSettings) {
            if (overrideSettings == null) {
                return;
            }
            if (overrideSettings.androidNotificationId != null) {
                this.androidNotificationId = overrideSettings.androidNotificationId;
            }
        }
    }
}

