/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.Context;
import com.amazon.device.iap.PurchasingListener;
import com.amazon.device.iap.PurchasingService;
import com.amazon.device.iap.model.Product;
import com.amazon.device.iap.model.ProductDataResponse;
import com.amazon.device.iap.model.PurchaseResponse;
import com.amazon.device.iap.model.PurchaseUpdatesResponse;
import com.amazon.device.iap.model.RequestId;
import com.amazon.device.iap.model.UserDataResponse;
import com.onesignal.OneSignal;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

class TrackAmazonPurchase {
    private Context context;
    private boolean canTrack = false;
    private OSPurchasingListener gtPurchasingListener;
    private Class<?> listnerHandlerClass;
    private Object listnerHandlerObject;
    private Field listnerHandlerField;

    TrackAmazonPurchase(Context context) {
        this.context = context;
        try {
            this.listnerHandlerClass = Class.forName("com.amazon.device.iap.internal.d");
            this.listnerHandlerObject = this.listnerHandlerClass.getMethod("d", new Class[0]).invoke(null, new Object[0]);
            this.listnerHandlerField = this.listnerHandlerClass.getDeclaredField("f");
            this.listnerHandlerField.setAccessible(true);
            this.gtPurchasingListener = new OSPurchasingListener();
            this.gtPurchasingListener.orgPurchasingListener = (PurchasingListener)this.listnerHandlerField.get(this.listnerHandlerObject);
            this.canTrack = true;
            this.setListener();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void setListener() {
        PurchasingService.registerListener((Context)this.context, (PurchasingListener)this.gtPurchasingListener);
    }

    public void checkListener() {
        if (this.canTrack) {
            try {
                PurchasingListener curPurchasingListener = (PurchasingListener)this.listnerHandlerField.get(this.listnerHandlerObject);
                if (curPurchasingListener != this.gtPurchasingListener) {
                    this.gtPurchasingListener.orgPurchasingListener = curPurchasingListener;
                    this.setListener();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private class OSPurchasingListener
    implements PurchasingListener {
        private static final String TAG = "OneSignalSDK-AmazonIAP";
        public PurchasingListener orgPurchasingListener;
        private RequestId lastRequestId;
        private String currentMarket;

        private OSPurchasingListener() {
        }

        private String marketToCurrencyCode(String market) {
            switch (market) {
                case "US": {
                    return "USD";
                }
                case "GB": {
                    return "GBP";
                }
                case "DE": 
                case "FR": 
                case "ES": 
                case "IT": {
                    return "EUR";
                }
                case "JP": {
                    return "JPY";
                }
                case "CA": {
                    return "CDN";
                }
                case "BR": {
                    return "BRL";
                }
                case "AU": {
                    return "AUD";
                }
            }
            return "";
        }

        public void onProductDataResponse(ProductDataResponse response) {
            if (this.lastRequestId != null && this.lastRequestId.toString().equals(response.getRequestId().toString())) {
                try {
                    switch (response.getRequestStatus()) {
                        case SUCCESSFUL: {
                            JSONArray purchasesToReport = new JSONArray();
                            Map products = response.getProductData();
                            for (String key : products.keySet()) {
                                Product product = (Product)products.get(key);
                                JSONObject jsonItem = new JSONObject();
                                jsonItem.put("sku", (Object)product.getSku());
                                jsonItem.put("iso", (Object)this.marketToCurrencyCode(this.currentMarket));
                                String price = product.getPrice();
                                if (!price.matches("^[0-9]")) {
                                    price = price.substring(1);
                                }
                                jsonItem.put("amount", (Object)price);
                                purchasesToReport.put((Object)jsonItem);
                            }
                            OneSignal.sendPurchases(purchasesToReport, false, null);
                        }
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            } else if (this.orgPurchasingListener != null) {
                this.orgPurchasingListener.onProductDataResponse(response);
            }
        }

        public void onPurchaseResponse(PurchaseResponse response) {
            try {
                PurchaseResponse.RequestStatus status = response.getRequestStatus();
                if (status == PurchaseResponse.RequestStatus.SUCCESSFUL) {
                    this.currentMarket = response.getUserData().getMarketplace();
                    HashSet<String> productSkus = new HashSet<String>();
                    productSkus.add(response.getReceipt().getSku());
                    this.lastRequestId = PurchasingService.getProductData(productSkus);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (this.orgPurchasingListener != null) {
                this.orgPurchasingListener.onPurchaseResponse(response);
            }
        }

        public void onPurchaseUpdatesResponse(PurchaseUpdatesResponse response) {
            if (this.orgPurchasingListener != null) {
                this.orgPurchasingListener.onPurchaseUpdatesResponse(response);
            }
        }

        public void onUserDataResponse(UserDataResponse response) {
            if (this.orgPurchasingListener != null) {
                this.orgPurchasingListener.onUserDataResponse(response);
            }
        }
    }
}

