/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.AlarmManager;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.os.Build;
import android.service.notification.StatusBarNotification;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.onesignal.BadgeCountUpdater;
import com.onesignal.NotificationBundleProcessor;
import com.onesignal.NotificationExtenderService;
import com.onesignal.NotificationLimitManager;
import com.onesignal.NotificationRestoreService;
import com.onesignal.OSUtils;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalDbHelper;
import com.onesignal.RestoreJobService;
import com.onesignal.RestoreKickoffJobService;
import java.io.Serializable;
import java.util.ArrayList;

class NotificationRestorer {
    private static final int RESTORE_KICKOFF_REQUEST_CODE = 2071862120;
    static final String[] COLUMNS_FOR_RESTORE = new String[]{"android_notification_id", "full_data", "created_time"};
    private static final int DELAY_BETWEEN_NOTIFICATION_RESTORES_MS = 200;
    static final int DEFAULT_TTL_IF_NOT_IN_PAYLOAD = 259200;
    public static boolean restored;
    private static final int RESTORE_NOTIFICATIONS_DELAY_MS = 15000;

    NotificationRestorer() {
    }

    static void asyncRestore(final Context context) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setPriority(10);
                NotificationRestorer.restore(context);
            }
        }, "OS_RESTORE_NOTIFS").start();
    }

    @WorkerThread
    public static void restore(Context context) {
        if (!OSUtils.areNotificationsEnabled(context)) {
            return;
        }
        if (restored) {
            return;
        }
        restored = true;
        OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "Restoring notifications");
        OneSignalDbHelper dbHelper = OneSignalDbHelper.getInstance(context);
        NotificationRestorer.deleteOldNotificationsFromDb(dbHelper);
        StringBuilder dbQuerySelection = OneSignalDbHelper.recentUninteractedWithNotificationsWhere();
        NotificationRestorer.skipVisibleNotifications(context, dbQuerySelection);
        NotificationRestorer.queryAndRestoreNotificationsAndBadgeCount(context, dbHelper, dbQuerySelection);
    }

    private static void deleteOldNotificationsFromDb(OneSignalDbHelper dbHelper) {
        SQLiteDatabase writableDb = null;
        try {
            writableDb = dbHelper.getWritableDbWithRetries();
            writableDb.beginTransaction();
            NotificationBundleProcessor.deleteOldNotifications(writableDb);
            writableDb.setTransactionSuccessful();
        }
        catch (Throwable t) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error deleting old notification records! ", t);
        }
        finally {
            if (writableDb != null) {
                try {
                    writableDb.endTransaction();
                }
                catch (Throwable t) {
                    OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error closing transaction! ", t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void queryAndRestoreNotificationsAndBadgeCount(Context context, OneSignalDbHelper dbHelper, StringBuilder dbQuerySelection) {
        OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "Querying DB for notifs to restore: " + dbQuerySelection.toString());
        Cursor cursor = null;
        try {
            SQLiteDatabase readableDb = dbHelper.getReadableDbWithRetries();
            cursor = readableDb.query("notification", COLUMNS_FOR_RESTORE, dbQuerySelection.toString(), null, null, null, "_id DESC", NotificationLimitManager.MAX_NUMBER_OF_NOTIFICATIONS_STR);
            NotificationRestorer.showNotificationsFromCursor(context, cursor, 200);
            BadgeCountUpdater.update(readableDb, context);
        }
        catch (Throwable t) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error restoring notification records! ", t);
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
    }

    private static void skipVisibleNotifications(Context context, StringBuilder dbQuerySelection) {
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        NotificationManager notifManager = (NotificationManager)context.getSystemService("notification");
        try {
            StatusBarNotification[] activeNotifs = notifManager.getActiveNotifications();
            if (activeNotifs.length == 0) {
                return;
            }
            ArrayList<Integer> activeNotifIds = new ArrayList<Integer>();
            for (StatusBarNotification activeNotif : activeNotifs) {
                activeNotifIds.add(activeNotif.getId());
            }
            dbQuerySelection.append(" AND android_notification_id NOT IN (").append(TextUtils.join((CharSequence)",", activeNotifIds)).append(")");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static void showNotificationsFromCursor(Context context, Cursor cursor, int delay) {
        boolean useExtender;
        if (!cursor.moveToFirst()) {
            return;
        }
        boolean bl = useExtender = NotificationExtenderService.getIntent(context) != null;
        do {
            Intent intent;
            if (useExtender) {
                intent = NotificationExtenderService.getIntent(context);
                NotificationRestorer.addRestoreExtras(intent, cursor);
                NotificationExtenderService.enqueueWork(context, intent.getComponent(), 2071862121, intent, false);
            } else {
                intent = NotificationRestorer.addRestoreExtras(new Intent(), cursor);
                ComponentName componentName = new ComponentName(context, RestoreJobService.class);
                RestoreJobService.enqueueWork(context, componentName, 2071862122, intent, false);
            }
            if (delay <= 0) continue;
            OSUtils.sleep(delay);
        } while (cursor.moveToNext());
    }

    private static Intent addRestoreExtras(Intent intent, Cursor cursor) {
        int existingId = cursor.getInt(cursor.getColumnIndex("android_notification_id"));
        String fullData = cursor.getString(cursor.getColumnIndex("full_data"));
        Long datetime = cursor.getLong(cursor.getColumnIndex("created_time"));
        intent.putExtra("json_payload", fullData).putExtra("android_notif_id", existingId).putExtra("restoring", true).putExtra("timestamp", (Serializable)datetime);
        return intent;
    }

    static void startDelayedRestoreTaskFromReceiver(Context context) {
        if (Build.VERSION.SDK_INT >= 26) {
            OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "scheduleRestoreKickoffJob");
            JobInfo.Builder jobBuilder = new JobInfo.Builder(2071862120, new ComponentName(context, RestoreKickoffJobService.class));
            JobInfo job = jobBuilder.setOverrideDeadline(15000L).setMinimumLatency(15000L).build();
            JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
            jobScheduler.schedule(job);
        } else {
            OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "scheduleRestoreKickoffAlarmTask");
            Intent intentForService = new Intent();
            intentForService.setComponent(new ComponentName(context.getPackageName(), NotificationRestoreService.class.getName()));
            PendingIntent pendingIntent = PendingIntent.getService((Context)context, (int)2071862120, (Intent)intentForService, (int)0x10000000);
            long scheduleTime = System.currentTimeMillis() + 15000L;
            AlarmManager alarm = (AlarmManager)context.getSystemService("alarm");
            alarm.set(1, scheduleTime, pendingIntent);
        }
    }
}

