/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.Context;
import android.net.Uri;
import com.onesignal.NotificationExtenderService;
import com.onesignal.OneSignal;
import java.security.SecureRandom;
import org.json.JSONObject;

class NotificationGenerationJob {
    Context context;
    JSONObject jsonPayload;
    boolean restoring;
    boolean isInAppPreviewPush;
    boolean showAsAlert;
    Long shownTimeStamp;
    CharSequence overriddenBodyFromExtender;
    CharSequence overriddenTitleFromExtender;
    Uri overriddenSound;
    Integer overriddenFlags;
    Integer orgFlags;
    Uri orgSound;
    NotificationExtenderService.OverrideSettings overrideSettings;

    NotificationGenerationJob(Context context) {
        this.context = context;
    }

    CharSequence getTitle() {
        if (this.overriddenTitleFromExtender != null) {
            return this.overriddenTitleFromExtender;
        }
        return this.jsonPayload.optString("title", null);
    }

    CharSequence getBody() {
        if (this.overriddenBodyFromExtender != null) {
            return this.overriddenBodyFromExtender;
        }
        return this.jsonPayload.optString("alert", null);
    }

    Integer getAndroidId() {
        if (this.overrideSettings == null) {
            this.overrideSettings = new NotificationExtenderService.OverrideSettings();
        }
        if (this.overrideSettings.androidNotificationId == null) {
            this.overrideSettings.androidNotificationId = new SecureRandom().nextInt();
        }
        return this.overrideSettings.androidNotificationId;
    }

    int getAndroidIdWithoutCreate() {
        if (this.overrideSettings == null || this.overrideSettings.androidNotificationId == null) {
            return -1;
        }
        return this.overrideSettings.androidNotificationId;
    }

    boolean isNotificationToDisplay() {
        return this.getAndroidIdWithoutCreate() != -1;
    }

    String getApiNotificationId() {
        return OneSignal.getNotificationIdFromGCMJson(this.jsonPayload);
    }

    void setAndroidIdWithOutOverriding(Integer id2) {
        if (id2 == null) {
            return;
        }
        if (this.overrideSettings != null && this.overrideSettings.androidNotificationId != null) {
            return;
        }
        if (this.overrideSettings == null) {
            this.overrideSettings = new NotificationExtenderService.OverrideSettings();
        }
        this.overrideSettings.androidNotificationId = id2;
    }

    boolean hasExtender() {
        return this.overrideSettings != null && this.overrideSettings.extender != null;
    }
}

