/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import com.onesignal.OSUtils;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

class OSObservable<ObserverType, StateType> {
    private String methodName;
    private List<Object> observers;
    private boolean fireOnMainThread;

    OSObservable(String methodName, boolean fireOnMainThread) {
        this.methodName = methodName;
        this.fireOnMainThread = fireOnMainThread;
        this.observers = new ArrayList<Object>();
    }

    void addObserver(ObserverType observer) {
        this.observers.add(new WeakReference<ObserverType>(observer));
    }

    void addObserverStrong(ObserverType observer) {
        this.observers.add(observer);
    }

    void removeObserver(ObserverType observer) {
        for (int i = 0; i < this.observers.size(); ++i) {
            Object anObserver = ((WeakReference)this.observers.get(i)).get();
            if (!anObserver.equals(observer)) continue;
            this.observers.remove(i);
            break;
        }
    }

    boolean notifyChange(final StateType state) {
        boolean notified = false;
        for (Object observer : this.observers) {
            final Object strongRefObserver = observer instanceof WeakReference ? ((WeakReference)observer).get() : observer;
            if (strongRefObserver == null) continue;
            try {
                Class<?> clazz = strongRefObserver.getClass();
                final Method method = clazz.getDeclaredMethod(this.methodName, state.getClass());
                method.setAccessible(true);
                if (this.fireOnMainThread) {
                    OSUtils.runOnMainUIThread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                method.invoke(strongRefObserver, state);
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                        }
                    });
                } else {
                    method.invoke(strongRefObserver, state);
                }
                notified = true;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return notified;
    }
}

