/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.support.annotation.NonNull;
import com.onesignal.OSReceiveReceiptRepository;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalPrefs;
import com.onesignal.OneSignalRestClient;

class OSReceiveReceiptController {
    private final OSReceiveReceiptRepository repository = new OSReceiveReceiptRepository();
    private static OSReceiveReceiptController sInstance;

    private OSReceiveReceiptController() {
    }

    public static synchronized OSReceiveReceiptController getInstance() {
        if (sInstance == null) {
            sInstance = new OSReceiveReceiptController();
        }
        return sInstance;
    }

    void sendReceiveReceipt(final @NonNull String notificationId) {
        String appId = OneSignal.appId == null || OneSignal.appId.isEmpty() ? OneSignal.getSavedAppId() : OneSignal.appId;
        String playerId = OneSignal.getUserId();
        if (!this.isReceiveReceiptEnabled()) {
            OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "sendReceiveReceipt disable");
            return;
        }
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "sendReceiveReceipt appId: " + appId + " playerId: " + playerId + " notificationId: " + notificationId);
        this.repository.sendReceiveReceipt(appId, playerId, notificationId, new OneSignalRestClient.ResponseHandler(){

            @Override
            void onSuccess(String response) {
                OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "Receive receipt sent for notificationID: " + notificationId);
            }

            @Override
            void onFailure(int statusCode, String response, Throwable throwable) {
                OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Receive receipt failed with statusCode: " + statusCode + " response: " + response);
            }
        });
    }

    private boolean isReceiveReceiptEnabled() {
        return OneSignalPrefs.getBool(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_RECEIVE_RECEIPTS_ENABLED", false);
    }
}

