/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.onesignal.OSSessionManager;
import com.onesignal.OSUtils;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalDbHelper;
import com.onesignal.OneSignalPrefs;
import com.onesignal.OneSignalRestClient;
import com.onesignal.OutcomeEvent;
import com.onesignal.OutcomeEventsRepository;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;

class OutcomeEventsController {
    private static final String OS_SAVE_OUTCOMES = "OS_SAVE_OUTCOMES";
    private static final String OS_SEND_SAVED_OUTCOMES = "OS_SEND_SAVED_OUTCOMES";
    private static final String OS_SAVE_UNIQUE_OUTCOME_NOTIFICATIONS = "OS_SAVE_UNIQUE_OUTCOME_NOTIFICATIONS";
    private Set<String> unattributedUniqueOutcomeEventsSentSet;
    @NonNull
    private final OutcomeEventsRepository outcomeEventsRepository;
    @NonNull
    private final OSSessionManager osSessionManager;

    public OutcomeEventsController(@NonNull OSSessionManager osSessionManager, @NonNull OutcomeEventsRepository outcomeEventsRepository) {
        this.osSessionManager = osSessionManager;
        this.outcomeEventsRepository = outcomeEventsRepository;
        this.initUniqueOutcomeEventsSentSets();
    }

    OutcomeEventsController(@NonNull OSSessionManager osSessionManager, @NonNull OneSignalDbHelper dbHelper) {
        this.outcomeEventsRepository = new OutcomeEventsRepository(dbHelper);
        this.osSessionManager = osSessionManager;
        this.initUniqueOutcomeEventsSentSets();
    }

    private void initUniqueOutcomeEventsSentSets() {
        this.unattributedUniqueOutcomeEventsSentSet = OSUtils.newConcurrentSet();
        Set<String> tempUnattributedUniqueOutcomeEventsSentSet = OneSignalPrefs.getStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_UNATTRIBUTED_UNIQUE_OUTCOME_EVENTS_SENT", null);
        if (tempUnattributedUniqueOutcomeEventsSentSet != null) {
            this.unattributedUniqueOutcomeEventsSentSet.addAll(tempUnattributedUniqueOutcomeEventsSentSet);
        }
    }

    void cleanOutcomes() {
        this.unattributedUniqueOutcomeEventsSentSet = OSUtils.newConcurrentSet();
        this.saveUnattributedUniqueOutcomeEvents();
    }

    void sendSavedOutcomes() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setPriority(10);
                List<OutcomeEvent> outcomeEvents = OutcomeEventsController.this.outcomeEventsRepository.getSavedOutcomeEvents();
                for (OutcomeEvent event : outcomeEvents) {
                    OutcomeEventsController.this.sendSavedOutcomeEvent(event);
                }
            }
        }, OS_SEND_SAVED_OUTCOMES).start();
    }

    void sendUniqueOutcomeEvent(@NonNull String name, @Nullable OneSignal.OutcomeCallback callback) {
        OSSessionManager.SessionResult sessionResult = this.osSessionManager.getSessionResult();
        this.sendUniqueOutcomeEvent(name, sessionResult, this.osSessionManager.getSession(), callback);
    }

    void sendUniqueClickOutcomeEvent(@NonNull String name) {
        OSSessionManager.SessionResult sessionResult = this.osSessionManager.getIAMSessionResult();
        this.sendUniqueOutcomeEvent(name, sessionResult, OSSessionManager.Session.UNATTRIBUTED, null);
    }

    void sendOutcomeEvent(@NonNull String name, @Nullable OneSignal.OutcomeCallback callback) {
        OSSessionManager.SessionResult sessionResult = this.osSessionManager.getSessionResult();
        this.sendAndCreateOutcomeEvent(name, 0.0f, sessionResult.notificationIds, sessionResult.session, callback);
    }

    void sendOutcomeEventWithValue(@NonNull String name, float weight, @Nullable OneSignal.OutcomeCallback callback) {
        OSSessionManager.SessionResult sessionResult = this.osSessionManager.getSessionResult();
        this.sendAndCreateOutcomeEvent(name, weight, sessionResult.notificationIds, sessionResult.session, callback);
    }

    void sendClickOutcomeEventWithValue(@NonNull String name, float weight) {
        OSSessionManager.SessionResult sessionResult = this.osSessionManager.getIAMSessionResult();
        this.sendAndCreateOutcomeEvent(name, weight, sessionResult.notificationIds, sessionResult.session, null);
    }

    private void sendUniqueOutcomeEvent(@NonNull String name, @NonNull OSSessionManager.SessionResult sessionResult, OSSessionManager.Session currentSession, @Nullable OneSignal.OutcomeCallback callback) {
        OSSessionManager.Session session = sessionResult.session;
        JSONArray notificationIds = sessionResult.notificationIds;
        if (currentSession.isAttributed()) {
            JSONArray uniqueNotificationIds = this.getUniqueNotificationIds(name, notificationIds);
            if (uniqueNotificationIds == null) {
                OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "Measure endpoint will not send because unique outcome already sent for: \nSession: " + this.osSessionManager.getSession().toString() + "\nOutcome name: " + name + "\nnotificationIds: " + notificationIds);
                if (callback != null) {
                    callback.onSuccess(null);
                }
                return;
            }
            this.sendAndCreateOutcomeEvent(name, 0.0f, uniqueNotificationIds, session, callback);
        } else if (currentSession.isUnattributed()) {
            if (this.unattributedUniqueOutcomeEventsSentSet.contains(name)) {
                OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "Measure endpoint will not send because unique outcome already sent for: \nSession: " + this.osSessionManager.getSession().toString() + "\nOutcome name: " + name);
                if (callback != null) {
                    callback.onSuccess(null);
                }
                return;
            }
            this.unattributedUniqueOutcomeEventsSentSet.add(name);
            this.sendAndCreateOutcomeEvent(name, 0.0f, null, session, callback);
        } else {
            OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "Unique Outcome for current session is disabled");
        }
    }

    private void sendSavedOutcomeEvent(final @NonNull OutcomeEvent event) {
        OneSignalRestClient.ResponseHandler responseHandler = new OneSignalRestClient.ResponseHandler(){

            @Override
            void onSuccess(String response) {
                super.onSuccess(response);
                OutcomeEventsController.this.outcomeEventsRepository.removeEvent(event);
            }
        };
        this.sendOutcomeEvent(event, responseHandler);
    }

    private void sendAndCreateOutcomeEvent(final @NonNull String name, @NonNull float weight, final @Nullable JSONArray notificationIds, final @NonNull OSSessionManager.Session session, final @Nullable OneSignal.OutcomeCallback callback) {
        long timestampSeconds = System.currentTimeMillis() / 1000L;
        final OutcomeEvent outcomeEvent = new OutcomeEvent(session, notificationIds, name, timestampSeconds, weight);
        OneSignalRestClient.ResponseHandler responseHandler = new OneSignalRestClient.ResponseHandler(){

            @Override
            void onSuccess(String response) {
                super.onSuccess(response);
                if (session.isAttributed()) {
                    OutcomeEventsController.this.saveAttributedUniqueOutcomeNotifications(notificationIds, name);
                } else {
                    OutcomeEventsController.this.saveUnattributedUniqueOutcomeEvents();
                }
                if (callback != null) {
                    callback.onSuccess(outcomeEvent);
                }
            }

            @Override
            void onFailure(int statusCode, String response, Throwable throwable) {
                super.onFailure(statusCode, response, throwable);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Thread.currentThread().setPriority(10);
                        OutcomeEventsController.this.outcomeEventsRepository.saveOutcomeEvent(outcomeEvent);
                    }
                }, OutcomeEventsController.OS_SAVE_OUTCOMES).start();
                OneSignal.onesignalLog(OneSignal.LOG_LEVEL.WARN, "Sending outcome with name: " + name + " failed with status code: " + statusCode + " and response: " + response + "\nOutcome event was cached and will be reattempted on app cold start");
                if (callback != null) {
                    callback.onSuccess(null);
                }
            }
        };
        this.sendOutcomeEvent(outcomeEvent, responseHandler);
    }

    private void sendOutcomeEvent(@NonNull OutcomeEvent outcomeEvent, OneSignalRestClient.ResponseHandler responseHandler) {
        String appId = OneSignal.appId;
        int deviceType = new OSUtils().getDeviceType();
        switch (outcomeEvent.getSession()) {
            case DIRECT: {
                this.outcomeEventsRepository.requestMeasureDirectOutcomeEvent(appId, deviceType, outcomeEvent, responseHandler);
                break;
            }
            case INDIRECT: {
                this.outcomeEventsRepository.requestMeasureIndirectOutcomeEvent(appId, deviceType, outcomeEvent, responseHandler);
                break;
            }
            case UNATTRIBUTED: {
                this.outcomeEventsRepository.requestMeasureUnattributedOutcomeEvent(appId, deviceType, outcomeEvent, responseHandler);
                break;
            }
            case DISABLED: {
                OneSignal.Log(OneSignal.LOG_LEVEL.VERBOSE, "Outcomes for current session are disabled");
            }
        }
    }

    private void saveAttributedUniqueOutcomeNotifications(final JSONArray notificationIds, final String name) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setPriority(10);
                OutcomeEventsController.this.outcomeEventsRepository.saveUniqueOutcomeNotifications(notificationIds, name);
            }
        }, OS_SAVE_UNIQUE_OUTCOME_NOTIFICATIONS).start();
    }

    private void saveUnattributedUniqueOutcomeEvents() {
        OneSignalPrefs.saveStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_UNATTRIBUTED_UNIQUE_OUTCOME_EVENTS_SENT", this.unattributedUniqueOutcomeEventsSentSet);
    }

    private JSONArray getUniqueNotificationIds(String name, JSONArray notificationIds) {
        JSONArray uniqueNotificationIds = this.outcomeEventsRepository.getNotCachedUniqueOutcomeNotifications(name, notificationIds);
        if (uniqueNotificationIds.length() == 0) {
            return null;
        }
        return uniqueNotificationIds;
    }
}

