/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.support.annotation.WorkerThread;
import com.onesignal.CachedUniqueOutcomeNotification;
import com.onesignal.OSSessionManager;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalDbHelper;
import com.onesignal.OutcomeEvent;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;

class OutcomeEventsCache {
    OutcomeEventsCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    static synchronized void deleteOldOutcomeEvent(OutcomeEvent event, OneSignalDbHelper dbHelper) {
        SQLiteDatabase writableDb = dbHelper.getWritableDbWithRetries();
        try {
            writableDb.beginTransaction();
            writableDb.delete("outcome", "timestamp = ?", new String[]{String.valueOf(event.getTimestamp())});
            writableDb.setTransactionSuccessful();
        }
        catch (SQLiteException e) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error deleting old outcome event records! ", e);
        }
        finally {
            if (writableDb != null) {
                try {
                    writableDb.endTransaction();
                }
                catch (SQLiteException e) {
                    OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error closing transaction! ", e);
                }
            }
        }
    }

    @WorkerThread
    static synchronized void saveOutcomeEvent(OutcomeEvent event, OneSignalDbHelper dbHelper) {
        SQLiteDatabase writableDb = dbHelper.getWritableDbWithRetries();
        String notificationIds = event.getNotificationIds() != null ? event.getNotificationIds().toString() : "[]";
        ContentValues values = new ContentValues();
        values.put("notification_ids", notificationIds);
        values.put("session", event.getSession().toString().toLowerCase());
        values.put("name", event.getName());
        values.put("timestamp", Long.valueOf(event.getTimestamp()));
        values.put("weight", Float.valueOf(event.getWeight()));
        writableDb.insert("outcome", null, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    static synchronized List<OutcomeEvent> getAllEventsToSend(OneSignalDbHelper dbHelper) {
        ArrayList<OutcomeEvent> events = new ArrayList<OutcomeEvent>();
        Cursor cursor = null;
        try {
            SQLiteDatabase readableDb = dbHelper.getReadableDbWithRetries();
            cursor = readableDb.query("outcome", null, null, null, null, null, null);
            if (cursor.moveToFirst()) {
                do {
                    String sessionString = cursor.getString(cursor.getColumnIndex("session"));
                    OSSessionManager.Session session = OSSessionManager.Session.fromString(sessionString);
                    String notificationIds = cursor.getString(cursor.getColumnIndex("notification_ids"));
                    String name = cursor.getString(cursor.getColumnIndex("name"));
                    long timestamp = cursor.getLong(cursor.getColumnIndex("timestamp"));
                    float weight = cursor.getFloat(cursor.getColumnIndex("weight"));
                    try {
                        OutcomeEvent event = new OutcomeEvent(session, new JSONArray(notificationIds), name, timestamp, weight);
                        events.add(event);
                    }
                    catch (JSONException e) {
                        OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Generating JSONArray from notifications ids outcome:JSON Failed.", e);
                    }
                } while (cursor.moveToNext());
            }
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
        return events;
    }

    @WorkerThread
    static synchronized void saveUniqueOutcomeNotifications(JSONArray notificationIds, String outcomeName, OneSignalDbHelper dbHelper) {
        if (notificationIds == null) {
            return;
        }
        SQLiteDatabase writableDb = dbHelper.getWritableDbWithRetries();
        try {
            for (int i = 0; i < notificationIds.length(); ++i) {
                ContentValues values = new ContentValues();
                String notificationId = notificationIds.getString(i);
                values.put("notification_id", notificationId);
                values.put("name", outcomeName);
                writableDb.insert("cached_unique_outcome_notification", null, values);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    static synchronized JSONArray getNotCachedUniqueOutcomeNotifications(String name, JSONArray notificationIds, OneSignalDbHelper dbHelper) {
        JSONArray uniqueNotificationIds = new JSONArray();
        SQLiteDatabase readableDb = dbHelper.getReadableDbWithRetries();
        Cursor cursor = null;
        try {
            for (int i = 0; i < notificationIds.length(); ++i) {
                String[] columns = new String[]{};
                String where = "notification_id = ? AND name = ?";
                String notificationId = notificationIds.getString(i);
                CachedUniqueOutcomeNotification notification = new CachedUniqueOutcomeNotification(notificationId, name);
                String[] args = new String[]{notification.getNotificationId(), notification.getName()};
                cursor = readableDb.query("cached_unique_outcome_notification", columns, where, args, null, null, null, "1");
                if (cursor.getCount() != 0) continue;
                uniqueNotificationIds.put((Object)notificationId);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
        return uniqueNotificationIds;
    }
}

