/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.amazon.device.messaging.ADMMessageHandlerBase;
import com.amazon.device.messaging.ADMMessageReceiver;
import com.onesignal.NotificationBundleProcessor;
import com.onesignal.NotificationGenerationJob;
import com.onesignal.OneSignal;
import com.onesignal.PushRegistratorADM;

public class ADMMessageHandler
extends ADMMessageHandlerBase {
    public ADMMessageHandler() {
        super("ADMMessageHandler");
    }

    protected void onMessage(Intent intent) {
        Bundle bundle = intent.getExtras();
        if (NotificationBundleProcessor.processBundle((Context)this, bundle)) {
            return;
        }
        NotificationGenerationJob notifJob = new NotificationGenerationJob((Context)this);
        notifJob.jsonPayload = NotificationBundleProcessor.bundleAsJSONObject(bundle);
        NotificationBundleProcessor.Process(notifJob);
    }

    protected void onRegistered(String newRegistrationId) {
        OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "ADM registration ID: " + newRegistrationId);
        PushRegistratorADM.fireCallback(newRegistrationId);
    }

    protected void onRegistrationError(String error) {
        OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "ADM:onRegistrationError: " + error);
        if ("INVALID_SENDER".equals(error)) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Please double check that you have a matching package name (NOTE: Case Sensitive), api_key.txt, and the apk was signed with the same Keystore and Alias.");
        }
        PushRegistratorADM.fireCallback(null);
    }

    protected void onUnregistered(String info) {
        OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "ADM:onUnregistered: " + info);
    }

    public static class Receiver
    extends ADMMessageReceiver {
        public Receiver() {
            super(ADMMessageHandler.class);
        }
    }
}

