/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import com.onesignal.LocationGMS;
import com.onesignal.OSUtils;
import com.onesignal.OneSignal;
import com.onesignal.UserStateEmailSynchronizer;
import com.onesignal.UserStatePushSynchronizer;
import com.onesignal.UserStateSynchronizer;
import org.json.JSONException;
import org.json.JSONObject;

class OneSignalStateSynchronizer {
    private static UserStatePushSynchronizer userStatePushSynchronizer;
    private static UserStateEmailSynchronizer userStateEmailSynchronizer;

    OneSignalStateSynchronizer() {
    }

    static UserStatePushSynchronizer getPushStateSynchronizer() {
        if (userStatePushSynchronizer == null) {
            userStatePushSynchronizer = new UserStatePushSynchronizer();
        }
        return userStatePushSynchronizer;
    }

    static UserStateEmailSynchronizer getEmailStateSynchronizer() {
        if (userStateEmailSynchronizer == null) {
            userStateEmailSynchronizer = new UserStateEmailSynchronizer();
        }
        return userStateEmailSynchronizer;
    }

    static boolean stopAndPersist() {
        boolean pushPersisted = OneSignalStateSynchronizer.getPushStateSynchronizer().stopAndPersist();
        boolean emailPersisted = OneSignalStateSynchronizer.getEmailStateSynchronizer().stopAndPersist();
        if (emailPersisted) {
            emailPersisted = OneSignalStateSynchronizer.getEmailStateSynchronizer().getRegistrationId() != null;
        }
        return pushPersisted || emailPersisted;
    }

    static void clearLocation() {
        OneSignalStateSynchronizer.getPushStateSynchronizer().clearLocation();
        OneSignalStateSynchronizer.getEmailStateSynchronizer().clearLocation();
    }

    static void initUserState() {
        OneSignalStateSynchronizer.getPushStateSynchronizer().initUserState();
        OneSignalStateSynchronizer.getEmailStateSynchronizer().initUserState();
    }

    static void syncUserState(boolean fromSyncService) {
        OneSignalStateSynchronizer.getPushStateSynchronizer().syncUserState(fromSyncService);
        OneSignalStateSynchronizer.getEmailStateSynchronizer().syncUserState(fromSyncService);
    }

    static void sendTags(JSONObject newTags) {
        try {
            JSONObject jsonField = new JSONObject().put("tags", (Object)newTags);
            OneSignalStateSynchronizer.getPushStateSynchronizer().sendTags(jsonField);
            OneSignalStateSynchronizer.getEmailStateSynchronizer().sendTags(jsonField);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    static void syncHashedEmail(String email) {
        try {
            JSONObject emailFields = new JSONObject();
            emailFields.put("em_m", (Object)OSUtils.hexDigest(email, "MD5"));
            emailFields.put("em_s", (Object)OSUtils.hexDigest(email, "SHA-1"));
            OneSignalStateSynchronizer.getPushStateSynchronizer().syncHashedEmail(emailFields);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static void setEmail(String email, String emailAuthHash) {
        OneSignalStateSynchronizer.getPushStateSynchronizer().setEmail(email);
        OneSignalStateSynchronizer.getEmailStateSynchronizer().setEmail(email, emailAuthHash);
    }

    static void setSubscription(boolean enable) {
        OneSignalStateSynchronizer.getPushStateSynchronizer().setSubscription(enable);
    }

    static boolean getUserSubscribePreference() {
        return OneSignalStateSynchronizer.getPushStateSynchronizer().getUserSubscribePreference();
    }

    static void setPermission(boolean enable) {
        OneSignalStateSynchronizer.getPushStateSynchronizer().setPermission(enable);
    }

    static void updateLocation(LocationGMS.LocationPoint point) {
        OneSignalStateSynchronizer.getPushStateSynchronizer().updateLocation(point);
        OneSignalStateSynchronizer.getEmailStateSynchronizer().updateLocation(point);
    }

    static boolean getSubscribed() {
        return OneSignalStateSynchronizer.getPushStateSynchronizer().getSubscribed();
    }

    static String getRegistrationId() {
        return OneSignalStateSynchronizer.getPushStateSynchronizer().getRegistrationId();
    }

    static UserStateSynchronizer.GetTagsResult getTags(boolean fromServer) {
        return OneSignalStateSynchronizer.getPushStateSynchronizer().getTags(fromServer);
    }

    static void resetCurrentState() {
        OneSignalStateSynchronizer.getPushStateSynchronizer().resetCurrentState();
        OneSignalStateSynchronizer.getEmailStateSynchronizer().resetCurrentState();
        OneSignal.saveUserId(null);
        OneSignal.saveEmailId(null);
        OneSignal.setLastSessionTime(-3660L);
    }

    static void updateDeviceInfo(JSONObject deviceInfo) {
        OneSignalStateSynchronizer.getPushStateSynchronizer().updateDeviceInfo(deviceInfo);
        OneSignalStateSynchronizer.getEmailStateSynchronizer().updateDeviceInfo(deviceInfo);
    }

    static void updatePushState(JSONObject pushState) {
        OneSignalStateSynchronizer.getPushStateSynchronizer().updateState(pushState);
    }

    static void refreshEmailState() {
        OneSignalStateSynchronizer.getEmailStateSynchronizer().refresh();
    }

    static void setSyncAsNewSession() {
        OneSignalStateSynchronizer.getPushStateSynchronizer().setSyncAsNewSession();
        OneSignalStateSynchronizer.getEmailStateSynchronizer().setSyncAsNewSession();
    }

    static void setSyncAsNewSessionForEmail() {
        OneSignalStateSynchronizer.getEmailStateSynchronizer().setSyncAsNewSession();
    }

    static void logoutEmail() {
        OneSignalStateSynchronizer.getPushStateSynchronizer().logoutEmail();
        OneSignalStateSynchronizer.getEmailStateSynchronizer().logoutEmail();
    }
}

