/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import com.amazon.device.messaging.ADMMessageHandlerBase;
import com.amazon.device.messaging.ADMMessageReceiver;
import com.onesignal.ADMMessageHandlerJob;
import com.onesignal.NotificationBundleProcessor;
import com.onesignal.OSNotification;
import com.onesignal.OSNotificationGenerationJob;
import com.onesignal.OneSignal;
import com.onesignal.PushRegistratorADM;
import org.json.JSONObject;

public class ADMMessageHandler
extends ADMMessageHandlerBase {
    private static final int JOB_ID = 123891;

    public ADMMessageHandler() {
        super("ADMMessageHandler");
    }

    protected void onMessage(Intent intent) {
        Bundle bundle;
        Context context = this.getApplicationContext();
        NotificationBundleProcessor.ProcessedBundleResult processedResult = NotificationBundleProcessor.processBundleFromReceiver(context, bundle = intent.getExtras());
        if (processedResult.processed()) {
            return;
        }
        JSONObject payload = NotificationBundleProcessor.bundleAsJSONObject(bundle);
        OSNotification notification = new OSNotification(payload);
        OSNotificationGenerationJob notificationJob = new OSNotificationGenerationJob(context);
        notificationJob.setJsonPayload(payload);
        notificationJob.setContext(context);
        notificationJob.setNotification(notification);
        NotificationBundleProcessor.processJobForDisplay(notificationJob, true);
    }

    protected void onRegistered(String newRegistrationId) {
        OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "ADM registration ID: " + newRegistrationId);
        PushRegistratorADM.fireCallback(newRegistrationId);
    }

    protected void onRegistrationError(String error) {
        OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "ADM:onRegistrationError: " + error);
        if ("INVALID_SENDER".equals(error)) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Please double check that you have a matching package name (NOTE: Case Sensitive), api_key.txt, and the apk was signed with the same Keystore and Alias.");
        }
        PushRegistratorADM.fireCallback(null);
    }

    protected void onUnregistered(String info) {
        OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "ADM:onUnregistered: " + info);
    }

    public static class Receiver
    extends ADMMessageReceiver {
        public Receiver() {
            super(ADMMessageHandler.class);
            boolean ADMLatestAvailable = false;
            try {
                Class.forName("com.amazon.device.messaging.ADMMessageHandlerJobBase");
                ADMLatestAvailable = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (ADMLatestAvailable) {
                this.registerJobServiceClass(ADMMessageHandlerJob.class, 123891);
            }
            OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "ADM latest available: " + ADMLatestAvailable);
        }
    }
}

