/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.annotation.TargetApi;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import androidx.legacy.content.WakefulBroadcastReceiver;
import com.onesignal.BundleCompat;
import com.onesignal.BundleCompatBundle;
import com.onesignal.BundleCompatFactory;
import com.onesignal.FCMIntentJobService;
import com.onesignal.FCMIntentService;
import com.onesignal.NotificationBundleProcessor;
import com.onesignal.OneSignal;

public class FCMBroadcastReceiver
extends WakefulBroadcastReceiver {
    private static final String FCM_RECEIVE_ACTION = "com.google.android.c2dm.intent.RECEIVE";
    private static final String FCM_TYPE = "gcm";
    private static final String MESSAGE_TYPE_EXTRA_KEY = "message_type";

    private static boolean isFCMMessage(Intent intent) {
        if (FCM_RECEIVE_ACTION.equals(intent.getAction())) {
            String messageType = intent.getStringExtra(MESSAGE_TYPE_EXTRA_KEY);
            return messageType == null || FCM_TYPE.equals(messageType);
        }
        return false;
    }

    public void onReceive(Context context, Intent intent) {
        Bundle bundle = intent.getExtras();
        if (bundle == null || "google.com/iid".equals(bundle.getString("from"))) {
            return;
        }
        OneSignal.initWithContext(context);
        NotificationBundleProcessor.ProcessBundleReceiverCallback bundleReceiverCallback2 = new NotificationBundleProcessor.ProcessBundleReceiverCallback(){

            @Override
            public void onBundleProcessed(@Nullable NotificationBundleProcessor.ProcessedBundleResult processedResult) {
                if (processedResult == null) {
                    FCMBroadcastReceiver.this.setSuccessfulResultCode();
                    return;
                }
                if (processedResult.isDup || processedResult.isWorkManagerProcessing) {
                    FCMBroadcastReceiver.this.setAbort();
                    return;
                }
                FCMBroadcastReceiver.this.setSuccessfulResultCode();
            }
        };
        FCMBroadcastReceiver.processOrderBroadcast(context, intent, bundle, bundleReceiverCallback2);
    }

    private void setSuccessfulResultCode() {
        if (this.isOrderedBroadcast()) {
            this.setResultCode(-1);
        }
    }

    private void setAbort() {
        if (this.isOrderedBroadcast()) {
            this.abortBroadcast();
            this.setResultCode(-1);
        }
    }

    private static void processOrderBroadcast(final Context context, Intent intent, final Bundle bundle, final NotificationBundleProcessor.ProcessBundleReceiverCallback fcmBundleReceiver) {
        if (!FCMBroadcastReceiver.isFCMMessage(intent)) {
            fcmBundleReceiver.onBundleProcessed(null);
        }
        NotificationBundleProcessor.ProcessBundleReceiverCallback bundleReceiverCallback2 = new NotificationBundleProcessor.ProcessBundleReceiverCallback(){

            @Override
            public void onBundleProcessed(@Nullable NotificationBundleProcessor.ProcessedBundleResult processedResult) {
                if (processedResult != null && processedResult.processed()) {
                    fcmBundleReceiver.onBundleProcessed(processedResult);
                    return;
                }
                FCMBroadcastReceiver.startFCMService(context, bundle);
                fcmBundleReceiver.onBundleProcessed(processedResult);
            }
        };
        NotificationBundleProcessor.processBundleFromReceiver(context, bundle, bundleReceiverCallback2);
    }

    static void startFCMService(Context context, Bundle bundle) {
        boolean isHighPriority;
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "startFCMService from: " + context + " and bundle: " + bundle);
        if (!NotificationBundleProcessor.hasRemoteResource(bundle)) {
            OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "startFCMService with no remote resources, no need for services");
            BundleCompat taskExtras = FCMBroadcastReceiver.setCompatBundleForServer(bundle, BundleCompatFactory.getInstance());
            NotificationBundleProcessor.processFromFCMIntentService(context, taskExtras);
            return;
        }
        boolean bl = isHighPriority = Integer.parseInt(bundle.getString("pri", "0")) > 9;
        if (!isHighPriority && Build.VERSION.SDK_INT >= 26) {
            FCMBroadcastReceiver.startFCMServiceWithJobIntentService(context, bundle);
        } else {
            try {
                FCMBroadcastReceiver.startFCMServiceWithWakefulService(context, bundle);
            }
            catch (IllegalStateException e) {
                if (Build.VERSION.SDK_INT >= 21) {
                    FCMBroadcastReceiver.startFCMServiceWithJobIntentService(context, bundle);
                }
                throw e;
            }
        }
    }

    @TargetApi(value=21)
    private static void startFCMServiceWithJobIntentService(Context context, Bundle bundle) {
        BundleCompat taskExtras = FCMBroadcastReceiver.setCompatBundleForServer(bundle, BundleCompatFactory.getInstance());
        Intent intent = new Intent(context, FCMIntentJobService.class);
        intent.putExtra("Bundle:Parcelable:Extras", (Parcelable)taskExtras.getBundle());
        FCMIntentJobService.enqueueWork(context, intent);
    }

    private static void startFCMServiceWithWakefulService(Context context, Bundle bundle) {
        ComponentName componentName = new ComponentName(context.getPackageName(), FCMIntentService.class.getName());
        BundleCompat taskExtras = FCMBroadcastReceiver.setCompatBundleForServer(bundle, new BundleCompatBundle());
        Intent intentForService = new Intent().replaceExtras((Bundle)taskExtras.getBundle()).setComponent(componentName);
        FCMBroadcastReceiver.startWakefulService((Context)context, (Intent)intentForService);
    }

    private static BundleCompat setCompatBundleForServer(Bundle bundle, BundleCompat taskExtras) {
        taskExtras.putString("json_payload", NotificationBundleProcessor.bundleAsJSONObject(bundle).toString());
        taskExtras.putLong("timestamp", OneSignal.getTime().getCurrentTimeMillis() / 1000L);
        return taskExtras;
    }
}

