/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.influence.data;

import com.onesignal.OSSharedPreferences;
import com.onesignal.OneSignalRemoteParams;
import com.onesignal.influence.domain.OSInfluenceType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\nJ\u000e\u0010'\u001a\u00020%2\u0006\u0010&\u001a\u00020\nJ\u0010\u0010(\u001a\u00020%2\b\u0010)\u001a\u0004\u0018\u00010\u0006J\u000e\u0010*\u001a\u00020%2\u0006\u0010+\u001a\u00020\u0019J\u000e\u0010,\u001a\u00020%2\u0006\u0010-\u001a\u00020.J\u000e\u0010/\u001a\u00020%2\u0006\u00100\u001a\u00020\u0019R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\u0017\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001bR\u0011\u0010\u001e\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\fR\u0011\u0010 \u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0010R\u0011\u0010\"\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/onesignal/influence/data/OSInfluenceDataRepository;", "", "preferences", "Lcom/onesignal/OSSharedPreferences;", "(Lcom/onesignal/OSSharedPreferences;)V", "cachedNotificationOpenId", "", "getCachedNotificationOpenId", "()Ljava/lang/String;", "iamCachedInfluenceType", "Lcom/onesignal/influence/domain/OSInfluenceType;", "getIamCachedInfluenceType", "()Lcom/onesignal/influence/domain/OSInfluenceType;", "iamIndirectAttributionWindow", "", "getIamIndirectAttributionWindow", "()I", "iamLimit", "getIamLimit", "isDirectInfluenceEnabled", "", "()Z", "isIndirectInfluenceEnabled", "isUnattributedInfluenceEnabled", "lastIAMsReceivedData", "Lorg/json/JSONArray;", "getLastIAMsReceivedData", "()Lorg/json/JSONArray;", "lastNotificationsReceivedData", "getLastNotificationsReceivedData", "notificationCachedInfluenceType", "getNotificationCachedInfluenceType", "notificationIndirectAttributionWindow", "getNotificationIndirectAttributionWindow", "notificationLimit", "getNotificationLimit", "cacheIAMInfluenceType", "", "influenceType", "cacheNotificationInfluenceType", "cacheNotificationOpenId", "id", "saveIAMs", "iams", "saveInfluenceParams", "influenceParams", "Lcom/onesignal/OneSignalRemoteParams$InfluenceParams;", "saveNotifications", "notifications", "onesignal_release"})
public final class OSInfluenceDataRepository {
    private final OSSharedPreferences preferences;

    public final void cacheNotificationInfluenceType(@NotNull OSInfluenceType influenceType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)influenceType), (String)"influenceType");
        this.preferences.saveString(this.preferences.getPreferencesName(), "PREFS_OS_OUTCOMES_CURRENT_SESSION", influenceType.toString());
    }

    @NotNull
    public final OSInfluenceType getNotificationCachedInfluenceType() {
        String influenceType = this.preferences.getString(this.preferences.getPreferencesName(), "PREFS_OS_OUTCOMES_CURRENT_SESSION", OSInfluenceType.UNATTRIBUTED.toString());
        return OSInfluenceType.Companion.fromString(influenceType);
    }

    public final void cacheIAMInfluenceType(@NotNull OSInfluenceType influenceType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)influenceType), (String)"influenceType");
        this.preferences.saveString(this.preferences.getPreferencesName(), "PREFS_OS_OUTCOMES_CURRENT_IAM_INFLUENCE", influenceType.toString());
    }

    @NotNull
    public final OSInfluenceType getIamCachedInfluenceType() {
        String defaultValue = OSInfluenceType.UNATTRIBUTED.toString();
        String influenceType = this.preferences.getString(this.preferences.getPreferencesName(), "PREFS_OS_OUTCOMES_CURRENT_IAM_INFLUENCE", defaultValue);
        return OSInfluenceType.Companion.fromString(influenceType);
    }

    public final void cacheNotificationOpenId(@Nullable String id2) {
        this.preferences.saveString(this.preferences.getPreferencesName(), "PREFS_OS_LAST_ATTRIBUTED_NOTIFICATION_OPEN", id2);
    }

    @Nullable
    public final String getCachedNotificationOpenId() {
        return this.preferences.getString(this.preferences.getPreferencesName(), "PREFS_OS_LAST_ATTRIBUTED_NOTIFICATION_OPEN", null);
    }

    public final void saveNotifications(@NotNull JSONArray notifications) {
        Intrinsics.checkParameterIsNotNull((Object)notifications, (String)"notifications");
        this.preferences.saveString(this.preferences.getPreferencesName(), "PREFS_OS_LAST_NOTIFICATIONS_RECEIVED", notifications.toString());
    }

    public final void saveIAMs(@NotNull JSONArray iams) {
        Intrinsics.checkParameterIsNotNull((Object)iams, (String)"iams");
        this.preferences.saveString(this.preferences.getPreferencesName(), "PREFS_OS_LAST_IAMS_RECEIVED", iams.toString());
    }

    @NotNull
    public final JSONArray getLastNotificationsReceivedData() throws JSONException {
        JSONArray jSONArray;
        String notificationsReceived;
        String string2 = notificationsReceived = this.preferences.getString(this.preferences.getPreferencesName(), "PREFS_OS_LAST_NOTIFICATIONS_RECEIVED", "[]");
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            jSONArray = new JSONArray(it);
        } else {
            jSONArray = new JSONArray();
        }
        return jSONArray;
    }

    @NotNull
    public final JSONArray getLastIAMsReceivedData() throws JSONException {
        JSONArray jSONArray;
        String iamReceived;
        String string2 = iamReceived = this.preferences.getString(this.preferences.getPreferencesName(), "PREFS_OS_LAST_IAMS_RECEIVED", "[]");
        if (string2 != null) {
            String string3 = string2;
            boolean bl = false;
            boolean bl2 = false;
            String it = string3;
            boolean bl3 = false;
            jSONArray = new JSONArray(it);
        } else {
            jSONArray = new JSONArray();
        }
        return jSONArray;
    }

    public final int getNotificationLimit() {
        return this.preferences.getInt(this.preferences.getPreferencesName(), "PREFS_OS_NOTIFICATION_LIMIT", 10);
    }

    public final int getIamLimit() {
        return this.preferences.getInt(this.preferences.getPreferencesName(), "PREFS_OS_IAM_LIMIT", 10);
    }

    public final int getNotificationIndirectAttributionWindow() {
        return this.preferences.getInt(this.preferences.getPreferencesName(), "PREFS_OS_INDIRECT_ATTRIBUTION_WINDOW", 1440);
    }

    public final int getIamIndirectAttributionWindow() {
        return this.preferences.getInt(this.preferences.getPreferencesName(), "PREFS_OS_IAM_INDIRECT_ATTRIBUTION_WINDOW", 1440);
    }

    public final boolean isDirectInfluenceEnabled() {
        return this.preferences.getBool(this.preferences.getPreferencesName(), "PREFS_OS_DIRECT_ENABLED", false);
    }

    public final boolean isIndirectInfluenceEnabled() {
        return this.preferences.getBool(this.preferences.getPreferencesName(), "PREFS_OS_INDIRECT_ENABLED", false);
    }

    public final boolean isUnattributedInfluenceEnabled() {
        return this.preferences.getBool(this.preferences.getPreferencesName(), "PREFS_OS_UNATTRIBUTED_ENABLED", false);
    }

    public final void saveInfluenceParams(@NotNull OneSignalRemoteParams.InfluenceParams influenceParams) {
        Intrinsics.checkParameterIsNotNull((Object)influenceParams, (String)"influenceParams");
        this.preferences.saveBool(this.preferences.getPreferencesName(), "PREFS_OS_DIRECT_ENABLED", influenceParams.isDirectEnabled());
        this.preferences.saveBool(this.preferences.getPreferencesName(), "PREFS_OS_INDIRECT_ENABLED", influenceParams.isIndirectEnabled());
        this.preferences.saveBool(this.preferences.getPreferencesName(), "PREFS_OS_UNATTRIBUTED_ENABLED", influenceParams.isUnattributedEnabled());
        this.preferences.saveInt(this.preferences.getPreferencesName(), "PREFS_OS_NOTIFICATION_LIMIT", influenceParams.getNotificationLimit());
        this.preferences.saveInt(this.preferences.getPreferencesName(), "PREFS_OS_INDIRECT_ATTRIBUTION_WINDOW", influenceParams.getIndirectNotificationAttributionWindow());
        this.preferences.saveInt(this.preferences.getPreferencesName(), "PREFS_OS_IAM_LIMIT", influenceParams.getIamLimit());
        this.preferences.saveInt(this.preferences.getPreferencesName(), "PREFS_OS_IAM_INDIRECT_ATTRIBUTION_WINDOW", influenceParams.getIndirectIAMAttributionWindow());
    }

    public OSInfluenceDataRepository(@NotNull OSSharedPreferences preferences) {
        Intrinsics.checkParameterIsNotNull((Object)preferences, (String)"preferences");
        this.preferences = preferences;
    }
}

