/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import com.onesignal.OSObservable;
import com.onesignal.OSUtils;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalPrefs;
import org.json.JSONObject;

public class OSPermissionState
implements Cloneable {
    private static final String ARE_NOTIFICATION_ENABLED_KEY = "areNotificationsEnabled";
    private static final String CHANGED_KEY = "changed";
    private OSObservable<Object, OSPermissionState> observable = new OSObservable("changed", false);
    private boolean notificationsEnabled;

    OSPermissionState(boolean asFrom) {
        if (asFrom) {
            this.notificationsEnabled = OneSignalPrefs.getBool(OneSignalPrefs.PREFS_ONESIGNAL, "ONESIGNAL_ACCEPTED_NOTIFICATION_LAST", false);
        } else {
            this.refreshAsTo();
        }
    }

    void refreshAsTo() {
        this.setNotificationsEnabled(OSUtils.areNotificationsEnabled(OneSignal.appContext));
    }

    public boolean areNotificationsEnabled() {
        return this.notificationsEnabled;
    }

    private void setNotificationsEnabled(boolean set) {
        boolean changed = this.notificationsEnabled != set;
        this.notificationsEnabled = set;
        if (changed) {
            this.observable.notifyChange(this);
        }
    }

    void persistAsFrom() {
        OneSignalPrefs.saveBool(OneSignalPrefs.PREFS_ONESIGNAL, "ONESIGNAL_ACCEPTED_NOTIFICATION_LAST", this.notificationsEnabled);
    }

    boolean compare(OSPermissionState from) {
        return this.notificationsEnabled != from.notificationsEnabled;
    }

    public OSObservable<Object, OSPermissionState> getObservable() {
        return this.observable;
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public JSONObject toJSONObject() {
        JSONObject mainObj = new JSONObject();
        try {
            mainObj.put(ARE_NOTIFICATION_ENABLED_KEY, this.notificationsEnabled);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return mainObj;
    }

    public String toString() {
        return this.toJSONObject().toString();
    }
}

