/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.view.ViewTreeObserver;
import androidx.annotation.NonNull;
import com.onesignal.ActivityLifecycleListener;
import com.onesignal.OSFocusDelaySync;
import com.onesignal.OSSystemConditionController;
import com.onesignal.OSUtils;
import com.onesignal.OSViewUtils;
import com.onesignal.OneSignal;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

class ActivityLifecycleHandler
implements OSSystemConditionController.OSSystemConditionHandler {
    private static final Object SYNC_LOCK = new Object();
    private static final String FOCUS_LOST_WORKER_TAG = "FOCUS_LOST_WORKER_TAG";
    private static final Map<String, ActivityAvailableListener> sActivityAvailableListeners = new ConcurrentHashMap<String, ActivityAvailableListener>();
    private static final Map<String, OSSystemConditionController.OSSystemConditionObserver> sSystemConditionObservers = new ConcurrentHashMap<String, OSSystemConditionController.OSSystemConditionObserver>();
    private static final Map<String, KeyboardListener> sKeyboardListeners = new ConcurrentHashMap<String, KeyboardListener>();
    private static AppFocusRunnable appFocusRunnable;
    @SuppressLint(value={"StaticFieldLeak"})
    private Activity curActivity = null;
    private boolean nextResumeIsFirstActivity = false;

    ActivityLifecycleHandler() {
    }

    void onConfigurationChanged(Configuration newConfig, Activity activity) {
        if (this.curActivity != null && OSUtils.hasConfigChangeFlag(this.curActivity, 128)) {
            this.logOrientationChange(newConfig.orientation, activity);
            this.onOrientationChanged(activity);
        }
    }

    void onActivityCreated(Activity activity) {
    }

    void onActivityStarted(Activity activity) {
    }

    void onActivityResumed(Activity activity) {
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "onActivityResumed: " + activity);
        this.setCurActivity(activity);
        this.logCurActivity();
        this.handleFocus();
    }

    void onActivityPaused(Activity activity) {
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "onActivityPaused: " + activity);
        if (activity == this.curActivity) {
            this.curActivity = null;
            this.handleLostFocus();
        }
        this.logCurActivity();
    }

    void onActivityStopped(Activity activity) {
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "onActivityStopped: " + activity);
        if (activity == this.curActivity) {
            this.curActivity = null;
            this.handleLostFocus();
        }
        for (Map.Entry<String, ActivityAvailableListener> entry : sActivityAvailableListeners.entrySet()) {
            entry.getValue().stopped(activity);
        }
        this.logCurActivity();
    }

    void onActivityDestroyed(Activity activity) {
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "onActivityDestroyed: " + activity);
        sKeyboardListeners.clear();
        if (activity == this.curActivity) {
            this.curActivity = null;
            this.handleLostFocus();
        }
        this.logCurActivity();
    }

    private void logCurActivity() {
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "curActivity is NOW: " + (this.curActivity != null ? "" + this.curActivity.getClass().getName() + ":" + this.curActivity : "null"));
    }

    private void logOrientationChange(int orientation, Activity activity) {
        if (orientation == 2) {
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "Configuration Orientation Change: LANDSCAPE (" + orientation + ") on activity: " + activity);
        } else if (orientation == 1) {
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "Configuration Orientation Change: PORTRAIT (" + orientation + ") on activity: " + activity);
        }
    }

    private void onOrientationChanged(Activity activity) {
        this.handleLostFocus();
        for (Map.Entry<String, ActivityAvailableListener> entry : sActivityAvailableListeners.entrySet()) {
            entry.getValue().stopped(activity);
        }
        for (Map.Entry<String, ActivityAvailableListener> entry : sActivityAvailableListeners.entrySet()) {
            entry.getValue().available(this.curActivity);
        }
        ViewTreeObserver treeObserver = this.curActivity.getWindow().getDecorView().getViewTreeObserver();
        for (Map.Entry<String, OSSystemConditionController.OSSystemConditionObserver> entry : sSystemConditionObservers.entrySet()) {
            KeyboardListener keyboardListener = new KeyboardListener(this, entry.getValue(), entry.getKey());
            treeObserver.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)keyboardListener);
            sKeyboardListeners.put(entry.getKey(), keyboardListener);
        }
        this.handleFocus();
    }

    private void handleLostFocus() {
        OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "ActivityLifecycleHandler Handling lost focus");
        if (appFocusRunnable != null && appFocusRunnable.backgrounded && !appFocusRunnable.completed) {
            return;
        }
        OneSignal.getFocusTimeController().appStopped();
        OSFocusDelaySync.getInstance().scheduleSyncTask(OneSignal.appContext);
    }

    private void handleFocus() {
        OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "ActivityLifecycleHandler handleFocus, with runnable: " + appFocusRunnable + " nextResumeIsFirstActivity: " + this.nextResumeIsFirstActivity);
        if (this.hasBackgrounded() || this.nextResumeIsFirstActivity) {
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "ActivityLifecycleHandler reset background state, call app focus");
            this.nextResumeIsFirstActivity = false;
            this.resetBackgroundState();
            OneSignal.onAppFocus();
        } else {
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "ActivityLifecycleHandler cancel background lost focus sync task");
            OSFocusDelaySync.getInstance().cancelBackgroundSyncTask(OneSignal.appContext);
        }
    }

    void addSystemConditionObserver(String key, OSSystemConditionController.OSSystemConditionObserver systemConditionObserver) {
        if (this.curActivity != null) {
            ViewTreeObserver treeObserver = this.curActivity.getWindow().getDecorView().getViewTreeObserver();
            KeyboardListener keyboardListener = new KeyboardListener(this, systemConditionObserver, key);
            treeObserver.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)keyboardListener);
            sKeyboardListeners.put(key, keyboardListener);
        }
        sSystemConditionObservers.put(key, systemConditionObserver);
    }

    @Override
    public void removeSystemConditionObserver(@NotNull String key, @NotNull KeyboardListener keyboardListener) {
        if (this.curActivity != null) {
            ViewTreeObserver treeObserver = this.curActivity.getWindow().getDecorView().getViewTreeObserver();
            if (Build.VERSION.SDK_INT < 16) {
                treeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)keyboardListener);
            } else {
                treeObserver.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)keyboardListener);
            }
        }
        sKeyboardListeners.remove(key);
        sSystemConditionObservers.remove(key);
    }

    void addActivityAvailableListener(String key, ActivityAvailableListener activityAvailableListener) {
        sActivityAvailableListeners.put(key, activityAvailableListener);
        if (this.curActivity != null) {
            activityAvailableListener.available(this.curActivity);
        }
    }

    void removeActivityAvailableListener(String key) {
        sActivityAvailableListeners.remove(key);
    }

    public Activity getCurActivity() {
        return this.curActivity;
    }

    public void setCurActivity(Activity activity) {
        this.curActivity = activity;
        for (Map.Entry<String, ActivityAvailableListener> entry : sActivityAvailableListeners.entrySet()) {
            entry.getValue().available(this.curActivity);
        }
        try {
            ViewTreeObserver treeObserver = this.curActivity.getWindow().getDecorView().getViewTreeObserver();
            for (Map.Entry<String, OSSystemConditionController.OSSystemConditionObserver> entry : sSystemConditionObservers.entrySet()) {
                KeyboardListener keyboardListener = new KeyboardListener(this, entry.getValue(), entry.getKey());
                treeObserver.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)keyboardListener);
                sKeyboardListeners.put(entry.getKey(), keyboardListener);
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    void setNextResumeIsFirstActivity(boolean nextResumeIsFirstActivity) {
        this.nextResumeIsFirstActivity = nextResumeIsFirstActivity;
    }

    void resetBackgroundState() {
        if (appFocusRunnable != null) {
            appFocusRunnable.backgrounded = false;
        }
    }

    boolean hasBackgrounded() {
        return appFocusRunnable != null && appFocusRunnable.backgrounded;
    }

    static void runLostFocusLogic(Context context) {
        OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "ActivityLifecycleHandler runLostFocusLogic");
        ActivityLifecycleHandler activityLifecycleHandler = ActivityLifecycleListener.getActivityLifecycleHandler();
        if (activityLifecycleHandler == null || activityLifecycleHandler.curActivity == null) {
            OneSignal.setInForeground(false);
        }
        appFocusRunnable = new AppFocusRunnable();
        OSFocusDelaySync.getInstance().doBackgroundSync(context, appFocusRunnable);
    }

    static class KeyboardListener
    implements ViewTreeObserver.OnGlobalLayoutListener {
        private final OSSystemConditionController.OSSystemConditionObserver observer;
        private final OSSystemConditionController.OSSystemConditionHandler systemConditionListener;
        private final String key;

        private KeyboardListener(OSSystemConditionController.OSSystemConditionHandler systemConditionListener, OSSystemConditionController.OSSystemConditionObserver observer, String key) {
            this.systemConditionListener = systemConditionListener;
            this.observer = observer;
            this.key = key;
        }

        public void onGlobalLayout() {
            boolean keyboardUp = OSViewUtils.isKeyboardUp(new WeakReference<Activity>(OneSignal.getCurrentActivity()));
            if (!keyboardUp) {
                this.systemConditionListener.removeSystemConditionObserver(this.key, this);
                this.observer.systemConditionChanged();
            }
        }
    }

    static class AppFocusRunnable
    implements Runnable {
        private boolean backgrounded;
        private boolean completed;

        AppFocusRunnable() {
        }

        @Override
        public void run() {
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "ActivityLifecycleHandler running AppFocusRunnable");
            this.backgrounded = true;
            OneSignal.onAppLostFocus();
            this.completed = true;
        }

        public String toString() {
            return "AppFocusRunnable{backgrounded=" + this.backgrounded + ", completed=" + this.completed + '}';
        }
    }

    static abstract class ActivityAvailableListener {
        ActivityAvailableListener() {
        }

        void available(@NonNull Activity activity) {
        }

        void stopped(@NonNull Activity activity) {
        }

        void lostFocus() {
        }
    }
}

