/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import androidx.annotation.Nullable;
import com.onesignal.OSObservable;
import com.onesignal.OSPermissionState;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalPrefs;
import com.onesignal.OneSignalStateSynchronizer;
import org.json.JSONException;
import org.json.JSONObject;

public class OSSubscriptionState
implements Cloneable {
    private static final String CHANGED_KEY = "changed";
    private OSObservable<Object, OSSubscriptionState> observable = new OSObservable("changed", false);
    private String userId;
    private String pushToken;
    private boolean accepted;
    private boolean pushDisabled;

    OSSubscriptionState(boolean asFrom, boolean permissionAccepted) {
        if (asFrom) {
            this.pushDisabled = OneSignalPrefs.getBool(OneSignalPrefs.PREFS_ONESIGNAL, "ONESIGNAL_SUBSCRIPTION_LAST", true);
            this.userId = OneSignalPrefs.getString(OneSignalPrefs.PREFS_ONESIGNAL, "ONESIGNAL_PLAYER_ID_LAST", null);
            this.pushToken = OneSignalPrefs.getString(OneSignalPrefs.PREFS_ONESIGNAL, "ONESIGNAL_PUSH_TOKEN_LAST", null);
            this.accepted = OneSignalPrefs.getBool(OneSignalPrefs.PREFS_ONESIGNAL, "ONESIGNAL_PERMISSION_ACCEPTED_LAST", false);
        } else {
            this.pushDisabled = !OneSignalStateSynchronizer.getUserSubscribePreference();
            this.userId = OneSignal.getUserId();
            this.pushToken = OneSignalStateSynchronizer.getRegistrationId();
            this.accepted = permissionAccepted;
        }
    }

    void changed(OSPermissionState state) {
        this.setAccepted(state.areNotificationsEnabled());
    }

    void setUserId(@Nullable String id2) {
        boolean changed = false;
        if (id2 == null) {
            changed = this.userId != null;
        } else if (!id2.equals(this.userId)) {
            changed = true;
        }
        this.userId = id2;
        if (changed) {
            this.observable.notifyChange(this);
        }
    }

    public String getUserId() {
        return this.userId;
    }

    void setPushToken(String id2) {
        if (id2 == null) {
            return;
        }
        boolean changed = !id2.equals(this.pushToken);
        this.pushToken = id2;
        if (changed) {
            this.observable.notifyChange(this);
        }
    }

    public String getPushToken() {
        return this.pushToken;
    }

    void setPushDisabled(boolean disabled) {
        boolean changed = this.pushDisabled != disabled;
        this.pushDisabled = disabled;
        if (changed) {
            this.observable.notifyChange(this);
        }
    }

    public boolean isPushDisabled() {
        return this.pushDisabled;
    }

    private void setAccepted(boolean set) {
        boolean lastSubscribed = this.isSubscribed();
        this.accepted = set;
        if (lastSubscribed != this.isSubscribed()) {
            this.observable.notifyChange(this);
        }
    }

    public boolean isSubscribed() {
        return this.userId != null && this.pushToken != null && !this.pushDisabled && this.accepted;
    }

    void persistAsFrom() {
        OneSignalPrefs.saveBool(OneSignalPrefs.PREFS_ONESIGNAL, "ONESIGNAL_SUBSCRIPTION_LAST", this.pushDisabled);
        OneSignalPrefs.saveString(OneSignalPrefs.PREFS_ONESIGNAL, "ONESIGNAL_PLAYER_ID_LAST", this.userId);
        OneSignalPrefs.saveString(OneSignalPrefs.PREFS_ONESIGNAL, "ONESIGNAL_PUSH_TOKEN_LAST", this.pushToken);
        OneSignalPrefs.saveBool(OneSignalPrefs.PREFS_ONESIGNAL, "ONESIGNAL_PERMISSION_ACCEPTED_LAST", this.accepted);
    }

    boolean compare(OSSubscriptionState from) {
        return this.pushDisabled != from.pushDisabled || !(this.userId != null ? this.userId : "").equals(from.userId != null ? from.userId : "") || !(this.pushToken != null ? this.pushToken : "").equals(from.pushToken != null ? from.pushToken : "") || this.accepted != from.accepted;
    }

    public OSObservable<Object, OSSubscriptionState> getObservable() {
        return this.observable;
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public JSONObject toJSONObject() {
        JSONObject mainObj = new JSONObject();
        try {
            if (this.userId != null) {
                mainObj.put("userId", (Object)this.userId);
            } else {
                mainObj.put("userId", JSONObject.NULL);
            }
            if (this.pushToken != null) {
                mainObj.put("pushToken", (Object)this.pushToken);
            } else {
                mainObj.put("pushToken", JSONObject.NULL);
            }
            mainObj.put("isPushDisabled", this.isPushDisabled());
            mainObj.put("isSubscribed", this.isSubscribed());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return mainObj;
    }

    public String toString() {
        return this.toJSONObject().toString();
    }
}

