/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.Context;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.huawei.hms.push.RemoteMessage;
import com.onesignal.NotificationPayloadProcessorHMS;
import com.onesignal.OneSignal;
import com.onesignal.PushRegistratorHMS;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONException;
import org.json.JSONObject;

public class OneSignalHmsEventBridge {
    public static final String HMS_TTL_KEY = "hms.ttl";
    public static final String HMS_SENT_TIME_KEY = "hms.sent_time";
    private static final AtomicBoolean firstToken = new AtomicBoolean(true);

    public static void onNewToken(@NonNull Context context, @NonNull String token, @Nullable Bundle bundle) {
        if (firstToken.compareAndSet(true, false)) {
            OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "OneSignalHmsEventBridge onNewToken - HMS token: " + token + " Bundle: " + bundle);
            PushRegistratorHMS.fireCallback(token);
        } else {
            OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "OneSignalHmsEventBridge ignoring onNewToken - HMS token: " + token + " Bundle: " + bundle);
        }
    }

    @Deprecated
    public static void onNewToken(@NonNull Context context, @NonNull String token) {
        OneSignalHmsEventBridge.onNewToken(context, token, null);
    }

    public static void onMessageReceived(@NonNull Context context, @NonNull RemoteMessage message) {
        String data = message.getData();
        try {
            JSONObject messageDataJSON = new JSONObject(message.getData());
            messageDataJSON.put(HMS_TTL_KEY, message.getTtl());
            messageDataJSON.put(HMS_SENT_TIME_KEY, message.getSentTime());
            data = messageDataJSON.toString();
        }
        catch (JSONException e) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "OneSignalHmsEventBridge error when trying to create RemoteMessage data JSON");
        }
        NotificationPayloadProcessorHMS.processDataMessageReceived(context, data);
    }
}

