/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.ChecksSdkIntAtLeast;
import com.onesignal.GenerateNotification;
import com.onesignal.NotificationBundleProcessor;
import com.onesignal.OSNotificationGenerationJob;
import com.onesignal.OneSignal;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0007J\u001c\u0010\f\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007J\b\u0010\u0011\u001a\u00020\bH\u0003\u00a8\u0006\u0012"}, d2={"Lcom/onesignal/OSInAppMessagePreviewHandler;", "", "()V", "inAppPreviewPushUUID", "", "payload", "Lorg/json/JSONObject;", "notificationOpened", "", "activity", "Landroid/app/Activity;", "jsonData", "notificationReceived", "context", "Landroid/content/Context;", "bundle", "Landroid/os/Bundle;", "shouldDisplayNotification", "onesignal_release"})
public final class OSInAppMessagePreviewHandler {
    @NotNull
    public static final OSInAppMessagePreviewHandler INSTANCE;

    @JvmStatic
    public static final boolean notificationReceived(@Nullable Context context, @Nullable Bundle bundle) {
        JSONObject jSONObject = NotificationBundleProcessor.bundleAsJSONObject(bundle);
        Intrinsics.checkNotNullExpressionValue((Object)jSONObject, (String)"NotificationBundleProces\u2026undleAsJSONObject(bundle)");
        JSONObject pushPayloadJson = jSONObject;
        String string2 = OSInAppMessagePreviewHandler.inAppPreviewPushUUID(pushPayloadJson);
        if (string2 == null) {
            return false;
        }
        String previewUUID = string2;
        if (OneSignal.isAppActive()) {
            OneSignal.getInAppMessageController().displayPreviewMessage(previewUUID);
        } else if (INSTANCE.shouldDisplayNotification()) {
            OSNotificationGenerationJob generationJob = new OSNotificationGenerationJob(context, pushPayloadJson);
            GenerateNotification.displayIAMPreviewNotification(generationJob);
        }
        return true;
    }

    @JvmStatic
    public static final boolean notificationOpened(@NotNull Activity activity, @NotNull JSONObject jsonData) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)jsonData, (String)"jsonData");
        String string2 = OSInAppMessagePreviewHandler.inAppPreviewPushUUID(jsonData);
        if (string2 == null) {
            return false;
        }
        String previewUUID = string2;
        OneSignal.openDestinationActivity(activity, new JSONArray().put((Object)jsonData));
        OneSignal.getInAppMessageController().displayPreviewMessage(previewUUID);
        return true;
    }

    @JvmStatic
    @Nullable
    public static final String inAppPreviewPushUUID(@NotNull JSONObject payload) {
        String string2;
        JSONObject jSONObject;
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        try {
            JSONObject jSONObject2 = NotificationBundleProcessor.getCustomJSONObject(payload);
            Intrinsics.checkNotNullExpressionValue((Object)jSONObject2, (String)"NotificationBundleProces\u2026CustomJSONObject(payload)");
            jSONObject = jSONObject2;
        }
        catch (JSONException e) {
            return null;
        }
        JSONObject osCustom = jSONObject;
        if (!osCustom.has("a")) {
            return null;
        }
        JSONObject jSONObject3 = osCustom.optJSONObject("a");
        if (jSONObject3 != null) {
            jSONObject = jSONObject3;
            boolean bl = false;
            boolean bl2 = false;
            JSONObject additionalData = jSONObject;
            boolean bl3 = false;
            string2 = additionalData.has("os_in_app_message_preview_id") ? additionalData.optString("os_in_app_message_preview_id") : null;
        } else {
            string2 = null;
        }
        return string2;
    }

    @ChecksSdkIntAtLeast(api=19)
    private final boolean shouldDisplayNotification() {
        return Build.VERSION.SDK_INT > 18;
    }

    private OSInAppMessagePreviewHandler() {
    }

    static {
        OSInAppMessagePreviewHandler oSInAppMessagePreviewHandler;
        INSTANCE = oSInAppMessagePreviewHandler = new OSInAppMessagePreviewHandler();
    }
}

